      SUBROUTINE HGO                                                    
C                                                    
C     ******************************************************************
C     * DUMMY HEADING FOR LIBRARY HGOLIB.                              *
C     * LIBRARY HGOLIB CONSISTS OF SUBROUTINES COLLECTED AND WRITTEN   *
C     * BY HANS GOEDBLOED SINCE MAY 1975.                              *
C     * LASL ROUTINES MODIFIED JUNE 1975 BY HANS SCHRIJVER TO RUN AT   *
C     * SARA AMSTERDAM.                                                *
C     * ROUTINE LSQ ADDED BY RICARDO GALVAO JAN 1980.                  *
C     * LASL SUBROUTINES MODIFIED AUGUST 1982 BY DENNIS HEWETT TO RUN  *
C     * ON LIVERMORE CRAY COMPUTERS.                                   *
C     * LASL SUBROUTINES MODIFIED AGAIN MARCH 84 FOR COMPATIBILITY     *
C     * WITH SARA FTN5 COMPILER.                                       *
C     * VERSION 29 (15/03/90):                                         *
C     * MINOR MODIFICATION OF SUBROUTINE PRARR2 TO GET COMPACT OUTPUT  *
C     * FOR JSIZE=9 (JPG) + NEW SUBROUTINE ARSIMP (GUIDO HUYSMANS)     *
C     *                                                                *
C     * version 30 (Jan-Willem Blokland and Hans Goedbloed 18/04/07):  *
C     * Everywhere: implicit double precision, also all explicit       *
C     * numbers 0 -> 0.D+0, etc. in subroutine arguments,              *
C     * and all ALOG -> DLOG, AMAX1 -> DMAX1 , AMIN1 -> DMIN1          *
C     ******************************************************************
C
      implicit double precision (a-h,o-z)
C
      WRITE(   *,10)
   10 FORMAT(/1X,'LIBRARY HGOLIB'/1X,'VERSION 30, D.D. 18/04/07')
      RETURN
      END
C
      SUBROUTINE PRARR1(NAME,ARRAY,ISIZE,LL)
C
C     ******************************************************************
C     * PRINTS 1D ARRAY(ISIZE) WITH THE TITLE NAME.                    *
C     * IF ISIZE.LT.0, INDEX I STARTS COUNTING FROM 0 (RATHER THAN 1). *
C     * THE ARGUMENT LL HAS THE DOUBLE FUNCTION OF COMMUNICATING THE   *
C     * OUTPUT UNIT IOUT=LL/10 AND THE FORMAT SWITCH L=LL-IOUT*10.     *
C     * IOUT=0 (L=LL): FILE IS "OUTPUT".                               *
C     * L=1: E-FORMAT, L=2: F-FORMAT (WIDTH OF 132 CHARACTERS),        *
C     * L=3: E-FORMAT, L=4: F-FORMAT (WIDTH OF 80 CHARACTERS).         *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C
      CHARACTER*(*) NAME                                                
      DIMENSION ARRAY(*)                                                
C                                                                       
      IOUT=LL/10                                                        
      L=LL-IOUT*10                                                      
      IF(L.EQ.0) THEN                                                   
         RETURN                                                         
      ELSEIF(L.EQ.1) THEN                                               
         KSTEP=8                                                        
         ASSIGN 11 TO IFM                                               
         IF(ISIZE.GE.100) ASSIGN 111 TO IFM                             
      ELSEIF(L.EQ.2) THEN                                               
         KSTEP=8                                                        
         ASSIGN 12 TO IFM                                               
      ELSEIF(L.EQ.3) THEN                                               
         KSTEP=5                                                        
         ASSIGN 13 TO IFM                                               
         IF(ISIZE.GE.100) ASSIGN 113 TO IFM                             
      ELSEIF(L.EQ.4) THEN                                               
         KSTEP=5                                                        
         ASSIGN 14 TO IFM                                               
      ENDIF                                                             
C                                                                       
      I0=0                                                              
      IS=ISIZE                                                          
      IF(ISIZE.LT.0) THEN                                               
         I0=1                                                           
         IS=-ISIZE                                                      
      ENDIF                                                             
C                                                                       
      IF(IOUT.EQ.0) THEN                                                
         WRITE(   *,10) NAME                                            
         DO 20 K=1,IS,KSTEP                                             
         KPLUS=MIN(K+KSTEP-1,IS)                                        
   20    WRITE(   *,IFM) (ARRAY(I),I-I0,I=K,KPLUS)                      
      ELSE                                                              
         WRITE(IOUT,10) NAME                                            
         DO 200 K=1,IS,KSTEP                                            
         KPLUS=MIN(K+KSTEP-1,IS)                                        
  200    WRITE(IOUT,IFM) (ARRAY(I),I-I0,I=K,KPLUS)                      
      ENDIF                                                             
      RETURN                                                            
C                                                                       
   10 FORMAT(/1X,A/)                                                    
   11 FORMAT(1X,8(1PE12.4,'(',0P,I2,')'))                               
  111 FORMAT(1X,8(1PE11.4,'(',0P,I3,')'))                               
   12 FORMAT(1X,8(F11.5,'(',I3,')'))                                    
   13 FORMAT(1X,5(1PE12.4,'(',0P,I2,')'))                               
  113 FORMAT(1X,5(1PE11.4,'(',0P,I3,')'))                               
   14 FORMAT(1X,5(F11.5,'(',I3,')'))                                    
      END                                                               
C                                                                       
      SUBROUTINE PRARR2(NAME,INDS,ARRAY,ISIZE,JSIZE,IMAX,LL)            
C                                                                       
C     ******************************************************************
C     * PRINTS 2D ARRAY(ISIZE,JSIZE) WITH TITLE AND INDICES INDICATED  *
C     * BY THE CHARACTER VARIABLES NAME AND INDS.                      *
C     * ISIZE SHOULD NOT EXCEED THE DIMENSION IMAX DECLARED IN THE     *
C     * CALLING PROGRAM.                                               *
C     * IF ISIZE.LT.0, INDEX I STARTS COUNTING FROM 0 (RATHER THAN 1). *
C     * IF JSIZE.LT.0, INDEX J STARTS COUNTING FROM 0 (RATHER THAN 1). *
C     * THE ARGUMENT LL HAS THE DOUBLE FUNCTION OF COMMUNICATING THE   *
C     * OUTPUT UNIT IOUT=LL/10 AND THE FORMAT SWITCH L=LL-IOUT*10.     *
C     * IOUT=0 (L=LL): FILE IS "OUTPUT".                               *
C     * L=1: E-FORMAT, L=2: F-FORMAT (WIDTH OF 132 CHARACTERS),        *
C     * L=3: E-FORMAT, L=4: F-FORMAT (WIDTH OF 80 CHARACTERS).         *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      CHARACTER*(*) NAME                                                
      CHARACTER*(*) INDS                                                
      CHARACTER*10 INDS1                                                
      DIMENSION ARRAY(IMAX,*)                                           
C                                                                       
      INDS1=INDS                                                        
      IOUT=LL/10                                                        
      L=LL-IOUT*10                                                      
      IF(L.EQ.0) THEN                                                   
         RETURN                                                         
      ELSEIF(L.EQ.1) THEN                                               
         KSTEP=8                                                        
         IF(IABS(JSIZE).EQ.9) KSTEP=9                                   
         ASSIGN 11 TO IFM1                                              
         ASSIGN 21 TO IFM2                                              
      ELSEIF(L.EQ.2) THEN                                               
         KSTEP=12                                                       
         ASSIGN 12 TO IFM1                                              
         ASSIGN 22 TO IFM2                                              
      ELSEIF(L.EQ.3) THEN                                               
         KSTEP=5                                                        
         ASSIGN 13 TO IFM1                                              
         ASSIGN 23 TO IFM2                                              
      ELSEIF(L.EQ.4) THEN                                               
         KSTEP=8                                                        
         ASSIGN 14 TO IFM1                                              
         ASSIGN 24 TO IFM2                                              
      ENDIF                                                             
C                                                                       
      I0=0                                                              
      IS=ISIZE                                                          
      IF(ISIZE.LT.0) THEN                                               
         I0=1                                                           
         IS=-ISIZE                                                      
      ENDIF                                                             
      J0=0                                                              
      JS=JSIZE                                                          
      IF(JSIZE.LT.0) THEN                                               
         J0=1                                                           
         JS=-JSIZE                                                      
      ENDIF                                                             
C                                                                       
      IF(IOUT.EQ.0) THEN                                                
         WRITE(   *,10) NAME                                            
         DO 20 K=1,JS,KSTEP                                             
         KPLUS=MIN(K+KSTEP-1,JS)                                        
         WRITE(   *,IFM1) INDS1,(J-J0,J=K,KPLUS)                        
         WRITE(   *,*)                                                  
         DO 20 I=1,IS                                                   
   20    WRITE(   *,IFM2) I-I0,(ARRAY(I,J),J=K,KPLUS)                   
      ELSE                                                              
         WRITE(IOUT,10) NAME                                            
         DO 200 K=1,JS,KSTEP                                            
         KPLUS=MIN(K+KSTEP-1,JS)                                        
         WRITE(IOUT,IFM1) INDS1,(J-J0,J=K,KPLUS)                        
         WRITE(IOUT,*)                                                  
         DO 200 I=1,IS                                                  
  200    WRITE(IOUT,IFM2) I-I0,(ARRAY(I,J),J=K,KPLUS)                   
      ENDIF                                                             
      RETURN                                                            
C                                                                       
   10 FORMAT(/1X,A)                                                     
   11 FORMAT(/2X,A10,I7,8I13)                                           
   12 FORMAT(/2X,A10,I3,11I9)                                           
   13 FORMAT(/2X,A10,I7,4I13)                                           
   14 FORMAT(/2X,A10,I3,7I9)                                            
   21 FORMAT(1X,I3,2X,1P9E13.4)                                         
   22 FORMAT(1X,I3,2X,12F9.5)                                           
   23 FORMAT(1X,I3,2X,1P5E13.4)                                         
   24 FORMAT(1X,I3,2X,8F9.5)                                            
      END                                                               
C                                                                       
      SUBROUTINE PROUT(A,ISIZE,JSIZE,IMAX,MTOTAL,BOUND,KK)              
C                                                                       
C     ******************************************************************
C     * PRINTS THE FIRST MTOTAL ELEMENTS OF A 2D ARRAY A(ISIZE,JSIZE)  *
C     * WHICH ARE OUTSIDE A PRESCRIBED BOUND: K*A(I,J).GT.K*BOUND.     *
C     * THE ARGUMENT KK PROVIDES BOTH THE OUTPUT UNIT IOUT=IABS(KK)/10 *
C     * AND THE SIGN K=KK-ISIGN(IOUT*10,KK) OF THE DESIRED BOUND.      *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION A(IMAX,*)                                               
C                                                                       
      IOUT=IABS(KK)/10                                                  
      K=KK-ISIGN(IOUT*10,KK)                                            
      B=K*BOUND                                                         
      M=0                                                               
      N=0                                                               
      IF(IOUT.EQ.0) THEN                                                
         DO 10 I=1,ISIZE                                                
         DO 10 J=1,JSIZE                                                
         IF(K*A(I,J).LE.B) GOTO 10                                      
         M=M+1                                                          
         IF(M.GT.MTOTAL) RETURN                                         
         N=N+1                                                          
         IF(N.EQ.1) WRITE(   *,11) A(I,J),I,J                           
         IF(N.EQ.2) WRITE(   *,12) A(I,J),I,J                           
         IF(N.EQ.3) WRITE(   *,13) A(I,J),I,J                           
         IF(N.EQ.4) WRITE(   *,14) A(I,J),I,J                           
         IF(N.EQ.5) WRITE(   *,15) A(I,J),I,J                           
         IF(N.EQ.6) WRITE(   *,16) A(I,J),I,J                           
         IF(N.EQ.6) N=0                                                 
   10    CONTINUE                                                       
      ELSE                                                              
         DO 100 I=1,ISIZE                                               
         DO 100 J=1,JSIZE                                               
         IF(K*A(I,J).LE.B) GOTO 100                                     
         M=M+1                                                          
         IF(M.GT.MTOTAL) RETURN                                         
         N=N+1                                                          
         IF(N.EQ.1) WRITE(IOUT,11) A(I,J),I,J                           
         IF(N.EQ.2) WRITE(IOUT,12) A(I,J),I,J                           
         IF(N.EQ.3) WRITE(IOUT,13) A(I,J),I,J                           
         IF(N.EQ.4) WRITE(IOUT,14) A(I,J),I,J                           
         IF(N.EQ.5) WRITE(IOUT,15) A(I,J),I,J                           
         IF(N.EQ.6) WRITE(IOUT,16) A(I,J),I,J                           
         IF(N.EQ.6) N=0                                                 
  100    CONTINUE                                                       
      ENDIF                                                             
      RETURN                                                            
C                                                                       
   11 FORMAT(      1X,1PE12.4,'(',I3,',',I3,')')                        
   12 FORMAT('+', 22X,1PE12.4,'(',I3,',',I3,')')                        
   13 FORMAT('+', 44X,1PE12.4,'(',I3,',',I3,')')                        
   14 FORMAT('+', 66X,1PE12.4,'(',I3,',',I3,')')                        
   15 FORMAT('+', 88X,1PE12.4,'(',I3,',',I3,')')                        
   16 FORMAT('+',110X,1PE12.4,'(',I3,',',I3,')')                        
      END                                                               
C                                                                       
      FUNCTION ELK(PAR)                                                 
C                                                                       
C     ******************************************************************
C     * COMPLETE ELLIPTIC INTEGRAL OF THE FIRST KIND USING POLYNOMIAL  *
C     * APPROXIMATION, SEE ABRAMOWITZ P.591.                           *
C     * PAR IS THE PARAMETER K*2.                                      *
C     * ACCURACY IS 2.E-8 FOR THE RANGE 0.LE.PAR.LT.1.                 *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      OMP=1.-PAR                                                        
      A0=1.38629436112                                                  
      A1=.09666344259                                                   
      A2=.03590092383                                                   
      A3=.03742563713                                                   
      A4=.01451196212                                                   
      B0=.5                                                             
      B1=.12498593597                                                   
      B2=.06880248576                                                   
      B3=.03328355346                                                   
      B4=.00441787012                                                   
      ELK=A0+A1*OMP+A2*OMP**2+A3*OMP**3+A4*OMP**4-                      
     A    (B0+B1*OMP+B2*OMP**2+B3*OMP**3+B4*OMP**4)*DLOG(OMP)           
      RETURN                                                            
      END                                                               
C                                                                       
      FUNCTION ELF(PHI,PAR)                                             
C                                                                       
C     ******************************************************************
C     * INCOMPLETE ELLIPTIC INTEGRAL OF THE FIRST KIND USING LANDEN    *
C     * TRANSFORMATION, SEE ABRAMOWITZ P.598.                          *
C     * PHI IS THE AMPLITUDE, PAR IS THE PARAMETER K*2.                *
C     * RANGES OF PHI AND PAR: 0.LE.PHI.LE.PI/2, 0.LE.PAR.LT.1.        *
C     * THE ACCURACY AND THE MAXIMUM NUMBER OF ITERATIONS ARE:         *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (ACC=1.E-10,NIT=50)                                     
C                                                                       
      A=1.                                                              
      B=SQRT(1.-PAR)                                                    
      C=SQRT(PAR)                                                       
      PHIS=PHI                                                          
      N=0                                                               
      IF(C.LE.ACC) GOTO 20                                              
      DO 10 N=1,NIT                                                     
      AS=A                                                              
      BS=B                                                              
      A=.5*(AS+BS)                                                      
      B=SQRT(AS*BS)                                                     
      C=.5*(AS-BS)                                                      
      SI=SIN(PHIS)                                                      
      CO=COS(PHIS)                                                      
      PHIS=2.*PHIS-ATAN2(SI,CO)+ATAN2(BS*SI,AS*CO)                      
      IF(C.LE.ACC) GOTO 20                                              
   10 CONTINUE                                                          
   20 ELF=PHIS/(A*2.**N)                                                
      RETURN                                                            
      END                                                               
C                                                                       
      FUNCTION ELE(PAR)                                                 
C                                                                       
C     ******************************************************************
C     * COMPLETE ELLIPTIC INTEGRAL OF THE SECOND KIND USING POLYNOMIAL *
C     * APPROXIMATION, SEE ABRAMOWITZ P.592.                           *
C     * PAR IS THE PARAMETER K*2.                                      *
C     * ACCURACY IS 2.E-8 FOR THE RANGE 0.LE.PAR.LT.1.                 *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      OMP=1.-PAR                                                        
      A1=.44325141463                                                   
      A2=.06260601220                                                   
      A3=.04757383546                                                   
      A4=.01736506451                                                   
      B1=.24998368310                                                   
      B2=.09200180037                                                   
      B3=.04069697526                                                   
      B4=.00526449639                                                   
      ELE=1.+A1*OMP+A2*OMP**2+A3*OMP**3+A4*OMP**4-                      
     A    (B1*OMP+B2*OMP**2+B3*OMP**3+B4*OMP**4)*DLOG(OMP)              
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE ARSIMP(N,DEL,A,R)                                      
C                                                                       
C     ******************************************************************
C     * SIMPSON INTEGRATION  (GUIDO HUYSMANS, '90)                     *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION A(N)                                                    
C                                                                       
      L = N                                                             
      SUM = A(1) - A(L)                                                 
      DO 10 I=2,L,2                                                     
   10    SUM = SUM + 4.0*A(I) + 2.0*A(I+1)                              
      R =  (DEL * SUM) /3.0                                             
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE ZZ(Q1,Q2,N,Q,F,FUNC,ERR,                               
     A              K,QL,FL,IL,QMIN,FMIN,IMIN,QR,FR,IR,LL)              
C                                                                       
C     ******************************************************************
C     * THE ZEROS FL(QL) AND FR(QR) OF A CURVE FUNC(QQ) WITH A SINGLE  *
C     * MINIMUM FMIN(QMIN) ARE DETERMINED ON THE CLOSED INTERVAL       *
C     * Q1.LE.QQ.LE.Q2.                                                *
C     * THE CALLING PROGRAM SHOULD PROVIDE N DISCRETE POINTS F(Q(I)) OF*
C     * THE CURVE, WHERE N.GE.2, AND THE EXTERNAL FUNCTION FUNC.       *
C     * UPON RETURN                                                    *
C     *   FL(QL) IS THE LEFT ZERO WHEN K=1,                            *
C     *   FR(QR) IS THE RIGHT ZERO WHEN K=2,                           *
C     *   FUNC(QQ) IS NEG. DEF. WHEN K=3,                              *
C     *   FL(QL) AND FR(QR) ARE THE LEFT AND RIGHT ZERO WHEN K=4,      *
C     *   FUNC(QQ) IS POS. DEF. WHEN K=5,                              *
C     *   FL(QL), FMIN(QMIN), AND FR(QR) ARE THE LEFT ZERO, THE        *
C     *     MINIMUM, AND THE RIGHT ZERO WHEN K=6,                      *
C     *   FUNC(QQ) IS POS. DEF. AND FMIN(QMIN) IS THE MINIMUM WHEN K=7.*
C     * IL OR IR IS THE NUMBER OF ITERATIONS WHICH WERE REQUIRED TO    *
C     * OBTAIN ABS(FUNC(QQ)).LE.ERR.                                   *
C     * IMIN IS THE NUMBER OF ITERATIONS REQUIRED TO OBTAIN            *
C     * ABS(ERROR FMIN).LE.ERR AND ABS(ERROR QMIN).LE.10*SQRT(ERR).    *
C     * DIAGNOSTIC INFORMATION IS PRINTED IF L.NE.0.                   *
C     * THE ARGUMENT LL HAS THE DOUBLE FUNCTION OF COMMUNICATING THE   *
C     * OUTPUT UNIT IOUT=LL/10 AND THE PRINT SWITCH L=LL-IOUT*10.      *
C     * IOUT=0 (L=LL): FILE IS "OUTPUT".                               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION Q(*),F(*)                                               
      EXTERNAL FUNC                                                     
C                                                                       
      IOUT=LL/10                                                        
      L=LL-IOUT*10                                                      
      NIMIN=10                                                          
      ERQMIN=10.*SQRT(ERR)                                              
      IF(N.LT.2) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,10)                                   
         IF(IOUT.NE.0) WRITE(IOUT,10)                                   
         RETURN                                                         
      ENDIF                                                             
C                                                                       
C     * ZEROS ARE DETERMINED.                                           
      IF((F(1).GE.0.).AND.(F(N).LT.0.)) GOTO 100                        
      IF((F(1).LT.0.).AND.(F(N).GE.0.)) GOTO 200                        
      IF((F(1).LT.0.).AND.(F(N).LT.0.)) GOTO 300                        
      IF((F(1).GE.0.).AND.(F(N).GE.0.)) GOTO 400                        
  100 K=1                                                               
      DO 110 I=2,N                                                      
  110 IF(F(I).LT.0.) GOTO 120                                           
  120 QP=Q(I-1)                                                         
      FP=F(I-1)                                                         
      QM=Q(I)                                                           
      FM=F(I)                                                           
      CALL ZERO(QP,FP,QM,FM,FUNC,ERR,QL,FL,IL,IOUT*10+L)                
      RETURN                                                            
  200 K=2                                                               
      DO 210 I=2,N                                                      
  210 IF(F(I).GE.0.) GOTO 220                                           
  220 QM=Q(I-1)                                                         
      FM=F(I-1)                                                         
      QP=Q(I)                                                           
      FP=F(I)                                                           
      CALL ZERO(QM,FM,QP,FP,FUNC,ERR,QR,FR,IR,IOUT*10+L)                
      RETURN                                                            
  300 K=3                                                               
      RETURN                                                            
  400 K=4                                                               
      DO 410 I=2,N                                                      
  410 IF(F(I).LT.0.) GOTO 420                                           
      GOTO 500                                                          
  420 QP=Q(I-1)                                                         
      FP=F(I-1)                                                         
      QM=Q(I)                                                           
      FM=F(I)                                                           
      CALL ZERO(QP,FP,QM,FM,FUNC,ERR,QL,FL,IL,IOUT*10+L)                
      DO 440 J=I,N                                                      
  440 IF(F(J).GE.0.) GOTO 450                                           
  450 QM=Q(J-1)                                                         
      FM=F(J-1)                                                         
      QP=Q(J)                                                           
      FP=F(J)                                                           
      CALL ZERO(QM,FM,QP,FP,FUNC,ERR,QR,FR,IR,IOUT*10+L)                
      RETURN                                                            
C                                                                       
C     * IF N=2 AN ADDITIONAL THIRD POINT IS CREATED.                    
  500 IF(N.GT.2) GOTO 510                                               
      Q(N+1)=Q(N)                                                       
      F(N+1)=F(N)                                                       
      Q(N)=(Q(N)+Q(1))/2.                                               
      F(N)=FUNC(Q(N))                                                   
      N=3                                                               
  510 CONTINUE                                                          
C                                                                       
C     * THE THREE LOWEST POINTS FA,FB,FC OF THE INPUT ARRAY F(I) ARE    
C     * FOUND.                                                          
      IB=1                                                              
      QB=Q(1)                                                           
      FB=F(1)                                                           
      DO 520 I=2,N                                                      
      IF((I.EQ.2).AND.(F(I).GE.FB)) GOTO 530                            
      IF(F(I).GT.FB) GOTO 520                                           
      IB=I                                                              
      QB=Q(I)                                                           
      FB=F(I)                                                           
  520 CONTINUE                                                          
      IF(IB.EQ.N) GOTO 540                                              
      IA=IB-1                                                           
      QA=Q(IA)                                                          
      FA=F(IA)                                                          
      IC=IB+1                                                           
      QC=Q(IC)                                                          
      FC=F(IC)                                                          
      GOTO 600                                                          
  530 QPLUS=Q1+(Q2-Q1)*ERR                                              
      FPLUS=FUNC(QPLUS)                                                 
      IF(FPLUS.GT.FB) GOTO 550                                          
      QA=Q(1)                                                           
      FA=F(1)                                                           
      QB=QPLUS                                                          
      FB=FPLUS                                                          
      QC=Q(I)                                                           
      FC=F(I)                                                           
      GOTO 600                                                          
  540 QMINUS=Q2-(Q2-Q1)*ERR                                             
      FMINUS=FUNC(QMINUS)                                               
      IF(FMINUS.GT.FB) GOTO 550                                         
      QA=Q(N-1)                                                         
      FA=F(N-1)                                                         
      QB=QMINUS                                                         
      FB=FMINUS                                                         
      QC=Q(N)                                                           
      FC=F(N)                                                           
      GOTO 600                                                          
  550 K=5                                                               
      RETURN                                                            
  600 CONTINUE                                                          
C                                                                       
C     * THE MINIMUM FM(QM) OF THE CURVE FUNC(QQ) IS FOUND.              
      QAS=QA                                                            
      FAS=FA                                                            
      QCS=QC                                                            
      FCS=FC                                                            
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,601)                                  
         IF(IOUT.NE.0) WRITE(IOUT,601)                                  
      ENDIF                                                             
      DO 640 IMIN=1,NIMIN                                               
      QMIN=.5*((QB**2-QC**2)*(FA-FB)-(QA**2-QB**2)*(FB-FC))/            
     A     ((QB-QC)*(FA-FB)-(QA-QB)*(FB-FC))                            
      FMIN=FUNC(QMIN)                                                   
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,605) IMIN,QA,FA,QB,FB,QC,FC,QMIN,FMIN 
         IF(IOUT.NE.0) WRITE(IOUT,605) IMIN,QA,FA,QB,FB,QC,FC,QMIN,FMIN 
      ENDIF                                                             
      IF((ABS(QMIN-QB).LE.ERQMIN).AND.(ABS(FMIN-FB).LE.ERR)) GOTO 660   
      IF(FMIN.GT.FB) GOTO 620                                           
      IF(QMIN.GT.QB) GOTO 610                                           
      QC=QB                                                             
      FC=FB                                                             
      QB=QMIN                                                           
      FB=FMIN                                                           
      GOTO 640                                                          
  610 QA=QB                                                             
      FA=FB                                                             
      QB=QMIN                                                           
      FB=FMIN                                                           
      GOTO 640                                                          
  620 IF(QMIN.GT.QB) GOTO 630                                           
      QA=QMIN                                                           
      FA=FMIN                                                           
      GOTO 640                                                          
  630 QC=QMIN                                                           
      FC=FMIN                                                           
  640 CONTINUE                                                          
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,650) NIMIN                            
         IF(IOUT.NE.0) WRITE(IOUT,650) NIMIN                            
      ENDIF                                                             
  660 IF(FMIN.GT.0.) GOTO 700                                           
      K=6                                                               
      CALL ZERO(QAS,FAS,QMIN,FMIN,FUNC,ERR,QL,FL,IL,IOUT*10+L)          
      CALL ZERO(QMIN,FMIN,QCS,FCS,FUNC,ERR,QR,FR,IR,IOUT*10+L)          
      RETURN                                                            
  700 K=7                                                               
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
   10 FORMAT(/1X,'***SUBROUTINE ZZ: N.LT.2')                            
  601 FORMAT(/1X,'SUBROUTINE ZZ')                                       
  605 FORMAT(1X,'IMIN=',I3,2X,'QA=',F10.5,2X,'FA=',F10.5,2X,            
     A       'QB=',F10.5,2X,'FB=',F10.5,2X,'QC=',F10.5,2X,              
     B       'FC=',F10.5,2X,'QMIN=',F10.5,2X,'FMIN=',F10.5)             
  650 FORMAT(/1X,'***SUBROUTINE ZZ: NO CONVERGENCE FOR QM IN ',I3,      
     A       ' STEPS')                                                  
      END                                                               
C                                                                       
      SUBROUTINE ZERO(X1,Y1,X2,Y2,FUNC,ERR,X,Y,IZERO,LL)                
C                                                                       
C     ******************************************************************
C     * THE ZERO Y=FUNC(X)=0 ON THE INTERVAL (X1,X2) IS FOUND.         *
C     * THE FUNCTION FUNC(X) SHOULD BE PROVIDED BY AN EXTERNAL.        *
C     * UPON RETURN IZERO IS THE NUMBER OF ITERATIONS WHICH WERE       *
C     * REQUIRED TO OBTAIN ABS(Y).LE.ERR.                              *
C     * DIAGNOSTIC INFORMATION IS PRINTED IF L.NE.0.                   *
C     * THE ARGUMENT LL HAS THE DOUBLE FUNCTION OF COMMUNICATING THE   *
C     * OUTPUT UNIT IOUT=LL/10 AND THE PRINT SWITCH L=LL-IOUT*10.      *
C     * IOUT=0 (L=LL): FILE IS "OUTPUT".                               *
C     * MODIFIED BY JAN REM TO IMPROVE CONVERGENCE 25/08/84.           *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      EXTERNAL FUNC                                                     
C                                                                       
      IOUT=LL/10                                                        
      L=LL-IOUT*10                                                      
      NIZERO=50                                                         
      IF((Y1.LT.0..AND.Y2.LT.0.).OR.(Y1.GT.0..AND.Y2.GT.0.)) THEN       
         IF(IOUT.EQ.0) WRITE(   *,5)                                    
         IF(IOUT.NE.0) WRITE(IOUT,5)                                    
         RETURN                                                         
      ENDIF                                                             
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,6)                                    
         IF(IOUT.NE.0) WRITE(IOUT,6)                                    
      ENDIF                                                             
      X1S=X1                                                            
      Y1S=Y1                                                            
      X2S=X2                                                            
      Y2S=Y2                                                            
      IF(X1.GT.X2) THEN                                                 
         X1=X2S                                                         
         Y1=Y2S                                                         
         X2=X1S                                                         
         Y2=Y1S                                                         
      ENDIF                                                             
      SIG=1.                                                            
      IF(Y1.GE.0.) THEN                                                 
         SIG=-1.                                                        
         Y1=-Y1                                                         
         Y2=-Y2                                                         
      ENDIF                                                             
C                                                                       
C     ***BEGIN LOOP ON IZERO***                                         
      IZERO=0                                                           
   10 X0=X1-(X2-X1)*Y1/(Y2-Y1)                                          
      Y0=SIG*FUNC(X0)                                                   
      IZERO=IZERO+1                                                     
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,11) IZERO,X1,Y1,X2,Y2,X0,Y0           
         IF(IOUT.NE.0) WRITE(IOUT,11) IZERO,X1,Y1,X2,Y2,X0,Y0           
      ENDIF                                                             
      IF(ABS(Y0).LE.ERR) GOTO 20                                        
      IF(ABS(Y0).GE.0.2*MIN(-Y1,Y2)) THEN                               
         A=((Y2-Y0)/(X2-X0)-(Y0-Y1)/(X0-X1))/(X2-X1)                    
         B=(Y2-Y1)/(X2-X1)-A*(X2+X1)                                    
         C=Y0-A*X0*X0-B*X0                                              
         XN=(-B+SQRT(B*B-4.*A*C))/(2.*A)                                
         YN=SIG*FUNC(XN)                                                
         IZERO=IZERO+1                                                  
         IF(L.NE.0) THEN                                                
            IF(IOUT.EQ.0) WRITE(   *,12) IZERO,X1,Y1,X2,Y2,XN,YN        
            IF(IOUT.NE.0) WRITE(IOUT,12) IZERO,X1,Y1,X2,Y2,XN,YN        
         ENDIF                                                          
         IF(ABS(YN).LE.ERR) GOTO 30                                     
         IF(YN.LT.0.) THEN                                              
            X1=XN                                                       
            Y1=YN                                                       
            IF(Y0.GT.0.) THEN                                           
               X2=X0                                                    
               Y2=Y0                                                    
            ENDIF                                                       
         ELSE                                                           
            X2=XN                                                       
            Y2=YN                                                       
            IF(Y0.LT.0.) THEN                                           
               X1=X0                                                    
               Y1=Y0                                                    
            ENDIF                                                       
         ENDIF                                                          
      ELSEIF(Y0.GT.ERR) THEN                                            
         X2=X0                                                          
         Y2=Y0                                                          
      ELSE                                                              
         X1=X0                                                          
         Y1=Y0                                                          
      ENDIF                                                             
      IF(IZERO.LT.NIZERO) GOTO 10                                       
C     ***END LOOP ON IZERO***                                           
      IF(IOUT.EQ.0) WRITE(   *,13) NIZERO                               
      IF(IOUT.NE.0) WRITE(IOUT,13) NIZERO                               
C                                                                       
   20 X=X0                                                              
      Y=SIG*Y0                                                          
      X1=X1S                                                            
      Y1=Y1S                                                            
      X2=X2S                                                            
      Y2=Y2S                                                            
      RETURN                                                            
C                                                                       
   30 X=XN                                                              
      Y=SIG*YN                                                          
      X1=X1S                                                            
      Y1=Y1S                                                            
      X2=X2S                                                            
      Y2=Y2S                                                            
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    5 FORMAT(/1X,'***SUBROUTINE ZERO: Y1 AND Y2 VIOLATE REQUIREMENTS')  
    6 FORMAT(/30X,'==== SUBROUTINE ZERO ====')                          
   11 FORMAT(1X,'IZERO=',I3,3X,'X1=',1PE12.4,3X,'Y1=',1PE12.4,          
     A       3X,'X2=',1PE12.4,3X,'Y2=',1PE12.4,3X,'X0=',1PE12.4,        
     B       3X,'Y0=',1PE12.4)                                          
   12 FORMAT(1X,'IZERO=',I3,3X,'X1=',1PE12.4,3X,'Y1=',1PE12.4,          
     A       3X,'X2=',1PE12.4,3X,'Y2=',1PE12.4,3X,'XN=',1PE12.4,        
     B       3X,'YN=',1PE12.4)                                          
   13 FORMAT(/1X,'***SUBROUTINE ZERO: NO CONVERGENCE FOR X IN ',I3,     
     A       ' STEPS')                                                  
      END                                                               
C                                                                       
      SUBROUTINE MAPIN1(SIGNUL,SIG,THIN,ROIN,MHARM,JPTS,NIMAP,IMAPIN,   
     A                  ERROR,TEST,LL,L1,L2,L3,L4,L5,L6,L7,L8,L9)       
C                                                                       
C     ******************************************************************
C     * THE INVERSE CONFORMAL MAPPING ZETA=ZETA(W),                    *
C     *   WHERE ZETA=RHO*EXP(I*THETA) AND W=S*EXP(I*T),                *
C     * OF THE INTERIOR OF THE CURVE RHO=G(THETA) IN THE ZETA-PLANE    *
C     * TO THE UNIT DISK S.LE.1 IN THE W-PLANE IS OBTAINED BY MEANS OF *
C     * THE THEODORSEN INTEGRAL EQUATION IN FOURIER REPRESENTATION.    *
C     * INPUT: THE FOURIER COEFFICIENTS SIGNUL,SIG(M), M=1,MHARM       *
C     * (WHERE MHARM.LE.JPTS/2-1) OF THE BOUNDARY CURVE                *
C     *   RHO=G(THETA)=.5*SIGNUL+SUM(SIG(M)*COS(M*THETA))              *
C     * IN THE ZETA-PLANE.                                             *
C     * OUTPUT: THE BOUNDARY CORRESPONDENCE FUNCTIONS                  *
C     *   THETA=THIN(T),   RHO=G(THIN(T))=ROIN(T)                      *
C     * ON THE GRID T(J),J=1,JPTS IN THE W-PLANE.                      *
C     * DIAGNOSTIC INFORMATION IS PRINTED IF ONE OF THE PRINT SWITCHES *
C     * L,L1,..,L9 .NE. 0.                                             *
C     * THE ARGUMENT LL HAS THE DOUBLE FUNCTION OF COMMUNICATING THE   *
C     * OUTPUT UNIT IOUT=LL/10 AND THE PRINT SWITCH L=LL-IOUT*10.      *
C     * IOUT=0 (L=LL): FILE IS "OUTPUT".                               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (JMAX=256)                                              
      DIMENSION SIG(*),THIN(*),ROIN(*),                                 
     A          T(JMAX),A(JMAX),C(JMAX),AF(JMAX/2-1),CF(JMAX/2-1)       
C                                                                       
      IOUT=LL/10                                                        
      L=LL-IOUT*10                                                      
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,5)                                    
         IF(IOUT.NE.0) WRITE(IOUT,5)                                    
      ENDIF                                                             
      PI=3.1415926535898                                                
      JHP=JPTS/2+1                                                      
      JHPP=JPTS/2+2                                                     
      JPTSPP=JPTS+2                                                     
C                                                                       
C1    * GRID AND INITIALIZATION.                                        
      DO 10 J=1,JPTS                                                    
      T(J)=2.*PI*(J-1.)/JPTS                                            
      THIN(J)=T(J)                                                      
   10 CONTINUE                                                          
      DO 15 M=1,MHARM                                                   
   15 CF(M)=0.                                                          
      DO 20 J=1,JHP                                                     
   20 CALL FSUM(ROIN(J),THIN(J),SIGNUL,SIG,MHARM)                       
      DO 30 J=JHPP,JPTS                                                 
   30 ROIN(J)=ROIN(JPTSPP-J)                                            
      IF(L1.NE.0) THEN                                                  
         IF(IOUT.EQ.0) WRITE(   *,31)                                   
         IF(IOUT.NE.0) WRITE(IOUT,31)                                   
         CALL PRARR1('THIN(J):',THIN,JPTS,IOUT*10+L1)                   
         CALL PRARR1('ROIN(J):',ROIN,JPTS,IOUT*10+L1)                   
      ENDIF                                                             
C                                                                       
C2    * ITERATION.                                                      
      IF(L2.NE.0) THEN                                                  
         IF(IOUT.EQ.0) WRITE(   *,32)                                   
         IF(IOUT.NE.0) WRITE(IOUT,32)                                   
      ENDIF                                                             
      TEST=100.                                                         
      DO 100 IMAP=1,NIMAP                                               
      DO 40 J=1,JHP                                                     
      A(J)=DLOG(ROIN(J))                                                
   40 CONTINUE                                                          
      DO 50 J=JHPP,JPTS                                                 
      A(J)=A(JPTSPP-J)                                                  
   50 CONTINUE                                                          
      IF(L2.NE.0) THEN                                                  
         IF(IOUT.EQ.0) WRITE(   *,51) IMAP                              
         IF(IOUT.NE.0) WRITE(IOUT,51) IMAP                              
      ENDIF                                                             
      IF(L3.NE.0) CALL PRARR1('A(J):',A,JPTS,IOUT*10+L3)                
      CALL RFTCOS(A,AFNUL,AF,JPTS,MHARM)                                
      SUM1=0.                                                           
      SUM2=0.                                                           
      DO 60 M=1,MHARM                                                   
      CFS=CF(M)                                                         
      CF(M)=AF(M)                                                       
      SUM1=SUM1+(CF(M)-CFS)**2                                          
      SUM2=SUM2+(CF(M)+CFS)**2                                          
   60 CONTINUE                                                          
      IF(L4.NE.0) THEN                                                  
         IF(IOUT.EQ.0) WRITE(   *,61) AFNUL                             
         IF(IOUT.NE.0) WRITE(IOUT,61) AFNUL                             
         CALL PRARR1('AF(M),CF(M):',CF,MHARM,IOUT*10+L4)                
      ENDIF                                                             
      CALL RFISIN(C,CF,JPTS,MHARM)                                      
      IF(L5.NE.0) CALL PRARR1('C(J):',C,JPTS,IOUT*10+L5)                
      DO 70 J=1,JPTS                                                    
   70 THIN(J)=C(J)+T(J)                                                 
      DO 80 J=1,JHP                                                     
   80 CALL FSUM(ROIN(J),THIN(J),SIGNUL,SIG,MHARM)                       
      DO 90 J=JHPP,JPTS                                                 
   90 ROIN(J)=ROIN(JPTSPP-J)                                            
      IF(L6.NE.0) THEN                                                  
         CALL PRARR1('THIN(J):',THIN,JPTS,IOUT*10+L6)                   
         CALL PRARR1('ROIN(J):',ROIN,JPTS,IOUT*10+L6)                   
      ENDIF                                                             
C                                                                       
C     * TEST CONVERGENCE.                                               
      STEST=TEST                                                        
      IF(SUM2.EQ.0.) SUM2=1.E-20                                        
      TEST=SQRT(SUM1/SUM2)                                              
      IF(L7.NE.0) THEN                                                  
         IF(IOUT.EQ.0) WRITE(   *,91) TEST                              
         IF(IOUT.NE.0) WRITE(IOUT,91) TEST                              
      ENDIF                                                             
      IF(TEST.LE.ERROR) GOTO 110                                        
      IF(TEST.LE..999*STEST) GOTO 100                                   
      IF(TEST.LT.STEST) THEN                                            
         IF(IOUT.EQ.0) WRITE(   *,92) IMAP,TEST                         
         IF(IOUT.NE.0) WRITE(IOUT,92) IMAP,TEST                         
      ENDIF                                                             
      IF(TEST.GT.STEST) THEN                                            
         IF(IOUT.EQ.0) WRITE(   *,93) IMAP,STEST,TEST                   
         IF(IOUT.NE.0) WRITE(IOUT,93) IMAP,STEST,TEST                   
      ENDIF                                                             
      GOTO 110                                                          
  100 CONTINUE                                                          
C                                                                       
      IMAP=NIMAP                                                        
      IF(IOUT.EQ.0) WRITE(   *,101) IMAP,TEST                           
      IF(IOUT.NE.0) WRITE(IOUT,101) IMAP,TEST                           
  110 CONTINUE                                                          
C                                                                       
C3    * END RESULT OF THE MAPPING.                                      
      IF((L8.NE.0).OR.(L9.NE.0)) THEN                                   
         IF(IOUT.EQ.0) WRITE(   *,111) TEST                             
         IF(IOUT.NE.0) WRITE(IOUT,111) TEST                             
      ENDIF                                                             
      IF(L8.NE.0) CALL PRARR1('THIN(J):',THIN,JPTS,IOUT*10+L8)          
      IF(L9.NE.0) CALL PRARR1('ROIN(J):',ROIN,JPTS,IOUT*10+L9)          
      IMAPIN=IMAP                                                       
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,112)                                  
         IF(IOUT.NE.0) WRITE(IOUT,112)                                  
      ENDIF                                                             
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    5 FORMAT(//30X,'==== BEGIN SUBROUTINE MAPIN1 ====')                 
   31 FORMAT(/32X,'-- GRID AND INITIALIZATION --')                      
   32 FORMAT(/32X,'-- ITERATION --')                                    
   51 FORMAT(/35X,'IMAP=',I2)                                           
   61 FORMAT(/1X,'AFNUL=',1PE12.4)                                      
   91 FORMAT(/32X,'-- TEST CONVERGENCE:',5X,'TEST=',1PE12.4,' --')      
   92 FORMAT(/1X,'***SUBROUTINE MAPIN1: SATURATION AT IMAP=',I3,4X,     
     A       'TEST=',1PE12.4)                                           
   93 FORMAT(/1X,'***SUBROUTINE MAPIN1: DIVERGENCE AT IMAP=',I3,4X,     
     A       'STEST=',1PE12.4,4X,'TEST=',1PE12.4)                       
  101 FORMAT(/1X,'***SUBROUTINE MAPIN1: PRESCRIBED ACCURACY NOT YET ',  
     A       'REACHED AT IMAP=',I3,4X,'TEST=',1PE12.4)                  
  111 FORMAT(/32X,'-- END RESULT OF THE MAPPING:',5X,'TEST=',1PE12.4,   
     A       ' --'//32X,'-- BOUNDARY CORRESPONDENCE FUNCTIONS --')      
  112 FORMAT(//30X,'==== END SUBROUTINE MAPIN1 ====')                   
      END                                                               
C                                                                       
      SUBROUTINE MAPIN(SIGNUL,SIG,THETIN,RHOIN,MAX,IPTS,NIMAP,IMAPIN,   
     A                 ACC,L)                                           
C                                                                       
C     ******************************************************************
C     * THE INVERSE CONFORMAL MAPPING ZETA=ZETA(W),                    *
C     *   WHERE ZETA=RHO*EXP(I*THETA) AND W=S*EXP(I*T),                *
C     * OF THE INTERIOR OF THE CURVE RHO=G(THETA) IN THE ZETA-PLANE    *
C     * TO THE UNIT DISK S.LE.1 IN THE W-PLANE IS OBTAINED BY MEANS OF *
C     * THE THEODORSEN INTEGRAL EQUATION IN FOURIER REPRESENTATION.    *
C     * INPUT: THE FOURIER COEFFICIENTS SIGNUL,SIG(M),M=1,MAXM OF THE  *
C     * BOUNDARY CURVE                                                 *
C     *   RHO=G(THETA)=.5*SIGNUL+SUM(SIG(M)*COS(M*THETA))              *
C     * IN THE ZETA-PLANE.                                             *
C     * OUTPUT: THE BOUNDARY CORRESPONDENCE FUNCTIONS                  *
C     *   THETA=THETIN(T),   RHO=G(THETIN(T))=RHOIN(T)                 *
C     * ON THE GRID T(I),I=1,IPTS IN THE W-PLANE.                      *
C     * WHEN THIS SUBROUTINE IS CALLED WITH L=1 ONE SHOULD FURNISH THE *
C     * NAMELIST INPUT $LMAPIN -- $.                                   *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION SIG(*),THETIN(*),RHOIN(*),                              
     A          T(256),A(256),C(256),AF(39),CF(39)                      
      NAMELIST/LMAPIN/L1,L2,L3,L4,L5,L6,L7,L8                           
      DATA            L1,L2,L3,L4,L5,L6,L7,L8                           
     A               / 0, 0, 0, 0, 0, 0, 0, 0/                          
      IF(L.EQ.0) GOTO 5                                                 
      READ(10,LMAPIN)                                                   
      PRINT 3,L1,L2,L3,L4,L5,L6,L7,L8                                   
    5 PI=4.*ATAN(1.)                                                    
      MAXM=MAX-1                                                        
      IHP=IPTS/2+1                                                      
      IHPP=IPTS/2+2                                                     
      IPTSPP=IPTS+2                                                     
C                                                                       
C     * GRID AND INITIALIZATION                                         
      DO 10 I=1,IPTS                                                    
      T(I)=2.*PI*(I-1.)/IPTS                                            
      THETIN(I)=T(I)                                                    
   10 CONTINUE                                                          
      DO 11 M=1,MAXM                                                    
   11 CF(M)=0.                                                          
      DO 20 I=1,IHP                                                     
   20 CALL FSUM(RHOIN(I),THETIN(I),SIGNUL,SIG,MAXM)                     
      DO 30 I=IHPP,IPTS                                                 
   30 RHOIN(I)=RHOIN(IPTSPP-I)                                          
      IF(L1.EQ.1) PRINT 31                                              
      IF(L1.EQ.1) CALL PRARR1('THETIN: ',THETIN,IPTS,1)                 
      IF(L1.EQ.1) CALL PRARR1('RHOIN:  ',RHOIN,IPTS,1)                  
      IF(L2.EQ.1) PRINT 32                                              
C                                                                       
C     * ITERATION                                                       
      TEST=100.                                                         
      DO 100 IMAP=1,NIMAP                                               
      DO 40 I=1,IHP                                                     
      A(I)=DLOG(RHOIN(I))                                               
   40 CONTINUE                                                          
      DO 50 I=IHPP,IPTS                                                 
      A(I)=A(IPTSPP-I)                                                  
   50 CONTINUE                                                          
      IF(L2.EQ.1) PRINT 51,IMAP                                         
      IF(L3.EQ.1) CALL PRARR1('A(I):   ',A,IPTS,1)                      
      CALL RFTCOS(A,AFNUL,AF,IPTS,MAXM)                                 
      IF(L3.EQ.1) PRINT 52,AFNUL                                        
      IF(L3.EQ.1) CALL PRARR1('AF(M):  ',AF,MAXM,1)                     
      SUM1=0.                                                           
      SUM2=0.                                                           
      DO 60 M=1,MAXM                                                    
      CFS=CF(M)                                                         
      CF(M)=AF(M)                                                       
      SUM1=SUM1+(CF(M)-CFS)**2                                          
      SUM2=SUM2+(CF(M)+CFS)**2                                          
   60 CONTINUE                                                          
      IF(L5.EQ.1) CALL PRARR1('CF(M):  ',CF,MAXM,1)                     
      CALL RFISIN(C,CF,IPTS,MAXM)                                       
      IF(L5.EQ.1) CALL PRARR1('C(I):   ',C,IPTS,1)                      
      DO 70 I=1,IPTS                                                    
   70 THETIN(I)=C(I)+T(I)                                               
      DO 71 I=1,IHP                                                     
   71 CALL FSUM(RHOIN(I),THETIN(I),SIGNUL,SIG,MAXM)                     
      DO 72 I=IHPP,IPTS                                                 
   72 RHOIN(I)=RHOIN(IPTSPP-I)                                          
      IF(L6.EQ.1) CALL PRARR1('THETIN: ',THETIN,IPTS,1)                 
      IF(L6.EQ.1) CALL PRARR1('RHOIN:  ',RHOIN,IPTS,1)                  
C                                                                       
C     * TEST CONVERGENCE                                                
      STEST=TEST                                                        
      IF(SUM2.EQ.0.) SUM2=1.E-20                                        
      TEST=SQRT(SUM1/SUM2)                                              
      IF(L7.EQ.1) PRINT 73,TEST                                         
      IF(TEST.LE.ACC) GOTO 120                                          
      IF(TEST.LE..999*STEST) GOTO 100                                   
      IF(TEST.LT.STEST) PRINT 80,IMAP,TEST                              
      IF(TEST.GT.STEST) PRINT 90,IMAP,STEST,TEST                        
      GOTO 120                                                          
  100 CONTINUE                                                          
      IMAP=NIMAP                                                        
      PRINT 110,IMAP,TEST                                               
  120 CONTINUE                                                          
C                                                                       
C     * ENDRESULT OF MAPPING                                            
      IF(L8.EQ.1) PRINT 121,TEST                                        
      IF(L8.EQ.1) CALL PRARR1('THETIN: ',THETIN,IPTS,1)                 
      IF(L8.EQ.1) CALL PRARR1('RHOIN:  ',RHOIN,IPTS,1)                  
      IMAPIN=IMAP                                                       
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    3 FORMAT(///1X,'SUBROUTINE MAPIN',///1X,'$LMAPIN L1=',I2,' L2=',I2, 
     A       ' L3=',I2,' L4=',I2,' L5=',I2,' L6=',I2,' L7=',I2,         
     B       ' L8=',I2,'$')                                             
   31 FORMAT(/1X,'-GRID AND INITIALIZATION:')                           
   32 FORMAT(/1X,'-ITERATION:')                                         
   51 FORMAT(/1X,'IMAP=',I2)                                            
   52 FORMAT(/1X,'AFNUL=',F10.5)                                        
   73 FORMAT(/1X,'-TEST CONVERGENCE:',//1X,'TEST=',F10.5)               
   80 FORMAT(/1X,'***SUBROUTINE MAPIN: SATURATION AT IMAP=',I3,4X,      
     A       'TEST=',F10.5)                                             
   90 FORMAT(/1X,'***SUBROUTINE MAPIN: DIVERGENCE AT IMAP=',I3,4X,      
     A       'STEST=',F10.5,4X,'TEST=',F10.5)                           
  110 FORMAT(/1X,'***SUBROUTINE MAPIN: PRESCRIBED ACCURACY NOT YET ',   
     A       'REACHED AT IMAP=',I3,4X,'TEST=',F10.5)                    
  121 FORMAT(/1X,'-ENDRESULT:',//1X,'TEST=',F10.5)                      
      END                                                               
C                                                                       
      SUBROUTINE MAPEX(SIGNL0,SIG0,SIGNL1,SIG1,THETX0,THETX1,           
     A                 RHOEX0,RHOEX1,P,MAX,IPTS,NIMAP,IMAPEX,ACC,L)     
C                                                                       
C     ******************************************************************
C     * THE INVERSE CONFORMAL MAPPING ZETA=ZETA(OMEGA),                *
C     *   WHERE ZETA=RHO*EXP(I*THETA) AND OMEGA=SIGMA*EXP(I*TAU),      *
C     * OF THE REGION BOUNDED BY THE TWO CURVES RHO=G0(THETA) AND      *
C     * RHO=G1(THETA) IN THE ZETA-PLANE TO THE ANNULUS P.LE.SIGMA.LE.1 *
C     * IS OBTAINED BY MEANS OF GARRICKS INTEGRAL EQUATION IN FOURIER  *
C     * REPRESENTATION.                                                *
C     * INPUT: THE FOURIERCOEFFICIENTS SIGNL0,SIG0(M),SIGNL1,SIG1(M),  *
C     * M=1,MAXM OF THE BOUNDARY CURVES                                *
C     *   RHO=G0(THETA)=.5*SIGNL0+SUM(SIG0(M)*COS(M*THETA))            *
C     *   RHO=G1(THETA)=.5*SIGNL1+SUM(SIG1(M)*COS(M*THETA))            *
C     * IN THE ZETA-PLANE.                                             *
C     * OUTPUT: THE MODULUS P AND THE BOUNDARY CORRESPONDENCE FUNCTIONS*
C     *   THETA=THETX0(TAU),   RHO=G0(THETX0(TAU))=RHOEX0(TAU),        *
C     *   THETA=THETX1(TAU),   RHO=G1(THETX1(TAU))=RHOEX1(TAU)         *
C     * ON THE GRID TAU(I),I=1,IPTS IN THE OMEGA-PLANE.                *
C     * WHEN THIS SUBROUTINE IS CALLED WITH L=1 ONE SHOULD FURNISH THE *
C     * NAMELIST INPUT $LMAPEX -- $.                                   *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION SIG0(*),SIG1(*),THETX0(*),THETX1(*),                    
     A          RHOEX0(*),RHOEX1(*),TAU(256),                           
     B          A(256),B(256),C(256),D(256),                            
     C          AF(39),BF(39),CF(39),DF(39)                             
      NAMELIST/LMAPEX/L1,L2,L3,L4,L5,L6,L7,L8                           
      DATA            L1,L2,L3,L4,L5,L6,L7,L8                           
     A               / 0, 0, 0, 0, 0, 0, 0, 0/                          
      IF(L.EQ.0) GOTO 5                                                 
      READ(10,LMAPEX)                                                   
      PRINT 3,L1,L2,L3,L4,L5,L6,L7,L8                                   
    5 PI=4.*ATAN(1.)                                                    
      MAXM=MAX-1                                                        
      IHP=IPTS/2+1                                                      
      IHPP=IPTS/2+2                                                     
      IPTSPP=IPTS+2                                                     
C                                                                       
C     * GRID AND INITIALIZATION                                         
      DO 10 I=1,IPTS                                                    
      TAU(I)=2.*PI*(I-1.)/IPTS                                          
      THETX0(I)=TAU(I)                                                  
      THETX1(I)=TAU(I)                                                  
   10 CONTINUE                                                          
      DO 11 M=1,MAXM                                                    
      CF(M)=0.                                                          
      DF(M)=0.                                                          
   11 CONTINUE                                                          
      DO 20 I=1,IHP                                                     
      CALL FSUM(RHOEX0(I),THETX0(I),SIGNL0,SIG0,MAXM)                   
   20 CALL FSUM(RHOEX1(I),THETX1(I),SIGNL1,SIG1,MAXM)                   
      DO 30 I=IHPP,IPTS                                                 
      RHOEX0(I)=RHOEX0(IPTSPP-I)                                        
   30 RHOEX1(I)=RHOEX1(IPTSPP-I)                                        
      IF(L1.EQ.1) PRINT 31                                              
      IF(L1.EQ.1) CALL PRARR1('THETX0: ',THETX0,IPTS,1)                 
      IF(L1.EQ.1) CALL PRARR1('THETX1: ',THETX1,IPTS,1)                 
      IF(L1.EQ.1) CALL PRARR1('RHOEX0: ',RHOEX0,IPTS,1)                 
      IF(L1.EQ.1) CALL PRARR1('RHOEX1: ',RHOEX1,IPTS,1)                 
      IF(L2.EQ.1) PRINT 32                                              
C                                                                       
C     * ITERATION                                                       
      TEST=100.                                                         
      DO 100 IMAP=1,NIMAP                                               
      DO 40 I=1,IHP                                                     
      A(I)=DLOG(RHOEX0(I))                                              
      B(I)=DLOG(RHOEX1(I))                                              
   40 CONTINUE                                                          
      DO 50 I=IHPP,IPTS                                                 
      A(I)=A(IPTSPP-I)                                                  
      B(I)=B(IPTSPP-I)                                                  
   50 CONTINUE                                                          
      IF(L2.EQ.1) PRINT 51,IMAP                                         
      IF(L3.EQ.1) CALL PRARR1('A(I):   ',A,IPTS,1)                      
      IF(L3.EQ.1) CALL PRARR1('B(I):   ',B,IPTS,1)                      
      CALL RFTCOS(A,AFNUL,AF,IPTS,MAXM)                                 
      CALL RFTCOS(B,BFNUL,BF,IPTS,MAXM)                                 
      IF(L3.EQ.1) PRINT 52,AFNUL,BFNUL                                  
      IF(L3.EQ.1) CALL PRARR1('AF(M):  ',AF,MAXM,1)                     
      IF(L3.EQ.1) CALL PRARR1('BF(M):  ',BF,MAXM,1)                     
      P=EXP((AFNUL-BFNUL)/2.)                                           
      IF(L4.EQ.1) PRINT 53,P                                            
      SUM1=0.                                                           
      SUM2=0.                                                           
      TERM=1.                                                           
      DO 60 M=1,MAXM                                                    
      TERM=P*TERM                                                       
      TERMS=TERM*TERM                                                   
      FAC1=(1.+TERMS)/(1.-TERMS)                                        
      FAC2=2.*TERM/(1.-TERMS)                                           
      CFS=CF(M)                                                         
      DFS=DF(M)                                                         
      CF(M)=-FAC1*AF(M)+FAC2*BF(M)                                      
      DF(M)=-FAC2*AF(M)+FAC1*BF(M)                                      
      SUM1=SUM1+(CF(M)-CFS)**2+(DF(M)-DFS)**2                           
      SUM2=SUM2+(CF(M)+CFS)**2+(DF(M)+DFS)**2                           
   60 CONTINUE                                                          
      IF(L5.EQ.1) CALL PRARR1('CF(M):  ',CF,MAXM,1)                     
      IF(L5.EQ.1) CALL PRARR1('DF(M):  ',DF,MAXM,1)                     
      CALL RFISIN(C,CF,IPTS,MAXM)                                       
      CALL RFISIN(D,DF,IPTS,MAXM)                                       
      IF(L5.EQ.1) CALL PRARR1('C(I):   ',C,IPTS,1)                      
      IF(L5.EQ.1) CALL PRARR1('D(I):   ',D,IPTS,1)                      
      DO 70 I=1,IPTS                                                    
      THETX0(I)=C(I)+TAU(I)                                             
      THETX1(I)=D(I)+TAU(I)                                             
   70 CONTINUE                                                          
      DO 71 I=1,IHP                                                     
      CALL FSUM(RHOEX0(I),THETX0(I),SIGNL0,SIG0,MAXM)                   
   71 CALL FSUM(RHOEX1(I),THETX1(I),SIGNL1,SIG1,MAXM)                   
      DO 72 I=IHPP,IPTS                                                 
      RHOEX0(I)=RHOEX0(IPTSPP-I)                                        
   72 RHOEX1(I)=RHOEX1(IPTSPP-I)                                        
      IF(L6.EQ.1) CALL PRARR1('THETX0: ',THETX0,IPTS,1)                 
      IF(L6.EQ.1) CALL PRARR1('THETX1: ',THETX1,IPTS,1)                 
      IF(L6.EQ.1) CALL PRARR1('RHOEX0: ',RHOEX0,IPTS,1)                 
      IF(L6.EQ.1) CALL PRARR1('RHOEX1: ',RHOEX1,IPTS,1)                 
C                                                                       
C     * TEST CONVERGENCE                                                
      STEST=TEST                                                        
      IF(SUM2.EQ.0.) SUM2=1.E-20                                        
      TEST=SQRT(SUM1/SUM2)                                              
      IF(L7.EQ.1) PRINT 73,TEST                                         
      IF(TEST.LE.ACC) GOTO 120                                          
      IF(TEST.LE..999*STEST) GOTO 100                                   
      IF(TEST.LT.STEST) PRINT 80,IMAP,TEST                              
      IF(TEST.GT.STEST) PRINT 90,IMAP,STEST,TEST                        
      GOTO 120                                                          
  100 CONTINUE                                                          
      IMAP=NIMAP                                                        
      PRINT 110,IMAP,TEST                                               
  120 CONTINUE                                                          
C                                                                       
C     * ENDRESULT OF MAPPING                                            
      IF(L8.EQ.1) PRINT 121,TEST,P                                      
      IF(L8.EQ.1) CALL PRARR1('THETX0: ',THETX0,IPTS,1)                 
      IF(L8.EQ.1) CALL PRARR1('THETX1: ',THETX1,IPTS,1)                 
      IF(L8.EQ.1) CALL PRARR1('RHOEX0: ',RHOEX0,IPTS,1)                 
      IF(L8.EQ.1) CALL PRARR1('RHOEX1: ',RHOEX1,IPTS,1)                 
      IMAPEX=IMAP                                                       
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    3 FORMAT(///1X,'SUBROUTINE MAPEX',///1X,'$LMAPEX L1=',I2,' L2=',I2, 
     A       ' L3=',I2,' L4=',I2,' L5=',I2,' L6=',I2,' L7=',I2,         
     B       ' L8=',I2,'$')                                             
   31 FORMAT(/1X,'-GRID AND INITIALIZATION:')                           
   32 FORMAT(/1X,'-ITERATION:')                                         
   51 FORMAT(/1X,'IMAP=',I2)                                            
   52 FORMAT(/1X,'AFNUL=',F10.5,2X,'BFNUL=',F10.5)                      
   53 FORMAT(/1X,'P=',F10.5)                                            
   73 FORMAT(/1X,'-TEST CONVERGENCE:',//1X,'TEST=',F10.5)               
   80 FORMAT(/1X,'***SUBROUTINE MAPEX: SATURATION AT IMAP=',I3,4X,      
     A       'TEST=',F10.5)                                             
   90 FORMAT(/1X,'***SUBROUTINE MAPEX: DIVERGENCE AT IMAP=',I3,4X,      
     A       'STEST=',F10.5,4X,'TEST=',F10.5)                           
  110 FORMAT(/1X,'***SUBROUTINE MAPEX: PRESCRIBED ACCURACY NOT YET ',   
     A       'REACHED AT IMAP=',I3,4X,'TEST=',F10.5)                    
  121 FORMAT(/1X,'-ENDRESULT:',//1X,'TEST=',F10.5)                      
      END                                                               
C                                                                       
      SUBROUTINE MAPEXC(SIGNUL,SIG,THETEX,RHOEX,P,MAX,IPTS,NIMAP,       
     A                  IMAPXC,ACC,L)                                   
C                                                                       
C     ******************************************************************
C     * THE INVERSE CONFORMAL MAPPING ZETA=ZETA(OMEGA),                *
C     *   WHERE ZETA=RHO*EXP(I*THETA) AND OMEGA=SIGMA*EXP(I*TAU),      *
C     * OF THE REGION BOUNDED BY THE TWO CURVES RHO=G(THETA) AND       *
C     * RHO=1 IN THE ZETA-PLANE TO THE ANNULUS P.LE.SIGMA.LE.1         *
C     * IS OBTAINED BY MEANS OF GARRICKS INTEGRAL EQUATION IN FOURIER  *
C     * REPRESENTATION.                                                *
C     * INPUT: THE FOURIER COEFFICIENTS SIGNUL,SIG(M),M=1,MAXM OF THE  *
C     * INNER BOUNDARY CURVE                                           *
C     *   RHO=G(THETA)=.5*SIGNUL+SUM(SIG(M)*COS(M*THETA))              *
C     * IN THE ZETA-PLANE.                                             *
C     * OUTPUT: THE MODULUS P AND THE INNER BOUNDARY CORRESPONDENCE    *
C     * FUNCTIONS                                                      *
C     *   THETA=THETEX(TAU),   RHO=G(THETEX(TAU))=RHOEX(TAU)           *
C     * ON THE GRID TAU(I),I=1,IPTS IN THE OMEGA-PLANE.                *
C     * WHEN THIS SUBROUTINE IS CALLED WITH L=1 ONE SHOULD FURNISH THE *
C     * NAMELIST INPUT $LMAPXC -- $.                                   *
C     * THIS SOUBROUTINE IS A SPECIAL CASE OF MAPEX, WHERE THE OUTER   *
C     * BOUNDARY IS ALREADY A CIRCLE SO THAT THE OUTER BOUNDARY        *
C     * CORRESPONDENCE FUNCTIONS NEED NOT BE CALCULATED.               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION SIG(*),THETEX(*),RHOEX(*),                              
     A          TAU(256),A(256),C(256),AF(39),CF(39),DF(39)             
      NAMELIST/LMAPXC/L1,L2,L3,L4,L5,L6,L7,L8                           
      DATA            L1,L2,L3,L4,L5,L6,L7,L8                           
     A               / 0, 0, 0, 0, 0, 0, 0, 0/                          
      IF(L.EQ.0) GOTO 5                                                 
      READ(10,LMAPXC)                                                   
      PRINT 3,L1,L2,L3,L4,L5,L6,L7,L8                                   
    5 PI=4.*ATAN(1.)                                                    
      MAXM=MAX-1                                                        
      IHP=IPTS/2+1                                                      
      IHPP=IPTS/2+2                                                     
      IPTSPP=IPTS+2                                                     
C                                                                       
C     * GRID AND INITIALIZATION                                         
      DO 10 I=1,IPTS                                                    
      TAU(I)=2.*PI*(I-1.)/IPTS                                          
      THETEX(I)=TAU(I)                                                  
   10 CONTINUE                                                          
      DO 11 M=1,MAXM                                                    
      CF(M)=0.                                                          
      DF(M)=0.                                                          
   11 CONTINUE                                                          
      DO 20 I=1,IHP                                                     
   20 CALL FSUM(RHOEX(I),THETEX(I),SIGNUL,SIG,MAXM)                     
      DO 30 I=IHPP,IPTS                                                 
   30 RHOEX(I)=RHOEX(IPTSPP-I)                                          
      IF(L1.EQ.1) PRINT 31                                              
      IF(L1.EQ.1) CALL PRARR1('THETEX: ',THETEX,IPTS,1)                 
      IF(L1.EQ.1) CALL PRARR1('RHOEX:  ',RHOEX,IPTS,1)                  
      IF(L2.EQ.1) PRINT 32                                              
C                                                                       
C     * ITERATION                                                       
      TEST=100.                                                         
      DO 100 IMAP=1,NIMAP                                               
      DO 40 I=1,IHP                                                     
      A(I)=DLOG(RHOEX(I))                                               
   40 CONTINUE                                                          
      DO 50 I=IHPP,IPTS                                                 
      A(I)=A(IPTSPP-I)                                                  
   50 CONTINUE                                                          
      IF(L2.EQ.1) PRINT 51,IMAP                                         
      IF(L3.EQ.1) CALL PRARR1('A(I):   ',A,IPTS,1)                      
      CALL RFTCOS(A,AFNUL,AF,IPTS,MAXM)                                 
      IF(L3.EQ.1) PRINT 52,AFNUL                                        
      IF(L3.EQ.1) CALL PRARR1('AF(M):  ',AF,MAXM,1)                     
      P=EXP(AFNUL/2.)                                                   
      IF(L4.EQ.1) PRINT 53,P                                            
      SUM1=0.                                                           
      SUM2=0.                                                           
      TERM=1.                                                           
      DO 60 M=1,MAXM                                                    
      TERM=P*TERM                                                       
      TERMS=TERM*TERM                                                   
      FAC1=(1.+TERMS)/(1.-TERMS)                                        
      FAC2=2.*TERM/(1.-TERMS)                                           
      CFS=CF(M)                                                         
      DFS=DF(M)                                                         
      CF(M)=-FAC1*AF(M)                                                 
      DF(M)=-FAC2*AF(M)                                                 
      SUM1=SUM1+(CF(M)-CFS)**2+(DF(M)-DFS)**2                           
      SUM2=SUM2+(CF(M)+CFS)**2+(DF(M)+DFS)**2                           
   60 CONTINUE                                                          
      IF(L5.EQ.1) CALL PRARR1('CF(M):  ',CF,MAXM,1)                     
      IF(L5.EQ.1) CALL PRARR1('DF(M):  ',DF,MAXM,1)                     
      CALL RFISIN(C,CF,IPTS,MAXM)                                       
      IF(L5.EQ.1) CALL PRARR1('C(I):   ',C,IPTS,1)                      
      DO 70 I=1,IPTS                                                    
   70 THETEX(I)=C(I)+TAU(I)                                             
      DO 71 I=1,IHP                                                     
   71 CALL FSUM(RHOEX(I),THETEX(I),SIGNUL,SIG,MAXM)                     
      DO 72 I=IHPP,IPTS                                                 
   72 RHOEX(I)=RHOEX(IPTSPP-I)                                          
      IF(L6.EQ.1) CALL PRARR1('THETEX: ',THETEX,IPTS,1)                 
      IF(L6.EQ.1) CALL PRARR1('RHOEX:  ',RHOEX,IPTS,1)                  
C                                                                       
C     * TEST CONVERGENCE                                                
      STEST=TEST                                                        
      IF(SUM2.EQ.0.) SUM2=1.E-20                                        
      TEST=SQRT(SUM1/SUM2)                                              
      IF(L7.EQ.1) PRINT 73,TEST                                         
      IF(TEST.LE.ACC) GOTO 120                                          
      IF(TEST.LE..999*STEST) GOTO 100                                   
      IF(TEST.LT.STEST)  PRINT 80,IMAP,TEST                             
      IF(TEST.GT.STEST)PRINT 90,IMAP,STEST,TEST                         
      GOTO 120                                                          
  100 CONTINUE                                                          
      IMAP=NIMAP                                                        
      PRINT 110,IMAP,TEST                                               
  120 CONTINUE                                                          
C                                                                       
C     * ENDRESULT OF MAPPING                                            
      IF(L8.EQ.1) PRINT 121,TEST,P                                      
      IF(L8.EQ.1) CALL PRARR1('THETEX: ',THETEX,IPTS,1)                 
      IF(L8.EQ.1) CALL PRARR1('RHOEX:  ',RHOEX,IPTS,1)                  
      IMAPXC=IMAP                                                       
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    3 FORMAT(///1X,'SUBROUTINE MAPEXC',///1X,'$LMAPXC L1=',I2,' L2=',I2,
     A       ' L3=',I2,' L4=',I2,' L5=',I2,' L6=',I2,' L7=',I2,         
     B       ' L8=',I2,'$')                                             
   31 FORMAT(/1X,'-GRID AND INITIALIZATION:')                           
   32 FORMAT(/1X,'-ITERATION:')                                         
   51 FORMAT(/1X,'IMAP=',I2)                                            
   52 FORMAT(/1X,'AFNUL=',F10.5)                                        
   53 FORMAT(/1X,'P=',F10.5)                                            
   73 FORMAT(/1X,'-TEST CONVERGENCE:',//1X,'TEST=',F10.5)               
   80 FORMAT(/1X,'***SUBROUTINE MAPEXC: SATURATION AT IMAP=',I3,4X,     
     A       'TEST=',F10.5)                                             
   90 FORMAT(/1X,'***SUBROUTINE MAPEXC: DIVERGENCE AT IMAP=',I3,4X,     
     A       'STEST=',F10.5,4X,'TEST=',F10.5)                           
  110 FORMAT(/1X,'***SUBROUTINE MAPEXC: PRESCRIBED ACCURACY NOT YET ',  
     A       'REACHED AT IMAP=',I3,4X,'TEST=',F10.5)                    
  121 FORMAT(/1X,'-ENDRESULT:',//1X,'TEST=',F10.5)                      
      END                                                               
C                                                                       
      SUBROUTINE MAPEXI(SIGNUL,SIG,THETEX,RHOEX,MAX,IPTS,NIMAP,         
     A                  IMAPXI,ACC,L)                                   
C                                                                       
C     ******************************************************************
C     * THE INVERSE CONFORMAL MAPPING ZETA=ZETA(OMEGA),                *
C     *   WHERE ZETA=RHO*EXP(I*THETA) AND OMEGA=SIGMA*EXP(I*TAU),      *
C     * OF THE EXTERIOR OF THE CURVE RHO=G(THETA) IN THE ZETA-PLANE    *
C     * TO THE EXTERIOR OF THE UNIT DISK SIGMA.GE.1 IN THE OMEGA-PLANE *
C     * IS OBTAINED BY MEANS OF THE SPECIAL CASE P=0 OF GARRICKS       *
C     * INTEGRAL EQUATION IN FOURIER REPRESENTATION.                   *
C     * INPUT: THE FOURIER COEFFICIENTS SIGNUL,SIG(M),M=1,MAXM OF THE  *
C     * BOUNDARY CURVE                                                 *
C     *   RHO=G(THETA)=.5*SIGNUL+SUM(SIG(M)*COS(M*THETA))              *
C     * IN THE ZETA-PLANE.                                             *
C     * OUTPUT: THE BOUNDARY CORRESPONDENCE FUNCTIONS                  *
C     *   THETA=THETEX(TAU),   RHO=G(THETEX(TAU))=RHOEX(TAU)           *
C     * ON THE GRID TAU(I),I=1,IPTS IN THE OMEGA-PLANE.                *
C     * WHEN THIS SUBROUTINE IS CALLED WITH L=1 ONE SHOULD FURNISH THE *
C     * NAMELIST INPUT $LMAPXI -- $.                                   *
C     * THIS SOUBROUTINE IS A SPECIAL CASE OF MAPEX, WHERE THE OUTER   *
C     * BOUNDARY IS MOVED TO INFINITY SO THAT THE OUTER BOUNDARY       *
C     * CORRESPONDENCE FUNCTIONS NEED NOT BE CALCULATED.               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION SIG(*),THETEX(*),RHOEX(*),                              
     A          TAU(256),A(256),C(256),AF(39),CF(39)                    
      NAMELIST/LMAPXI/L1,L2,L3,L4,L5,L6,L7,L8                           
      DATA            L1,L2,L3,L4,L5,L6,L7,L8                           
     A               / 0, 0, 0, 0, 0, 0, 0, 0/                          
      IF(L.EQ.0) GOTO 5                                                 
      READ(10,LMAPXI)                                                   
      PRINT 3,L1,L2,L3,L4,L5,L6,L7,L8                                   
    5 PI=4.*ATAN(1.)                                                    
      MAXM=MAX-1                                                        
      IHP=IPTS/2+1                                                      
      IHPP=IPTS/2+2                                                     
      IPTSPP=IPTS+2                                                     
C                                                                       
C     * GRID AND INITIALIZATION                                         
      DO 10 I=1,IPTS                                                    
      TAU(I)=2.*PI*(I-1.)/IPTS                                          
      THETEX(I)=TAU(I)                                                  
   10 CONTINUE                                                          
      DO 11 M=1,MAXM                                                    
      CF(M)=0.                                                          
   11 CONTINUE                                                          
      DO 20 I=1,IHP                                                     
   20 CALL FSUM(RHOEX(I),THETEX(I),SIGNUL,SIG,MAXM)                     
      DO 30 I=IHPP,IPTS                                                 
   30 RHOEX(I)=RHOEX(IPTSPP-I)                                          
      IF(L1.EQ.1) PRINT 31                                              
      IF(L1.EQ.1) CALL PRARR1('THETEX: ',THETEX,IPTS,1)                 
      IF(L1.EQ.1) CALL PRARR1('RHOEX:  ',RHOEX,IPTS,1)                  
      IF(L2.EQ.1) PRINT 32                                              
C                                                                       
C     * ITERATION                                                       
      TEST=100.                                                         
      DO 100 IMAP=1,NIMAP                                               
      DO 40 I=1,IHP                                                     
      A(I)=DLOG(RHOEX(I))                                               
   40 CONTINUE                                                          
      DO 50 I=IHPP,IPTS                                                 
      A(I)=A(IPTSPP-I)                                                  
   50 CONTINUE                                                          
      IF(L2.EQ.1) PRINT 51,IMAP                                         
      IF(L3.EQ.1) CALL PRARR1('A(I):   ',A,IPTS,1)                      
      CALL RFTCOS(A,AFNUL,AF,IPTS,MAXM)                                 
      IF(L3.EQ.1) PRINT 52,AFNUL                                        
      IF(L3.EQ.1) CALL PRARR1('AF(M):  ',AF,MAXM,1)                     
      SUM1=0.                                                           
      SUM2=0.                                                           
      DO 60 M=1,MAXM                                                    
      CFS=CF(M)                                                         
      CF(M)=-AF(M)                                                      
      SUM1=SUM1+(CF(M)-CFS)**2                                          
      SUM2=SUM2+(CF(M)+CFS)**2                                          
   60 CONTINUE                                                          
      IF(L5.EQ.1) CALL PRARR1('CF(M):  ',CF,MAXM,1)                     
      CALL RFISIN(C,CF,IPTS,MAXM)                                       
      IF(L5.EQ.1) CALL PRARR1('C(I):   ',C,IPTS,1)                      
      DO 70 I=1,IPTS                                                    
   70 THETEX(I)=C(I)+TAU(I)                                             
      DO 71 I=1,IHP                                                     
   71 CALL FSUM(RHOEX(I),THETEX(I),SIGNUL,SIG,MAXM)                     
      DO 72 I=IHPP,IPTS                                                 
   72 RHOEX(I)=RHOEX(IPTSPP-I)                                          
      IF(L6.EQ.1) CALL PRARR1('THETEX: ',THETEX,IPTS,1)                 
      IF(L6.EQ.1) CALL PRARR1('RHOEX:  ',RHOEX,IPTS,1)                  
C                                                                       
C     * TEST CONVERGENCE                                                
      STEST=TEST                                                        
      IF(SUM2.EQ.0.)SUM2=1.E-20                                         
      TEST=SQRT(SUM1/SUM2)                                              
      IF(L7.EQ.1) PRINT 73,TEST                                         
      IF(TEST.LE.ACC) GOTO 120                                          
      IF(TEST.LE..999*STEST) GOTO 100                                   
      IF(TEST.LT.STEST) PRINT 80,IMAP,TEST                              
      IF(TEST.GT.STEST) PRINT 90,IMAP,STEST,TEST                        
      GOTO 120                                                          
  100 CONTINUE                                                          
      IMAP=NIMAP                                                        
      PRINT 110,IMAP,TEST                                               
  120 CONTINUE                                                          
C                                                                       
C     * ENDRESULT OF MAPPING                                            
      IF(L8.EQ.1) PRINT 121,TEST                                        
      IF(L8.EQ.1) CALL PRARR1('THETEX: ',THETEX,IPTS,1)                 
      IF(L8.EQ.1) CALL PRARR1('RHOEX:  ',RHOEX,IPTS,1)                  
      IMAPXI=IMAP                                                       
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    3 FORMAT(///1X,'SUBROUTINE MAPEXI',///1X,'$LMAPXI L1=',I2,' L2=',I2,
     A       ' L3=',I2,' L4=',I2,' L5=',I2,' L6=',I2,' L7=',I2,         
     B       ' L8=',I2,'$')                                             
   31 FORMAT(/1X,'-GRID AND INITIALIZATION:')                           
   32 FORMAT(/1X,'-ITERATION:')                                         
   51 FORMAT(/1X,'IMAP=',I2)                                            
   52 FORMAT(/1X,'AFNUL=',F10.5)                                        
   73 FORMAT(/1X,'-TEST CONVERGENCE:',//1X,'TEST=',F10.5)               
   80 FORMAT(/1X,'***SUBROUTINE MAPEXI: SATURATION AT IMAP=',I3,4X,     
     A       'TEST=',F10.5)                                             
   90 FORMAT(/1X,'***SUBROUTINE MAPEXI: DIVERGENCE AT IMAP=',I3,4X,     
     A       'STEST=',F10.5,4X,'TEST=',F10.5)                           
  110 FORMAT(/1X,'***SUBROUTINE MAPEXI: PRESCRIBED ACCURACY NOT YET ',  
     A       'REACHED AT IMAP=',I3,4X,'TEST=',F10.5)                    
  121 FORMAT(/1X,'-ENDRESULT:',//1X,'TEST=',F10.5)                      
      END                                                               
C                                                                       
      SUBROUTINE GRIDCON(THETEX,THETIN,T,JPTS,ACC,IGRDCN,LL)            
C                                                                       
C     ******************************************************************
C     * THE FUNCTIONS                                                  *
C     *   THETEX(TAU) GIVEN ON THE GRID TAU(I)=2*PI*(I-1)/JPTS         *
C     * AND                                                            *
C     *   THETIN(T) GIVEN ON THE GRID T(J)=2*PI*(J-1)/JPTS             *
C     * ARE CONNECTED TO EACH OTHER BY DETERMINING THE FUNCTION        *
C     *   T=T(TAU(I)) FOR WHICH THETIN(T)=THETEX(TAU(I)).              *
C     * THIS IS DONE BY DETERMINING THE ZEROS OF THE FUNCTION          *
C     *   Y(T)=T+SUM(CF(M)*SIN(M*T))-THETEX(TAU(I)),                   *
C     * WHERE CF(M) ARE THE FOURIER COEFFICIENTS OF C(T)=THETIN(T)-T.  *
C     * DIAGNOSTIC INFORMATION IS PRINTED IF L.NE.0.                   *
C     * THE ARGUMENT LL HAS THE DOUBLE FUNCTION OF COMMUNICATING THE   *
C     * OUTPUT UNIT IOUT=LL/10 AND THE PRINT SWITCH L=LL-IOUT*10.      *
C     * IOUT=0 (L=LL): FILE IS "OUTPUT".                               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (JMAX=256,NINV=100)                                     
      DIMENSION THETEX(*),THETIN(*),T(*),C(JMAX),CF(JMAX/2-1)           
C                                                                       
      MHARM=JPTS/2-1                                                    
C                                                                       
      IOUT=LL/10                                                        
      L=LL-IOUT*10                                                      
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,3)                                    
         IF(IOUT.NE.0) WRITE(IOUT,3)                                    
      ENDIF                                                             
      PI=3.1415926535898                                                
      DO 10 I=1,JPTS                                                    
   10 C(I)=THETIN(I)-2.*PI*(I-1.)/JPTS                                  
      CALL RFTSIN(C,CF,JPTS,MHARM)                                      
      IF(L.NE.0) THEN                                                   
         CALL PRARR1('C(I):',C,JPTS,IOUT*10+L)                          
         CALL PRARR1('CF(M):',CF,MHARM,IOUT*10+L)                       
         IF(IOUT.EQ.0) WRITE(   *,*)                                    
         IF(IOUT.NE.0) WRITE(IOUT,*)                                    
      ENDIF                                                             
      T(1)=0.                                                           
      T(JPTS/2+1)=PI                                                    
      J1=2                                                              
      IGRDCN=1                                                          
      DO 80 I=2,JPTS/2                                                  
      DO 20 J=J1,JPTS/2+1                                               
      T0=THETEX(J-1)                                                    
      T1=THETEX(J)                                                      
      CALL GSUM(SUM0,T0,CF,MHARM)                                       
      Y0=T0+SUM0-THETEX(I)                                              
      CALL GSUM(SUM1,T1,CF,MHARM)                                       
      Y1=T1+SUM1-THETEX(I)                                              
      IF(Y1.LE.0.) GOTO 20                                              
      J1S=J                                                             
      GOTO 22                                                           
   20 CONTINUE                                                          
   22 J1=J1S                                                            
      DO 40 N=1,NINV                                                    
      T2=T0-(T1-T0)*Y0/(Y1-Y0)                                          
      CALL GSUM(SUM2,T2,CF,MHARM)                                       
      Y2=T2+SUM2-THETEX(I)                                              
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,25) N,T0,T1,Y0,Y1,T2,Y2,J             
         IF(IOUT.NE.0) WRITE(IOUT,25) N,T0,T1,Y0,Y1,T2,Y2,J             
      ENDIF                                                             
      IF(ABS(Y2).LE.ACC) GOTO 50                                        
      IF(Y2.GT.ACC) GOTO 30                                             
      T0=T2                                                             
      Y0=Y2                                                             
      GOTO 40                                                           
   30 T1=T2                                                             
      Y1=Y2                                                             
   40 CONTINUE                                                          
      GOTO 60                                                           
   50 T(I)=T2                                                           
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,55) I,N                               
         IF(IOUT.NE.0) WRITE(IOUT,55) I,N                               
      ENDIF                                                             
      IF(N.GT.IGRDCN) IGRDCN=N                                          
      GOTO 80                                                           
   60 IF(IOUT.EQ.0) WRITE(   *,70)                                      
      IF(IOUT.NE.0) WRITE(IOUT,70)                                      
   80 CONTINUE                                                          
      DO 90 I=JPTS/2+2,JPTS                                             
   90 T(I)=2.*PI-T(JPTS-I+2)                                            
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    3 FORMAT(///1X,'SUBROUTINE GRIDCON')                                
   25 FORMAT(1X,'N=',I3,' T0=',F10.5,' T1=',F10.5,                      
     A       ' Y0=',F10.5,' Y1=',F10.5,' T2=',F10.5,' Y2=',F10.5,       
     B       ' J=',I3)                                                  
   55 FORMAT(1X,'I=',I3,5X,'N=',I3)                                     
   70 FORMAT(/1X,'***SUBROUTINE GRIDCON: NO CONVERGENCE FOR T(I)')      
      END                                                               
C                                                                       
      SUBROUTINE GRIDINV(TIN,TOUT,JPTS,ACC,IGRDNV,LL)                   
C                                                                       
C     ******************************************************************
C     * THE FUNCTION TIN(TOUT), GIVEN ON THE GRID TOUT=2*PI*(J-1)/JPTS,*
C     * IS INVERTED TO GIVE TOUT(TIN) ON THE GRID TIN=2*PI*(I-1)/JPTS. *
C     * THIS IS DONE BY DETERMINING THE ZEROS OF THE FUNCTION          *
C     *    Y(T)=T+SUM(GF(M)*SIN(M*T))-2*PI*(I-1)/JPTS,                 *
C     * WHERE GF(M) ARE THE FOURIER COEFFICIENTS OF G(T)=TIN(T)-T.     *
C     * DIAGNOSTIC INFORMATION IS PRINTED IF L.NE.0.                   *
C     * THE ARGUMENT LL HAS THE DOUBLE FUNCTION OF COMMUNICATING THE   *
C     * OUTPUT UNIT IOUT=LL/10 AND THE PRINT SWITCH L=LL-IOUT*10.      *
C     * IOUT=0 (L=LL): FILE IS "OUTPUT".                               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (JMAX=256,NINV=100)                                     
      DIMENSION TIN(*),TOUT(*),T(JMAX),G(JMAX),GF(JMAX/2-1)             
      EQUIVALENCE(T(1),G(1))                                            
C                                                                       
      MHARM=JPTS/2-1                                                    
C                                                                       
      IOUT=LL/10                                                        
      L=LL-IOUT*10                                                      
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,3)                                    
         IF(IOUT.NE.0) WRITE(IOUT,3)                                    
      ENDIF                                                             
      PI=3.1415926535898                                                
      DO 10 I=1,JPTS                                                    
   10 G(I)=TIN(I)-2.*PI*(I-1.)/JPTS                                     
      CALL RFTSIN(G,GF,JPTS,MHARM)                                      
      IF(L.NE.0) THEN                                                   
         CALL PRARR1('G(I):',T,JPTS,IOUT*10+L)                          
         CALL PRARR1('GF(M):',GF,MHARM,IOUT*10+L)                       
         IF(IOUT.EQ.0) WRITE(   *,*)                                    
         IF(IOUT.NE.0) WRITE(IOUT,*)                                    
      ENDIF                                                             
      DO 20 I=1,JPTS                                                    
   20 T(I)=2.*PI*(I-1.)/JPTS                                            
      TOUT(1)=0.                                                        
      TOUT(JPTS/2+1)=PI                                                 
      J1=2                                                              
      IGRDNV=1                                                          
      DO 80 I=2,JPTS/2                                                  
      DO 21 J=J1,JPTS/2+1                                               
      T0=T(J-1)                                                         
      T1=T(J)                                                           
      CALL GSUM(SUM0,T0,GF,MHARM)                                       
      Y0=T0+SUM0-T(I)                                                   
      CALL GSUM(SUM1,T1,GF,MHARM)                                       
      Y1=T1+SUM1-T(I)                                                   
      IF(Y1.LE.0.) GOTO 21                                              
      J1S=J                                                             
      GOTO 22                                                           
   21 CONTINUE                                                          
   22 J1=J1S                                                            
      DO 40 N=1,NINV                                                    
      T2=T0-(T1-T0)*Y0/(Y1-Y0)                                          
      CALL GSUM(SUM2,T2,GF,MHARM)                                       
      Y2=T2+SUM2-T(I)                                                   
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,25) N,T0,T1,Y0,Y1,T2,Y2,J             
         IF(IOUT.NE.0) WRITE(IOUT,25) N,T0,T1,Y0,Y1,T2,Y2,J             
      ENDIF                                                             
      IF(ABS(Y2).LE.ACC) GOTO 50                                        
      IF(Y2.GT.ACC) GOTO 30                                             
      T0=T2                                                             
      Y0=Y2                                                             
      GOTO 40                                                           
   30 T1=T2                                                             
      Y1=Y2                                                             
   40 CONTINUE                                                          
      GOTO 60                                                           
   50 TOUT(I)=T2                                                        
      IF(L.NE.0) THEN                                                   
         IF(IOUT.EQ.0) WRITE(   *,55) I,N                               
         IF(IOUT.NE.0) WRITE(IOUT,55) I,N                               
      ENDIF                                                             
      IF(N.GT.IGRDNV) IGRDNV=N                                          
      GOTO 80                                                           
   60 IF(IOUT.EQ.0) WRITE(   *,70)                                      
      IF(IOUT.NE.0) WRITE(IOUT,70)                                      
   80 CONTINUE                                                          
      DO 90 I=JPTS/2+2,JPTS                                             
   90 TOUT(I)=2.*PI-TOUT(JPTS-I+2)                                      
      RETURN                                                            
C                                                                       
C     * FORMATS.                                                        
    3 FORMAT(///1X,'SUBROUTINE GRIDINV')                                
   25 FORMAT(1X,'N=',I3,' T0=',F10.5,' T1=',F10.5,                      
     A       ' Y0=',F10.5,' Y1=',F10.5,' T2=',F10.5,' Y2=',F10.5,       
     B       ' J=',I3)                                                  
   55 FORMAT(1X,'I=',I3,5X,'N=',I3)                                     
   70 FORMAT(/1X,'***SUBROUTINE GRIDINV: NO CONVERGENCE FOR TOUT')      
      END                                                               
C                                                                       
      SUBROUTINE FPRIME(F,FP,JPTS)                                      
C                                                                       
C     ******************************************************************
C     * CALCULATES FP(T)=DF/DT(T) FROM F(T), WHERE F IS A SYMMETRIC    *
C     * FUNCTION OF T REPRESENTABLE AS A COSINE SERIES.                *
C     * NOTICE: IN CALLING PROGRAM THE DIMENSIONS SHOULD BE AT LEAST   *
C     * F(JPTS) AND FP(JPTS+2).                                        *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION F(*),FP(*)                                              
      DO 10 J=1,JPTS                                                    
   10 FP(J)=F(J)                                                        
      CALL RFT2(FP,JPTS,1)                                              
      DO 20 J=1,JPTS-1,2                                                
      FP(J+1)=.5*(J-1.)*FP(J)                                           
   20 FP(J)=0.                                                          
      FP(JPTS+1)=0.                                                     
      FP(JPTS+2)=0.                                                     
      CALL RFI2(FP,JPTS,1)                                              
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE GPRIME(G,GP,JPTS)                                      
C                                                                       
C     ******************************************************************
C     * CALCULATES GP(T)=DG/DT(T) FROM G(T), WHERE G IS AN ANTI-       *
C     * SYMMETRIC FUNCTION OF T REPRESENTABLE AS A SINE SERIES.        *
C     * NOTICE: IN CALLING PROGRAM THE DIMENSIONS SHOULD BE AT LEAST   *
C     * G(JPTS) AND GP(JPTS+2).                                        *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION G(*),GP(*)                                              
      DO 10 J=1,JPTS                                                    
   10 GP(J)=G(J)                                                        
      CALL RFT2(GP,JPTS,1)                                              
      DO 20 J=1,JPTS-1,2                                                
      GP(J)=-.5*(J-1.)*GP(J+1)                                          
   20 GP(J+1)=0.                                                        
      GP(JPTS+1)=0.                                                     
      GP(JPTS+2)=0.                                                     
      CALL RFI2(GP,JPTS,1)                                              
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE FAV(F,AV,JPTS)                                         
C                                                                       
C     ******************************************************************
C     * CALCULATES ANGULAR AVERAGE OF F(T).                            *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION F(*)                                                    
      SUM=0.                                                            
      DO 10 J=1,JPTS                                                    
   10 SUM=SUM+F(J)                                                      
      AV=SUM/JPTS                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE FSYN(F,JPTS,FFNUL,FF,MHARM)                            
C                                                                       
C     ******************************************************************
C     * FOURIERSYNTHESIS OF A SYMMETRIC FUNCTION F(J), J.LE.JPTS, FROM *
C     * THE COSINE COEFFICIENTS FFNUL=FF(0) AND FF(M),  M=1,MHARM :    *
C     *     F(T)=.5*FFNUL+SUM(FF(M)*COS(M*T)),   T=2*PI*(J-1)/JPTS.    *
C     * TYPICAL USE IS FOR MHARM MUCH SMALLER THAN JPTS/2-1, SO THAT   *
C     * RFI2 CANNOT BE USED FOR THIS PURPOSE.                          *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION F(*),FF(*)                                              
      PI=3.1415926535898                                                
      DARG=2.*PI/JPTS                                                   
      ARG=-DARG                                                         
      DO 20 J=1,JPTS                                                    
      ARG=ARG+DARG                                                      
      CO=COS(ARG)                                                       
      SI=SIN(ARG)                                                       
      C=1.                                                              
      S=0.                                                              
      SUM=.5*FFNUL                                                      
      DO 10 M=1,MHARM                                                   
      CA=C*CO-S*SI                                                      
      S=S*CO+C*SI                                                       
      C=CA                                                              
   10 SUM=SUM+FF(M)*C                                                   
   20 F(J)=SUM                                                          
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE GSYN(G,JPTS,GF,MHARM)                                  
C                                                                       
C     ******************************************************************
C     * FOURIERSYNTHESIS OF AN ANTI-SYMMETRIC FUNCTION G(J),J.LE.JPTS, *
C     * FROM THE SINE COEFFICIENTS GF(M),  M=1,MHARM:                  *
C     *     G(T)=SUM(GF(M)*SIN(M*T)),    T=2*PI*(J-1)/JPTS.            *
C     * TYPICAL USE IS FOR MHARM MUCH SMALLER THAN JPTS/2-1, SO THAT   *
C     * RFI2 CANNOT BE USED FOR THIS PURPOSE.                          *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION G(*),GF(*)                                              
      PI=3.1415926535898                                                
      DARG=2.*PI/JPTS                                                   
      ARG=-DARG                                                         
      DO 20 J=1,JPTS                                                    
      ARG=ARG+DARG                                                      
      CO=COS(ARG)                                                       
      SI=SIN(ARG)                                                       
      C=1.                                                              
      S=0.                                                              
      SUM=0.                                                            
      DO 10 M=1,MHARM                                                   
      CA=C*CO-S*SI                                                      
      S=S*CO+C*SI                                                       
      C=CA                                                              
   10 SUM=SUM+GF(M)*S                                                   
   20 G(J)=SUM                                                          
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE FSUM(F,T,FFNUL,FF,MHARM)                               
C                                                                       
C     ******************************************************************
C     * FOURIERSYNTHESIS OF SYMMETRIC FUNCTION F(T) AT SINGLE POINT T. *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION FF(*)                                                   
      CO=COS(T)                                                         
      SI=SIN(T)                                                         
      C=1.                                                              
      S=0.                                                              
      SUM=.5*FFNUL                                                      
      DO 10 M=1,MHARM                                                   
      CA=C*CO-S*SI                                                      
      S=S*CO+C*SI                                                       
      C=CA                                                              
   10 SUM=SUM+FF(M)*C                                                   
      F=SUM                                                             
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE GSUM(G,T,GF,MHARM)                                     
C                                                                       
C     ******************************************************************
C     * FOURIERSYNTHESIS OF ANTI-SYMM. FUNCTION G(T) AT SINGLE POINT T *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION GF(*)                                                   
      CO=COS(T)                                                         
      SI=SIN(T)                                                         
      C=1.                                                              
      S=0.                                                              
      SUM=0.                                                            
      DO 10 M=1,MHARM                                                   
      CA=C*CO-S*SI                                                      
      S=S*CO+C*SI                                                       
      C=CA                                                              
   10 SUM=SUM+GF(M)*S                                                   
      G=SUM                                                             
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE RFTCOS(F,FFNUL,FF,JPTS,MHARM)                          
C                                                                       
C     ******************************************************************
C     * CALCULATES FOURIER COSINE COEFFICIENTS FF(M) FROM THE INPUT    *
C     * ARRAY F(J) CORRESPONDING TO THE UP-DOWN SYMMETRIC FUNCTION     *
C     *   F(T)=.5*FFNUL+SUM(FF(M)*COS(M*T)),  M=1,MHARM,               *
C     * WHERE MHARM.LE.JPTS/2-1, FFNUL=FF(0) AND T=2*PI*(J-1)/JPTS.    *
C     * THE INPUT ARRAY F(J) IS NOT DESTROYED BY CALLING RFTCOS.       *
C     * TYPICAL USE IS FOR MHARM MUCH SMALLER THAN JPTS/2-1, SO THAT   *
C     * RFT2 CANNOT BE USED DIRECTLY.                                  *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (JMAX=256)                                              
      DIMENSION F(*),FF(*),FSTORE(JMAX+2)                               
      DO 10 J=1,JPTS                                                    
   10 FSTORE(J)=F(J)                                                    
      CALL RFT2(FSTORE,JPTS,1)                                          
      FAC=2./JPTS                                                       
      FFNUL=FSTORE(1)*FAC                                               
      DO 20 M=1,MHARM                                                   
   20 FF(M)=FSTORE(2*M+1)*FAC                                           
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE RFTSIN(G,GF,JPTS,MHARM)                                
C                                                                       
C     ******************************************************************
C     * CALCULATES FOURIER SINE COEFFICIENTS GF(M) FROM THE INPUT      *
C     * ARRAY G(J) CORRESPONDING TO THE UP-DOWN ANTI-SYMM. FUNCTION    *
C     *   G(T)=SUM(GF(M)*SIN(M*T)),  M=1,MHARM (MHARM.LE.JPTS/2-1),    *
C     * AND T=2*PI*(J-1)/JPTS.                                         *
C     * THE INPUT ARRAY G(J) IS NOT DESTROYED BY CALLING RFTSIN.       *
C     * TYPICAL USE IS FOR MHARM MUCH SMALLER THAN JPTS/2-1, SO THAT   *
C     * RFT2 CANNOT BE USED DIRECTLY.                                  *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (JMAX=256)                                              
      DIMENSION G(*),GF(*),GSTORE(JMAX+2)                               
      DO 10 J=1,JPTS                                                    
   10 GSTORE(J)=G(J)                                                    
      CALL RFT2(GSTORE,JPTS,1)                                          
      FAC=-2./JPTS                                                      
      DO 20 M=1,MHARM                                                   
   20 GF(M)=GSTORE(2*M+2)*FAC                                           
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE RFICOS(F,FFNUL,FF,JPTS,MHARM)                          
C                                                                       
C     ******************************************************************
C     * FOURIERSYNTHESIS OF A SYMMETRIC FUNCTION F(J), J.LE.JPTS, FROM *
C     * THE COSINE COEFFICIENTS FFNUL=FF(0) AND FF(M), M=1,MHARM:      *
C     *     F(T)=.5*FFNUL+SUM(FF(M)*COS(M*T)),   T=2*PI*(J-1)/JPTS.    *
C     * THE INPUT ARRAY FF(M) IS NOT DESTROYED BY CALLING RFICOS.      *
C     * TYPICAL USE IS FOR MHARM MUCH SMALLER THAN JPTS/2-1, SO THAT   *
C     * RFI2 CANNOT BE USED DIRECTLY.                                  *
C     * THIS ROUTINE IS EQUIVALENT TO, BUT FASTER THAN, FSYN.          *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (JMAX=256)                                              
      DIMENSION F(*),FF(*),FSTORE(JMAX+2)                               
      FSTORE(1)=FFNUL                                                   
      FSTORE(2)=0.                                                      
      DO 10 M=1,MHARM                                                   
      FSTORE(2*M+1)=FF(M)                                               
   10 FSTORE(2*M+2)=0.                                                  
      DO 20 J=2*MHARM+3,JPTS+2                                          
   20 FSTORE(J)=0.                                                      
      CALL RFI2(FSTORE,JPTS,1)                                          
      FAC=JPTS/2.                                                       
      DO 30 J=1,JPTS                                                    
   30 F(J)=FSTORE(J)*FAC                                                
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE RFISIN(G,GF,JPTS,MHARM)                                
C                                                                       
C     ******************************************************************
C     * FOURIERSYNTHESIS OF ANTI-SYMMETRIC FUNCTION G(J), J.LE.JPTS,   *
C     * FROM THE SINE COEFFICIENTS GF(M), M=1,MHARM:                   *
C     *     G(T)=SUM(GF(M)*SIN(M*T)),    T=2*PI*(J-1)/JPTS.            *
C     * THE INPUT ARRAY GF(M) IS NOT DESTROYED BY CALLING RFISIN.      *
C     * TYPICAL USE IS FOR MHARM MUCH SMALLER THAN JPTS/2-1, SO THAT   *
C     * RFI2 CANNOT BE USED DIRECTLY.                                  *
C     * THIS ROUTINE IS EQUIVALENT TO, BUT FASTER THAN, GSYN.          *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (JMAX=256)                                              
      DIMENSION G(*),GF(*),GSTORE(JMAX+2)                               
      GSTORE(1)=0.                                                      
      GSTORE(2)=0.                                                      
      DO 10 M=1,MHARM                                                   
      GSTORE(2*M+1)=0.                                                  
   10 GSTORE(2*M+2)=GF(M)                                               
      DO 20 J=2*MHARM+3,JPTS+2                                          
   20 GSTORE(J)=0.                                                      
      CALL RFI2(GSTORE,JPTS,1)                                          
      FAC=-JPTS/2.                                                      
      DO 30 J=1,JPTS                                                    
   30 G(J)=GSTORE(J)*FAC                                                
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE RFT2(DATA,NR,KR)                                       
C                                                                       
C     ******************************************************************
C     * REAL FOURIER TRANSFORM.                                        *
C     * INPUT:  NR REAL COEFFICIENTS                                   *
C     *             DATA(1),DATA(1+KR),....,DATA(1+(NR-1)*KR).         *
C     * OUTPUT: NR/2+1 COMPLEX COEFFICIENTS                            *
C     *            (DATA(1),      DATA(1+KR))                          *
C     *            (DATA(1+2*KR), DATA(1+3*KR))                        *
C     *             .............................                      *
C     *            (DATA(1+NR*KR),DATA(1+(NR+1)*KR).                   *
C     * THE CALLING PROGRAM SHOULD HAVE DATA DIMENSIONED WITH AT LEAST *
C     * (NR+1)*KR+1 ELEMENTS. (I.E., NR+2 IF INCREMENT KR=1).          *
C     * LASL ROUTINE MAY 75, CALLING FFT2 AND RTRAN2.                  *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION DATA(*)                                                 
      CALL FFT2(DATA(1),DATA(KR+1),NR/2,-(KR+KR))                       
      CALL RTRAN2(DATA,NR,KR,1)                                         
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE RFI2(DATA,NR,KR)                                       
C                                                                       
C     ******************************************************************
C     * INVERSE OF RFT2.                                               *
C     * WHEN USING RFI2 IT IS NECESSARY TO HAVE VANISHING IMAGINARY    *
C     * PARTS OF THE FIRST AND LAST ELEMENT OF THE INPUT VECTOR:       *
C     *   DATA(1+KR)=DATA(1+(NR+1)*KR)=0.                              *
C     * THE CALLING PROGRAM SHOULD HAVE DATA DIMENSIONED WITH AT LEAST *
C     * (NR+1)*KR+1 ELEMENTS.                                          *
C     * LASL ROUTINE MAY 75, CALLING RTRAN2 AND FFT2.                  *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION DATA(*)                                                 
      CALL RTRAN2(DATA,NR,KR,-1)                                        
      MR=NR*KR                                                          
      FNI=2./NR                                                         
      DO 10 I=1,MR,KR                                                   
   10 DATA(I)=FNI*DATA(I)                                               
      CALL FFT2(DATA(1),DATA(KR+1),NR/2,(KR+KR))                        
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE RTRAN2(DATA,NR,KR,KTRAN)                               
C                                                                       
C     ******************************************************************
C     * INTERFACE BETWEEN RFT2, RFI2, AND FFT2.                        *
C     * THE CALLING PROGRAM SHOULD HAVE DATA DIMENSIONED WITH AT LEAST *
C     * (NR+1)*KR+1 ELEMENTS.                                          *
C     * LASL ROUTINE MAY 75, CALLED FROM RFT2 AND RFI2.                *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION DATA(*)                                                 
      KS=2*KR                                                           
      N=NR/2                                                            
      NMAX=N*KS+2                                                       
      KMAX=NMAX/2                                                       
      THETA=1.5707963267949/N                                           
      DC=2.*SIN(THETA)**2                                               
      DS=SIN(2.*THETA)                                                  
      WS=0.                                                             
      IF(KTRAN.LE.0) THEN                                               
         WC=-1.0                                                        
         DS=-DS                                                         
      ELSE                                                              
         WC=1.0                                                         
         DATA(NMAX-1)=DATA(1)                                           
         DATA(NMAX-1+KR)=DATA(KR+1)                                     
      ENDIF                                                             
      DO 10 K=1,KMAX,KS                                                 
         NK=NMAX-K                                                      
         SUMR=.5*(DATA(K)+DATA(NK))                                     
         DIFR=.5*(DATA(K)-DATA(NK))                                     
         SUMI=.5*(DATA(K+KR)+DATA(NK+KR))                               
         DIFI=.5*(DATA(K+KR)-DATA(NK+KR))                               
         TR=WC*SUMI-WS*DIFR                                             
         TI=WS*SUMI+WC*DIFR                                             
         DATA(K)=SUMR+TR                                                
         DATA(K+KR)=DIFI-TI                                             
         DATA(NK)=SUMR-TR                                               
         DATA(NK+KR)=-DIFI-TI                                           
         WCA=WC-DC*WC-DS*WS                                             
         WS=WS+DS*WC-DC*WS                                              
         WC=WCA                                                         
   10 CONTINUE                                                          
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE FFT2 (DATAR,DATAI,N,INC)                               
C                                                                       
C     ******************************************************************
C     * FFT2 FORTRAN VERSION CLAIR NIELSON MAY 75.                     *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION DATAR(*), DATAI(*)                                      
      KTRAN=ISIGN(-1,INC)                                               
      KS=IABS(INC)                                                      
      IP0=KS                                                            
      IP3=IP0*N                                                         
      IREV=1                                                            
      DO 20 I=1,IP3,IP0                                                 
         IF(I.LT.IREV) THEN                                             
            TEMPR=DATAR(I)                                              
            TEMPI=DATAI(I)                                              
            DATAR(I)=DATAR(IREV)                                        
            DATAI(I)=DATAI(IREV)                                        
            DATAR(IREV)=TEMPR                                           
            DATAI(IREV)=TEMPI                                           
         ENDIF                                                          
         IBIT=IP3/2                                                     
   10    IF(IREV.GT.IBIT) THEN                                          
            IREV=IREV-IBIT                                              
            IBIT=IBIT/2                                                 
            IF(IBIT.GE.IP0) GOTO 10                                     
         ENDIF                                                          
   20    IREV=IREV+IBIT                                                 
      IP1=IP0                                                           
      THETA=REAL(KTRAN)*3.1415926535898                                 
   30 IF(IP1.GE.IP3) GOTO 60                                            
      IP2=IP1+IP1                                                       
      SINTH=SIN(.5*THETA)                                               
      WSTPR=-2.*SINTH*SINTH                                             
      WSTPI=SIN(THETA)                                                  
      WR=1.                                                             
      WI=0.                                                             
      DO 50 I1=1,IP1,IP0                                                
         DO 40 I3=I1,IP3,IP2                                            
            J0=I3                                                       
            J1=J0+IP1                                                   
            TEMPR=WR*DATAR(J1)-WI*DATAI(J1)                             
            TEMPI=WR*DATAI(J1)+WI*DATAR(J1)                             
            DATAR(J1)=DATAR(J0)-TEMPR                                   
            DATAI(J1)=DATAI(J0)-TEMPI                                   
            DATAR(J0)=DATAR(J0)+TEMPR                                   
   40       DATAI(J0)=DATAI(J0)+TEMPI                                   
         TEMPR=WR                                                       
         WR=WR*WSTPR-WI*WSTPI+WR                                        
   50    WI=WI*WSTPR+TEMPR*WSTPI+WI                                     
      IP1=IP2                                                           
      THETA=.5*THETA                                                    
      GOTO 30                                                           
   60 RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE EIGEN(W,NMAX,NARR,ALAM,V)                              
C                                                                       
C     ******************************************************************
C     * FOR THE SYMMETRIC INPUT MATRIX W(N,M), WHERE N,M=1,2,--NMAX AND*
C     * NMAX.LE.NARR (THE DIMENSION OF THE INPUT ARRAY W) THE ORDERED  *
C     * EIGENVALUES ALAM(NE), NE=1,2,--NMAX, AND THE ASSOCIATED EIGEN- *
C     * VECTORS V(N,NE), N,NE=1,2,--NMAX, ARE COMPUTED.                *
C     * THIS IS DONE BY ORDERING THE OUTPUT OF LASL SUBROUTINE SMEVEV. *
C     * THE VALUE OF NARR SHOULD NOT EXCEED NARRM.                     *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      PARAMETER (NARRM=500)                                             
C                                                                       
      DIMENSION W(NARR,*),ALAM(*),V(NARR,*)                             
      DIMENSION STOR(3*NARRM)                                           
      CALL SMEVEV(NMAX,W,ALAM,V,STOR,0.D+0,KE,NARR)                        
      IF(KE.NE.0) WRITE(   *,5)                                         
C                                                                       
C     * ORDERING OF THE EIGENVALUES ALAM IN INCREASING ORDER.           
      DO 20 NE=2,NMAX                                                   
      DO 20 NN=NE,NMAX                                                  
      IF(ALAM(NE-1).LE.ALAM(NN)) GOTO 20                                
      SAVE=ALAM(NN)                                                     
      ALAM(NN)=ALAM(NE-1)                                               
      ALAM(NE-1)=SAVE                                                   
      DO 10 N=1,NMAX                                                    
      SAVE=V(N,NN)                                                      
      V(N,NN)=V(N,NE-1)                                                 
   10 V(N,NE-1)=SAVE                                                    
   20 CONTINUE                                                          
      RETURN                                                            
C                                                                       
C     * FORMAT.                                                         
    5 FORMAT(/1X,'***SUBROUTINE EIGEN: KE NOT EQUAL TO 0')              
      END                                                               
C                                                                       
      SUBROUTINE SMEVEV (NN,T,R,V,A,EPL,KE,M)                           
C                                                                       
C     ******************************************************************
C     * EIGENVALUES AND EIGENVECTORS OF A REAL SYMMETRIC MATRIX.       *
C     * LASL ROUTINE BY B.L.BUZBEE, MAY 75.                            *
C     * METHOD:                                                        *
C     * REDUCTION TO TRIDIAGONAL FORM BY HOUSEHOLDER TRANSFORMATIONS   *
C     * (SMHHTR) WITH DOUBLE PRECISION ACCUMULATION OF INNER PRODUCT   *
C     * (DOTPRO). THE PRODUCT OF THESE TRANSFORMATIONS IS COMPUTED IN  *
C     * PRODHH. THE QR METHOD IS THEN USED TO COMPUTE THE EIGENVALUES  *
C     * AND EIGENVECTORS OF THE TRIDIAGONAL SYMMETRIC MATRIX.          *
C     * EIGENVECTORS PRODUCED BY THIS ROUTINE ARE ALWAYS LINEARLY INDE-*
C     * PENDENT AND ORTHONORMAL REGARDLESS OF EIGENVALUE MULTIPLICITY. *
C     * THE INPUT MATRIX IS DESTROYED.                                 *
C     * USAGE:                                                         *
C     * 1. CALL SMEVEV(NN,T,R,V,A,EPL,KE,M)                            *
C     *    WHERE:                                                      *
C     *    NN   - DIMENSION OF THE INPUT ARRAY, TO BE CALLED (AIJ)     *
C     *           (AND NOT TO BE CONFUSED WITH THE WORK VECTOR A);     *
C     *    T    - A RECTANGULAR ARRAY IN WHICH THE INPUT MATRIX IS     *
C     *           STORED SUCH THAT T(1,1)=A11,...,T(I,J)=AIJ;          *
C     *    R    - A VECTOR IN WHICH THE NN EIGENVALUES WILL BE         *
C     *           RETURNED (UNORDERED);                                *
C     *    V    - A RECTANGULAR ARRAY IN WHICH THE NN EIGENVECTORS WILL*
C     *           BE STORED COLUMNWISE, THE VECTOR IN COLUMN ONE WILL  *
C     *           CORRESPOND TO R(1), ETC.;                            *
C     *    A    - A VECTOR FOR TEMPORY STORAGE, IT MUST CONTAIN 3*NN   *
C     *           WORDS;                                               *
C     *    EPL  - THE CONVERGENCE CRITERION FOR THE EIGENVALUES,       *
C     *           THE ABSOLUTE ERROR OF THE COMPUTED EIGENVALUES       *
C     *           WILL BE PROPORTIONAL TO EPL. IF EPL.LE.2**(-47),     *
C     *           THEN A VALUE OF 2**(-47) WILL BE USED;               *
C     *    KE   - AN ERROR FLAG; IF KE=0 ON RETURN, RESULTS ARE        *
C     *           CORRECT; IF KE.NE.0, NO RESULTS ARE RETURNED;        *
C     *    M    - THE COLUMN LENGTH (NUMBER OF ROWS) IN THE ARRAYS     *
C     *           T AND V.                                             *
C     * 2. CALL STEVEV(NN,B,R,V,A,EPL,KE,M)                            *
C     *    WHERE ALL ARGUMENTS ARE THE SAME AS ABOVE EXCEPT M APPLIES  *
C     *    ONLY TO THE ARRAY V AND B IS A VECTOR CONTAINING A TRIANGLE *
C     *    OF THE MATRIX (AIJ), I.E.,                                  *
C     *    B(1)=A11, B(2)=A21, .... , B(NN)=ANN,1,                     *
C     *    B(NN+1)=A22, .... ,B(NN+NN-1)=ANN,2,                        *
C     *       .......                                                  *
C     *    B(NN*(NN+1)/2)=ANN,NN.                                      *
C     * 3. CALL S3DVEV(NN,T,R,V,A,EPL,KE,M)                            *
C     *    FINDS THE EIGENVALUES AND EIGENVECTORS OF A SYMMETRIC TRI-  *
C     *    DIAGONAL MATRIX. ALL ARGUMENTS ARE THE SAME AS IN THE CALL  *
C     *    TO SMEVEV EXCEPT THE FIRST COLUMN OF T CONTAINS THE MATRIX  *
C     *    DIAGONAL AND THE SECOND COLUMN OF T CONTAINS ITS SUPER-     *
C     *    DIAGONAL:                                                   *
C     *    T(1,1)=A11          T(1,2)=A12                              *
C     *    T(2,1)=A22          T(2,2)=A23                              *
C     *         .......                                                *
C     *    T(NN,1)=ANN-1,NN-1  T(NN-1,2)=ANN-1,NN                      *
C     *    T(NN,1)=ANN,NN.                                             *
C     * MODIFIED MARCH 84 TO GET RID OF ERROR MESSAGES OF SARA FTN5    *
C     * COMPILER CONCERNING USE OF A BOTH AS 1D AND 2D SUBSCRIPTED     *
C     * ARRAY: USE OF A AS 2D SUBSCRIPTED ARRAY HAS BEEN ELIMINATED.   *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C     DIMENSION A(NN,NN), R(M), T(M), V(M,M)                            
      DIMENSION A(*), R(M), T(M), V(M,M)                                
C     DATA TS/16414000000000000000B/                                    
      DATA TS/7.105427357601E-15/                                       
      CALL SMHHTR (NN,T,A,KE,M)                                         
      GO TO 1                                                           
C                                                                       
      ENTRY STEVEV (NN,T,R,V,A,EPL,KE,M)                                
C     * ENTRY POINT FOR TRIANGULAR MATRICES.                            
      CALL STHHTR (NN,T,A,KE)                                           
1     IF (KE.NE.0) RETURN                                               
      CALL PRODHH (NN,T,A,KE,V,M)                                       
      IF (KE.NE.0) RETURN                                               
      GO TO 4                                                           
C                                                                       
      ENTRY S3DVEV (NN,T,R,V,A,EPL,KE,M)                                
C     * ENTRY POINT FOR TRIDIAGONAL MATRICES.                           
      DO 3 I=1,NN                                                       
      A(I)=T(I)                                                         
      A(I+NN)=T(M+I)                                                    
      DO 2 J=1,NN                                                       
2     V(I,J)=0.                                                         
3     V(I,I)=1.                                                         
      KE=0                                                              
C                                                                       
4     IF (NN.GT.1) GO TO 5                                              
      R(1)=A(1)                                                         
      RETURN                                                            
5     EPS=EPL                                                           
      IF (EPS.LT.TS) EPS=TS                                             
      A(2*NN)=0.                                                        
      L1=1                                                              
      LL=1                                                              
6     LL=LL+1                                                           
      N=LL                                                              
      IF (LL.EQ.NN) GO TO 7                                             
      I=LL                                                              
C     IF (ABS(A(I-1,2)).GT.(ABS(A(I))+ABS(A(I-1)))*EPS) GO TO 21        
      IF (ABS(A(I-1+NN)).GT.(ABS(A(I))+ABS(A(I-1)))*EPS) GO TO 21       
7     NL=L1                                                             
      NP=NL+1                                                           
8     N1=N-1                                                            
      IF (N.LT.NL) GO TO 21                                             
      IF (N.EQ.NL) GO TO 20                                             
      MI=0                                                              
      EP=EPS*(ABS(A(N1))+ABS(A(N)))                                     
      GP=EPS*(ABS(A(NL))+ABS(A(NP)))                                    
      IF (EP.EQ.0.) EP=EPS                                              
      IF (GP.EQ.0.) GP=EPS                                              
9     A1=A(N1)                                                          
C     B1=A(N1,2)                                                        
      B1=A(N1+NN)                                                       
      A2=A(N)                                                           
      C=.5*(A2-A1)                                                      
      B=(A1+A2)*.5                                                      
      S=ABS(C)                                                          
      D=ABS(B1)                                                         
      IF (D.LE.EP) GO TO 17                                             
      IF (S.GT.D) GO TO 10                                              
      X=S                                                               
      S=D                                                               
      D=X                                                               
10    D=S*SQRT(1.+(D/S)**2)                                             
      SH=B+SIGN(1.,C)*D                                                 
      A1=A(NL)-SH                                                       
      A2=A(NP)-SH                                                       
C     B1=A(NL,2)                                                        
      B1=A(NL+NN)                                                       
      S=ABS(B1)                                                         
      D=ABS(A1)                                                         
      IF (S.LT.GP) GO TO 19                                             
      IF (S.GT.D) GO TO 11                                              
      X=S                                                               
      S=D                                                               
      D=X                                                               
11    D=S*SQRT(1.+(D/S)**2)                                             
      S=B1/D                                                            
      C=A1/D                                                            
      A1=A1+SH                                                          
      A2=A2+SH                                                          
      X=C*A1+S*B1                                                       
      Y=C*A2-S*B1                                                       
      A(NL)=C*X+S*(C*B1+S*A2)                                           
      X=C*B1-S*A1                                                       
C     A(NL,2)=S*Y+C*X                                                   
      A(NL+NN)=S*Y+C*X                                                  
      A(NP)=C*Y-S*X                                                     
C     E=A(NP,2)                                                         
      E=A(NP+NN)                                                        
C     A(NP,2)=C*E                                                       
      A(NP+NN)=C*E                                                      
      E=S*E                                                             
      DO 12 L=1,NN                                                      
      X=C*V(L,NL)+S*V(L,NP)                                             
      V(L,NP)=C*V(L,NP)-S*V(L,NL)                                       
12    V(L,NL)=X                                                         
      IF (NP.EQ.N) GO TO 16                                             
      DO 15 I=NP,N1                                                     
C     B1=A(I-1,2)                                                       
      B1=A(I-1+NN)                                                      
      S=ABS(B1)                                                         
      C=ABS(E)                                                          
      IF (C.LT.TS*S) GO TO 18                                           
      IF (S.GT.C) GO TO 13                                              
      X=S                                                               
      S=C                                                               
      C=X                                                               
13    D=S*SQRT(1.+(C/S)**2)                                             
      S=E/D                                                             
      C=B1/D                                                            
      A2=A(I)                                                           
C     B2=A(I,2)                                                         
      B2=A(I+NN)                                                        
      A3=A(I+1)                                                         
C     A(I-1,2)=C*B1+S*E                                                 
      A(I-1+NN)=C*B1+S*E                                                
      A(I)=C*(C*A2+S*B2)+S*(C*B2+S*A3)                                  
      X=C*B2-S*A2                                                       
      Y=C*A3-S*B2                                                       
C     A(I,2)=C*X+S*Y                                                    
      A(I+NN)=C*X+S*Y                                                   
      A(I+1)=C*Y-S*X                                                    
      DO 14 L=1,NN                                                      
      X=C*V(L,I)+S*V(L,I+1)                                             
      V(L,I+1)=C*V(L,I+1)-S*V(L,I)                                      
14    V(L,I)=X                                                          
      IF (I.EQ.N1) GO TO 15                                             
C     E=A(I+1,2)                                                        
      E=A(I+1+NN)                                                       
C     A(I+1,2)=C*E                                                      
      A(I+1+NN)=C*E                                                     
      E=E*S                                                             
15    CONTINUE                                                          
16    MI=MI+1                                                           
      IF (MI.GT.40) GO TO 22                                            
C     IF (ABS(A(N1,2)).GT.EP) GO TO 9                                   
      IF (ABS(A(N1+NN)).GT.EP) GO TO 9                                  
17    R(N)=A(N)                                                         
      N=N1                                                              
      GO TO 8                                                           
18    LL=L1                                                             
      GO TO 6                                                           
19    R(NL)=A(NL)                                                       
      NL=NL+1                                                           
      NP=NP+1                                                           
      GO TO 8                                                           
20    R(N)=A(N)                                                         
      L1=LL                                                             
21    IF (LL.LT.NN) GO TO 6                                             
      RETURN                                                            
22    KE=1                                                              
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE SMHHTR (IN,A,T,KE,IA)                                  
C                                                                       
C     ******************************************************************
C     * HOUSEHOLDER TRANSFORMATIONS OF A REAL SYMMETRIC MATRIX.        *
C     * LASL ROUTINE BY B.L.BUZBEE, MAY 75.                            *
C     * CALLED BY SMEVEV, CALLING DOTPRO.                              *
C     * MODIFIED BY DENNIS HEWETT AUG 82.                              *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C     DIMENSION A(1), T(1), MG(5)                                       
      DIMENSION A(*), T(*)                                              
      DOUBLE PRECISION DS                                               
      EQUIVALENCE (DS,S)                                                
C     DATA MG/50H /F223A/ N.LE.0 OR N.GT.IA             N =        /    
C     DATA EPS/15644000000000000000B/                                   
      EPS=2.**(-92)                                                     
      N=IN                                                              
      L=1                                                               
      IF (N.LE.0.OR.N.GT.IA) GO TO 15                                   
      DO 2 J=1,N                                                        
      K=(J-1)*IA                                                        
      DO 1 I=J,N                                                        
      A(L)=A(I+K)                                                       
1     L=L+1                                                             
2     CONTINUE                                                          
      NT=IN                                                             
      GO TO 3                                                           
C                                                                       
      ENTRY STHHTR (IN,A,T,KE)                                          
C     * ENTRY POINT FOR TRIANGULAR MATRICES.                            
      N=IN                                                              
      NT=IN                                                             
C                                                                       
3     CONTINUE                                                          
      IF (N.GT.2) GO TO 4                                               
      T(1)=A(1)                                                         
      KE=0                                                              
      IF (N.EQ.1) RETURN                                                
      T(2)=A(3)                                                         
      T(3)=A(2)                                                         
      RETURN                                                            
4     CONTINUE                                                          
      NN=NT+NT-3                                                        
C     SEE WILKINSON, THE ALGEBRAIC EIGENVALUE POBLEM, P.292.            
      IR=2                                                              
      NE=N-1                                                            
      DO 14 NR=3,N                                                      
      SQ=DOTPRO(NE-1,A(IR+1),1,A(IR+1),1)                               
      T(NR-2)=A(IR-1)                                                   
      T(NR+NT-2)=A(IR)                                                  
      DS=A(IR)**2                                                       
      J=IR+1                                                            
      II=NE-1                                                           
C     SKIP IF THIS COL ALREADY TRIDIAGNOAL (RELATIVELY)                 
      IF (SQ.LE.EPS*S) GO TO 5                                          
      SQ=SQ+DS                                                          
      II=NE                                                             
      J=IR                                                              
C     SKIP IF OFF DIAGONAL ELEMENTS INSIGNIFICANT                       
      IF (SQ.GT.EPS*A(IR-1)**2) GO TO 7                                 
5     DO 6 I=1,II                                                       
      A(J)=0.                                                           
6     J=J+1                                                             
      GO TO 13                                                          
7     S=SQRT(SQ)*SIGN(1.,A(IR))                                         
      TKS=1./(SQ+S*A(IR))                                               
      A(IR)=A(IR)+S                                                     
      T(NR+NT-2)=-S                                                     
      NM=NR-1                                                           
      JR=IR+NE                                                          
C     CALC P(R)                                                         
      T(NM)=DOTPRO(NE,A(IR),1,A(JR),1)*TKS                              
      N1=1                                                              
      N2=NE-1                                                           
      II=IR                                                             
      DO 9 I=NR,N                                                       
      JR=JR+1                                                           
      II=II+1                                                           
      IC=NE-1                                                           
      L=JR                                                              
      DO 8 J=NR,I                                                       
      T(J+NN)=A(L)                                                      
      L=L+IC                                                            
8     IC=IC-1                                                           
      T(I)=(DOTPRO(N1,T(NR+NN),1,A(IR),1)+DOTPRO(N2,A(L),1,A(II),1))*TKS
      N1=N1+1                                                           
9     N2=N2-1                                                           
C     CALC Q(R)                                                         
      UP=.5*DOTPRO(NE,A(IR),1,T(NM),1)*TKS                              
      J=IR                                                              
      DO 10 I=NM,N                                                      
      T(I)=T(I)-UP*A(J)                                                 
10    J=J+1                                                             
C     CALC A(R)                                                         
      K=IR+NE                                                           
      N1=IR                                                             
      DO 12 I=NM,N                                                      
      N2=IR+I-NM                                                        
      DO 11 J=I,N                                                       
      A(K)=A(K)-T(I)*A(N2)-T(J)*A(N1)                                   
      N2=N2+1                                                           
11    K=K+1                                                             
12    N1=N1+1                                                           
13    IR=IR+NE+1                                                        
      NE=NE-1                                                           
14    CONTINUE                                                          
      T(N-1)=A(IR-1)                                                    
      T(N)=A(IR+1)                                                      
      T(NT+N-1)=A(IR)                                                   
      KE=0                                                              
      RETURN                                                            
   15 WRITE(   *,16) N                                                  
   16 FORMAT(/1X,'***SUBROUTINE SMHHTR: N.LE.0 OR N.GT.IA,  N =',I5)    
      KE=1                                                              
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE PRODHH (IN,A,T,KE,V,IV)                                
C                                                                       
C     ******************************************************************
C     * PRODUCT OF THE HOUSEHOLDER TRANSFORMATIONS OF A REAL SYMMETRIC *
C     * MATRIX.                                                        *
C     * LASL ROUTINE BY B.L.BUZBEE, MAY 75.                            *
C     * CALLED BY SMEVEV, CALLING DOTPRO.                              *
C     * MODIFIED BY DENNIS HEWETT AUG 82.                              *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C     DIMENSION A(1), T(1), MG(5)                                       
      DIMENSION A(*), T(*)                                              
      DIMENSION V(IV,IV)                                                
C     DATA MG/50H F225A CALLED WITH N.LE.0.OR.N.GT.IV,  N=            / 
      N=IN                                                              
      NA=IA                                                             
      NT=N                                                              
      NV=IV                                                             
      IF (N.LE.0.OR.N.GT.NV) GO TO 7                                    
      KE=0                                                              
      IR=(N*(N+1))/2-4                                                  
      NE=2                                                              
      MV=N-1                                                            
      V(N,N)=1.                                                         
      IF(N.EQ.1) RETURN                                                 
      V(N-1,N-1)=1.                                                     
      V(N,N-1)=0.                                                       
      V(N-1,N)=0.                                                       
      IF(N.EQ.2) RETURN                                                 
      DO 6 MR=3,N                                                       
      IF(DOTPRO(NE-1,A(IR+1),1,A(IR+1),1).EQ.0.) GO TO 4                
      TKS=-1./(A(IR)*T(NT+MV-1))                                        
      L=MV+1                                                            
      DO 1 I=L,N                                                        
1     V(1,I)=DOTPRO(NE,A(IR),1,V(MV,I),1)*TKS                           
      V(1,MV)=A(IR)*TKS                                                 
      L=IR                                                              
      DO 3 I=MV,N                                                       
      DO 2 J=MV,N                                                       
2     V(I,J)=V(I,J)-A(L)*V(1,J)                                         
3     L=L+1                                                             
4     MV=MV-1                                                           
      DO 5 I=MV,N                                                       
      V(MV,I)=0.                                                        
5     V(I,MV)=0.                                                        
      V(MV,MV)=1.                                                       
      NE=NE+1                                                           
6     IR=IR-NE-1                                                        
      RETURN                                                            
    7 WRITE(   *,8) N                                                   
    8 FORMAT(/1X,'***SUBROUTINE PRODHH: CALLED WITH N.LE.0 OR N.GT.IV,',
     A       ' N =',I5)                                                 
      KE=1                                                              
      RETURN                                                            
      END                                                               
C                                                                       
      FUNCTION DOTPRO(N,X,IX,Y,IY)                                      
C                                                                       
C     ******************************************************************
C     * DOUBLE PRECISION INNER PRODUCT.                                *
C     * X AND Y ARE REAL VECTORS, EACH CONTAINING N ELEMENTS FOR THE   *
C     * INNER PRODUCT WITH A SPACING OF IX AND IY, RESPECTIVELY.       *
C     * THE RESULT RETURNED IS THE SUM  X(1+(I-1)*IX) * Y(1+(I-1)*IY)  *
C     * FOR I=1 TO N.                                                  *
C     * CALLED BY PRODHH AND MATINV.                                   *
C     * WRITTEN BY DENNIS HEWETT AUG 82.                               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DOUBLE PRECISION TMP                                              
      DIMENSION X(*),Y(*)                                               
      IXRUN=1-IX                                                        
      IYRUN=1-IY                                                        
      TMP=0.                                                            
      DO 100 I=1,N                                                      
      IXRUN=IXRUN+IX                                                    
      IYRUN=IYRUN+IY                                                    
  100 TMP=TMP+X(IXRUN)*Y(IYRUN)                                         
      DOTPRO=TMP                                                        
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE MATINV(A,IA,IN,R,DET)                                  
C                                                                       
C     ******************************************************************
C     * COMPUTES INVERSE OF A MATRIX.                                  *
C     * LASL ROUTINE MAY 75.                                           *
C     * CALLING DOTPRO.                                                *
C     * MODIFIED BY DENNIS HEWETT AUG 82.                              *
C     * MODIFIED MARCH 84 TO ELIMINATE PROBLEMS OF SARA FTN5 COMPILER  *
C     * WITH THE USE OF A BOTH AS 1D AND 2D SUBSCRIPTED ARRAY:         *
C     * USE OF A AS 1D SUBSCRIPTED ARRAY HAS BEEN ELIMINATED.          *
C     * MODIFIED MAY 85 TO ELIMINATE PROBLEMS ASSOCIATED WITH DOUBLE   *
C     * PRECISION OF DOTPRO (THIS ONLY WORKED WELL IN COMBINATION WITH *
C     * THE OLD COMPASS VERSION OF DOTPRO).                            *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION A(IA,IN),DET(*),R(*)                                    
C     DOUBLE PRECISION DOTPRO,S                                         
      DOUBLE PRECISION S                                                
      N=IN                                                              
      IF(N.LE.0.OR.N.GT.IA) GOTO 190                                    
C     FACTOR MATRIX                                                     
      IX=1                                                              
      LE=N*IA                                                           
      IF(N.GT.1) GOTO 10                                                
      DET(1)=A(1,1)                                                     
      IF(DET(1).EQ.0.) GOTO 200                                         
      A(1,1)=1./A(1,1)                                                  
      RETURN                                                            
   10 DO 80 NR=1,N                                                      
      MR=NR-1                                                           
      MP=NR+1                                                           
      T=0.                                                              
      DO 30 NT=NR,N                                                     
      S=A(NT,NR)                                                        
      IF(NR.EQ.1) GOTO 20                                               
C     S=S-DOTPRO(MR,A(NT),IA,A(IX),1)                                   
      S=S-DOTPRO(MR,A(NT,1),IA,A(IX,1),1)                               
   20 R(NT)=S                                                           
      IF(ABS(S).LE.T) GOTO 30                                           
      T=ABS(S)                                                          
      MX=NT                                                             
   30 CONTINUE                                                          
      IF(T.EQ.0.) GOTO 200                                              
      IF(MX.EQ.NR) GOTO 50                                              
C     PIVOT                                                             
      T=R(NR)                                                           
      R(NR)=R(MX)                                                       
      R(MX)=T                                                           
C     KX=MX                                                             
C     DO 40 J=NR,LE,IA                                                  
C     T=A(J)                                                            
C     A(J)=A(KX)                                                        
C     A(KX)=T                                                           
C  40 KX=KX+IA                                                          
      DO 40 J=1,N                                                       
      T=A(NR,J)                                                         
      A(NR,J)=A(MX,J)                                                   
      A(MX,J)=T                                                         
   40 CONTINUE                                                          
   50 T=R(NR)                                                           
      A(NR,NR)=T                                                        
      R(NR)=MX                                                          
      IF(NR.EQ.N) GOTO 70                                               
      DO 60 NT=MP,N                                                     
      A(NT,NR)=R(NT)/T                                                  
      S=A(NR,NT)                                                        
      IF(MR.EQ.0) GOTO 60                                               
      S=S-DOTPRO(MR,A(NR,1),IA,A(1,NT),1)                               
   60 A(NR,NT)=S                                                        
   70 CONTINUE                                                          
      IX=IX+IA                                                          
   80 CONTINUE                                                          
      DET(1)=A(1,1)                                                     
      DO 100 NR=2,N                                                     
      NE=0                                                              
      J=NR-1                                                            
      DO 90 I=NR,N                                                      
      A(I,J)=-DOTPRO(NE,A(NR,J),1,A(I,NR),IA)-A(I,J)                    
   90 NE=NE+1                                                           
      DET(1)=DET(1)*A(NR,NR)                                            
  100 CONTINUE                                                          
      S=1./A(N,N)                                                       
      A(N,N)=S                                                          
      DO 110 I=2,N                                                      
  110 A(N,I-1)=A(N,I-1)*S                                               
      NE=1                                                              
      NC=N-1                                                            
      NP=N                                                              
      MC=N-2                                                            
      DO 160 NR=2,N                                                     
      S=1./A(NC,NC)                                                     
      IF(MC.LE.0) GOTO 130                                              
      DO 120 IR=1,MC                                                    
  120 A(NC,IR)=S*(A(NC,IR)-DOTPRO(NE,A(NC,NP),IA,A(NP,IR),1))           
  130 A(NC,NC)=S*(  1.    -DOTPRO(NE,A(NC,NP),IA,A(NP,NC),1))           
      DO 140 IR=NP,N                                                    
      DET(IR)=-S*DOTPRO(NE,A(NC,NP),IA,A(NP,IR),1)                      
  140 CONTINUE                                                          
      DO 150 IR=NP,N                                                    
  150 A(NC,IR)=DET(IR)                                                  
      MC=MC-1                                                           
      NC=NC-1                                                           
      NP=NP-1                                                           
  160 NE=NE+1                                                           
      DO 180 IR=2,N                                                     
      J=N-IR+1                                                          
      K=R(J)                                                            
      IF(K.EQ.J) GOTO 180                                               
      DO 170 I=1,N                                                      
      S=A(I,J)                                                          
      A(I,J)=A(I,K)                                                     
  170 A(I,K)=S                                                          
      DET(1)=-DET(1)                                                    
  180 CONTINUE                                                          
      RETURN                                                            
  190 WRITE(   *,191) N                                                 
  191 FORMAT(/1X,'***SUBROUTINE MATINV: N.LE.0 OR N.GT.IA,  N =',I5)    
      GOTO 210                                                          
  200 WRITE(   *,201) NR                                                
  201 FORMAT(/1X,'***SUBROUTINE MATINV: SINGULAR SYSTEM, ',             
     A       'NO UNIQUE SOLUTION, NR =',I5)                             
  210 DET(1)=0.                                                         
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE ODE(F,NEQN,Y,T,TOUT,RELERR,ABSERR,IFLAG,WORK,IWORK)    
C                                                                       
C     ******************************************************************
C     * SOLVES A SET OF ORDINAIRY DIFFERENTIAL EQUATIONS.              *
C     * LASL ROUTINE MAY 75.                                           *
C     * CALLING DE.                                                    *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C   SUBROUTINE  ODE  INTEGRATES A SYSTEM OF  NEQN  FIRST ORDER          
C   ORDINARY DIFFERENTIAL EQUATIONS OF THE FORM                         
C             DY(I)/DT = F(T,Y(1),Y(2),...,Y(NEQN))                     
C             Y(I) GIVEN AT  T .                                        
C   THE SUBROUTINE INTEGRATES FROM  T  TO  TOUT .  ON RETURN THE        
C   PARAMETERS IN THE CALL LIST ARE SET FOR CONTINUING THE INTEGRATION. 
C   THE USER HAS ONLY TO DEFINE A NEW VALUE  TOUT  AND CALL  ODE  AGAIN.
C                                                                       
C   THE DIFFERENTIAL EQUATIONS ARE ACTUALLY SOLVED BY A SUITE OF CODES  
C   DE ,  STEP , AND  INTRP .  ODE  ALLOCATES VIRTUAL STORAGE IN THE    
C   ARRAYS  WORK  AND  IWORK  AND CALLS  DE .  DE  IS A SUPERVISOR WHICH
C   DIRECTS THE SOLUTION.  IT CALLS ON THE ROUTINES  STEP  AND  INTRP   
C   TO ADVANCE THE INTEGRATION AND TO INTERPOLATE AT OUTPUT POINTS.     
C   STEP  USES A MODIFIED DIVIDED DIFFERENCE FORM OF THE ADAMS PECE     
C   FORMULAS AND LOCAL EXTRAPOLATION.  IT ADJUSTS THE ORDER AND STEP    
C   SIZE TO CONTROL THE LOCAL ERROR PER UNIT STEP IN A GENERALIZED      
C   SENSE.  NORMALLY EACH CALL TO  STEP  ADVANCES THE SOLUTION ONE STEP 
C   IN THE DIRECTION OF  TOUT .  FOR REASONS OF EFFICIENCY  DE          
C   INTEGRATES BEYOND  TOUT  INTERNALLY, THOUGH NEVER BEYOND            
C   T+10*(TOUT-T), AND CALLS  INTRP  TO INTERPOLATE THE SOLUTION AT     
C   TOUT .  AN OPTION IS PROVIDED TO STOP THE INTEGRATION AT  TOUT  BUT 
C   IT SHOULD BE USED ONLY IF IT IS IMPOSSIBLE TO CONTINUE THE          
C   INTEGRATION BEYOND  TOUT .                                          
C                                                                       
C   THIS CODE IS COMPLETELY EXPLAINED AND DOCUMENTED IN THE TEXT,       
C   COMPUTER SOLUTION OF ORDINARY DIFFERENTIAL EQUATIONS:  THE INITIAL  
C   VALUE PROBLEM  BY L. F. SHAMPINE AND M. K. GORDON.                  
C                                                                       
C   THE PARAMETERS REPRESENT:                                           
C      F -- SUBROUTINE F(T,Y,YP) TO EVALUATE DERIVATIVES YP(I)=DY(I)/DT 
C      NEQN -- NUMBER OF EQUATIONS TO BE INTEGRATED                     
C      Y(*) -- SOLUTION VECTOR AT  T                                    
C      T -- INDEPENDENT VARIABLE                                        
C      TOUT -- POINT AT WHICH SOLUTION IS DESIRED                       
C      RELERR,ABSERR -- RELATIVE AND ABSOLUTE ERROR TOLERANCES FOR LOCAL
C           ERROR TEST.  AT EACH STEP THE CODE REQUIRES                 
C             ABS(LOCAL ERROR) .LE. ABS(Y)*RELERR + ABSERR              
C           FOR EACH COMPONENT OF THE LOCAL ERROR AND SOLUTION VECTORS  
C      IFLAG -- INDICATES STATUS OF INTEGRATION                         
C      WORK(*),IWORK(*) -- ARRAYS TO HOLD INFORMATION INTERNAL TO CODE  
C           WHICH IS NECESSARY FOR SUBSEQUENT CALLS                     
C                                                                       
C   FIRST CALL TO ODE --                                                
C                                                                       
C   THE USER MUST PROVIDE STORAGE IN HIS CALLING PROGRAM FOR THE ARRAYS 
C   IN THE CALL LIST,                                                   
C      Y(NEQN), WORK(100+21*NEQN), IWORK(5),                            
C   DECLARE  F  IN AN EXTERNAL STATEMENT, SUPPLY THE SUBROUTINE         
C   F(T,Y,YP) TO EVALUATE                                               
C      DY(I)/DT = YP(I) = F(T,Y(1),Y(2),...,Y(NEQN))                    
C   AND INITIALIZE THE PARAMETERS:                                      
C      NEQN -- NUMBER OF EQUATIONS TO BE INTEGRATED                     
C      Y(*) -- VECTOR OF INITIAL CONDITIONS                             
C      T -- STARTING POINT OF INTEGRATION                               
C      TOUT -- POINT AT WHICH SOLUTION IS DESIRED                       
C      RELERR,ABSERR -- RELATIVE AND ABSOLUTE LOCAL ERROR TOLERANCES    
C      IFLAG -- +1,-1.  INDICATOR TO INITIALIZE THE CODE.  NORMAL INPUT 
C           IS +1.  THE USER SHOULD SET IFLAG=-1 ONLY IF IT IS          
C           IMPOSSIBLE TO CONTINUE THE INTEGRATION BEYOND  TOUT .       
C   ALL PARAMETERS EXCEPT  F ,  NEQN  AND  TOUT  MAY BE ALTERED BY THE  
C   CODE ON OUTPUT SO MUST BE VARIABLES IN THE CALLING PROGRAM.         
C                                                                       
C   OUTPUT FROM  ODE  --                                                
C                                                                       
C      NEQN -- UNCHANGED                                                
C      Y(*) -- SOLUTION AT  T                                           
C      T -- LAST POINT REACHED IN INTEGRATION.  NORMAL RETURN HAS       
C           T = TOUT .                                                  
C      TOUT -- UNCHANGED                                                
C      RELERR,ABSERR -- NORMAL RETURN HAS TOLERANCES UNCHANGED.  IFLAG=3
C           SIGNALS TOLERANCES INCREASED                                
C      IFLAG = 2 -- NORMAL RETURN.  INTEGRATION REACHED  TOUT           
C            = 3 -- INTEGRATION DID NOT REACH  TOUT  BECAUSE ERROR      
C                   TOLERANCES TOO SMALL.  RELERR ,  ABSERR  INCREASED  
C                   APPROPRIATELY FOR CONTINUING                        
C            = 4 -- INTEGRATION DID NOT REACH  TOUT  BECAUSE MORE THAN  
C                   500 STEPS NEEDED                                    
C            = 5 -- INTEGRATION DID NOT REACH  TOUT  BECAUSE EQUATIONS  
C                   APPEAR TO BE STIFF                                  
C            = 6 -- INVALID INPUT PARAMETERS (FATAL ERROR)              
C           THE VALUE OF  IFLAG  IS RETURNED NEGATIVE WHEN THE INPUT    
C           VALUE IS NEGATIVE AND THE INTEGRATION DOES NOT REACH  TOUT ,
C           I.E., -3, -4, -5.                                           
C      WORK(*),IWORK(*) -- INFORMATION GENERALLY OF NO INTEREST TO THE  
C           USER BUT NECESSARY FOR SUBSEQUENT CALLS.                    
C                                                                       
C   SUBSEQUENT CALLS TO  ODE --                                         
C                                                                       
C   SUBROUTINE  ODE  RETURNS WITH ALL INFORMATION NEEDED TO CONTINUE    
C   THE INTEGRATION.  IF THE INTEGRATION REACHED  TOUT , THE USER NEED  
C   ONLY DEFINE A NEW  TOUT  AND CALL AGAIN.  IF THE INTEGRATION DID NOT
C   REACH  TOUT  AND THE USER WANTS TO CONTINUE, HE JUST CALLS AGAIN.   
C   THE OUTPUT VALUE OF  IFLAG  IS THE APPROPRIATE INPUT VALUE FOR      
C   SUBSEQUENT CALLS.  THE ONLY SITUATION IN WHICH IT SHOULD BE ALTERED 
C   IS TO STOP THE INTEGRATION INTERNALLY AT THE NEW  TOUT , I.E.,      
C   CHANGE OUTPUT  IFLAG=2  TO INPUT  IFLAG=-2 .  ERROR TOLERANCES MAY  
C   BE CHANGED BY THE USER BEFORE CONTINUING.  ALL OTHER PARAMETERS MUST
C   REMAIN UNCHANGED.                                                   
C                                                                       
C***********************************************************************
C*  SUBROUTINES  DE  AND  STEP  CONTAIN MACHINE DEPENDENT CONSTANTS.   *
C*  BE SURE THEY ARE SET BEFORE USING  ODE .                           *
C***********************************************************************
C                                                                       
      LOGICAL START,PHASE1,NORND                                        
      DIMENSION Y(NEQN),WORK(*),IWORK(5)                                
      EXTERNAL F                                                        
      DATA IALPHA,IBETA,ISIG,IV,IW,IG,IPHASE,IPSI,IX,IH,IHOLD,ISTART,   
     1  ITOLD,IDELSN/1,13,25,38,50,62,75,76,88,89,90,91,92,93/          
      IYY = 100                                                         
      IWT = IYY + NEQN                                                  
      IP = IWT + NEQN                                                   
      IYP = IP + NEQN                                                   
      IYPOUT = IYP + NEQN                                               
      IPHI = IYPOUT + NEQN                                              
      IF(IABS(IFLAG) .EQ. 1) GO TO 10                                   
      START = WORK(ISTART) .GT. 0.0                                     
      PHASE1 = WORK(IPHASE) .GT. 0.0                                    
      NORND = IWORK(2) .NE. -1                                          
   10 CALL DE(F,NEQN,Y,T,TOUT,RELERR,ABSERR,IFLAG,WORK(IYY),            
     1  WORK(IWT),WORK(IP),WORK(IYP),WORK(IYPOUT),WORK(IPHI),           
     2  WORK(IALPHA),WORK(IBETA),WORK(ISIG),WORK(IV),WORK(IW),WORK(IG), 
     3  PHASE1,WORK(IPSI),WORK(IX),WORK(IH),WORK(IHOLD),START,          
     4  WORK(ITOLD),WORK(IDELSN),IWORK(1),NORND,IWORK(3),IWORK(4),      
     5  IWORK(5))                                                       
      WORK(ISTART) = -1.0                                               
      IF(START) WORK(ISTART) = 1.0                                      
      WORK(IPHASE) = -1.0                                               
      IF(PHASE1) WORK(IPHASE) = 1.0                                     
      IWORK(2) = -1                                                     
      IF(NORND) IWORK(2) = 1                                            
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DE(F,NEQN,Y,T,TOUT,RELERR,ABSERR,IFLAG,YY,             
     A              WT,P,YP,YPOUT,PHI,ALPHA,BETA,SIG,V,W,G,PHASE1,PSI,  
     B              X,H,HOLD,START,TOLD,DELSGN,NS,NORND,K,KOLD,ISNOLD)  
C                                                                       
C     ******************************************************************
C     * LASL ROUTINE MAY 75.                                           *
C     * CALLED BY ODE, CALLING STEP AND INTRP.                         *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C   ODE  MERELY ALLOCATES STORAGE FOR  DE  TO RELIEVE THE USER OF THE   
C   INCONVENIENCE OF A LONG CALL LIST.  CONSEQUENTLY  DE  IS USED AS    
C   DESCRIBED IN THE COMMENTS FOR  ODE .                                
C                                                                       
C   THIS CODE IS COMPLETELY EXPLAINED AND DOCUMENTED IN THE TEXT,       
C   COMPUTER SOLUTION OF ORDINARY DIFFERENTIAL EQUATIONS:  THE INITIAL  
C   VALUE PROBLEM  BY L. F. SHAMPINE AND M. K. GORDON.                  
C                                                                       
      LOGICAL STIFF,CRASH,START,PHASE1,NORND                            
      DIMENSION Y(NEQN),YY(NEQN),WT(NEQN),PHI(NEQN,16),P(NEQN),YP(NEQN),
     1  YPOUT(NEQN),PSI(12),ALPHA(12),BETA(12),SIG(13),V(12),W(12),G(13)
      EXTERNAL F                                                        
C                                                                       
C***********************************************************************
C*  THE ONLY MACHINE DEPENDENT CONSTANT IS BASED ON THE MACHINE UNIT   *
C*  ROUNDOFF ERROR  U  WHICH IS THE SMALLEST POSITIVE NUMBER SUCH THAT *
C*  1.0+U .GT. 1.0 .  U  MUST BE CALCULATED AND  FOURU=4.0*U  INSERTED *
C*  IN THE FOLLOWING DATA STATEMENT BEFORE USING  DE .  THE ROUTINE    *
C*  MACHIN  CALCULATES  U .  FOURU  AND  TWOU=2.0*U  MUST ALSO BE      *
C*  INSERTED IN SUBROUTINE  STEP  BEFORE CALLING  DE .                 *
      DATA FOURU/2.84E-14/                                              
C***********************************************************************
C                                                                       
C   THE CONSTANT  MAXNUM  IS THE MAXIMUM NUMBER OF STEPS ALLOWED IN ONE 
C   CALL TO  DE .  THE USER MAY CHANGE THIS LIMIT BY ALTERING THE       
C   FOLLOWING STATEMENT                                                 
      DATA MAXNUM/500/                                                  
C                                                                       
C            ***            ***            ***                          
C   TEST FOR IMPROPER PARAMETERS                                        
C                                                                       
      IF(NEQN .LT. 1) GO TO 10                                          
      IF(T .EQ. TOUT) GO TO 10                                          
      IF(RELERR .LT. 0.0  .OR.  ABSERR .LT. 0.0) GO TO 10               
      EPS = DMAX1(RELERR,ABSERR)                                        
      IF(EPS .LE. 0.0) GO TO 10                                         
      IF(IFLAG .EQ. 0) GO TO 10                                         
      ISN = ISIGN(1,IFLAG)                                              
      IFLAG = IABS(IFLAG)                                               
      IF(IFLAG .EQ. 1) GO TO 20                                         
      IF(T .NE. TOLD) GO TO 10                                          
      IF(IFLAG .GE. 2  .AND.  IFLAG .LE. 5) GO TO 20                    
   10 IFLAG = 6                                                         
      RETURN                                                            
C                                                                       
C   ON EACH CALL SET INTERVAL OF INTEGRATION AND COUNTER FOR NUMBER OF  
C   STEPS.  ADJUST INPUT ERROR TOLERANCES TO DEFINE WEIGHT VECTOR FOR   
C   SUBROUTINE  STEP                                                    
C                                                                       
   20 DEL = TOUT - T                                                    
      ABSDEL = ABS(DEL)                                                 
      TEND = T + 10.0*DEL                                               
      IF(ISN .LT. 0) TEND = TOUT                                        
      NOSTEP = 0                                                        
      KLE4 = 0                                                          
      STIFF = .FALSE.                                                   
      RELEPS = RELERR/EPS                                               
      ABSEPS = ABSERR/EPS                                               
      IF(IFLAG .EQ. 1) GO TO 30                                         
      IF(ISNOLD .LT. 0) GO TO 30                                        
      IF(DELSGN*DEL .GT. 0.0) GO TO 50                                  
C                                                                       
C   ON START AND RESTART ALSO SET WORK VARIABLES X AND YY(*), STORE THE 
C   DIRECTION OF INTEGRATION AND INITIALIZE THE STEP SIZE               
C                                                                       
   30 START = .TRUE.                                                    
      X = T                                                             
      DO 40 L = 1,NEQN                                                  
   40   YY(L) = Y(L)                                                    
      DELSGN = SIGN(1.0,DEL)                                            
      H = SIGN( DMAX1( FOURU*ABS(X) , ABS( TOUT-X ) ),TOUT-X )          
C                                                                       
C   IF ALREADY PAST OUTPUT POINT, INTERPOLATE AND RETURN                
C                                                                       
   50 IF(ABS(X-T) .LT. ABSDEL) GO TO 60                                 
      CALL INTRP(X,YY,TOUT,Y,YPOUT,NEQN,KOLD,PHI,PSI)                   
      IFLAG = 2                                                         
      T = TOUT                                                          
      TOLD = T                                                          
      ISNOLD = ISN                                                      
      RETURN                                                            
C                                                                       
C   IF CANNOT GO PAST OUTPUT POINT AND SUFFICIENTLY CLOSE,              
C   EXTRAPOLATE AND RETURN                                              
C                                                                       
   60 IF(ISN .GT. 0  .OR.  ABS(TOUT-X) .GE. FOURU*ABS( X  )) GO TO 80   
      H = TOUT - X                                                      
      CALL F(X,YY,YP)                                                   
      DO 70 L = 1,NEQN                                                  
   70   Y(L) = YY(L) + H*YP(L)                                          
      IFLAG = 2                                                         
      T = TOUT                                                          
      TOLD = T                                                          
      ISNOLD = ISN                                                      
      RETURN                                                            
C                                                                       
C   TEST FOR TOO MANY STEPS                                             
C                                                                       
   80 IF(NOSTEP .LT. MAXNUM) GO TO 100                                  
      IFLAG = ISN*4                                                     
      IF(STIFF) IFLAG = ISN*5                                           
      DO 90 L = 1,NEQN                                                  
   90   Y(L) = YY(L)                                                    
      T = X                                                             
      TOLD = T                                                          
      ISNOLD = 1                                                        
      RETURN                                                            
C                                                                       
C   LIMIT STEP SIZE, SET WEIGHT VECTOR AND TAKE A STEP                  
C                                                                       
  100 H = SIGN(DMIN1(ABS(H),ABS(TEND-X)),H)                             
      DO 110 L = 1,NEQN                                                 
  110   WT(L) = RELEPS*ABS(YY(L)) + ABSEPS                              
      CALL STEP(F,NEQN,YY,X,H,EPS,WT,START,                             
     1  HOLD,K,KOLD,CRASH,PHI,P,YP,PSI,                                 
     2  ALPHA,BETA,SIG,V,W,G,PHASE1,NS,NORND)                           
C                                                                       
C   TEST FOR TOLERANCES TOO SMALL                                       
C                                                                       
      IF(.NOT.CRASH) GO TO 130                                          
      IFLAG = ISN*3                                                     
      RELERR = EPS*RELEPS                                               
      ABSERR = EPS*ABSEPS                                               
      DO 120 L = 1,NEQN                                                 
  120   Y(L) = YY(L)                                                    
      T = X                                                             
      TOLD = T                                                          
      ISNOLD = 1                                                        
      RETURN                                                            
C                                                                       
C   AUGMENT COUNTER ON NUMBER OF STEPS AND TEST FOR STIFFNESS           
C                                                                       
  130 NOSTEP = NOSTEP + 1                                               
      KLE4 = KLE4 + 1                                                   
      IF(KOLD .GT. 4) KLE4 = 0                                          
      IF(KLE4 .GE. 50) STIFF = .TRUE.                                   
      GO TO 50                                                          
      END                                                               
C                                                                       
      SUBROUTINE STEP(F,NEQN,Y,X,H,EPS,WT,START,                        
     A                HOLD,K,KOLD,CRASH,PHI,P,YP,PSI,                   
     B                ALPHA,BETA,SIG,V,W,G,PHASE1,NS,NORND)             
C                                                                       
C     ******************************************************************
C     * LASL ROUTINE MAY 75.                                           *
C     * CALLED BY STEP.                                                *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C   SUBROUTINE  STEP  IS NORMALLY USED INDIRECTLY THROUGH SUBROUTINE    
C   ODE .  BECAUSE  ODE  SUFFICES FOR MOST PROBLEMS AND IS MUCH EASIER  
C   TO USE, USING IT SHOULD BE CONSIDERED BEFORE USING  STEP  ALONE.    
C                                                                       
C   SUBROUTINE  STEP  INTEGRATES A SYSTEM OF  NEQN  FIRST ORDER ORDINARY
C   DIFFERENTIAL EQUATIONS ONE STEP, NORMALLY FROM X TO X+H, USING A    
C   MODIFIED DIVIDED DIFFERENCE FORM OF THE ADAMS PECE FORMULAS.  LOCAL 
C   EXTRAPOLATION IS USED TO IMPROVE ABSOLUTE STABILITY AND ACCURACY.   
C   THE CODE ADJUSTS ITS ORDER AND STEP SIZE TO CONTROL THE LOCAL ERROR 
C   PER UNIT STEP IN A GENERALIZED SENSE.  SPECIAL DEVICES ARE INCLUDED 
C   TO CONTROL ROUNDOFF ERROR AND TO DETECT WHEN THE USER IS REQUESTING 
C   TOO MUCH ACCURACY.                                                  
C                                                                       
C   THIS CODE IS COMPLETELY EXPLAINED AND DOCUMENTED IN THE TEXT,       
C   COMPUTER SOLUTION OF ORDINARY DIFFERENTIAL EQUATIONS:  THE INITIAL  
C   VALUE PROBLEM  BY L. F. SHAMPINE AND M. K. GORDON.                  
C                                                                       
C                                                                       
C   THE PARAMETERS REPRESENT:                                           
C      F -- SUBROUTINE TO EVALUATE DERIVATIVES                          
C      NEQN -- NUMBER OF EQUATIONS TO BE INTEGRATED                     
C      Y(*) -- SOLUTION VECTOR AT X                                     
C      X -- INDEPENDENT VARIABLE                                        
C      H -- APPROPRIATE STEP SIZE FOR NEXT STEP.  NORMALLY DETERMINED BY
C           CODE                                                        
C      EPS -- LOCAL ERROR TOLERANCE                                     
C      WT(*) -- VECTOR OF WEIGHTS FOR ERROR CRITERION                   
C      START -- LOGICAL VARIABLE SET .TRUE. FOR FIRST STEP,  .FALSE.    
C           OTHERWISE                                                   
C      HOLD -- STEP SIZE USED FOR LAST SUCCESSFUL STEP                  
C      K -- APPROPRIATE ORDER FOR NEXT STEP (DETERMINED BY CODE)        
C      KOLD -- ORDER USED FOR LAST SUCCESSFUL STEP                      
C      CRASH -- LOGICAL VARIABLE SET .TRUE. WHEN NO STEP CAN BE TAKEN,  
C           .FALSE. OTHERWISE.                                          
C      YP(*) -- DERIVATIVE OF SOLUTION VECTOR AT  X  AFTER SUCCESSFUL   
C           STEP                                                        
C   THE ARRAYS  PHI, PSI  ARE REQUIRED FOR THE INTERPOLATION SUBROUTINE 
C   INTRP .  THE ARRAY  P  IS INTERNAL TO THE CODE.  THE REMAINING NINE 
C   VARIABLES AND ARRAYS ARE INCLUDED IN THE CALL LIST ONLY TO ELIMINATE
C   LOCAL RETENTION OF VARIABLES BETWEEN CALLS.                         
C                                                                       
C   INPUT TO  STEP                                                      
C                                                                       
C      FIRST CALL --                                                    
C                                                                       
C   THE USER MUST PROVIDE STORAGE IN HIS CALLING PROGRAM FOR ALL ARRAYS 
C   IN THE CALL LIST, NAMELY                                            
C                                                                       
C     DIMENSION Y(NEQN),WT(NEQN),PHI(NEQN,16),P(NEQN),YP(NEQN),PSI(12), 
C    1  ALPHA(12),BETA(12),SIG(13),V(12),W(12),G(13)                    
C                                                                       
C   THE USER MUST ALSO DECLARE  START ,  CRASH ,  PHASE1  AND  NORND    
C   LOGICAL VARIABLES AND  F  AN EXTERNAL SUBROUTINE, SUPPLY THE        
C   SUBROUTINE  F(X,Y,YP)  TO EVALUATE                                  
C      DY(I)/DX = YP(I) = F(X,Y(1),Y(2),...,Y(NEQN))                    
C   AND INITIALIZE ONLY THE FOLLOWING PARAMETERS:                       
C      NEQN -- NUMBER OF EQUATIONS TO BE INTEGRATED                     
C      Y(*) -- VECTOR OF INITIAL VALUES OF DEPENDENT VARIABLES          
C      X -- INITIAL VALUE OF THE INDEPENDENT VARIABLE                   
C      H -- NOMINAL STEP SIZE INDICATING DIRECTION OF INTEGRATION       
C           AND MAXIMUM SIZE OF STEP.  MUST BE VARIABLE                 
C      EPS -- LOCAL ERROR TOLERANCE PER STEP.  MUST BE VARIABLE         
C      WT(*) -- VECTOR OF NON-ZERO WEIGHTS FOR ERROR CRITERION          
C      START -- .TRUE.                                                  
C                                                                       
C   STEP  REQUIRES THE L2 NORM OF THE VECTOR WITH COMPONENTS            
C   LOCAL ERROR(L)/WT(L)  BE LESS THAN  EPS  FOR A SUCCESSFUL STEP.  THE
C   ARRAY  WT  ALLOWS THE USER TO SPECIFY AN ERROR TEST APPROPRIATE     
C   FOR HIS PROBLEM.  FOR EXAMPLE,                                      
C      WT(L) = 1.0  SPECIFIES ABSOLUTE ERROR,                           
C            = ABS(Y(L))  ERROR RELATIVE TO THE MOST RECENT VALUE OF THE
C                 L-TH COMPONENT OF THE SOLUTION,                       
C            = ABS(YP(L))  ERROR RELATIVE TO THE MOST RECENT VALUE OF   
C                 THE L-TH COMPONENT OF THE DERIVATIVE,                 
C            = DMAX1(WT(L),ABS(Y(L)))  ERROR RELATIVE TO THE LARGEST    
C                 MAGNITUDE OF L-TH COMPONENT OBTAINED SO FAR,          
C            = ABS(Y(L))*RELERR/EPS + ABSERR/EPS  SPECIFIES A MIXED     
C                 RELATIVE-ABSOLUTE TEST WHERE  RELERR  IS RELATIVE     
C                 ERROR,  ABSERR  IS ABSOLUTE ERROR AND  EPS =          
C                 DMAX1(RELERR,ABSERR) .                                
C                                                                       
C      SUBSEQUENT CALLS --                                              
C                                                                       
C   SUBROUTINE  STEP  IS DESIGNED SO THAT ALL INFORMATION NEEDED TO     
C   CONTINUE THE INTEGRATION, INCLUDING THE STEP SIZE  H  AND THE ORDER 
C   K , IS RETURNED WITH EACH STEP.  WITH THE EXCEPTION OF THE STEP     
C   SIZE, THE ERROR TOLERANCE, AND THE WEIGHTS, NONE OF THE PARAMETERS  
C   SHOULD BE ALTERED.  THE ARRAY  WT  MUST BE UPDATED AFTER EACH STEP  
C   TO MAINTAIN RELATIVE ERROR TESTS LIKE THOSE ABOVE.  NORMALLY THE    
C   INTEGRATION IS CONTINUED JUST BEYOND THE DESIRED ENDPOINT AND THE   
C   SOLUTION INTERPOLATED THERE WITH SUBROUTINE  INTRP .  IF IT IS      
C   IMPOSSIBLE TO INTEGRATE BEYOND THE ENDPOINT, THE STEP SIZE MAY BE   
C   REDUCED TO HIT THE ENDPOINT SINCE THE CODE WILL NOT TAKE A STEP     
C   LARGER THAN THE  H  INPUT.  CHANGING THE DIRECTION OF INTEGRATION,  
C   I.E., THE SIGN OF  H , REQUIRES THE USER SET  START = .TRUE. BEFORE 
C   CALLING  STEP  AGAIN.  THIS IS THE ONLY SITUATION IN WHICH  START   
C   SHOULD BE ALTERED.                                                  
C                                                                       
C   OUTPUT FROM  STEP                                                   
C                                                                       
C      SUCCESSFUL STEP --                                               
C                                                                       
C   THE SUBROUTINE RETURNS AFTER EACH SUCCESSFUL STEP WITH  START  AND  
C   CRASH  SET .FALSE. .  X  REPRESENTS THE INDEPENDENT VARIABLE        
C   ADVANCED ONE STEP OF LENGTH  HOLD  FROM ITS VALUE ON INPUT AND  Y   
C   THE SOLUTION VECTOR AT THE NEW VALUE OF  X .  ALL OTHER PARAMETERS  
C   REPRESENT INFORMATION CORRESPONDING TO THE NEW  X  NEEDED TO        
C   CONTINUE THE INTEGRATION.                                           
C                                                                       
C      UNSUCCESSFUL STEP --                                             
C                                                                       
C   WHEN THE ERROR TOLERANCE IS TOO SMALL FOR THE MACHINE PRECISION,    
C   THE SUBROUTINE RETURNS WITHOUT TAKING A STEP AND  CRASH = .TRUE. .  
C   AN APPROPRIATE STEP SIZE AND ERROR TOLERANCE FOR CONTINUING ARE     
C   ESTIMATED AND ALL OTHER INFORMATION IS RESTORED AS UPON INPUT       
C   BEFORE RETURNING.  TO CONTINUE WITH THE LARGER TOLERANCE, THE USER  
C   JUST CALLS THE CODE AGAIN.  A RESTART IS NEITHER REQUIRED NOR       
C   DESIRABLE.                                                          
C                                                                       
      LOGICAL START,CRASH,PHASE1,NORND                                  
      DIMENSION Y(NEQN),WT(NEQN),PHI(NEQN,16),P(NEQN),YP(NEQN),PSI(12), 
     1  ALPHA(12),BETA(12),SIG(13),V(12),W(12),G(13)                    
      DIMENSION TWO(13),GSTR(13)                                        
      EXTERNAL F                                                        
C***********************************************************************
C*  THE ONLY MACHINE DEPENDENT CONSTANTS ARE BASED ON THE MACHINE UNIT *
C*  ROUNDOFF ERROR  U  WHICH IS THE SMALLEST POSITIVE NUMBER SUCH THAT *
C*  1.0+U .GT. 1.0  .  THE USER MUST CALCULATE  U  AND INSERT          *
C*  TWOU=2.0*U  AND  FOURU=4.0*U  IN THE DATA STATEMENT BEFORE CALLING *
C*  THE CODE.  THE ROUTINE  MACHIN  CALCULATES  U .                    *
      DATA TWOU,FOURU/1.42E-14,2.84E-14/                                
C***********************************************************************
      DATA TWO/2.0,4.0,8.0,16.0,32.0,64.0,128.0,256.0,512.0,1024.0,     
     1  2048.0,4096.0,8192.0/                                           
      DATA GSTR/0.500,0.0833,0.0417,0.0264,0.0188,0.0143,0.0114,0.00936,
     1  0.00789,0.00679,0.00592,0.00524,0.00468/                        
C                                                                       
C                                                                       
C       ***     BEGIN BLOCK 0     ***                                   
C   CHECK IF STEP SIZE OR ERROR TOLERANCE IS TOO SMALL FOR MACHINE      
C   PRECISION.  IF FIRST STEP, INITIALIZE PHI ARRAY AND ESTIMATE A      
C   STARTING STEP SIZE.                                                 
C                   ***                                                 
C                                                                       
C   IF STEP SIZE IS TOO SMALL, DETERMINE AN ACCEPTABLE ONE              
C                                                                       
      CRASH = .TRUE.                                                    
      IF(ABS(H) .GE. FOURU*ABS(X)) GO TO 5                              
      H = SIGN(FOURU*ABS(X),H)                                          
      RETURN                                                            
    5 P5EPS = 0.5*EPS                                                   
C                                                                       
C   IF ERROR TOLERANCE IS TOO SMALL, INCREASE IT TO AN ACCEPTABLE VALUE 
C                                                                       
      ROUND = 0.0                                                       
      DO 10 L = 1,NEQN                                                  
   10   ROUND = ROUND + (Y(L)/WT(L))**2                                 
      ROUND = TWOU*SQRT(ROUND)                                          
      IF(P5EPS .GE. ROUND) GO TO 15                                     
      EPS = 2.0*ROUND*(1.0 + FOURU)                                     
      RETURN                                                            
   15 CRASH = .FALSE.                                                   
      G(1) = 1.0                                                        
      G(2) = 0.5                                                        
      SIG(1) = 1.0                                                      
      IF(.NOT.START) GO TO 99                                           
C                                                                       
C   INITIALIZE.  COMPUTE APPROPRIATE STEP SIZE FOR FIRST STEP           
C                                                                       
      CALL F(X,Y,YP)                                                    
      SUM = 0.0                                                         
      DO 20 L = 1,NEQN                                                  
        PHI(L,1) = YP(L)                                                
        PHI(L,2) = 0.0                                                  
   20   SUM = SUM + (YP(L)/WT(L))**2                                    
      SUM = SQRT(SUM)                                                   
      ABSH = ABS(H)                                                     
      IF(EPS .LT. 16.0*SUM*H*H) ABSH = 0.25*SQRT(EPS/SUM)               
      H = SIGN(DMAX1(ABSH,FOURU*ABS(X)),H)                              
      HOLD = 0.0                                                        
      K = 1                                                             
      KOLD = 0                                                          
      START = .FALSE.                                                   
      PHASE1 = .TRUE.                                                   
      NORND = .TRUE.                                                    
      IF(P5EPS .GT. 100.0*ROUND) GO TO 99                               
      NORND = .FALSE.                                                   
      DO 25 L = 1,NEQN                                                  
   25   PHI(L,15) = 0.0                                                 
   99 IFAIL = 0                                                         
C       ***     END BLOCK 0     ***                                     
C                                                                       
C       ***     BEGIN BLOCK 1     ***                                   
C   COMPUTE COEFFICIENTS OF FORMULAS FOR THIS STEP.  AVOID COMPUTING    
C   THOSE QUANTITIES NOT CHANGED WHEN STEP SIZE IS NOT CHANGED.         
C                   ***                                                 
C                                                                       
  100 KP1 = K+1                                                         
      KP2 = K+2                                                         
      KM1 = K-1                                                         
      KM2 = K-2                                                         
C                                                                       
C   NS IS THE NUMBER OF STEPS TAKEN WITH SIZE H, INCLUDING THE CURRENT  
C   ONE.  WHEN K.LT.NS, NO COEFFICIENTS CHANGE                          
C                                                                       
      IF(H .NE. HOLD) NS = 0                                            
      NS = MIN0(NS+1,KOLD+1)                                            
      NSP1 = NS+1                                                       
      IF (K .LT. NS) GO TO 199                                          
C                                                                       
C   COMPUTE THOSE COMPONENTS OF ALPHA(*),BETA(*),PSI(*),SIG(*) WHICH    
C   ARE CHANGED                                                         
C                                                                       
      BETA(NS) = 1.0                                                    
      REALNS = NS                                                       
      ALPHA(NS) = 1.0/REALNS                                            
      TEMP1 = H*REALNS                                                  
      SIG(NSP1) = 1.0                                                   
      IF(K .LT. NSP1) GO TO 110                                         
      DO 105 I = NSP1,K                                                 
        IM1 = I-1                                                       
        TEMP2 = PSI(IM1)                                                
        PSI(IM1) = TEMP1                                                
        BETA(I) = BETA(IM1)*PSI(IM1)/TEMP2                              
        TEMP1 = TEMP2 + H                                               
        ALPHA(I) = H/TEMP1                                              
        REALI = I                                                       
  105   SIG(I+1) = REALI*ALPHA(I)*SIG(I)                                
  110 PSI(K) = TEMP1                                                    
C                                                                       
C   COMPUTE COEFFICIENTS G(*)                                           
C                                                                       
C   INITIALIZE V(*) AND SET W(*).                                       
C                                                                       
      IF(NS .GT. 1) GO TO 120                                           
      DO 115 IQ = 1,K                                                   
        TEMP3 = IQ*(IQ+1)                                               
        V(IQ) = 1.0/TEMP3                                               
  115   W(IQ) = V(IQ)                                                   
      GO TO 140                                                         
C                                                                       
C   IF ORDER WAS RAISED, UPDATE DIAGONAL PART OF V(*)                   
C                                                                       
  120 IF(K .LE. KOLD) GO TO 130                                         
      TEMP4 = K*KP1                                                     
      V(K) = 1.0/TEMP4                                                  
      NSM2 = NS-2                                                       
      IF(NSM2 .LT. 1) GO TO 130                                         
      DO 125 J = 1,NSM2                                                 
        I = K-J                                                         
  125   V(I) = V(I) - ALPHA(J+1)*V(I+1)                                 
C                                                                       
C   UPDATE V(*) AND SET W(*)                                            
C                                                                       
  130 LIMIT1 = KP1 - NS                                                 
      TEMP5 = ALPHA(NS)                                                 
      DO 135 IQ = 1,LIMIT1                                              
        V(IQ) = V(IQ) - TEMP5*V(IQ+1)                                   
  135   W(IQ) = V(IQ)                                                   
      G(NSP1) = W(1)                                                    
C                                                                       
C   COMPUTE THE G(*) IN THE WORK VECTOR W(*)                            
C                                                                       
  140 NSP2 = NS + 2                                                     
      IF(KP1 .LT. NSP2) GO TO 199                                       
      DO 150 I = NSP2,KP1                                               
        LIMIT2 = KP2 - I                                                
        TEMP6 = ALPHA(I-1)                                              
        DO 145 IQ = 1,LIMIT2                                            
  145     W(IQ) = W(IQ) - TEMP6*W(IQ+1)                                 
  150   G(I) = W(1)                                                     
  199   CONTINUE                                                        
C       ***     END BLOCK 1     ***                                     
C                                                                       
C       ***     BEGIN BLOCK 2     ***                                   
C   PREDICT A SOLUTION P(*), EVALUATE DERIVATIVES USING PREDICTED       
C   SOLUTION, ESTIMATE LOCAL ERROR AT ORDER K AND ERRORS AT ORDERS K,   
C   K-1, K-2 AS IF CONSTANT STEP SIZE WERE USED.                        
C                   ***                                                 
C                                                                       
C   CHANGE PHI TO PHI STAR                                              
C                                                                       
      IF(K .LT. NSP1) GO TO 215                                         
      DO 210 I = NSP1,K                                                 
        TEMP1 = BETA(I)                                                 
        DO 205 L = 1,NEQN                                               
  205     PHI(L,I) = TEMP1*PHI(L,I)                                     
  210   CONTINUE                                                        
C                                                                       
C   PREDICT SOLUTION AND DIFFERENCES                                    
C                                                                       
  215 DO 220 L = 1,NEQN                                                 
        PHI(L,KP2) = PHI(L,KP1)                                         
        PHI(L,KP1) = 0.0                                                
  220   P(L) = 0.0                                                      
      DO 230 J = 1,K                                                    
        I = KP1 - J                                                     
        IP1 = I+1                                                       
        TEMP2 = G(I)                                                    
        DO 225 L = 1,NEQN                                               
          P(L) = P(L) + TEMP2*PHI(L,I)                                  
  225     PHI(L,I) = PHI(L,I) + PHI(L,IP1)                              
  230   CONTINUE                                                        
      IF(NORND) GO TO 240                                               
      DO 235 L = 1,NEQN                                                 
        TAU = H*P(L) - PHI(L,15)                                        
        P(L) = Y(L) + TAU                                               
  235   PHI(L,16) = (P(L) - Y(L)) - TAU                                 
      GO TO 250                                                         
  240 DO 245 L = 1,NEQN                                                 
  245   P(L) = Y(L) + H*P(L)                                            
  250 XOLD = X                                                          
      X = X + H                                                         
      ABSH = ABS(H)                                                     
      CALL F(X,P,YP)                                                    
C                                                                       
C   ESTIMATE ERRORS AT ORDERS K,K-1,K-2                                 
C                                                                       
      ERKM2 = 0.0                                                       
      ERKM1 = 0.0                                                       
      ERK = 0.0                                                         
      DO 265 L = 1,NEQN                                                 
        TEMP3 = 1.0/WT(L)                                               
        TEMP4 = YP(L) - PHI(L,1)                                        
        IF(KM2)265,260,255                                              
  255   ERKM2 = ERKM2 + ((PHI(L,KM1)+TEMP4)*TEMP3)**2                   
  260   ERKM1 = ERKM1 + ((PHI(L,K)+TEMP4)*TEMP3)**2                     
  265   ERK = ERK + (TEMP4*TEMP3)**2                                    
      IF(KM2)280,275,270                                                
  270 ERKM2 = ABSH*SIG(KM1)*GSTR(KM2)*SQRT(ERKM2)                       
  275 ERKM1 = ABSH*SIG(K)*GSTR(KM1)*SQRT(ERKM1)                         
  280 TEMP5 = ABSH*SQRT(ERK)                                            
      ERR = TEMP5*(G(K)-G(KP1))                                         
      ERK = TEMP5*SIG(KP1)*GSTR(K)                                      
      KNEW = K                                                          
C                                                                       
C   TEST IF ORDER SHOULD BE LOWERED                                     
C                                                                       
      IF(KM2)299,290,285                                                
  285 IF(DMAX1(ERKM1,ERKM2) .LE. ERK) KNEW = KM1                        
      GO TO 299                                                         
  290 IF(ERKM1 .LE. 0.5*ERK) KNEW = KM1                                 
C                                                                       
C   TEST IF STEP SUCCESSFUL                                             
C                                                                       
  299 IF(ERR .LE. EPS) GO TO 400                                        
C       ***     END BLOCK 2     ***                                     
C                                                                       
C       ***     BEGIN BLOCK 3     ***                                   
C   THE STEP IS UNSUCCESSFUL.  RESTORE  X, PHI(*,*), PSI(*) .           
C   IF THIRD CONSECUTIVE FAILURE, SET ORDER TO ONE.  IF STEP FAILS MORE 
C   THAN THREE TIMES, CONSIDER AN OPTIMAL STEP SIZE.  DOUBLE ERROR      
C   TOLERANCE AND RETURN IF ESTIMATED STEP SIZE IS TOO SMALL FOR MACHINE
C   PRECISION.                                                          
C                   ***                                                 
C                                                                       
C   RESTORE X, PHI(*,*) AND PSI(*)                                      
C                                                                       
      PHASE1 = .FALSE.                                                  
      X = XOLD                                                          
      DO 310 I = 1,K                                                    
        TEMP1 = 1.0/BETA(I)                                             
        IP1 = I+1                                                       
        DO 305 L = 1,NEQN                                               
  305     PHI(L,I) = TEMP1*(PHI(L,I) - PHI(L,IP1))                      
  310   CONTINUE                                                        
      IF(K .LT. 2) GO TO 320                                            
      DO 315 I = 2,K                                                    
  315   PSI(I-1) = PSI(I) - H                                           
C                                                                       
C   ON THIRD FAILURE, SET ORDER TO ONE.  THEREAFTER, USE OPTIMAL STEP   
C   SIZE                                                                
C                                                                       
  320 IFAIL = IFAIL + 1                                                 
      TEMP2 = 0.5                                                       
      IF(IFAIL - 3) 335,330,325                                         
  325 IF(P5EPS .LT. 0.25*ERK) TEMP2 = SQRT(P5EPS/ERK)                   
  330 KNEW = 1                                                          
  335 H = TEMP2*H                                                       
      K = KNEW                                                          
      IF(ABS(H) .GE. FOURU*ABS(X)) GO TO 340                            
      CRASH = .TRUE.                                                    
      H = SIGN(FOURU*ABS(X),H)                                          
      EPS = EPS + EPS                                                   
      RETURN                                                            
  340 GO TO 100                                                         
C       ***     END BLOCK 3     ***                                     
C                                                                       
C       ***     BEGIN BLOCK 4     ***                                   
C   THE STEP IS SUCCESSFUL.  CORRECT THE PREDICTED SOLUTION, EVALUATE   
C   THE DERIVATIVES USING THE CORRECTED SOLUTION AND UPDATE THE         
C   DIFFERENCES.  DETERMINE BEST ORDER AND STEP SIZE FOR NEXT STEP.     
C                   ***                                                 
  400 KOLD = K                                                          
      HOLD = H                                                          
C                                                                       
C   CORRECT AND EVALUATE                                                
C                                                                       
      TEMP1 = H*G(KP1)                                                  
      IF(NORND) GO TO 410                                               
      DO 405 L = 1,NEQN                                                 
        RHO = TEMP1*(YP(L) - PHI(L,1)) - PHI(L,16)                      
        Y(L) = P(L) + RHO                                               
  405   PHI(L,15) = (Y(L) - P(L)) - RHO                                 
      GO TO 420                                                         
  410 DO 415 L = 1,NEQN                                                 
  415   Y(L) = P(L) + TEMP1*(YP(L) - PHI(L,1))                          
  420 CALL F(X,Y,YP)                                                    
C                                                                       
C   UPDATE DIFFERENCES FOR NEXT STEP                                    
C                                                                       
      DO 425 L = 1,NEQN                                                 
        PHI(L,KP1) = YP(L) - PHI(L,1)                                   
  425   PHI(L,KP2) = PHI(L,KP1) - PHI(L,KP2)                            
      DO 435 I = 1,K                                                    
        DO 430 L = 1,NEQN                                               
  430     PHI(L,I) = PHI(L,I) + PHI(L,KP1)                              
  435   CONTINUE                                                        
C                                                                       
C   ESTIMATE ERROR AT ORDER K+1 UNLESS:                                 
C     IN FIRST PHASE WHEN ALWAYS RAISE ORDER,                           
C     ALREADY DECIDED TO LOWER ORDER,                                   
C     STEP SIZE NOT CONSTANT SO ESTIMATE UNRELIABLE                     
C                                                                       
      ERKP1 = 0.0                                                       
      IF(KNEW .EQ. KM1  .OR.  K .EQ. 12) PHASE1 = .FALSE.               
      IF(PHASE1) GO TO 450                                              
      IF(KNEW .EQ. KM1) GO TO 455                                       
      IF(KP1 .GT. NS) GO TO 460                                         
      DO 440 L = 1,NEQN                                                 
  440   ERKP1 = ERKP1 + (PHI(L,KP2)/WT(L))**2                           
      ERKP1 = ABSH*GSTR(KP1)*SQRT(ERKP1)                                
C                                                                       
C   USING ESTIMATED ERROR AT ORDER K+1, DETERMINE APPROPRIATE ORDER     
C   FOR NEXT STEP                                                       
C                                                                       
      IF(K .GT. 1) GO TO 445                                            
      IF(ERKP1 .GE. 0.5*ERK) GO TO 460                                  
      GO TO 450                                                         
  445 IF(ERKM1 .LE. DMIN1(ERK,ERKP1)) GO TO 455                         
      IF(ERKP1 .GE. ERK  .OR.  K .EQ. 12) GO TO 460                     
C                                                                       
C   HERE ERKP1 .LT. ERK .LT. DMAX1(ERKM1,ERKM2) ELSE ORDER WOULD HAVE   
C   BEEN LOWERED IN BLOCK 2.  THUS ORDER IS TO BE RAISED                
C                                                                       
C   RAISE ORDER                                                         
C                                                                       
  450 K   = KP1                                                           
      ERK = ERKP1                                                       
      GO TO 460                                                         
C                                                                       
C   LOWER ORDER                                                         
C                                                                       
  455 K   = KM1                                                           
      ERK = ERKM1                                                       
C                                                                       
C   WITH NEW ORDER DETERMINE APPROPRIATE STEP SIZE FOR NEXT STEP        
C                                                                       
  460 HNEW = H + H                                                      
      IF(PHASE1) GO TO 465                                              
      IF(P5EPS .GE. ERK*TWO(K+1)) GO TO 465                             
      HNEW = H                                                          
      IF(P5EPS .GE. ERK) GO TO 465                                      
      TEMP2 = K+1                                                       
      R    = (P5EPS/ERK)**(1.0/TEMP2)                                      
      HNEW = ABSH*DMAX1(0.5D+0,DMIN1(0.9D+0,R))                               
      HNEW = SIGN(DMAX1(HNEW,FOURU*ABS(X)),H)                           
  465 H = HNEW                                                          
      RETURN                                                            
C       ***     END BLOCK 4     ***                                     
      END                                                               
C                                                                       
      SUBROUTINE INTRP(X,Y,XOUT,YOUT,YPOUT,NEQN,KOLD,PHI,PSI)           
C                                                                       
C     ******************************************************************
C     * LASL ROUTINE MAY 75.                                           *
C     * CALLED BY DE.                                                  *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C   THE METHODS IN SUBROUTINE  STEP  APPROXIMATE THE SOLUTION NEAR  X   
C   BY A POLYNOMIAL.  SUBROUTINE  INTRP  APPROXIMATES THE SOLUTION AT   
C   XOUT  BY EVALUATING THE POLYNOMIAL THERE.  INFORMATION DEFINING THIS
C   POLYNOMIAL IS PASSED FROM  STEP  SO  INTRP  CANNOT BE USED ALONE.   
C                                                                       
C   THIS CODE IS COMPLETELY EXPLAINED AND DOCUMENTED IN THE TEXT,       
C   COMPUTER SOLUTION OF ORDINARY DIFFERENTIAL EQUATIONS:  THE INITIAL  
C   VALUE PROBLEM  BY L. F. SHAMPINE AND M. K. GORDON.                  
C                                                                       
C   INPUT TO INTRP --                                                   
C                                                                       
C   THE USER PROVIDES STORAGE IN THE CALLING PROGRAM FOR THE ARRAYS IN  
C   THE CALL LIST                                                       
       DIMENSION Y(NEQN),YOUT(NEQN),YPOUT(NEQN),PHI(NEQN,16),PSI(12)    
C   AND DEFINES                                                         
C      XOUT -- POINT AT WHICH SOLUTION IS DESIRED.                      
C   THE REMAINING PARAMETERS ARE DEFINED IN  STEP  AND PASSED TO  INTRP 
C   FROM THAT SUBROUTINE                                                
C                                                                       
C   OUTPUT FROM  INTRP --                                               
C                                                                       
C      YOUT(*) -- SOLUTION AT  XOUT                                     
C      YPOUT(*) -- DERIVATIVE OF SOLUTION AT  XOUT                      
C   THE REMAINING PARAMETERS ARE RETURNED UNALTERED FROM THEIR INPUT    
C   VALUES.  INTEGRATION WITH  STEP  MAY BE CONTINUED.                  
C                                                                       
      DIMENSION G(13),W(13),RHO(13)                                     
      DATA G(1)/1.0/,RHO(1)/1.0/                                        
C                                                                       
      HI = XOUT - X                                                     
      KI = KOLD + 1                                                     
      KIP1 = KI + 1                                                     
C                                                                       
C   INITIALIZE W(*) FOR COMPUTING G(*)                                  
C                                                                       
      DO 5 I = 1,KI                                                     
        TEMP1 = I                                                       
    5   W(I) = 1.0/TEMP1                                                
      TERM = 0.0                                                        
C                                                                       
C   COMPUTE G(*)                                                        
C                                                                       
      DO 15 J = 2,KI                                                    
        JM1 = J - 1                                                     
        PSIJM1 = PSI(JM1)                                               
        GAMMA = (HI + TERM)/PSIJM1                                      
        ETA = HI/PSIJM1                                                 
        LIMIT1 = KIP1 - J                                               
        DO 10 I = 1,LIMIT1                                              
   10     W(I) = GAMMA*W(I) - ETA*W(I+1)                                
        G(J) = W(1)                                                     
        RHO(J) = GAMMA*RHO(JM1)                                         
   15   TERM = PSIJM1                                                   
C                                                                       
C   INTERPOLATE                                                         
C                                                                       
      DO 20 L = 1,NEQN                                                  
        YPOUT(L) = 0.0                                                  
   20   YOUT(L) = 0.0                                                   
      DO 30 J = 1,KI                                                    
        I = KIP1 - J                                                    
        TEMP2 = G(I)                                                    
        TEMP3 = RHO(I)                                                  
        DO 25 L = 1,NEQN                                                
          YOUT(L) = YOUT(L) + TEMP2*PHI(L,I)                            
   25     YPOUT(L) = YPOUT(L) + TEMP3*PHI(L,I)                          
   30   CONTINUE                                                        
      DO 35 L = 1,NEQN                                                  
   35   YOUT(L) = Y(L) + HI*YOUT(L)                                     
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE LSQ(NAX,X,Y,MAX,A)                                     
C                                                                       
C     ******************************************************************
C     * LEAST SQUARES FITTING SUBROUTINE.                              *
C     * (X(N),Y(N)), N=1,NAX ARE THE COORDINATES OF THE POINTS TO BE   *
C     * FITTED, AND A(M), M=1,MAX ARE THE COEFFICIENTS OF POLYNOMIAL   *
C     * Y=SUM(A(M)*X**(M-1)).                                          *
C     * MAX SHOULD NOT EXCEED 20 OR NAX.                               *
C     * LSQ CALLS UZERO, UCOPY, AND MATIN1.                            *
C     * COPIED BY RICARDO GALVAO FROM CERNLIB AT SARA AMSTERDAM DEC 80.*
c     * added integer array IC to avoid inconsistent types in call to  *
c     * MATIN1 (jpg, 17/04/07)                                         *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION X(*),Y(*),A(*),B(20,21),C(40)
c     * added integer array IC (jpg):	  
	  INTEGER IC(40)                           
      IF(MAX.GT.20) GO TO 24                                            
      IF(MAX.GE.NAX) GO TO 32                                           
      IF(MAX.LE.0) GO TO 36                                             
      IF(NAX.LE.0) GO TO 40                                             
      LAX=2*MAX-1                                                       
      C(1)=NAX                                                          
      IF(MAX.EQ.1) GO TO 8                                              
      CALL UZERO(C,2,LAX)                                               
      DO 4 N=1,NAX                                                      
      XN=X(N)                                                           
      XL=1.0                                                            
      DO 4 L=2,LAX                                                      
      XL=XL*XN                                                          
    4 C(L)=C(L)+XL                                                      
    8 DO 12 M=1,MAX                                                     
   12 CALL UCOPY(C(M),B(1,M),MAX)                                       
      CALL UZERO(C,1,MAX)                                               
      DO 16 N=1,NAX                                                     
      XN=X(N)                                                           
      YXL=Y(N)                                                          
      DO 16 M=1,MAX                                                     
      C(M)=C(M)+YXL                                                     
   16 YXL=YXL*XN                                                        
      CALL UCOPY(C,B(1,MAX+1),MAX)                                      
      IF(MAX.EQ.1) GO TO 20 
c     * replaced argument C by IC (jpg)	                                              
c      CALL MATIN1(B,20,MAX,0,1,C,NERR,DET)
      CALL MATIN1(B,20,MAX,0,1,IC,NERR,DET)                              
      IF(NERR.NE.0) GO TO 28                                            
      CALL UCOPY(B(1,MAX+1),A,MAX)                                      
      RETURN                                                            
   20 A(1)=B(1,2)/B(1,1)                                                
      RETURN                                                            
   24 MAX=0                                                             
      WRITE(   *,101)                                                   
      RETURN                                                            
   28 MAX=0                                                             
      WRITE(   *,102)                                                   
      RETURN                                                            
   32 MAX=0                                                             
      WRITE(   *,103)                                                   
      RETURN                                                            
   36 MAX=0                                                             
      WRITE(   *,104)                                                   
      RETURN                                                            
   40 MAX=0                                                             
      WRITE(   *,105)                                                   
      RETURN                                                            
  101 FORMAT('0ORDER GREATER THAN 20')                                  
  102 FORMAT('0ERROR DURING INVERSION')                                 
  103 FORMAT('0ORDER HIGHER THAN NUMBER OF POINTS')                     
  104 FORMAT('0ORDER LESS THAN 1')                                      
  105 FORMAT('0NUMBER OF POINTS LESS THAN 1')                           
      END                                                               
C                                                                       
      SUBROUTINE UZERO(A,J1,J2)                                         
C                                                                       
C     ******************************************************************
C     * SETS A(J1) TO A(J2) EQUAL TO ZERO.                             *
C     * CALLED BY LSQ.                                                 *
C     * WRITTEN BY DENNIS HEWETT AUG 82.                               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION A(*)                                                    
      DO 10 I=J1,J2                                                     
   10 A(I)=0.                                                           
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE UCOPY(A,X,N)                                           
C                                                                       
C     ******************************************************************
C     * COPIES N WORDS FROM A INTO X.                                  *
C     * CALLED BY LSQ.                                                 *
C     * WRITTEN BY DENNIS HEWETT AUG 82.                               *
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
      DIMENSION A(*), X(*)                                              
      DO 10 I=1,N                                                       
   10 X(I)=A(I)                                                         
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE MATIN1(A,IDIM1,N1,IDIM2,N2,INDEX,NERROR,DETERM)        
C                                                                       
C     ******************************************************************
C     * COMPUTES THE INVERSE OF A MATRIX A, ITS DETERMINANT D AND      *
C     * SOLVES A SYSTEM OF LINEAR EQUATIONS AX=B.                      *
C     * IT USES JORDAN'S METHOD WITH PARTIAL PIVOTING TO REDUCE THE    *
C     * MATRIX A TO THE IDENTITY MATRIX I THROUGH A SUCCESSION OF      *
C     * ELEMENTARY TRANSFORMATIONS:  L(N).L(N-1)....L(1).A=I.          *
C     * IF THESE TRANSFORMATIONS ARE SIMULTANEOUSLY APPLIED TO I AND A *
C     * MATRIX B OF CONSTANT VECTORS, THE RESULT IS AINVERSE AND X     *
C     * WHERE AX=B.                                                    *
C     * CALLING STATEMENT:                                             *
C     *    CALL MATIN1(E,NDIM,N,MDIM,M,INDEX,NERROR,DETERM),           *
C     * WHERE                                                          *
C     * E       IS A TWO DIMENSIONAL ARRAY WITH COLUMN LENGTH NDIM     *
C     *         CONTAINING THE MATRIX A OF ORDER N IN ITS FIRST N      *
C     *         COLUMNS. THE MATRIX OF CONSTANT VECTORS, B, IS STORED  *
C     *         IN COLUMNS N+1 THROUGH N+M OF E.                       *
C     * NDIM    IS THE FIRST DIMENSION PARAMETER OF E AS DECLARED IN   *
C     *         THE CALLING PROGRAM.                                   *
C     * N       IS THE ORDER OF MATRIX A.                              *
C     * MDIM    IS NOT USED (WAS USED IN PREVIOUS VERSIONS OF MATIN1). *
C     * M       IS THE NUMBER OF COLUMN VECTORS IN MATRIX B.           *
C     *         IF M=0 ONLY THE INVERSE OF A AND THE COMPUTATION OF    *
C     *         THE DETERMINANT IS CARRIED OUT.                        *
C     * INDEX   IS A ONE DIMENSIONAL ARRAY CONTAINING N LOCATIONS AND  *
C     *         IS USED FOR BOOK-KEEPING. THE SPACE FOR THIS ARRAY     *
C     *         MUST BE PROVIDED IN THE CALLING PROGRAM.               *
C     * NERROR  IS AN OUTPUT PARAMETER WHICH IS SET ON RETURN TO NON   *
C     *         ZERO, IF AT ELIMINATION STEP NERROR THE CORRESPONDING  *
C     *         COLUMN OF A CONTAINED ONLY ZEROS.                      *
C     * DETERM  IS A SINGLE PRECISION VARIABLE AND CONTAINS ON RETURN  *
C     *         THE DETERMINANT OF A.                                  *
C     * ON RETURN E WILL, IF NERROR=0, CONTAIN THE INVERSE OF A IN ITS *
C     * FIRST N COLUMNS AND IF M.NE.0 THE SOLUTION MATRIX X IN THE     *
C     * NEXT FOLLOWING N+1,...,N+M COLUMNS.                            *
C     * MATIN1 IS CALLED BY LSQ.                                       *
C     * COPIED BY RICARDO GALVAO FROM CERNLIB AT SARA AMSTERDAM DEC 80.*
C     ******************************************************************
c
      implicit double precision (a-h,o-z)
C                                                                       
C        MATRIX INVERSION WITH ACCOMPANYING SOLUTION OF LINEAR EQUATIONS
      DIMENSION A(IDIM1),INDEX(IDIM1)                                   
      DETER=1.0                                                         
      N=N1                                                              
      IEMAT=N+N2                                                        
      IDIM=IDIM1                                                        
      NMIN1=N-1                                                         
C        THE ROUTINE DOES ITS OWN EVALUATION FOR DOUBLE SUBSCRIPTING OF 
C        ARRAY A.                                                       
      IPIVC=1-IDIM                                                      
C        MAIN LOOP TO INVERT THE MATRIX                                 
      DO 11 MAIN=1,N                                                    
      PIVOT=0.0                                                         
      IPIVC=IPIVC+IDIM                                                  
C        SEARCH FOR NEXT PIVOT IN COLUMN MAIN.                          
      IPIVC1=IPIVC+MAIN-1                                               
      IPIVC2=IPIVC +NMIN1                                               
      DO 2 I=IPIVC1,IPIVC2                                              
      IF(ABS(A(I))-ABS(PIVOT)) 2,2,1                                    
    1 PIVOT=A(I)                                                        
      LPIV=I                                                            
    2 CONTINUE                                                          
C        IS PIVOT DIFFERENT FROM ZERO                                   
      IF(PIVOT) 3,15,3                                                  
C        GET THE PIVOT-LINE INDICATOR AND SWAP LINES IF NECESSARY       
    3 ICOL=LPIV-IPIVC+1                                                 
      INDEX(MAIN)=ICOL                                                  
      IF(ICOL-MAIN) 6,6,4                                               
C        COMPLEMENT THE DETERMINANT                                     
    4 DETER=-DETER                                                      
C        POINTER TO LINE PIVOT FOUND                                    
      ICOL=ICOL-IDIM                                                    
C        POINTER TO EXACT PIVOT LINE                                    
      I3=MAIN-IDIM                                                      
      DO 5 I=1,IEMAT                                                    
      ICOL=ICOL+IDIM                                                    
      I3=I3+IDIM                                                        
      SWAP=A(I3)                                                        
      A(I3)=A(ICOL)                                                     
    5 A(ICOL)=SWAP                                                      
C        COMPUTE DETERMINANT                                            
    6 DETER=DETER*PIVOT                                                 
      PIVOT=1./PIVOT                                                    
C        TRANSFORM PIVOT COLUMN                                         
      I3=IPIVC+NMIN1                                                    
      DO 7 I=IPIVC,I3                                                   
    7 A(I)=-A(I)*PIVOT                                                  
      A(IPIVC1)=PIVOT                                                   
C        PIVOT ELEMENT TRANSFORMED                                      
C                                                                       
C        NOW CONVERT REST OF THE MATRIX                                 
      I1=MAIN-IDIM                                                      
C        POINTER TO PIVOT LINE ELEMENTS                                 
      ICOL=1-IDIM                                                       
C        GENERAL COLUMN POINTER                                         
      DO 10 I=1,IEMAT                                                   
      ICOL=ICOL+IDIM                                                    
      I1=I1+IDIM                                                        
C        POINTERS MOVED                                                 
      IF(I-MAIN) 8,10,8                                                 
C        PIVOT COLUMN EXCLUDED                                          
    8 JCOL=ICOL+NMIN1                                                   
      SWAP=A(I1)                                                        
      I3=IPIVC-1                                                        
      DO 9 I2=ICOL,JCOL                                                 
      I3=I3+1                                                           
    9 A(I2)=A(I2)+SWAP*A(I3)                                            
      A(I1)=SWAP*PIVOT                                                  
   10 CONTINUE                                                          
   11 CONTINUE                                                          
C        NOW REARRANGE THE MATRIX TO GET RIGHT INVERS                   
      DO 14 I1=1,N                                                      
      MAIN=N+1-I1                                                       
      LPIV=INDEX(MAIN)                                                  
      IF(LPIV-MAIN) 12,14,12                                            
   12 ICOL=(LPIV-1)*IDIM+1                                              
      JCOL=ICOL+NMIN1                                                   
      IPIVC=(MAIN-1)*IDIM+1-ICOL                                        
      DO 13 I2=ICOL,JCOL                                                
      I3=I2+IPIVC                                                       
      SWAP=A(I2)                                                        
      A(I2)=A(I3)                                                       
   13 A(I3)=SWAP                                                        
   14 CONTINUE                                                          
      DETERM=DETER                                                      
      NERROR=0                                                          
      RETURN                                                            
   15 NERROR=MAIN                                                       
      DETERM=DETER                                                      
      RETURN                                                            
      END                                                               
