      SUBROUTINE PPP                                                    
C                                                                       
C***********************************************************************
C     Dummmy heading for the FORTRAN source of library PPPLIB. "PPP"   *
C stands for "Plasma Physics Plotting (Package)". It is derived from   *
C the similar plotting package P4, developed at Los Alamos Scinetific  *
C laboratory by Clair Nielson, Brendan Godfrey, Dennis Hewett, Deborah *
C Hyman, and Robert Malone, starting from basic LASL plotting routines *
C that were written by R.M. Frank, Gene Willbanks, and others (whose   *
C names we were not able to trace). The package was obtained in August *
C 1983 from Dennis Hewett. Hans Goedbloed (31/10/85) converted it into *
C standard FORTRAN 77, and replaced all holleriths, word lengths and   *
C octals by machine-independent integer representations; subroutines   *
C DPLOT/DASH to draw dashed curves were added on 28/01/86.             *
C                                                                      *
C     Version 10 (3/05/06) was documented extensively in Rijnhuizen    *
C Report 81-186 "Plasma Physics PLotting Library; FORTRAN 77 revision" *
C by Hans Goedbloed, Dick Hogewey and Dennis Hewett.                   *
C                                                                      *
C     Version 14 (11/07/91), Guido Huysmans:                           *
C added DRVCLIP in LPLOT to clip linepieces to fit in plotting window. *
C                                                                      *
C     Version 15 (11/11/91), Hans Goedbloed, Guido Huysmans and Egbert *
C Westerhof: separate branch creating laserwriter postscript files.    *
C                                                                      *
C     Version 16 (13/11/99), Hans Goedbloed:                           *
C plotting resolution increased with parameter KR(= 9);                *
C bounding boxes added for eps (encapsulated postscript) files;        *
C comments written on postscript file to facilitate editing.           *
C                                                                      *
C     Version 17 (15/12/99), Sander Belien:                            *
C added external references to common blocks for LHEAD and POS.        *
C                                                                      *
C     Version 20 (18/04/07), Jan-Willem Blokland and Hans Goedbloed:   *
C new date and time calls in DATI, modified character labels D*10/T*10 *
C in LBLTOP/BOT and NFRAME; everywhere implicit double precision and   *
C real numbers "0." replaced by "0.D+0", etc. in subroutine arguments, *
C all ALOG10/AMAX1/AMIN1 replaced by DLOG10/DMAX1/DMIN1.               *
C                                                                      *
C     Version 21 (19/07/07), Hans Goedbloed:                           *
C extended LPLOT and DPLOT with option LW to increase linewidth;       *
C extended NFRAME with option IMX=4,IMY=1 to plot square frames;       *
C removed definition /pt in BEGPLT causing change of linewidth;        *
C added subroutines DOTPLOT to plot shaded areas, and DCIRCXY/DLCHXY   *
C to draw circles or characters at positions given by X,Y.             *
C                                                                      *
C     Version 22 (24/07/07), Hans Goedbloed:                           *
C added color options to subroutines LPLOT/DPLOT/DCIRCXY/DLCHXY.       *
C                                                                      *
C     Version 23 (30/07/07), Hans Goedbloed:                           *
C eliminated redundant "high-level" routines LPLOT6, etc. and QCPLOT;  *
C eliminated obsolete lowest-level Calcomp routines (controlling the   *
C motion of a plotter pen) so that only the postscript branch remains; *
C improved character tables of DLCH and corrected DLCV;                *
C improved ARROW1/2, corrected P3PLOT;                                 *
C modified lowest subroutines DRP and DRWABS to yield visible points;  *
C added subroutines DR3/4/5/6.                                         *
C                                                                      *
C     Version 24 (10/08/07), Hans Goedbloed:                           *
C added clipping with DRVCLIP/DRPCLIP in PPLOT, DPLOT/DASH, DOTPLOT,   *
C and entries LPLOT2 and DPLOT2 to suppress vectors that do not lie    * 
C entirely inside the frame.                                           *
C                                                                      *
C     Version 25 (4/09/07), Hans Goedbloed:                            *
C corrected BEGPLT for bounding boxes, corrected DCIRCXY and DLCHXY,   *
C corrected NFRAME for labels with proportional fonts.                 *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      WRITE(*,10)                                                       
   10 FORMAT(/1X,'Library PPPLIB'/1X,'Version 25, d.d. 4/09/07')       
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE LPLOT(MX,MY,IOP,X,Y,NPTS,INC,                          
     A                 TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)          
C                                                                       
C***********************************************************************
C     THIS SUBROUTINE DRAWS A LINE PLOT OF THE NPTS VALUES IN X AND Y. *
C LPLOT DETERMINES THE RANGES OF X AND Y, SUBSEQUENTLY CALLS NFRAME TO *
C DRAW A BOX AROUND THE PLOT, TO SCALE THE X- AND Y-AXES, AND TO PLACE *
C A TITLE AND LABELS ALONG THE AXES, AND FINALLY PUTS THE CURVE ON THE *
C PLOT.  THIS SEQUENCE MAY BE SPLIT BY THE USE OF NEGATIVE VALUES OF   *
C THE ARGUMENTS IOP (TO SUPPRESS PLOTTING OF THE CURVE) AND NPTS (TO   *
C SUPPRESS PLOTTING OF THE FRAME AND SCALES).                          *
C                                                                      *
C     THE PLOT'S POSITION ON THE PAGE IS DETERMINED BY IMX,IMY.  IMY=1 *
C SPECIFIES THAT THE Y-COORDINATE RANGE SPANS A FULL PAGE; IMY=2 AND 3 *
C SPECIFY THE UPPER AND LOWER HALVES OF THE PAGE; AND IMY=4, 5, AND 6  *
C SPECIFY THE UPPER, MIDDLE, AND LOWER THIRDS OF THE PAGE.  IMX=1 SPE- *
C CIFIES THAT THE X-COORDINATE RANGE SPANS A FULL PAGE; IMX=2 AND 3    *
C SPECIFY THE LEFT AND RIGHT HALVES OF THE PAGE; WHILE IMX=4, 5, AND 6 *
C ARE NOT ALLOWED.                                                     *
C     FOR EXAMPLE, (IMX,IMY)=(1,1) SPECIFIES A PLOT FILLING THE FULL   *
C PAGE, AND (3,3) SPECIFIES A PLOT IN THE LOWER RIGHT-HAND QUADRANT.   *
C A MAXIMUM OF SIX PLOTS ON A PAGE IS POSSIBLE IF THE PAIRS (2,4),     *
C (3,4), (2,5), (3,5), (2,6), AND (3,6) ARE USED.  PAGE ADVANCE IS     *
C AUTOMATIC WITH THE FIRST PLOT THAT EXTENDS INTO THE UPPER LEFT-HAND  *
C CORNER OF THE PAGE.  SUCH A PLOT MUST BE THE FIRST IN ANY PLOT       *
C SEQUENCE INTENDED TO APPEAR ON ONE PAGE.                             *
C                                                                      *
C     THE PLOT'S RANGE USUALLY IS EXPANDED TO A "ROUND" DECIMAL NUMBER *
C BY THE AUTOMATIC SCALING ROUTINES FROM THE MINIMUM RANGE IMPLIED BY  *
C THE DATA.  EXPANSION MAY BE PREVENTED BY APPENDING A '1' IN FRONT OF *
C THE IMX AND IMY VALUES IN ANY PLOT CALL (I.E., ISX=1).  FOR EXAMPLE, *
C IF XMIN=0.17, XMAX=359.78, AND ISX=0 FOR AUTOMATIC SCALING, THE X-   *
C SCALE GOES FROM 0.0 TO 400.0.  NOW, IF XMIN AND XMAX STAY THE SAME   *
C AND ISX=1 FOR EXACT SCALING, THE X-SCALE GOES FROM 0.0 TO 360.0.     *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX     - DEFINES THE GRAPH AREA AND THE SCALING IN THE X-DIRECTION   *
C          ACCORDING TO THE FORMULA                                    *
C             IABS(MX) = IIX*1000 + IAX*100 + ISX*10 + IMX ,           *
C          WHERE IMX DETERMINES THE HORIZONTAL EXTENSION OF THE PLOT:  *
C             IMX = 1 - FULL PAGE                                      *
C                   2 - LEFT HALF OF THE PAGE                          *
C                   3 - RIGHT HALF OF THE PAGE,                        *
C          AND ISX DETERMINES THE SCALING ALONG THE X-AXIS:            *
C             ISX = 0 - AUTOMATIC SCALING WITH EXPANSION (DEFAULT)     *
C                   1 - EXACT SCALING (NO ROUNDING)                    *
C                   2 - EQUIDISTANT SCALING WITH THE X-SCALE ADAPTED   *
C                       TO THE LENGTHS ALONG Y (SEE NOTE IN NFRAME),   *
C          AND IAX PROVIDES AN ADDITIONAL OPTION:                      *
C             IAX = 0 - NO ACTION (DEFAULT)                            *
C                   1 - X=0 AXIS IS DRAWN  (IF IT LIES IN THE RANGE)   *
C                   2 - X=0 AXIS IS DASHED (IF IT LIES IN THE RANGE),  *
C          AND IIX OVERRULES THE DEFAULT NUMBER OF SCALE INTERVALS:    *
C             IIX = 0 - 4 INTERVALS FOR SCALES AND TICKMARKS (DEFAULT) *
C             IIX > 0 - IIX INTERVALS (NOT FOR AUTOMATIC SCALING).     *
C          MX < 0 : PLOTTING OF SCALES AND TICK MARKS SUPPRESSED.      *
C MY     - DEFINES THE GRAPH AREA AND THE SCALING IN THE Y-DIRECTION,  *
C          ANALOGOUS TO THE ABOVE EXPRESSIONS WITH X REPLACED BY Y,    *
C          WHERE IMY DETERMINES THE VERTICAL EXTENSION OF THE PLOT:    *
C             IMY = 1 - FULL PAGE                                      *
C                   2 - TOP HALF OF THE PAGE                           *
C                   3 - BOTTOM HALF OF THE PAGE                        *
C                   4 - TOP THIRD OF THE PAGE                          *
C                   5 - MIDDLE THIRD OF THE PAGE                       *
C                   6 - BOTTOM THIRD OF THE PAGE.                      *
C IOP    - PROVIDES DIFFERENT OPTIONS FOR THE X-Y SCALES, THE SYMBOLS  *
C          PLOTTED, AND THE CURVE DRAWN, ACCORDING TO THE FORMULA      *
C             IABS(IOP) = N*10000 + IC*10 + JOP,                       *
C          WHERE JOP DETERMINES THE SCALES ALONG THE X- AND Y-AXES:    *
C             JOP = 1 - LINEAR X-AXIS, LINEAR Y-AXIS                   *
C                   2 - LINEAR X-AXIS, LOG Y-AXIS                      *
C                   3 - LOG X-AXIS, LINEAR Y-AXIS                      *
C                   4 - LOG X-AXIS, LOG Y-AXIS                         *
C                   5 - LINEAR X-AXIS, LINEAR Y-AXIS (BUT PLOTTING OF  *
C                       FRAME, SCALES, AND TICK MARKS SUPPRESSED),     *
C          AND IC INDICATES THE ASCII CHARACTER TO BE PLACED AT THE    *
C          POINTS:                                                     *
C             IC = 0 (DEFAULT) - NO CHARACTER PLACED                   *
C             32 (192) <= IC <= 126 (254)                              *
C                              - CHARACTER FROM TABLE OF DLCH,         *
C          AND N DETERMINES THE SPACING BETWEEN THE PLOTTED CHARACTERS *
C          AND WHETHER A CURVE IS TO BE DRAWN THROUGH THEM:            *
C             N = 0 (DEFAULT) - SYMBOL SPECIFIED BY IC PLACED AT EACH  *
C                               POINT; THE POINTS ARE NOT CONNECTED    *
C             N > 0           - A SYMBOL PLACED AT EVERY N'TH POINT;   *
C                               ALL POINTS ARE CONNECTED BY A CURVE.   *
C          IOP < 0: THE FRAME IS DRAWN AND THE AXES ARE SCALED, BUT    *
C          THE CURVE IS NOT DRAWN.  THIS AMOUNTS TO JUST A CALL OF     *
C          NFRAME WITH AUTOMATIC DETERMINATION OF THE EXTREME VALUES   *
C          OF X AND Y BY LPLOT.  (IF THESE VALUES ARE ALREADY KNOWN,   *
C          IT IS MORE EFFICIENT TO CALL NFRAME DIRECTLY).              *
C X      - THE TABLE OF ABSCISSA VALUES TO BE PLOTTED.                 *
C Y      - THE TABLE OF ORDINATE VALUES TO BE PLOTTED.                 *
C NPTS   - IABS(NPTS) IS THE NUMBER OF X/Y ELEMENTS.                   *
C          NPTS < 0: A CURVE IS DRAWN ONTO A FRAME PREVIOUSLY SET UP   *
C          BY A CALL TO NFRAME OR LPLOT WITH IOP < 0.                  *
C INC    - Defines the spacing between elements plotted and linewidth  *
C          and color of the curves according to                        *
C             IABS(INC) = LW*1000 + ICOL*100 + INCA,                   *
C          where LW is the linewidth, ICOL indicates the color and     *
C          INCA is the increment of the curve.                         *
C          max(LW) = 99, max(ICOL) = 9, max(INCA) = 99.                *
C          INC < 0: THE Y-ELEMENTS PLOTTED ARE PAIRED WITH ABSCISSA    *
C          VALUES DETERMINED BY THE TWO VALUES XMIN=X(1) AND DX=X(2),  *
C          WHICH THE USER SHOULD INSERT IN X.                          *
C TITLE  - TITLE FOR THE GRAPH.                                        *
C NTITLE - THE NUMBER OF CHARACTERS IN NTITLE.                         *
C XNAME  - LABEL FOR THE X-AXIS.                                       *
C NXNAME - NUMBER OF CHARACTERS IN XNAME.                              *
C YNAME  - LABEL FOR THE Y-AXIS.                                       *
C NYNAME - NUMBER OF CHARACTERS IN YNAME.                              *
C          THE ABOVE THREE CHARACTER STRINGS ARE AUTOMATICALLY TRUN-   *
C          CATED TO FIT ALONGSIDE THE CHOSEN FRAME.  THE FONT CAN BE   *
C          CHANGED ACCORDING TO THE RULES GIVEN IN DLCH.               *
C                                                                      *
C     ENTRY HPLOT DRAWS A HISTOGRAM OF THE VALUES IN X AND Y.          *
C THE ARGUMENTS ARE THE SAME AS FOR LPLOT.                             *
C                                                                      *
C     Entry LPLOT2 draws a line plot with NCLIP=2, i.e. all vectors    *
C that do not fall entirely within the frame are omitted. Typical use: *
C functions of X, Y that are not defined on ranges that are not known  *
C beforehand; in that case, X or Y should be initialized to values     *
C outside the frame so that only the defined values X, Y are plotted.  *
C The arguments are the same as for LPLOT (for which NCLIP=1).         *
C     NCLIP=1: omit vectors that lie entirely outside the frame,       *
C     NCLIP=2: omit vectors that do not lie entirely inside the frame. *
C                                                                      *
C     WRITTEN BY CLAIR NIELSON.                                        *
C     MODIFIED BY DENNIS HEWETT 2-78, FOR RANGE PRINTED ON TOP RIGHT.  *
C     MODIFIED BY BOB MALONE 3-78, FOR CHARACTERS ON THE CURVE.        *
C     MODIFIED BY DEBBY HYMAN 4-80, FOR INCREMENTATION TO WORK,        *
C     FOR RNG TO BE PRINTED ONLY WHEN VERY SMALL.                      *
C     MODIFIED BY HANS GOEDBLOED 14/11/85, FOR ADAPTATION TO NEW DLCH, *
C     SHIFT OF THE TITLE WHEN RNG IS PRINTED.                          *
C     MODIFIED BY GUIDO HUYSMANS 1/07/89, FOR CLIPPING LINES TO FIT    *
C     THE FRAME.                                                       *
C     MODIFIED BY RONALD VAN DER LINDEN 6/90, TO MAKE IT POSSIBLE      *
C     TO HAVE 100 INSTEAD OF 10 DATA POINTS BETWEEN PRINTED SYMBOLS.   *
c     Modified to admit different linewidths of plots, jpg 17/07/07.   *
c     Added entry LPLOT2 to clip lines outside frame, jpg 10/08/07.    *
C***********************************************************************
c                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
c                                                                       
c     * plotting resolution increased KR times (keeping I4 x I4 format  
c     * for the postscript coordinates: KR can be at most 9).           
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION X(*),Y(*)
      INTEGER C1,C2                                               
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
      CHARACTER TITLE1*80,RANGE*14                                      
      LOGICAL FHIST,FLOGX,FLOGY,FCONN,FCHAR                             
C                                                                       
C     * DEFAULT CLIPPING.                                             
      NCLIP = 1                                                     
C                                                                       
C     * DEFAULT NO HISTOGRAM.                                             
   10 FHIST=.FALSE.                                                     
C
   20 IOPA=IABS(IOP)                                                    
      JOP=MOD(IOPA,10)                                                  
      FLOGX=.FALSE.                                                     
      FLOGY=.FALSE.                                                     
      IF(JOP.EQ.3.OR.JOP.EQ.4) FLOGX=.TRUE.                             
      IF(JOP.EQ.2.OR.JOP.EQ.4) FLOGY=.TRUE.                             
      NTOT=IABS(NPTS)                                                   
c                                                                       
c     * modified for changing linewidth and color                       
      INCA = MOD(IABS(INC),100)                                         
      ICOL = MOD(IABS(INC)/100,10)                                      
      LW   = MOD(IABS(INC)/1000,100)                                    
C                                                                       
C     * SCHEME FOR CHARACTERS ON THE CURVE BY BOB MALONE, 3/78          
C     * SET DEFAULTS FOR OPERATION WITHOUT CHARACTERS ON CURVES.        
      FCONN=.TRUE.                                                      
      FCHAR=.FALSE.                                                     
      N=1                                                               
C                                                                       
C     * DETERMINE WHETHER CHARACTERS ARE DESIRED.                       
      IC=MOD(IOPA/10,1000)                                              
      IF(IC.NE.0) THEN                                                  
         FCHAR=.TRUE.                                                   
         N=MOD(IOPA/10000,100)                                          
         IF(N.EQ.0) THEN                                                
            FCONN=.FALSE.                                               
            N=1                                                         
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C     * DRAW THE FRAME.                                                 
      IF(NPTS.GT.0) THEN                                                
         IF(INC.LT.0) THEN                                              
            XMN=X(1)                                                    
            XMX=X(1)+(NTOT-1)*X(2)/INCA                                 
         ELSE                                                           
            CALL MAXV(X,NTOT,INCA,XMX,IDUM)                             
            CALL MINV(X,NTOT,INCA,XMN,IDUM)                             
         ENDIF                                                          
         CALL MAXV(Y,NTOT,INCA,YMX,IDUM)                                
         CALL MINV(Y,NTOT,INCA,YMN,IDUM)                                
         NB=0                                                           
         RNG=ABS(YMX-YMN)                                               
         IF(RNG.LT.(.02*ABS(YMX))) THEN                                 
            WRITE(RANGE,'(''RNG ='',1PE9.2)') RNG                       
            NB=10                                                       
         ENDIF                                                          
         TITLE1=TITLE                                                   
         NTITL1=ISIGN(MIN(IABS(NTITLE)+NB,80),NTITLE)                   
         CALL NFRAME(MX,MY,JOP,XMN,XMX,YMN,YMX,                         
     A               TITLE1,NTITL1,XNAME,NXNAME,YNAME,NYNAME)           
         IF(NB.NE.0) CALL DLCH(IXR-120*KR,IYT+8*KR,RANGE,14,1)          
         IF(IOP.LT.0) RETURN                                            
      ELSE                                                              
         CALL OFRAME(MX,MY)                                             
      ENDIF                                                             
C                                                                       
C     * DRAW THE CURVE.                                                 
c     * postscript comment                                              
      WRITE(IPS,'(/A22/)') '%%%%Curve (from LPLOT)'                     
c                                                                       
c     * change linewidth and color                                      
      IF(LW.EQ.0) LW = 9                                                
      CALL LWCOL(LW,ICOL)                                               
c                                                                       
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      HX=0.                                                             
      IF(INC.LT.0) HX=X(2)                                              
      XJS=X(1)                                                          
      XJ=XJS                                                            
      IF(FLOGX) XJ=ALOG19(XJ)                                           
      IX1=IXL+INT((XJ-XL)*XFAC)                                         
      YJ=Y(1)                                                           
      IF(FLOGY) YJ=ALOG19(YJ)                                           
      IY1=IYB+INT((YJ-YB)*YFAC)                                         
      IF(FHIST) CALL DRV(IX1,IYB,IX1,IY1)                               
      IF(FCHAR.AND.N.EQ.1) CALL DLCH(IX1,-IY1,' ',IC,1)                 
      DO 30 J=1+INCA,NTOT,INCA                                          
         XJS=XJS+HX                                                     
         IF(INC.GT.0) XJS=X(J)                                          
         XJ=XJS                                                         
         IF(FLOGX) XJ=ALOG19(XJ)                                        
         IX=IXL+INT((XJ-XL)*XFAC)                                       
         YJ=Y(J)                                                        
         IF(FLOGY) YJ=ALOG19(YJ)                                        
         IY=IYB+INT((YJ-YB)*YFAC)                                       
         IF(FHIST) THEN                                                 
C           * HISTOGRAM DRAWN BY THESE CALLS TO DRV.                    
            CALL DRV(IX1,IY1,IX,IY1)                                    
            CALL DRV(IX,IY1,IX,IY)                                      
         ELSE                                                           
            IF(FCONN) THEN                                              
               IDX1=IX1                                                 
               IDY1=IY1                                                 
               IDX=IX                                                   
               IDY=IY                                                   
               IF(NCLIP.EQ.1) CALL DRVCLIP(IDX1,IDY1,IDX,IDY)                            
               IF(NCLIP.EQ.2) THEN
                  CALL CODE(IX1,IY1,C1)                                             
                  CALL CODE(IX,IY,C2)
                  IF(C1.EQ.1.AND.C2.EQ.1) 
     &               CALL DRVCLIP(IDX1,IDY1,IDX,IDY)
               ENDIF
            ENDIF                                                       
            IF(FCHAR.AND.MOD(J,N).EQ.0) THEN                            
               IF((IX.GT.IXL.AND.IX.LT.IXR).AND.                        
     A            (IY.GT.IYB.AND.IY.LT.IYT))                            
     B         CALL DLCH(IX,-IY,' ',IC,1)                               
            ENDIF                                                       
         ENDIF                                                          
         IX1=IX                                                         
         IY1=IY                                                         
   30 CONTINUE                                                          
c                                                                       
c     * restore linewidth and color                                     
      WRITE(IPS,'(/a11)') 'st grestore'                                 
c                                                                       
      RETURN                                                            
C                                                                       
C     * Entry for plots with NCLIP=2 clipping.                                  
      ENTRY LPLOT2(MX,MY,IOP,X,Y,NPTS,INC,                               
     A             TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)               
C                                                                       
      NCLIP = 2                                                     
      GOTO 10                                                           
C                                                                       
C     * ENTRY FOR DRAWING A HISTOGRAM.                                  
      ENTRY HPLOT(MX,MY,IOP,X,Y,NPTS,INC,                               
     A            TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)               
C                                                                       
      FHIST=.TRUE.                                                      
      GOTO 20                                                           
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE DRVCLIP(IX1,IY1,IX2,IY2)                                  
C                                                                       
C***********************************************************************
C     SUBROUTINE TO CLIP LINEPIECE TO FIT WITHIN PLOTTING BOUNDARIES   *
C (SOURCE: INTERACTIVE GRAPHICS, P.8866).                              *
C                                                                      *
C     ADDED BY GUIDO HUYSMANS 11/07/91.                                *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      INTEGER C,C1,C2                                                   
C                                                                       
      CALL CODE(IX1,IY1,C1)                                             
      CALL CODE(IX2,IY2,C2)
C
   10 IF((C1.GT.1).OR.(C2.GT.1)) THEN                                   
         IF(MOD(44100/(C1*C2),210).NE.0) RETURN                         
         C = C1                                                         
         IF(C.LE.1) C = C2                                              
         IF(MOD(C,5).EQ.0) THEN                                         
            IY = IY1 + (IY2-IY1)*(IXL-IX1)/(IX2-IX1)                    
            IX = IXL                                                    
         ELSE                                                           
            IF(MOD(C,7).EQ.0) THEN                                      
               IY = IY1 + (IY2-IY1)*(IXR-IX1)/(IX2-IX1)                 
               IX = IXR                                                 
            ELSE                                                        
               IF(MOD(C,3).EQ.0) THEN                                   
                  IX = IX1 + (IX2-IX1)*(IYB-IY1)/(IY2-IY1)              
                  IY = IYB                                              
               ELSE                                                     
                  IF(MOD(C,2).EQ.0) THEN                                
                     IX = IX1 + (IX2-IX1)*(IYT-IY1)/(IY2-IY1)           
                     IY = IYT                                           
                  ENDIF                                                 
               ENDIF                                                    
            ENDIF                                                       
         ENDIF                                                          
         IF(C.EQ.C1) THEN                                               
            IX1 = IX                                                    
            IY1 = IY                                                    
            CALL CODE(IX,IY,C1)                                         
         ELSE                                                           
            IX2 = IX                                                    
            IY2 = IY                                                    
            CALL CODE(IX,IY,C2)                                         
         ENDIF                                                          
         GOTO 10                                                        
      ENDIF                                                             
      CALL DRV(IX1,IY1,IX2,IY2)                                         
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DRPCLIP(IX,IY)                                  
C                                                                       
C***********************************************************************
C     SUBROUTINE CALLING DRP IF POINT FITS INSIDE PLOTTING BOUNDARIES. *
C                                                                      *
C     Added by Hans Goedbloed 10/08/07.                                *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      INTEGER C                                                   
C                                                                       
      CALL CODE(IX,IY,C)                                                                                                         
      IF(C.EQ.1) CALL DRP(IX,IY)                                         
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE CODE(IX,IY,C)                                          
C                                                                       
C***********************************************************************
C     SUBROUTINE TO COMPUTE POSITION OF PLOTTING POINT WITH RESPECT TO *
C PLOTTING BOUNDARIES (C=1 IF INSIDE); CALLED BY DRVCLIP AND DRPCLIP.  *
C                                                                      *
C     ADDED BY GUIDO HUYSMANS 11/07/91.                                *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      INTEGER C                                                         
C                                                                       
      C = 1                                                             
      IF(IX.LT.IXL) THEN                                                
         C = 5*C                                                        
      ELSE                                                              
         IF(IX.GT.IXR) C = 7*C                                          
      ENDIF                                                             
      IF(IY.LT.IYB) THEN                                                
         C = 3*C                                                        
      ELSE                                                              
         IF(IY.GT.IYT) C = 2*C                                          
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE PPLOT(MX,MY,X,Y,NPTS,INC)                              
C                                                                       
C***********************************************************************
C     SUBROUTINE PPLOT PLOTS THE VALUES IN X AND Y.  EACH POINT IS RE- *
C PRESENTED BY A PLOTTING DOT, AND ADJACENT POINTS ARE NOT CONNECTED.  *
C ENTRY PPLOTC PROVIDES A CONDITIONAL POINT PLOT OF THOSE POINTS FOR   *
C WHICH THE Z VALUE SATISFIES ZMIN < Z < ZMAX.  THE ROUTINES HAVE BEEN *
C OPTIMIZED TO PLOT MANY PARTICLES AS DOTS.                            *
C     BOTH SUBROUTINES ASSUME THAT THE FRAME, SCALE, AND LABELS FOR    *
C THIS (IMX,IMY) PLOT HAVE BEEN GENERATED BY A PREVIOUS CALL OF LPLOT  *
C WITH IOP = -1 OR A DIRECT CALL OF NFRAME.  ONLY LINEAR-LINEAR SCA-   *
C LING IS ALLOWED.  IF PPLOT IS CALLED WITHOUT A PRECEDING LPLOT CALL, *
C IT WILL USE THE SCALING LEFT IN COMMON BLOCK CJE07 FOR THAT FRAME.   *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY - SEE LPLOT.                                                   *
C X     - THE TABLE OF ABSCISSA VALUES.                                *
C Y     - THE TABLE OF ORDINATE VALUES.                                *
C NPTS  - THE NUMBER OF ELEMENTS IN THE ARRAYS X, Y, AND Z.            *
C INC   - Defines the spacing between elements plotted and linewidth   *
C         and color of the curves according to                         *
C             IABS(INC) = LW*1000 + ICOL*100 + INCA,                   *
C         where LW is the linewidth, ICOL indicates the color and      *
C         INCA is the increment of the curve.                          *
C         max(LW) = 99, max(ICOL) = 9, max(INCA) = 99.                 *
C                                                                      *
C     ADDITIONAL ARGUMENTS FOR PPLOTC:                                 *
C                                                                      *
C Z     - A FUNCTION OF X AND Y.                                       *
C ZMIN  - THE SMALLEST VALUE TO BE PLOTTED.                            *
C ZMAX  - THE LARGEST VALUE TO BE PLOTTED.                             *
C                                                                      *
C     WRITTEN BY CLAIR NIELSON.                                        *
C     Modified for linewidth and color of points, jpg 26/07/07.        *
c     Modified for clipping with DRPCLIP, jpg 10/08/07.                *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION X(*),Y(*),Z(*)                                          
C                                                                       
c     * modified for changing linewidth and color                       
      INCA = MOD(IABS(INC),100)                                         
      ICOL = MOD(IABS(INC)/100,10)                                      
      LW   = MOD(IABS(INC)/1000,100)                                    
C                                                                       
      CALL OFRAME(MX,MY)                                                
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A23/)') '%%%%Points (from PPLOT)'                    
c                                                                       
c     * change linewidth and color                                      
      IF(LW.EQ.0) LW = 9                                                
      CALL LWCOL(LW,ICOL)                                               
C                                                                       
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      DO 10 J=1,NPTS,INCA                                               
         IX=IXL+INT((X(J)-XL)*XFAC)                   
         IY=IYB+INT((Y(J)-YB)*YFAC)                   
         CALL DRPCLIP(IX,IY)                                                
   10 CONTINUE                                                          
c                                                                       
c     * restore linewidth and color                                     
      WRITE(IPS,'(/a11)') 'st grestore'                                 
C                                                                       
      RETURN                                                            
C                                                                       
C     * ENTRY FOR CONDITIONAL POINT PLOT.                               
      ENTRY PPLOTC(MX,MY,X,Y,NPTS,INC,Z,ZMIN,ZMAX)                      
c                                                                       
c     * modified for changing linewidth and color                       
      INCA = MOD(IABS(INC),100)                                         
      ICOL = MOD(IABS(INC)/100,10)                                      
      LW   = MOD(IABS(INC)/1000,100)                                    
C                                                                       
      CALL OFRAME(MX,MY)                                                
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A24/)') '%%%%Points (from PPLOTC)'                   
c                                                                       
c     * change linewidth and color                                      
      IF(LW.EQ.0) LW = 9                                                
      CALL LWCOL(LW,ICOL)                                               
C                                                                       
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      DO 20 J=1,NPTS,INCA                                               
         IF(Z(J).LT.ZMIN) GOTO 20                                       
         IF(Z(J).GT.ZMAX) GOTO 20                                       
         IX=IXL+INT((X(J)-XL)*XFAC)                   
         IY=IYB+INT((Y(J)-YB)*YFAC)                   
         CALL DRPCLIP(IX,IY)                                                
   20 CONTINUE                                                          
c                                                                       
c     * restore linewidth and color                                     
      WRITE(IPS,'(/a11)') 'st grestore'                                 
C                                                                       
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE DPLOT(MX,MY,X,Y,NPTS,INC,L1,L2)                        
C                                                                       
C***********************************************************************
C     DPLOT DRAWS A DASHED OR DOTTED CURVE THROUGH THE POINTS          *
C                   X(I),Y(I), I=1,NPTS,INC,                           *
C WHERE L1 AND L2 ARE THE LENGTHS OF THE STROKES AND SPACES OF THE     *
C LINE.  E.G., IF L1=0, A DOTTED CURVE IS PRODUCED WITH DISTANCES L2   *
C BETWEEN THE DOTS.  IF L2=0 THE CURVE IS FULLY DRAWN (OF COURSE, ONE  *
C SHOULD NOT USE DPLOT BUT LPLOT IN THAT CASE).                        *
C     THIS SUBROUTINE ASSUMES A PREVIOUS CALL OF NFRAME OR LPLOT WITH  *
C IOP = -1 TO SET UP THE FRAME AND SCALING.                            *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY - SEE LPLOT.                                                   *
C X     - THE TABLE OF ABSCISSA VALUES.                                *
C Y     - THE TABLE OF ORDINATE VALUES.                                *
C NPTS  - THE NUMBER OF ELEMENTS IN THE ARRAYS X AND Y.                *
C INC    - Defines the spacing between elements plotted and linewidth  *
C          and color of the curves according to                        *
C             IABS(INC) = LW*1000 + ICOL*100 + INCA,                   *
C          where LW is the linewidth, ICOL indicates the color and     *
C          INCA is the increment of the curve.                         *
C          max(LW) = 99, max(ICOL) = 9, max(INCA) = 99.                *
C L1    - LENGTH OF THE STROKES IN PLOTTING COORDINATES.               *
C L2    - LENGTH OF THE SPACES IN PLOTTING COORDINATES.                *
C                                                                      *
C     ENTRY DPLOT2 draws a dashed curve  with NCLIP=2, i.e. all dashes *
C that do not fall entirely within the frame are omitted. Typical use: *
C functions of X, Y that are not defined on ranges that are not known  *
C beforehand; in that case, X or Y should be initialized to values     *
C outside the frame so that only the defined values X, Y are plotted.  *
C The arguments are the same as for DPLOT (for which NCLIP=1).         *
C     NCLIP=1: omit dashes that lie entirely outside the frame,        *
C     NCLIP=2: omit dashes that do not lie entirely inside the frame.  *
C                                                                      *
C     WRITTEN BY HANS GOEDBLOED 28/01/86.                              *
c     Modified to admit different linewidths of plots, jpg 17/07/07.   *
c     Added entry DPLOT2 to clip dashes outside frame, jpg 10/08/07.   *
C***********************************************************************
c                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION X(*),Y(*)                                               
      INTEGER C1,C2                                                   
c                                                                       
      NCLIP = 1
c
c     * modified for changing linewidth and color                       
   10 INCA = MOD(IABS(INC),100)                                         
      ICOL = MOD(IABS(INC)/100,10)                                      
      LW   = MOD(IABS(INC)/1000,100)                                    
C                                                                       
      CALL OFRAME(MX,MY)                                                
c                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A22/)') '%%%%Curve (from DPLOT)'                     
c                                                                       
c     * change linewidth and color                                      
      IF(LW.EQ.0) LW = 9                                                
      CALL LWCOL(LW,ICOL)                                               
c                                                                       
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      IX1=IXL+INT((X(1)-XL)*XFAC)                     
      IY1=IYB+INT((Y(1)-YB)*YFAC)                     
      L=0                                                               
      DO 20 J=1+INCA,NPTS,INCA                                          
         IX=IXL+INT((X(J)-XL)*XFAC)                   
         IY=IYB+INT((Y(J)-YB)*YFAC)                   
         IF(NCLIP.EQ.1) CALL DASH(IX1,IY1,IX,IY,L1,L2,L,LL)
         IF(NCLIP.EQ.2) THEN
            CALL CODE(IX1,IY1,C1)                                             
            CALL CODE(IX,IY,C2)
            IF(C1.EQ.1.AND.C2.EQ.1) CALL DASH(IX1,IY1,IX,IY,L1,L2,L,LL)
         ENDIF
         L=LL                                                           
         IX1=IX                                                         
         IY1=IY                                                         
   20 CONTINUE                                                          
c                                                                       
c     * restore linewidth and color                                     
      WRITE(IPS,'(/a11)') 'st grestore'                                 
c                                                                       
      RETURN                                                            
C                                                                       
C     * ENTRY FOR PLOTS WITH NCLIP=2 CLIPPING.                                  
      ENTRY DPLOT2(MX,MY,X,Y,NPTS,INC,L1,L2) 
C                                                                       
      NCLIP = 2                                                     
      GOTO 10                                                           
C
      END                                                               
C                                                                       
      SUBROUTINE DASH(IX1,IY1,IX2,IY2,L1,L2,L,LL)                       
C                                                                       
C***********************************************************************
C     THIS ROUTINE DRAWS A DASHED LINE FROM (IX1,IY1) TO (IX2,IY2).    *
C THE ARGUMENTS L1 AND L2 ARE THE LENGTHS IN PLOTTING COORDINATES OF   *
C THE STROKES AND SPACES OF THE LINE, RESP.  L IS THE INITIAL POSITION *
C (INPUT) AND LL IS THE FINAL POSITION (OUTPUT) OF THE POINTER ON THE  *
C PLOTTING STRIP (0,L1+L2).                                            *
C                                                                      *
C     WRITTEN BY HANS GOEDBLOED 28/01/86.                              *
C     Added clipping with DRVCLIP/DRPCLIP, jpg 10/08/07.               *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C
      LLL=L                                                              
      R=SQRT(REAL((IX2-IX1)**2+(IY2-IY1)**2))                           
      IF(R.NE.0.) THEN                                                  
         XFAC=(IX2-IX1)/R                                               
         YFAC=(IY2-IY1)/R                                               
      ELSE                                                              
         XFAC=1.                                                        
         YFAC=1.                                                        
      ENDIF                                                             
      IR=INT(R)                                                         
      LTOT=0                                                            
      DX=0.                                                             
      DY=0.                                                             
      IXS=IX1                                                            
      IYS=IY1                                                            
      IX =IXS                                                            
      IY =IYS                                                            
   10 IF(LLL.EQ.0.AND.L1.EQ.0) CALL DRPCLIP(IX,IY)
      IF(LLL.LT.L1) THEN                                                 
         L11=MIN(L1-LLL,IR-LTOT)                                         
         DX=DX+L11*XFAC                                                 
         DY=DY+L11*YFAC                                                 
         IX=IX1+DX                                                      
         IY=IY1+DY                                                      
         IF(L1.NE.0) THEN
            IDXS=IXS                                                            
            IDYS=IYS                                                            
            IDX =IX                                                            
            IDY =IY                                                            
            CALL DRVCLIP(IDXS,IDYS,IDX,IDY)                                 
         ENDIF
         IF(L1.EQ.0) CALL DRPCLIP(IX,IY)                                    
         LTOT=LTOT+L11                                                  
         LLL=LLL+L11                                                      
      ELSE                                                              
         L22=MIN(L1+L2-LLL,IR-LTOT)                                      
         DX=DX+L22*XFAC                                                 
         DY=DY+L22*YFAC                                                 
         IXS=IX1+DX                                                      
         IYS=IY1+DY                                                      
         LTOT=LTOT+L22                                                  
         LLL=LLL+L22                                                      
         IF(LLL.GE.L1+L2) LLL=0                                           
      ENDIF                                                             
      IF(LTOT.LT.IR) GOTO 10                                            
      LL=LLL
C                                                                       
      RETURN                                                            
      END                                                               
c                                                                       
      SUBROUTINE DCIRCXY(X,Y,IRADIUS,LW,ICOL)                           
C                                                                       
C***********************************************************************
C     THIS ROUTINE DRAWS A CIRCLE AT POSITION X,Y, OF SIZE IRADIUS (IN *
C PLOTTING UNITS), WITH LINEWIDTH GIVEN BT LW AND COLOR BY ICOL.       *
C                                                                      *
C     Written by Hans Goedbloed 19/07/07, modified for color 23/07/07; *
C     corrected for differences of x/y length scales and for restoring *
C     postscript settings, extended permitted plotting area, 4/09/07.  *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION XX(40),YY(40)                                           
c                                                                       
      XFAC = (IXR-IXL)/(XR-XL)                                          
      YFAC = (IYT-IYB)/(YT-YB)                                          
      IX = IXL+INT((X-XL)*XFAC)                                         
      IY = IYB+INT((Y-YB)*YFAC)                                         
c                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A24)') '%%%%Circle (from dircxy)'                    
c                                                                       
c     * permit plotting slightly outside frame (including label areas) 
      IL = IXL - 65*KR
      IR = IXR + 18*KR
      IB = IYB - 77*KR
      IT = IYT + 44*KR
      IF(.NOT.((IX.GE.IL.AND.IX.LE.IR).AND.(IY.GE.IB.AND.IY.LE.IT)))
     >   GOTO 100                                                         
c                                                                       
c     * change linewidth and color                                      
      IF(LW.EQ.0) LW = 9                                                
      CALL LWCOL(LW,ICOL)                                               
C                                                                       
      R = FLOAT(IRADIUS)/XFAC                                           
      XX0 = X + R                                                       
      YY0 = Y                                                           
      IX0 = IXL+INT((XX0-XL)*XFAC)                                      
      IY0 = IYB+INT((YY0-YB)*YFAC)                                      
      PI=3.1415926535898                                                
      DO 10 I = 1, 40                                                   
         TH = FLOAT(I)*PI/20.                                           
         XX(I) = X+R*COS(TH)                                            
         YY(I) = Y+R*SIN(TH)*XFAC/YFAC                                             
         IX = IXL+INT((XX(I)-XL)*XFAC)                                  
         IY = IYB+INT((YY(I)-YB)*YFAC)                                  
         CALL DRV(IX0,IY0,IX,IY)                                        
         IX0 = IX                                                       
         IY0 = IY                                                       
   10 CONTINUE                                                          
c                                                                       
c     * restore linewidth and color                                     
  100 WRITE(IPS,'(/a11)') 'st grestore'                                 
c                                                                       
      RETURN                                                            
      END                                                               
c                                                                       
      SUBROUTINE DLCHXY(X,Y,STRING,NC,ISIZE,ICOL)                       
C                                                                       
C***********************************************************************
C     THIS ROUTINE PRINTS ARBITRARILY LARGE CHARACTERS ON THE GRAPHICS *
C FILE AT POSITION X,Y, WHICH IS CONVERTED INTO PLOTTING UNITS IX,IY,  *
C AFTER WHICH DLCH(IX,IY,STRING,NC,ISIZE) IS CALLED.                   *
C     ICOL INDICATES THE COLOR OF THE CHARACTERS.                      *
C     SEE COMMENTS IN DLCH FOR MEANING OF THE REMAINING ARGUMENTS.     *
C                                                                      *
C     Written by Hans Goedbloed 19/07/07, modified for color 23/07/07. *
C     corrected for restoring postscript settings, extended permitted  *
C     plotting area, 4/09/07.                                          *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      CHARACTER*(*) STRING                                              
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A24)') '%%%%String (from dlchxy)'                    
c                                                                       
c     * change color                                                    
      CALL LWCOL(0,ICOL)                                                
c                                                                       
      XFAC = (IXR-IXL)/(XR-XL)                                          
      YFAC = (IYT-IYB)/(YT-YB)                                          
      IX = IXL+INT((X-XL)*XFAC)                                         
      IY = IYB+INT((Y-YB)*YFAC)                                         
c                                                                       
c     * permit plotting slightly outside frame (including label areas) 
      IL = IXL - 65*KR
      IR = IXR + 18*KR
      IB = IYB - 77*KR
      IT = IYT + 44*KR
      IF((IX.GE.IL.AND.IX.LE.IR).AND.(IY.GE.IB.AND.IY.LE.IT))
     >   CALL DLCH(IX,IY,STRING,NC,ISIZE)                                  
c                                                                       
c     * restore color                                                   
      WRITE(IPS,'(/a11/)') 'st grestore'                                
C                                                                       
      RETURN                                                            
      END                                                               
c                                                                       
      SUBROUTINE DOTPLOT(MX,MY,X,Y,NX,NY,INCX,INCY,ICOND,NDIM,LW,ICOL)  
C                                                                       
C***********************************************************************
C     SUBROUTINE DOTPLOT PLOTS DOTS AT ALL POSITIONS                   *
C         X(I), I=1,IABS(NX),IABS(INCX),                               *
C         Y(J), J=1,IABS(NY),IABS(INCY),                               *
C FOR WHICH ICOND(I,J).NE.0, SO THAT A SHADED AREA IS OBTAINED WITH    *
C INTENSITY OF THE SHADING DETERMINED BY INCX AND INCY.                *
C      FRAME, SCALE, AND LABELS OF THE PLOT SHOULD HAVE BEEN GENERATED *
C BY A PREVIOUS CALL TO NFRAME OR LPLOT WITH IOP = -1.                 *
C ONLY LINEAR-LINEAR SCALING IS ALLOWED.                               *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY - SEE LPLOT.                                                   *
C X     - THE TABLE OF ABSCISSA VALUES.                                *
C Y     - THE TABLE OF ORDINATE VALUES.                                *
C NX    - IABS(NX) IS THE NUMBER OF POINTS IN X TO BE USED.            *
C NY    - IABS(NY) IS THE NUMBER OF POINTS IN Y TO BE USED.            *
C INCX  - IABS(INCX) IS THE SKIP PARAMETER IN A ROW.                   *
C INCY  - IABS(INCY) IS THE SKIP PARAMETER IN A COLUMN.                *
C ICOND - TWO-DIMENSIONAL INTEGER FUNCTION WITH 1'S FOR THE POINTS TO  *
C         TO BE SHOWN AND 0'S FOR THE POINTS TO BE SUPPRESSED;         *
C         TO BE STORED SUCH THAT ICOND(I,J) IS THE VALUE AT X(I),Y(J). *
C NDIM  - LENGTH OF A ROW OF ICOND (1ST DIMENSION OF THE 2-D ARRAY).   *
C         HENCE, ONE SHOULD OBSERVE: NX <= NDIM.                       *
C LW    - linewidth of the dots.                                       *
C ICOL  - color of the dots.                                           *
C                                                                      *
C     Written by Hans Goedbloed 18/07/07, modified for color 23/07/07; *
C     added clipping with DRPCLIP, 10/08/07.                           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION X(*),Y(*)                                               
      INTEGER ICOND(NDIM,*)                                             
C                                                                       
      CALL OFRAME(MX,MY)                                                
c                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A26,/)') '%%%%Shading (from DOTPLOT)'                
c                                                                       
c     * change linewidth and color                                      
      IF(LW.EQ.0) LW = 9                                                
      CALL LWCOL(LW,ICOL)                                               
c                                                                       
      XFAC = (IXR-IXL)/(XR-XL)                                          
      YFAC = (IYT-IYB)/(YT-YB)                                          
      DO 10 I = 1, NX, INCX                                             
      DO 10 J = 1, NY, INCY                                             
         IX = IXL+INT((X(I)-XL)*XFAC)                 
         IY = IYB+INT((Y(J)-YB)*YFAC)                 
         IF(ICOND(I,J).NE.0) CALL DRPCLIP(IX,IY)                            
   10 CONTINUE                                                          
c                                                                       
c     * restore linewidth and color                                     
      WRITE(IPS,'(/a11)') 'st grestore'                                 
c                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE CPLOT(MX,MY,ILAB,X,Y,NX,NY,INCX,INCY,Z,NDIM,ZC,NC,     
     A                 TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)          
C                                                                       
C***********************************************************************
C     SUBROUTINE CPLOT DRAWS NC CONTOURS OF THE FUNCTION Z = F(X,Y).   *
C THIS FUNCTION SHOULD BE STORED AS A TWO-DIMENSIONAL ARRAY Z(I,J),    *
C COMPUTED AT THE POINTS   X(I), I=1,IABS(NX),IABS(INCX),              *
C                          Y(J), J=1,IABS(NY),IABS(INCY).              *
C ENTRY CPLOTX IS AN EXTENSION FOR DRAWING POLAR PLOTS AND LOG10 CON-  *
C TOURS.                                                               *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY - SEE LPLOT.                                                   *
C ILAB  - CONTROLS THE ABSENCE/PRESENCE (ILAB=0/1) OF ALPHABETIC       *
C         LABELS ON THE CONTOURS.  THE CHOICE OF THE LABELS IS FIXED   *
C         IN THE PARAMETER STATEMENT BELOW TO BE UPPER CASE (N1=65),   *
C         LOWER CASE (N1=97), OR GREEK (N1=225).                       *
C X     - TABLE OF ABSCISSA VALUES.                                    *
C Y     - TABLE OF ORDINATE VALUES.                                    *
C NX    - IABS(NX) IS THE NUMBER OF POINTS IN X TO BE USED.            *
C         NX < 0 : ONLY THE FRAME AND SCALES FOR THE PLOT ARE DRAWN.   *
C NY    - IABS(NY) IS THE NUMBER OF POINTS IN Y TO BE USED.            *
C         NY < 0 : CONTOURS ARE DRAWN ON A FRAME PREVIOUSLY CREATED    *
C         BY A CALL TO CPLOT WITH NX < 0 OR A DIRECT CALL OF NFRAME    *
C         (IN ORDER TO SPECIFY A FRAME SIZE DIFFERENT FROM THE ONE     *
C         IMPLIED BY THE RANGES OF X AND Y).                           *
C INCX  - IABS(INCX) IS THE SKIP PARAMETER IN A ROW.                   *
C         INCX < 0 : XMIN = X(1) AND HX = X(2).                        *
C INCY  - IABS(INCY) IS THE SKIP PARAMETER IN A COLUMN.                *
C         INCY < 0 : YMIN = Y(1) AND HY = Y(2).                        *
C Z     - THE TWO-DIMENSIONAL FUNCTION TO BE CONTOURED; Z SHOULD BE    *
C         STORED SO THAT Z(I,J) IS THE VALUE OF Z AT X(I),Y(J).        *
C NDIM  - LENGTH OF A ROW OF Z (1ST DIMENSION OF THE 2-D ARRAY).       *
C         HENCE, ONE SHOULD OBSERVE: NX <= NDIM.                       *
C ZC    - THE TABLE OF CONTOUR VALUES, WHICH SHOULD BE DIMENSIONED AT  *
C         LEAST AS ZC(NC) IN THE CALLING PROGRAM.                      *
C NC    - NUMBER OF CONTOURS TO BE PLOTTED; MAXIMUM OF 26.             *
C         NC < 0 : CPLOT AUTOMATICALLY FILLS ZC WITH NC VALUES.        *
C         NC > 0 : ZC IS SUPPLIED BY THE USER; VALUES MUST BE STORED   *
C         IN INCREASING ORDER IN ZC.                                   *
C TITLE                - TITLE FOR THE GRAPH.                          *
C XNAME/YNAME          - LABEL FOR THE X/Y-AXIS.                       *
C NTITLE/NXNAME/NYNAME - NUMBER OF CHARACTERS IN TITLE/XNAME/YNAME.    *
C                                                                      *
C     ADDITIONAL ARGUMENTS FOT CPLOTX:                                 *
C                                                                      *
C RMAX  - MAXIMUM RADIUS FOR A POLOR PLOT.                             *
C         = 0 : CARTESIAN PLOT.                                        *
C         > 0 : X/Y CORRESPONDS TO R/THETA (IN RADIANS).               *
C         < 0 : X/Y CORRESPONDS TO R/COS(THETA).                       *
C IQUAD - TOTAL NUMBER OF QUADRANTS (FOR RMAX.NE.0 ONLY).              *
C LGZ   - IABS(ILGZ) CONTROLS THE NUMBER OF LOG10 CONTOURS.            *
C         LGZ = 0 : SCALAR CONTOURS.                                   *
C         ILGZ = 1,2,3,4 : LOG10 CONTOURS AT II = 1,9,ILGZ INTVLS/DEC. *
C         LGZ > 0 : THIS NUMBER II IS AUTOMATICALLY OVERRIDDEN (DOWN   *
C         TO 1 INT/DEC, DEPENDING ON THE NUMBER OF DECADES COMPUTED    *
C         FROM THE RANGE OF Z) TO GET A REASONABLE NUMBER OF CONTOURS. *
C         LGZ < 0 : THE AUTOMATIC OVERRIDE IS SWITCHED OFF, BUT THE    *
C         NUMBER OF DECADES IS LIMITED TO 8.                           *
C                                                                      *
C     WRITTEN BY CLAIR NIELSON.                                        *
C     MODIFIED BY DENNIS HEWETT 2/8/78, FOR CONTOLLING CONTOUR LABELS, *
C     ADDED VARIABLE NLAB BOTH HERE AND IN TRICJ3.                     *
C     EXTENDED BY DENNIS HEWETT 12/8/82, WITH CPLOTX AND TRICJ3 FOR    *
C     LOG10 CONTOURS AND POLAR PLOTS.                                  *
C     ADDED ARGUMENT ILAB (=NLAB), JPG 6/12/85.                        *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      PARAMETER (KR = 9)                                                
      PARAMETER (N1=97)                                                 
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      COMMON /CPLCOM/XFAC,YFAC,FX0,FY0,ISYM(26),NLAB,N1C                
      DIMENSION X(*),Y(*),Z(NDIM,*),ZC(*)                               
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
      DIMENSION ZT(4)                                                   
      CHARACTER*19 AMIN,AMAX                                            
      CHARACTER*80 TITLE1                                               
      LOGICAL FLGZ                                                      
C                                                                       
C     * INITIALIZE N1 AND ISYM FOR USE IN TRICJ3.                       
      N1C=N1                                                            
      DO 5 I=1,26                                                       
    5    ISYM(I)=0                                                      
C                                                                       
C     * INITIALIZE FOR SCALAR CONTOURS.                                 
      ILGZ=0                                                            
C     * FLAG DOWN FOR OVERRIDING THE AUTOMATIC DETERMINATION OF THE     
C     * NUMBER OF CONTOURS PER DECADE IN THE CASE OF LOG10 CONTOURS.    
      FLGZ=.FALSE.                                                      
C                                                                       
C     * INPUT PARAMETERS.                                               
   10 ICORD=0                                                           
      RMX=0.                                                            
      NNX=IABS(NX)                                                      
      NNY=IABS(NY)                                                      
      IF(NNY.LE.1) RETURN                                               
      NLAB=ILAB                                                         
      INX=IABS(INCX)                                                    
      INY=IABS(INCY)                                                    
      XMN=X(1)                                                          
      YMN=Y(1)                                                          
      IF(INCX.LE.0) THEN                                                
         HX=X(2)                                                        
         XMX=X(1)+(NNX-1)*X(2)/INX                                      
      ELSE                                                              
         XMX=X(NNX)                                                     
      ENDIF                                                             
      IF(INCY.LE.0) THEN                                                
         HY=Y(2)                                                        
         YMX=Y(1)+(NNY-1)*Y(2)/INY                                      
      ELSE                                                              
         YMX=Y(NNY)                                                     
      ENDIF                                                             
C                                                                       
C     * DRAW THE FRAME.                                                 
   20 IF(NY.GE.0) THEN                                                  
         NB=0                                                           
         IF(ILAB.EQ.1) THEN                                             
            NB=8                                                        
            IF(ILGZ.NE.0) NB=14                                         
         ENDIF                                                          
         TITLE1=TITLE                                                   
         NTITL1=ISIGN(MIN(IABS(NTITLE)+NB,80),NTITLE)                   
         CALL NFRAME(MX,MY,1,XMN,XMX,YMN,YMX,                           
     A               TITLE1,NTITL1,XNAME,NXNAME,YNAME,NYNAME)           
         IF(NX.LT.0) RETURN                                             
      ELSE                                                              
         CALL OFRAME(MX,MY)                                             
      ENDIF                                                             
C                                                                       
C     * PARAMETERS FOR COMMON /CPLCOM/ SHARED WITH SUBROUTINE TRICJ3.   
C     * INT(FX0) AND INT(FY0) ARE THE INTEGER LOCATIONS OF X=0 AND Y=0. 
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      FX0=IXL-XL*XFAC                                                   
      FY0=IYB-YB*YFAC                                                   
C                                                                       
C     * DETERMINE CONTOUR VALUES AND NUMBER OF CONTOURS.                
      NOC=MIN(26,IABS(NC))                                              
      IF(NC.LE.0) THEN                                                  
         CALL MINM(Z,NDIM,NNX,NNY,INX,INY,ZMIN,IDUM,JDUM)               
         CALL MAXM(Z,NDIM,NNX,NNY,INX,INY,ZMAX,IDUM,JDUM)               
         IF(ILGZ.EQ.0) THEN                                             
            DELZ=(ZMAX-ZMIN)/NOC                                        
            DO 30 IC=1,NOC                                              
   30          ZC(IC)=ZMIN+(REAL(IC)-.5)*DELZ                           
         ELSE                                                           
            LGMX=ALOG19(ZMAX)                                           
            IF(ZMAX.LT.1.) LGMX=LGMX-1                                  
            LGMN=ALOG19(ZMIN)                                           
            IF(ZMIN.LT.1.) LGMN=LGMN-1                                  
            LGMN=MAX(LGMN,LGMX-25)                                      
            LDEC=LGMX-LGMN+1                                            
            IF(FLGZ) THEN                                               
               IF(ILGZ.EQ.1) LDEC=MIN(LDEC,2)                           
               IF(ILGZ.EQ.2) LDEC=MIN(LDEC,5)                           
               LDEC=MIN(LDEC,8)                                         
               LGMN=LGMX-LDEC+1                                         
            ELSE                                                        
               IF(LDEC.GT.2.AND.ILGZ.LT.2) ILGZ=2                       
               IF(LDEC.GT.5.AND.ILGZ.LT.3) ILGZ=4                       
               IF(LDEC.GT.8) ILGZ=10                                    
            ENDIF                                                       
            IC=0                                                        
            STEP=10.**LGMN                                              
            DO 50 ID=1,LDEC                                             
               DO 40 II=1,9,ILGZ                                        
                  ZCT=REAL(II)*STEP                                     
                  IF((IC.EQ.NOC).OR.(ZCT.GT.ZMAX)) GOTO 60              
                  IC=IC+1                                               
   40             ZC(IC)=ZCT                                            
   50          STEP=STEP*10.                                            
   60       NOC=IC                                                      
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C     * PUT EXTREME PARAMETERS ALONG THE TOP OF THE GRAPH.              
      IF(ILAB.EQ.1) THEN                                                
         IF(ILGZ.EQ.0) THEN                                             
            WRITE(AMIN,'(''='',1PE9.2)') ZC(1)                          
            WRITE(AMAX,'(''='',1PE9.2)') ZC(NOC)                        
            CALL DLCH(IXR-90*KR,IYT+18*KR,' ',N1,1)                     
            CALL DLCH(IXR-75*KR,IYT+18*KR,AMIN,10,1)                    
            CALL DLCH(IXR-90*KR,IYT+ 4*KR,' ',N1+NOC-1,1)               
            CALL DLCH(IXR-75*KR,IYT+ 4*KR,AMAX,10,1)                    
         ELSE                                                           
            WRITE(AMIN,'(''='',1PE9.2,'' ILGZ ='',I2)') ZC(1),ILGZ      
            WRITE(AMAX,'(''='',1PE9.2,'' LDEC ='',I2)') ZC(NOC),LDEC    
            CALL DLCH(IXR-170*KR,IYT+18*KR,' ',N1,1)                    
            CALL DLCH(IXR-155*KR,IYT+18*KR,AMIN,19,1)                   
            CALL DLCH(IXR-170*KR,IYT+ 4*KR,' ',N1+NOC-1,1)              
            CALL DLCH(IXR-155*KR,IYT+ 4*KR,AMAX,19,1)                   
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
C     * DRAW THE CONTOURS BY CALLING TRICJ3 FOR THE TWO TRIANGLES       
C     * WITHIN A MESH OF THE GRID.                                      
c     * postscript comment                                              
      WRITE(IPS,'(/A23/)') '%%%%Curves (from CPLOT)'                    
C                                                                       
      Y1=Y(1)                                                           
      DO 80 J=1+INY,NNY,INY                                             
         IF(INCY.GT.0) HY=Y(J)-Y(J-INY)                                 
         Y2=Y1+HY                                                       
         X1=X(1)                                                        
         DO 70 I=1+INX,NNX,INX                                          
            IF(INCX.GT.0) HX=X(I)-X(I-INX)                              
            X2=X1+HX                                                    
            ZT(1)=Z(I-INX,J-INY)                                        
            ZT(2)=Z(I,J-INY)                                            
            ZT(3)=Z(I,J)                                                
            ZT(4)=Z(I-INX,J)                                            
            IF(ABS(ZT(3)-ZT(1)).GE.ABS(ZT(4)-ZT(2))) THEN               
               CALL TRICJ3(X1,Y1,HX,HY,NOC,ZC,ZT(2),ZT(1),ZT(4),ICORD)  
               CALL TRICJ3(X2,Y2,-HX,-HY,NOC,ZC,ZT(4),ZT(3),ZT(2),ICORD)
            ELSE                                                        
               CALL TRICJ3(X2,Y1,-HX,HY,NOC,ZC,ZT(1),ZT(2),ZT(3),ICORD) 
               CALL TRICJ3(X1,Y2,HX,-HY,NOC,ZC,ZT(3),ZT(4),ZT(1),ICORD) 
            ENDIF                                                       
            X1=X2                                                       
   70    CONTINUE                                                       
         Y1=Y2                                                          
   80 CONTINUE                                                          
C                                                                       
      RETURN                                                            
C                                                                       
C     * ENTRY FOR POLAR PLOTS AND LOG10 CONTOURS.                       
      ENTRY CPLOTX(MX,MY,ILAB,X,Y,NX,NY,INCX,INCY,Z,NDIM,ZC,NC,         
     A             TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME,              
     B             RMAX,IQUAD,LGZ)                                      
C                                                                       
      ILGZ=MIN(IABS(LGZ),4)                                             
      IF(ILGZ.LT.0) FLGZ=.TRUE.                                         
      IF(RMAX.EQ.0.) GOTO 10                                            
C                                                                       
      ICORD=1                                                           
      IF(RMAX.LT.0.) ICORD=2                                            
      RMX=ABS(RMAX)                                                     
      NNX=IABS(NX)                                                      
      NNY=IABS(NY)                                                      
      IF(NNY.LE.1) RETURN                                               
      NLAB=ILAB                                                         
      INX=IABS(INCX)                                                    
      INY=IABS(INCY)                                                    
      IF(INCX.LT.0) HX=X(2)                                             
      IF(INCY.LT.0) HY=Y(2)                                             
      XMN=0.                                                            
      YMN=0.                                                            
      XMX=RMX                                                           
      YMX=RMX                                                           
      IQUD=MAX(IQUAD,1)                                                 
      IF(IQUD.GT.2.AND.RMAX.LT.0.) IQUD=2                               
      IF(IQUD.EQ.2.) THEN                                               
         XMN=-RMX                                                       
         XMX=RMX                                                        
         YMX=RMX                                                        
      ELSEIF(IQUD.EQ.3.OR.IQUD.EQ.4) THEN                               
         XMN=-RMX                                                       
         YMN=-RMX                                                       
      ENDIF                                                             
      GOTO 20                                                           
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE TRICJ3(XV,YV,DX,DY,NOC,ZC,ZX,ZV,ZY,ICORD)              
C                                                                       
C***********************************************************************
C     THIS SUBROUTINE IS CALLED FROM CPLOT TO DETERMINE THE PARTS OF   *
C THE CONTOURS THAT LIE WITHIN A TRIANGLE OF THE GRID MESH.  TRICJ3    *
C FINDS THE INTERSECTIONS OF THE CONTOURS WITH THE TWO SIDES OF THE    *
C TRIANGLE AND DRAWS LINES BETWEEN THOSE POINTS.                       *
C     IF NLABEL=1 IN COMMON /CPLCOM/, ALPHABETIC LABELS ARE WRITTEN    *
C EVERY #(ISKIP+1) CALL OF TRICJ3.  ISKIP IS FIXED IN THE PARAMETER    *
C STATEMENT BELOW.                                                     *
C                                                                      *
C     MODIFIED BY D.W. HEWETT 12-82, FOR THE DIFFERENT COORDINATES     *
C     X,Y (ICORD=0), R,THETA (ICORD=1), AND  R,COS(THETA) (ICORD=2).   *
C     ADDED PARAMETER ISKIP, ADDED CHECK ON RANGE Y1/2, JPG 9/12/85.   *
C     changed ISKIP to 49, jpg 25/07/07.                               *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
      PARAMETER (ISKIP=49)                                              
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      COMMON /CPLCOM/XFAC,YFAC,FX0,FY0,ISYM(26),NLAB,N1C                
      DIMENSION ZC(*)                                                   
      DIMENSION X(3),Y(3),Z(3)                                          
C                                                                       
      N1=N1C                                                            
      IX=1                                                              
      IF(ZV.LT.ZX) THEN                                                 
         IX=2                                                           
         IF(ZY.LT.ZX) IX=3                                              
         IV=1                                                           
         IY=5-IX                                                        
         IF(ZY.LE.ZV) THEN                                              
            IV=5-IX                                                     
            IY=1                                                        
         ENDIF                                                          
      ELSE                                                              
         IF(ZY.LT.ZX) IX=2                                              
         IV=3-IX                                                        
         IY=3                                                           
         IF(ZY.LE.ZV) THEN                                              
            IV=3                                                        
            IY=3-IX                                                     
         ENDIF                                                          
      ENDIF                                                             
C                                                                       
      X(IX)=XV+DX                                                       
      X(IV)=XV                                                          
      X(IY)=XV                                                          
      Y(IX)=YV                                                          
      Y(IV)=YV                                                          
      Y(IY)=YV+DY                                                       
      Z(IX)=ZX                                                          
      Z(IV)=ZV                                                          
      Z(IY)=ZY                                                          
      IF(Z(1).EQ.Z(3)) RETURN                                           
C                                                                       
      PI=3.1415926535898                                                
      TPI=2.*PI                                                         
      DO 10 IC=1,NOC                                                    
         IF(ZC(IC).LT.Z(1)) GOTO 10                                     
         IF(ZC(IC).GT.Z(3)) GOTO 20                                     
         FRAC=(ZC(IC)-Z(1))/(Z(3)-Z(1))                                 
         X1=X(1)+(X(3)-X(1))*FRAC                                       
         Y1=Y(1)+(Y(3)-Y(1))*FRAC                                       
         IF(ZC(IC).LE.Z(2).AND.Z(1).NE.Z(2)) THEN                       
            FRAC=(ZC(IC)-Z(1))/(Z(2)-Z(1))                              
            X2=X(1)+FRAC*(X(2)-X(1))                                    
            Y2=Y(1)+FRAC*(Y(2)-Y(1))                                    
         ELSE                                                           
            FRAC=(ZC(IC)-Z(2))/(Z(3)-Z(2))                              
            X2=X(2)+FRAC*(X(3)-X(2))                                    
            Y2=Y(2)+FRAC*(Y(3)-Y(2))                                    
         ENDIF                                                          
         IF(ICORD.NE.0) THEN                                            
            FLP1=1.                                                     
            FLP2=1.                                                     
            IF(ICORD.EQ.1) THEN                                         
               IF(Y1.GT.PI.AND.Y1.LT.TPI) FLP1=-1.                      
               IF(Y2.GT.PI.AND.Y2.LT.TPI) FLP2=-1.                      
               Y1=COS(Y1)                                               
               Y2=COS(Y2)                                               
            ENDIF                                                       
            Y1=DMIN1(DMAX1(-1.D+0,Y1),1.D+0)                            
            Y2=DMIN1(DMAX1(-1.D+0,Y2),1.D+0)                            
            TX1=Y1*X1                                                   
            Y1=FLP1*X1*SQRT(1.-Y1*Y1)                                   
            X1=TX1                                                      
            TX2=Y2*X2                                                   
            Y2=FLP2*X2*SQRT(1.-Y2*Y2)                                   
            X2=TX2                                                      
         ENDIF                                                          
         IX1=FX0+X1*XFAC                                                
         IY1=FY0+Y1*YFAC                                                
         IX2=FX0+X2*XFAC                                                
         IY2=FY0+Y2*YFAC                                                
         CALL DRV(IX1,IY1,IX2,IY2)                                      
         ISYM(IC)=ISYM(IC)+NLAB                                         
         IF(ISYM(IC).GE.1) THEN                                         
            ICC=IC+N1-1                                                 
            IDX=8*KR                                                    
            IDY=0*KR                                                    
            IF(IABS(IX2-IX1).GE.IABS(IY2-IY1)) THEN                     
               IDX=0*KR                                                 
               IDY=8*KR                                                 
            ENDIF                                                       
            IX11=MIN(MAX(IXL+5*KR,IX1+IDX),IXR-5)                       
            IY11=MIN(MAX(IYB+5*KR,IY1+IDY),IYT-5)                       
            CALL DLCH(IX11,-IY11,' ',ICC,1)                             
            ISYM(IC)=-ISKIP                                             
         ENDIF                                                          
   10 CONTINUE                                                          
C                                                                       
   20 RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE VPLOT(MX,MY,IVEC,X,Y,NX,NY,INCX,INCY,VX,VY,NDIM,SIZE,L,
     A                 TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)          
C                                                                       
C***********************************************************************
C     SUBROUTINE VPLOT DRAWS A REPRESENTION OF A 2-DIMENSIONAL VECTOR  *
C FIELD VX = F(X,Y), VY = G(X,Y).  THESE FUNCTIONS SHOULD BE STORED AS *
C 2-DIMENSIONAL ARRAYS VX(I,J), VY(I,J), COMPUTED AT THE OBSERVATION   *
C POINTS X(I), I=1,IABS(NX),IABS(INCX), Y(J), J=1,IABS(NY),IABS(INCY). *
C ENTRY VPLOTX IS AN EXTENSION FOR POLAR COORDINATES.                  *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY - SEE LPLOT.                                                   *
C IVEC  - PROVIDES DIFFERENT OPTIONS FOR THE PRESENTATION OF THE VEC-  *
C         TOR FIELD ACCORDING TO THE FORMULA                           *
C            IABS(IVEC) = ISUP*100 + IDOT*10 + JVEC,                   *
C         WHERE JVEC DETERMINES THE SHAPE OF THE ARROWHEADS:           *
C            JVEC = 1 - SIZE ARROWHEAD PROPORTIONAL TO VECTOR LENGTH   *
C                   2 - CONSTANT-SIZE ARROWHEAD,                       *
C         AND IDOT PROVIDES THE OPTION TO IDENTIFY THE DATA POINTS:    *
C            IDOT = 0 - NO ACTION (DEFAULT)                            *
C                   1 - DOT PLACED AT THE DATA LOCATIONS,              *
C         AND ISUP DETERMINES WHETHER SMALL VECTORS ARE DRAWN OR NOT:  *
C            ISUP = 0 - NO ACTION (DEFAULT)                            *
C                   1 - SUPPRESS DOT AND VECTOR IF BOTH VECTOR COMPO-  *
C                       NENTS <= EPS * MAXIMUM AMPLITUDE OF VX AND VY, *
C                       WHERE EPS IS FIXED IN THE PARAMETER STATEMENT. *
C X/Y   - TABLE OF THE ABSCISSA/ORDINATE VALUES.                       *
C NX    - IABS(NX) IS THE NUMBER OF POINTS IN X TO BE USED.            *
C         NX < 0 : ONLY THE FRAME AND SCALES FOR THE PLOT ARE DRAWN.   *
C NY    - IABS(NY) IS THE NUMBER OF POINTS IN Y TO BE USED.            *
C         NY < 0 : VECTORS ARE DRAWN ON A FRAME PREVIOUSLY CREATED     *
C         BY A CALL TO VPLOT WITH NX < 0 OR A DIRECT CALL OF NFRAME    *
C         (IN ORDER TO SPECIFY A FRAME SIZE DIFFERENT FROM THE ONE     *
C         IMPLIED BY THE RANGES OF X AND Y).                           *
C INCX  - IABS(INCX) IS THE SKIP PARAMETER IN A ROW.                   *
C         INCX < 0 : XMIN = X(1) AND HX =X(2).                         *
C INCY  - IABS(INCY) IS THE SKIP PARAMETER IN A COLUMN.                *
C         INCY < 0 : YMIN = Y(1) AND HY =Y(2).                         *
C VX/VY - THE TWO-DIMENSIONAL VECTOR COMPONENTS TO BE PLOTTED; STORED  *
C         SUCH THAT VX/VY(I,J) IS THE VALUE OF VX/VY AT X(I),Y(J).     *
C NDIM  - LENGTH OF A ROW OF VX/VY (1ST ARGUMENT OF THE 2-D ARRAYS).   *
C         HENCE, ONE SHOULD OBSERVE: NX <= NDIM.                       *
C SIZE  - THE VECTORS ARE PLOTTED WITH THEIR MAXIMUM AMPLITUDE AMP     *
C         (PRINTED ON TOP OF THE GRAPH IF ISUP=1) SCALED DOWN WITH A   *
C         FACTOR OF SIZE*STEP/AMP, WHERE STEP IS THE WIDTH OF THE      *
C         SMALLEST MESH OF THE GRID AND SIZE IS CHOSEN FOR CLARITY OF  *
C         PRESENTATION.  FOR A UNIFORM GRID, THE LARGEST VECTORS WILL  *
C         PRECISELY FIT THE MESH WHEN SIZE=1.  FOR A NON-UNIFORM GRID, *
C         SIZE HAS TO BE CHOSEN BY CONSIDERING THE SPACING OF A TYPI-  *
C         CAL MESH AS COMPARED TO THE SMALLEST ONE.                    *
C L     - LENGTH OF THE ARROWHEADS AS AN INTEGER PERCENTAGE OF THE     *
C         VECTOR LENGTH (FOR JVEC=1) OR AS AN ABSOLUTE VALUE IN TERMS  *
C         OF PLOTTING COORDINATES (FOR JVEC=2).                        *
C TITLE               - TITLE FOR THE GRAPH.                           *
C XNAME/YNAME         - LABEL FOR THE X/Y-AXIS.                        *
C NTITLE/NXNAME/YNAME - NUMBER OF CHARACTERS IN TITLE/XNAME/YNAME.     *
C                                                                      *
C     ADDITIONAL ARGUMENTS FOR VPLOTX:                                 *
C                                                                      *
C RMAX  - MAXIMUM RADIUS FOR A POLAR PLOT.                             *
C         = 0 : CARTESIAN PLOT.                                        *
C         > 0 : X/Y CORRESPONDS TO R/THETA (IN RADIANS),               *
C               VX/VY CORRESPONDS TO THE VECTOR COMPONENT VR/VT.       *
C IQUAD - TOTAL NUMBER OF QUADRANTS (FOR RMAX.NE.0 ONLY).              *
C                                                                      *
C     WRITTEN BY D. HEWETT 3/83 BY ADAPTING A VERSION OF CPLOT.        *
C     EXTENDED FOR NON-UNIFORM GRID, ADDED ARGUMENTS IVEC, SIZE, L,    *
C     ADDED PARAMETER EPS, ELIMINATED ICORD=2 OPTION OF CPLOT/TRICJ3,  *
C     JPG 16/12/85.                                                    *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
      PARAMETER (EPS=.1)                                                
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION X(*),Y(*),VX(NDIM,*),VY(NDIM,*)                         
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
      CHARACTER TITLE1*80,STRING*14                                     
C                                                                       
   10 ICORD=0                                                           
      RMX=0.                                                            
      NNX=IABS(NX)                                                      
      NNY=IABS(NY)                                                      
      IF(NNY.LE.1) RETURN                                               
      INX=IABS(INCX)                                                    
      INY=IABS(INCY)                                                    
      HX=X(2)-X(1)                                                      
      HY=Y(2)-Y(1)                                                      
      XMN=X(1)                                                          
      YMN=Y(1)                                                          
      XMX=X(NNX)                                                        
      YMX=Y(NNY)                                                        
      IF(INCX.LT.0) THEN                                                
         HX=X(2)                                                        
         XMX=X(1)+(NNX-1)*X(2)/INX                                      
      ENDIF                                                             
      IF(INCY.LT.0) THEN                                                
         HY=Y(2)                                                        
         YMX=Y(1)+(NNY-1)*Y(2)/INY                                      
      ENDIF                                                             
C                                                                       
   20 JVEC=MOD(IABS(IVEC),10)                                           
      IDOT=MOD(IABS(IVEC)/10,10)                                        
      ISUP=MOD(IABS(IVEC)/100,10)                                       
      IF(NY.GE.0) THEN                                                  
         NB=0                                                           
         IF(ISUP.EQ.1) NB=9                                             
         TITLE1=TITLE                                                   
         NTITL1=ISIGN(MIN(IABS(NTITLE)+NB,80),NTITLE)                   
         CALL NFRAME(MX,MY,1,XMN,XMX,YMN,YMX,                           
     A               TITLE1,NTITL1,XNAME,NXNAME,YNAME,NYNAME)           
         IF(NX.LT.0) RETURN                                             
      ELSE                                                              
         CALL OFRAME(MX,MY)                                             
      ENDIF                                                             
C                                                                       
C     * INT(FX0) AND INT(FY0) ARE THE INTEGER LOCATIONS OF X=0 AND Y=0. 
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      FX0=IXL-XL*XFAC                                                   
      FY0=IYT-YT*YFAC                                                   
C                                                                       
      CALL MAXAM(VX,NDIM,NNX,NNY,INX,INY,VXMX,IDUM,JDUM)                
      CALL MAXAM(VY,NDIM,NNX,NNY,INX,INY,VYMX,IDUM,JDUM)                
      VXMX=ABS(VXMX)                                                    
      VYMX=ABS(VYMX)                                                    
      AMP=DMAX1(VXMX,VYMX)                                              
      IF(ISUP.EQ.1.OR.AMP.EQ.0.) THEN                                   
         WRITE(STRING,'(''AMP ='',1PE9.2)') AMP                         
         CALL DLCH(IXR-110*KR,IYT+18*KR,STRING,14,1)                    
         WRITE(STRING,'(''EPS ='',1PE9.2)') EPS                         
         CALL DLCH(IXR-110*KR,IYT+4*KR,STRING,14,1)                     
         IF(AMP.EQ.0.) AMP=1.                                           
      ENDIF                                                             
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A24/)') '%%%%Vectors (from VPLOT)'                   
C                                                                       
      DXMN=INX*ABS(HX)                                                  
      IF(INCX.GT.0) THEN                                                
         DO 30 I=1+INX,NNX,INX                                          
            DX=ABS(X(I)-X(I-INX))                                       
   30       IF(DX.LT.DXMN) DXMN=DX                                      
      ENDIF                                                             
      DYMN=INY*ABS(HY)                                                  
      IF(INCY.GT.0) THEN                                                
         DO 40 J=1+INY,NNY,INY                                          
            DY=ABS(Y(J)-Y(J-INY))                                       
   40       IF(DY.LT.DYMN) DYMN=DY                                      
      ENDIF                                                             
      STEP=DMIN1(DXMN,DYMN)                                             
      VFAC=SIZE*STEP/AMP                                                
      THR=EPS*SIZE*STEP                                                 
C                                                                       
      PI=3.1415926535898                                                
      TPI=2.*PI                                                         
      Y1SAV=Y(1)-HY                                                     
      DO 60 J=1,NNY,INY                                                 
         Y1=Y1SAV+HY                                                    
         IF(INCY.GT.0) Y1=Y(J)                                          
         Y1SAV=Y1                                                       
         X1SAV=X(1)-HX                                                  
         DO 50 I=1,NNX,INX                                              
            X1=X1SAV+HX                                                 
            IF(INCX.GT.0) X1=X(I)                                       
            X1SAV=X1                                                    
            Y1=Y1SAV                                                    
            X2=VFAC*VX(I,J)                                             
            Y2=VFAC*VY(I,J)                                             
            IF(ISUP.EQ.1.AND.ABS(X2).LT.THR.AND.ABS(Y2).LT.THR) GOTO 50 
            IF(ICORD.NE.0) THEN                                         
               C=COS(Y1)                                                
               C=DMIN1(DMAX1(-1.D+0,C),1.D+0)                           
               FLP=1.                                                   
               IF(Y1.GT.PI.AND.Y1.LT.TPI) FLP=-1.                       
               S=FLP*SQRT(1.-C*C)                                       
               Y1=X1*S                                                  
               X1=X1*C                                                  
               X2S=X2                                                   
               X2=X2S*C-Y2*S                                            
               Y2=X2S*S+Y2*C                                            
            ENDIF                                                       
            X2=X1+X2                                                    
            Y2=Y1+Y2                                                    
            IX1=FX0+X1*XFAC                                             
            IY1=FY0+Y1*YFAC                                             
            IX2=FX0+X2*XFAC                                             
            IY2=FY0+Y2*YFAC                                             
            IF(IDOT.EQ.1) CALL DLCH(IX1,-IY1,' ',46,1)                  
            IF(JVEC.EQ.1) CALL ARROW1(IX1,IY1,IX2,IY2,L)                
            IF(JVEC.EQ.2) CALL ARROW2(IX1,IY1,IX2,IY2,L)                
   50    CONTINUE                                                       
   60 CONTINUE                                                          
C                                                                       
      RETURN                                                            
C                                                                       
      ENTRY VPLOTX(MX,MY,IVEC,X,Y,NX,NY,INCX,INCY,VX,VY,NDIM,SIZE,L,    
     A             TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME,              
     B             RMAX,IQUAD)                                          
C                                                                       
      IF(RMAX.EQ.0.) GOTO 10                                            
C                                                                       
      ICORD=1                                                           
      RMX=ABS(RMAX)                                                     
      NNX=IABS(NX)                                                      
      NNY=IABS(NY)                                                      
      IF(NNY.LE.1) RETURN                                               
      INX=IABS(INCX)                                                    
      INY=IABS(INCY)                                                    
      HX=X(2)-X(1)                                                      
      HY=Y(2)-Y(1)                                                      
      IF(INCX.LT.0) HX=X(2)                                             
      IF(INCY.LT.0) HY=Y(2)                                             
      XMN=0.                                                            
      YMN=0.                                                            
      XMX=RMX                                                           
      YMX=RMX                                                           
      IQUD=MAX(IQUAD,1)                                                 
      IF(IQUD.GT.2.AND.RMAX.LT.0.) IQUD=2                               
      IF(IQUD.EQ.2) THEN                                                
         XMN=-RMX                                                       
         XMX=RMX                                                        
         YMX=RMX                                                        
      ELSEIF(IQUD.EQ.3.OR.IQUD.EQ.4) THEN                               
         XMN=-RMX                                                       
         YMN=-RMX                                                       
      ENDIF                                                             
      GOTO 20                                                           
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE FPLOT(MX,MY,IVEC,X,Y,NPTS,INC,VX,VY,VFAC,L,            
     A                 TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)          
C                                                                       
C***********************************************************************
C     FPLOT IS A ONE-DIMENSIONAL VECTOR PLOTTING ROUTINE WHICH PLOTS   *
C THE TWO-DIMENSIONAL FLOW FIELD VX = F(X,Y), VY = G(X,Y) ALONG A ONE- *
C DIMENSIONAL CURVE X(I), Y(I), I=1,..,NPTS.  CONSEQUENTLY, THE VECTOR *
C COMPONENTS SHOULD BE GIVEN AS ONE-DIMENSIONAL ARRAYS VX(I), VY(I).   *
C THE AMPLITUDE OF THE VECTOR FIELD IS SCALED WITH THE FACTOR VFAC.    *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY - SEE LPLOT.                                                   *
C IVEC  - PROVIDES DIFFERENT OPTIONS FOR THE PRESENTATION OF THE VEC-  *
C         TOR FIELD ACCORDING TO THE FORMULA                           *
C            IABS(IVEC) = IDOT*10 + JVEC,                              *
C         WHERE JVEC DETERMINES THE SHAPE OF THE ARROWHEADS:           *
C            JVEC = 1 - SIZE ARROWHEAD PROPORTIONAL TO VECTOR LENGTH   *
C                   2 - CONSTANT-SIZE ARROWHEAD,                       *
C         AND IDOT PROVIDES THE OPTION TO IDENTIFY THE DATA POINTS:    *
C            IDOT = 0 - NO ACTION (DEFAULT)                            *
C                   1 - DOT PLACED AT THE DATA LOCATIONS.              *
C         IVEC < 0 : ONLY FRAME AND SCALES FOR THE PLOT ARE DRAWN.     *
C X/Y   - TABLE OF ABSCISSA/ORDINATE VALUES.                           *
C NPTS  - IABS(NPTS) IS THE NUMBER OF ELEMENTS IN THE ARRAYS X AND Y.  *
C         NPTS < 0: THE VECTORS ARE DRAWN ONTO A FRAME PREVIOUSLY SET  *
C         UP BY A CALL TO NFRAME OR FPLOT WITH IVEC < 0.               *
C INC   - IABS(INC) IS THE SPACING BETWEEN THE X/Y POSITIONS PLOTTED.  *
C         INC < 0: THE Y-POSITIONS PLOTTED ARE PAIRED WITH ABSCISSA    *
C         VALUES DETERMINED BY THE TWO VALUES XMIN=X(1) AND DX=X(2),   *
C         WHICH THE USER SHOULD INSERT IN X.                           *
C VX    - 1D ARRAY CONTAINING THE X-COMPONENTS OF THE VECTOR FIELD.    *
C VY    - 1D ARRAY CONTAINING THE Y-COMPONENTS OF THE VECTOR FIELD.    *
C VFAC  - MULTIPLICATIVE FACTOR FOR THE AMPLITUDE OF THE VECTORS.      *
C L     - LENGTH OF THE ARROWHEADS AS AN INTEGER PERCENTAGE OF THE     *
C         VECTOR LENGTH (FOR JVEC=1) OR AS AN ABSOLUTE VALUE IN TERMS  *
C         OF PLOTTING COORDINATES (FOR JVEC=2).                        *
C TITLE                - TITLE FOR THE GRAPH.                          *
C XNAME/YNAME          - LABEL FOR THE X/Y-AXIS.                       *
C NTITLE/NXNAME/NYNAME - NUMBER OF CHARACTERS IN TITLE/XNAME/YNAME.    *
C                                                                      *
C     WRITTEN BY HANS GOEDBLOED 29/08/85 BY ADAPTING LPLOT.            *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION X(*),Y(*),VX(*),VY(*)                                   
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
C                                                                       
      JVEC=MOD(IABS(IVEC),10)                                           
      IDOT=MOD(IABS(IVEC)/10,10)                                        
      NTOT=IABS(NPTS)                                                   
      INCA=IABS(INC)                                                    
C                                                                       
C     * DRAW THE FRAME.                                                 
      IF(NPTS.GT.0) THEN                                                
         IF(INC.LT.0) THEN                                              
            XMN=X(1)                                                    
            XMX=X(1)+(NTOT-1)*X(2)/INCA                                 
         ELSE                                                           
            CALL MAXV(X,NTOT,INCA,XMX,IDUM)                             
            CALL MINV(X,NTOT,INCA,XMN,IDUM)                             
         ENDIF                                                          
         CALL MAXV(Y,NTOT,INCA,YMX,IDUM)                                
         CALL MINV(Y,NTOT,INCA,YMN,IDUM)                                
         CALL NFRAME(MX,MY,1,XMN,XMX,YMN,YMX,                           
     A               TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)            
         IF(IVEC.LT.0) RETURN                                           
      ELSE                                                              
         CALL OFRAME(MX,MY)                                             
      ENDIF                                                             
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A24/)') '%%%%Vectors (from FPLOT)'                   
C                                                                       
C     * DRAW THE VECTOR FIELD.                                          
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      HX=0.                                                             
      IF(INC.LT.0) HX=X(2)                                              
      X1=X(1)-HX                                                        
      DO 10 I=1,NTOT,INCA                                               
         X1=X1+HX                                                       
         IF(INC.GT.0) X1=X(I)                                           
         Y1=Y(I)                                                        
         IX1=MIN(MAX(IXL,IXL+INT((X1-XL)*XFAC)),IXR)                    
         IY1=MIN(MAX(IYB,IYB+INT((Y1-YB)*YFAC)),IYT)                    
         IF(IDOT.EQ.1) CALL DLCH(IX1,-IY1,' ',46,1)                     
         X2=X1+VX(I)*VFAC                                               
         Y2=Y1+VY(I)*VFAC                                               
         IX2=IXL+INT((X2-XL)*XFAC)                                      
         IY2=IYB+INT((Y2-YB)*YFAC)                                      
         IF(IX2.LT.IXL.OR.IX2.GT.IXR.OR.IY2.LT.IYB.OR.IY2.GT.IYT) THEN  
C           * IF VECTOR WOULD CROSS THE BOUNDARY, SUPPRESS ARROWHEAD    
C           * AND PART OF THE VECTOR OUTSIDE THE DOMAIN.                
            IXX=MIN(MAX(IXL,IX2),IXR)                                   
            IYY=MIN(MAX(IYB,IY2),IYT)                                   
            IYYS=IYY                                                    
            IF(IXX.NE.IX2) IYY=IY1+(IY2-IY1)*(IXX-IX1)/(IX2-IX1)        
            IF(IYYS.NE.IY2.AND.(IYY.LE.IYB.OR.IYY.GE.IYT)) THEN         
               IXX=IX1+(IX2-IX1)*(IYYS-IY1)/(IY2-IY1)                   
               IYY=IYYS                                                 
            ENDIF                                                       
            CALL DRV(IX1,IY1,IXX,IYY)                                   
         ELSE                                                           
            IF(JVEC.EQ.1) CALL ARROW1(IX1,IY1,IX2,IY2,L)                
            IF(JVEC.EQ.2) CALL ARROW2(IX1,IY1,IX2,IY2,L)                
         ENDIF                                                          
   10 CONTINUE                                                          
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE ARROW1(IX1,IY1,IX2,IY2,L)                              
C***********************************************************************
C     SUBROUTINE ARROW1 DRAWS AN ARROW FROM (IX1,IY1) TO (IX2,IY2).    *
C THE HEIGHT AND THE WIDTH OF THE ARROWHEAD ARE FIXED RELATIVE TO THE  *
C LENGTH OF THE ARROW BY THE VARIABLES H AND W, WHERE H = L/100 (I.E., *
C THE ARGUMENT L PROVIDES THE LENGTH OF THE ARROWHEAD AS AN INTEGER    *
C PERCENTAGE OF THE VECTOR LENGTH R) AND W = WR*H (I.E., THE PARAMETER *
C WR PROVIDES THE WIDTH RELATIVE TO THE HEIGHT OF THE ARROWHEAD).      *
C     THROUGH ENTRY ARROW2 ARROWS WITH A CONSTANT LENGTH OF THE ARROW- *
C HEAD ARE DRAWN.  THIS LENGTH IS FIXED BY THE ARGUMENT L = H*R (I.E., *
C L PROVIDES THE ABSOLUTE LENGTH OF THE ARROWHEAD IN TERMS OF PLOTTING *
C COORDINATES).                                                        *
C                                                                      *
C     WRITTEN BY HANS GOEDBLOED 29/08/85.                              *
C     improved shape arrowhead by calling DR3, jpg 30/07/07.           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      PARAMETER (WR=.35)                                                
C                                                                       
      H=REAL(L)/100.                                                    
C                                                                       
   10 IF(L.EQ.0) THEN                                                   
         CALL DRV(IX1,IY1,IX2,IY2)                                      
         RETURN                                                         
      ENDIF                                                             
      W=WR*H                                                            
      IHX=H*(IX2-IX1)                                                   
      IHY=H*(IY2-IY1)                                                   
      IWX=W*(IX2-IX1)                                                   
      IWY=W*(IY2-IY1)                                                   
      IX3=IX2-IHX+IWY                                                   
      IY3=IY2-IWX-IHY                                                   
      IX4=IX2-IHX-IWY                                                   
      IY4=IY2+IWX-IHY                                                   
      CALL DRV(IX1,IY1,IX2,IY2)                                         
      CALL DR3(IX2,IY2,IX3,IY3,IX4,IY4)                                 
C                                                                       
      RETURN                                                            
C                                                                       
C     * ENTRY FOR DRAWING CONSTANT-SIZE ARROWHEADS.                     
      ENTRY ARROW2(IX1,IY1,IX2,IY2,L)                                   
C                                                                       
      R=SQRT(REAL((IX2-IX1)**2+(IY2-IY1)**2))                           
      IF(R.LT.REAL(L)) THEN                                             
         CALL DLCH(IX1,-IY1,' ',46,1)                                   
         RETURN                                                         
      ENDIF                                                             
      H=REAL(L)/R                                                       
      GOTO 10                                                           
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE SPLOT(MX,MY,IS,IOP,YX,ZXY,NX,NY,INCYX,Z,NDIM,IJARR,NS, 
     A                 TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)          
C                                                                       
C***********************************************************************
C     SPLOT PLOTS THE ONE-DIMENSIONAL CROSS-SECTIONS OF THE TWO-DIMEN- *
C SIONAL FUNCTION Z(X(I),Y(J)) IN THE X- OR Y-DIRECTION, DEPENDING ON  *
C THE VALUE OF IS.  THE VALUES OF THE X- OR Y-INDICES MAY BE SPECIFIED *
C IN THE ARRAY IJARR(ISEC), WHERE ISEC=1,NS.                           *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY  - SEE LPLOT.                                                  *
C IS     - DETERMINES WHETHER X- OR Y-SECTIONS ARE PLOTTED.            *
C          IS = 1 : X-SECTION ZX PLOTTED AS A FUNCTION OF Y.           *
C          IS = 2 : Y-SECTION ZY PLOTTED AS A FUNCTION OF X.           *
C          HENCE, FOR EXPRESSIONS XY READ: X FOR IS=1, Y FOR IS=2,     *
C          AND VICE VERSA FOR YX.                                      *
C IOP    - SEE LPLOT.                                                  *
C          IF IOP > 10 (I.E., CHARACTERS ARE PLACED ON THE CURVES),    *
C          THE CHARACTER NUMBER IC IS AUTOMATICALLY INCREMENTED FOR    *
C          THE NS DIFFERENT CURVES SPECIFIED.  E.G., IF IOP=30971, A   *
C          LOWER CASE 'A' IS PLACED AT EVERY 3RD POINT ON THE FIRST    *
C          CURVE, A LOWER CASE 'B' ON THE SECOND CURVE, ETC.           *
C YX     - TABLE OF THE ABSCISSA VALUES FOR THE PLOTS.                 *
C ZXY    - AN ARRAY THAT HOLDS THE X/Y-SECTIONS OF THE FUNCTION Z.     *
C          IT SHOULD BE DIMENSIONED NY/NX IN THE CALLING PROGRAM.      *
C NX     - THE NUMBER OF POINTS IN THE X-DIRECTION, I.E. THE NUMBER OF *
C          POINTS IN A Y-SECTION PLOT.                                 *
C          NX < 0 : ONLY THE FRAME AND SCALES FOR THE PLOT ARE DRAWN.  *
C NY     - THE NUMBER OF POINTS IN THE Y-DIRECTION, I.E. THE NUMBER OF *
C          POINTS IN A X-SECTION PLOT.                                 *
C          NY < 0 : SECTIONS ARE DRAWN ON A FRAME PREVIOUSLY CREATED   *
C          BY A CALL TO SPLOT WITH NX < 0 OR A DIRECT CALL OF NFRAME   *
C          (IN ORDER TO SPECIFY A FRAME SIZE DIFFERENT FROM THE ONE    *
C          IMPLIED BY THE RANGES OF YX AND ZXY).                       *
C INCYX  - IABS(INCYX) IS THE SKIP PARAMATER FOR YX.                   *
C          INCYX < 0 : YXMIN = YX(1) AND DYX = YX(2).                  *
C Z      - THE TWO-DIMENSIONAL TABLE OF VALUES DIMENSIONED AT LEAST AS *
C          NX BY NY IN THE CALLING PROGRAM.                            *
C NDIM   - THE FIRST DIMENSION OF THE ARRAY Z.  HENCE: NX <= NDIM.     *
C IJARR  - CONTAINS THE X/Y INDICES AT WHICH TO TAKE SECTIONS AND      *
C          DIMENSIONED BY NS.                                          *
C NS     - THE NUMBER OF ROWS OR COLUMNS AT WHICH TO TAKE SECTIONS.    *
C          NS < 0 : SPLOT AUTOMATICALLY FILLS IJARR WITH |NS| VALUES.  *
C          NS > 0 : IJARR IS SUPPLIED BY THE USER.                     *
C TITLE                - TITLE FOR THE GRAPH.                          *
C XNAME/YNAME          - LABEL FOR THE X/Y-AXIS.                       *
C NTITLE/NXNAME/NYNAME - NUMBER OF CHARACTERS IN TITLE/XNAME/YNAME.    *
C                                                                      *
C     WRITTEN BY BRENDAN GODFREY.                                      *
C     ADDED ARGUMENTS IS AND NDIM, JPG 23/12/85.                       *
C     CORRECTED ERROR IN CALCULATION IJARR, JPG 2/8/91.                *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      DIMENSION YX(*),ZXY(*),Z(NDIM,*),IJARR(*)                         
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
c                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      NNX=IABS(NX)                                                      
      NNY=IABS(NY)                                                      
      IF(IS.EQ.1) THEN                                                  
         NNXY=NNX                                                       
         NNYX=NNY                                                       
      ELSE                                                              
         NNXY=NNY                                                       
         NNYX=NNX                                                       
      ENDIF                                                             
C                                                                       
C     * DRAW FRAME AND SCALES.                                          
      IF(NY.GT.0) THEN                                                  
C        * DETERMINE THE RANGE OF ALL POSSIBLE ZXY'S.                   
         CALL MINM(Z,NDIM,NNX,NNY,1,1,ZXYMIN,IDUM,JDUM)                 
         CALL MAXM(Z,NDIM,NNX,NNY,1,1,ZXYMAX,IDUM,JDUM)                 
C        * DETERMINE THE RANGE OF YX.                                   
         YXMIN=YX(1)                                                    
         YXMAX=YX(1)+YX(2)*(NNYX-1)/IABS(INCYX)                         
         IF(INCYX.GT.0) YXMAX=YX(NNYX)                                  
         CALL NFRAME(MX,MY,IABS(IOP),YXMIN,YXMAX,ZXYMIN,ZXYMAX,         
     A               TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)            
C        * IF NX < 0, DRAW FRAME AND SCALES ONLY.                       
         IF(NX.LT.0) RETURN                                             
      ELSE                                                              
C        * DRAW SECTIONS ONTO PREVIOUSLY DRAWN FRAME.                   
         CALL OFRAME(MX,MY)                                             
      ENDIF                                                             
C                                                                       
C     * DETERMINE THE NUMBER AND INDICES OF THE SECTIONS.               
      NOS=IABS(NS)                                                      
      IF(NS.LT.0) THEN                                                  
C        * STORE UNIFORMLY SPACED INDICES ALONG XY IN THE ARRAY IJARR.  
         DXY=REAL(NNXY)/REAL(NOS)                                       
         DO 10 ISEC=1,NOS                                               
   10       IJARR(ISEC)=(ISEC-0.5)*DXY+0.5                              
      ENDIF                                                             
C                                                                       
C     * FILL THE ARRAY ZXY AND PASS IT ONTO LPLOT.                      
      DO 30 ISEC=1,NOS                                                  
         DO 20 JI=1,NNYX                                                
            IF(IS.EQ.1) ZXY(JI)=Z(IJARR(ISEC),JI)                       
            IF(IS.EQ.2) ZXY(JI)=Z(JI,IJARR(ISEC))                       
   20    CONTINUE                                                       
         IOP1=IOP                                                       
         IF(IOP/10.NE.0) IOP1=IOP+(ISEC-1)*10                           
c        * postscript comment                                           
         WRITE(IPS,'(/A10,I1,A2)') '%%%%SPLOT(',IS,'):'                 
         CALL LPLOT(MX,MY,IOP1,YX,ZXY,-NNYX,INCYX,                      
     A              TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)             
   30 CONTINUE                                                          
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE APLOT(MX,MY,IA,YX,AVXY,NX,NY,INCYX,Z,NDIM,IJ1,IJ2,     
     A                 TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)          
C                                                                       
C***********************************************************************
C     APLOT AVERAGES OVER THE TWO-DIMENSIONAL FUNCTION Z(X(I),Y(J)) IN *
C ONE DIRECTION (X OR Y, DEPENDING ON THE VALUE OF IA) AND PLOTS THE   *
C RESULT WITH RESPECT TO THE OTHER DIRECTION.  AVERAGING MAY BE LIMI-  *
C TED TO A SPECIFIED BAND OF INDICES IJ1-IJ2 IN THE X- OR Y-DIRECTION. *
C THIS SUBROUTINE ONLY PERFORMS THE AVERAGING CALCULATION; IT CALLS    *
C LPLOT TO DRAW THE RESULTING CURVE.                                   *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY  - SEE LPLOT.                                                  *
C IA     - DETERMINES WHETHER X- OR Y-AVERAGES ARE PLOTTED.            *
C          IA = 1 : X-AVERAGE AVX PLOTTED AS A FUNCTION OF Y.          *
C          IA = 2 : Y-AVERAGE AVY PLOTTED AS A FUNCTION OF X.          *
C          HENCE, FOR EXPRESSIONS XY READ: X FOR IA=1, Y FOR IA=2,     *
C          AND VICE VERSA FOR YX.                                      *
C YX     - TABLE OF THE ABSCISSA VALUES FOR THE PLOT.                  *
C AVXY   - AN ARRAY THAT HOLDS THE X/Y-AVERAGES OF THE FUNCTION Z.     *
C          IT SHOULD BE DIMENSIONED NY/NX IN THE CALLING PROGRAM.      *
C NX     - THE NUMBER OF POINTS IN THE X-DIRECTION, I.E. THE NUMBER OF *
C          POINTS IN A Y-AVERAGE PLOT.                                 *
C          NX < 0 : ONLY THE FRAME AND SCALES FOR THE PLOT ARE DRAWN.  *
C NY     - THE NUMBER OF POINTS IN THE Y-DIRECTION, I.E. THE NUMBER OF *
C          POINTS IN A X-AVERAGE PLOT.                                 *
C          NY < 0 : AVERAGES ARE DRAWN ON A FRAME PREVIOUSLY CREATED   *
C          BY A CALL TO APLOT WITH NX < 0 OR A DIRECT CALL OF NFRAME   *
C          (IN ORDER TO SPECIFY A FRAME SIZE DIFFERENT FROM THE ONE    *
C          IMPLIED BY THE RANGES OF YX AND AVXY).                      *
C INCYX  - IABS(INCYX) IS THE SKIP PARAMATER FOR YX.                   *
C          INCYX < 0 : YXMIN = YX(1) AND DYX = YX(2).                  *
C Z      - THE TWO-DIMENSIONAL TABLE OF VALUES DIMENSIONED AT LEAST AS *
C          NX BY NY IN THE CALLING PROGRAM.                            *
C NDIM   - THE FIRST DIMENSION OF THE ARRAY Z.  HENCE: NX <= NDIM.     *
C IJ1    - THE INDEX OF THE FIRST CELL IN THE AVERAGE CALCULATION.     *
C          IJ1 <= 0 : THE VALUE 1 FOR AVERAGING OVER THE WHOLE RANGE   *
C          IS TAKEN.                                                   *
C IJ2    - THE INDEX OF THE LAST CELL OF THE BAND TO AVERAGE OVER.     *
C          IJ2 <= 0 : THE VALUE NX/NY FOR AVERAGING OVER THE WHOLE     *
C          RANGE IS TAKEN.                                             *
C TITLE                - TITLE FOR THE GRAPH.                          *
C XNAME/YNAME          - LABEL FOR THE X/Y-AXIS.                       *
C NTITLE/NXNAME/NYNAME - NUMBER OF CHARACTERS IN TITLE/XNAME/YNAME.    *
C                                                                      *
C     WRITTEN BY DENNIS HEWETT.                                        *
C     MODIFIED BY DEBBY HYMAN 5-80, FOR -NX OR -NY TO TRIGGER SEPARATE *
C     DRAWING OF THE FRAME AND THE CURVE.                              *
C     ADDED ARGUMENTS IA AND NDIM, SEPARATED X- AND Y-AVERAGE PLOTS,   *
C     IMPROVED HANDLING OF THE SKIP PARAMETER, JPG 23/12/85.           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
c                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      DIMENSION YX(*),AVXY(*),Z(NDIM,*)                                 
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
C                                                                       
      NNX=IABS(NX)                                                      
      NNY=IABS(NY)                                                      
      IF(IA.EQ.1) THEN                                                  
         NNXY=NNX                                                       
         NNYX=NNY                                                       
      ELSE                                                              
         NNXY=NNY                                                       
         NNYX=NNX                                                       
      ENDIF                                                             
C                                                                       
C     * INSTALL BAND OF INDICES TO AVERAGE OVER, IF DESIRED.            
      IJ11=1                                                            
      IF(IJ1.GT.0) IJ11=IJ1                                             
      IJ22=NNXY                                                         
      IF(IJ2.GT.0) IJ22=IJ2                                             
C                                                                       
C     * COMPUTE THE AVERAGE AVXY.                                       
      DO 20 JI=1,NNYX                                                   
         AVXY(JI)=0.                                                    
         DO 10 IJ=IJ11,IJ22                                             
            IF(IA.EQ.1) AVXY(JI)=AVXY(JI)+Z(IJ,JI)                      
            IF(IA.EQ.2) AVXY(JI)=AVXY(JI)+Z(JI,IJ)                      
   10    CONTINUE                                                       
   20    AVXY(JI)=AVXY(JI)/REAL(IJ22-IJ11+1)                            
C                                                                       
C     * PLOT AVXY AS A FUNCTION OF YX.                                  
c     * postscript comment                                              
      WRITE(IPS,'(/A10,I1,A2)') '%%%%APLOT(',IA,'):'                    
      CALL LPLOT(MX,MY,ISIGN(1,NX),YX,AVXY,ISIGN(NNYX,NY),INCYX,        
     A           TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)                
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE TPLOT(MX,MY,IVERT,NX,NY,INCX,INCY,Z,NDIM,              
     A                 TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)          
C                                                                       
C***********************************************************************
C     THIS ROUTINE PLOTS A FUNCTION OF TWO VARIABLES ON A RECTANGULAR  *
C GRID AS A SET OF VERTICAL LINES RISING FROM THE GRID POINTS.  THE    *
C HEIGHT OF THE LINES IS RELATED TO THE AMPLITUDE OF THE FUNCTION:     *
C          FMZ(I,J)/ZMAX                   FOR IVERT=1 (LINEAR),       *
C          GM(1+HM*ALOG10(Z(I,J)/ZMAX2))   FOR IVERT=2 (QUASI-LOG),    *
C WHERE FM,GM,HM ARE FIXED IN THE PARAMETER STATEMENT BELOW.  THE      *
C PARAMETERS DM,DN,EM DETERMINE THE LENGTH AND ORIENTATION OF THE X-   *
C AND Y-AXES.  TPLOT MAY BE USED, E.G., TO PLOT FOURIER COMPONENTS     *
C WITH A VERTICAL LOG SCALE.  IT PRODUCES A CRUDE 3-D PLOT.  ONLY      *
C POSITIVE VALUES OF Z ARE PLOTTED.                                    *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY  - SEE LPLOT.                                                  *
C IVERT  - DETERMINES WHETHER THE VERTICAL SCALE OF THE PLOT IS LINEAR *
C          OR QUASI-LOGARITHMIC.                                       *
C NX     - NUMBER OF POINTS IN THE X-DIRECTION.                        *
C NY     - NUMBER OF POINTS IN THE Y-DIRECTION.                        *
C INCX   - SKIP PARAMETER FOR X.                                       *
C INCY   - SKIP PARAMETER FOR Y.                                       *
C Z      - 2-D ARRAY OF VERTICAL HEIGHTS.                              *
C NDIM   - THE FIRST DIMENSION OF THE ARRAY Z.  HENCE: NX <= NDIM.     *
C TITLE                - TITLE FOR THE GRAPH.                          *
C XNAME/YNAME          - LABEL FOR THE X/Y-AXIS (REFERS TO INDICES!).  *
C NTITLE/NXNAME/NYNAME - NUMBER OF CHARACTERS IN TITLE/XNAME/YNAME.    *
C                                                                      *
C     WRITTEN BY DAVE FORSLUND.                                        *
C     ADDED ARGUMENTS IVERT AND NDIM, INTRODUCED PARAMETERS DN AND FM, *
C     IMPROVED SCALES, JPG 24/12/85.                                   *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      PARAMETER (KR = 9)                                                
      PARAMETER (DM=.57,DN=.91,EM=.82,FM=2.,GM=.1,HM=.33)               
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION Z(NDIM,*)                                               
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
      CHARACTER*9 STRING                                                
C                                                                       
      CALL NFRAME(MX,MY,5,0.D+0,1.D+0,0.D+0,1.D+0,                      
     A            TITLE,NTITLE,' ',1,' ',1)                             
C                                                                       
C     * DETERMINE THE MAXIMUM OF Z (ZMAX2 IS THE NEXT LARGEST VALUE).   
      ZMAX  = 0.D+0                                                     
      ZMAX2 = 0.D+0                                                     
      DO 10 J=1,NY,INCY                                                 
         DO 10 I=1,NX,INCX                                              
            ZMAX2=DMAX1(ZMAX2,Z(I,J))                                   
            IF(ZMAX2.GT.ZMAX) THEN                                      
               ZMAX2=ZMAX                                               
               ZMAX=Z(I,J)                                              
            ENDIF                                                       
   10 CONTINUE                                                          
C                                                                       
      CALL DLCH(IXL,IYT-20*KR,'ZMAX =',6,2)                             
      WRITE(STRING,'(1PE9.2)') ZMAX                                     
      CALL DLCH(IXL,IYT-40*KR,STRING,9,2)                               
      WRITE(STRING,'(1PE9.2)') ZMAX2                                    
      CALL DLCH(IXL,IYT-60*KR,STRING,9,2)                               
C                                                                       
C     * SCALE FACTORS.                                                  
      DMAX=(NX-1.)/DM                                                   
      EMAX=(NY-1.)/EM                                                   
      A=DMAX*(DN-DM)/(EMAX*EM)                                          
C                                                                       
C     * DRAW X- AND Y-AXIS.                                             
      CALL CONVRT(0.D+0          ,I0,0.D+0,DMAX,IXL,IXR)                
      CALL CONVRT(0.D+0          ,J0,0.D+0,EMAX,IYB,IYT)                
      CALL CONVRT(NX-1.D+0       ,I1,0.D+0,DMAX,IXL,IXR)                
      CALL CONVRT(NX-1.+A*(NY-1.),I2,0.D+0,DMAX,IXL,IXR)                
      CALL CONVRT(NY-1.D+0       ,J1,0.D+0,EMAX,IYB,IYT)                
      CALL DRV(I0,J0,I1,J0)                                             
      CALL DRV(I1,J0,I2,J1)                                             
C                                                                       
C     * SCALE AND LABEL X-AXIS.                                         
      CALL DLCH(I0-6*KR,J0-22*KR,'1',1,2)                               
      IF(NX.LT.10) THEN                                                 
         NC=1                                                           
         WRITE(STRING,'(I1)') NX                                        
      ELSEIF(NX.LT.100) THEN                                            
         NC=2                                                           
         WRITE(STRING,'(I2)') NX                                        
      ELSEIF(NX.LT.1000) THEN                                           
         NC=3                                                           
         WRITE(STRING,'(I3)') NX                                        
      ENDIF                                                             
      CALL DLCH(I1-NC*6*KR,J0-22*KR,STRING,NC,2)                        
      CALL DLCH((I0+I1)/2-NXNAME*6*KR,J0-43*KR,XNAME,NXNAME,2)          
C                                                                       
C     * SCALE AND LABEL Y-AXIS.                                         
      CALL DRV(I1,J0,I1+15*KR,J0)                                       
      CALL DRV(I2,J1,I2+15*KR,J1)                                       
      CALL DLCH(I1+20*KR,J0-8*KR,'1',1,2)                               
      IF(NY.LT.10) THEN                                                 
         NC=1                                                           
         WRITE(STRING,'(I1)') NY                                        
      ELSEIF(NY.LT.100) THEN                                            
         NC=2                                                           
         WRITE(STRING,'(I2)') NY                                        
      ELSEIF(NY.LT.1000) THEN                                           
         NC=3                                                           
         WRITE(STRING,'(I3)') NY                                        
      ENDIF                                                             
      CALL DLCH(I2+20*KR,J1-8*KR,STRING,NC,2)                           
      CALL DLCH((I1+I2)/2+50*KR,(J0+J1)/2-8*KR,YNAME,NYNAME,2)          
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A22/)') '%%%%Lines (from TPLOT)'                     
C                                                                       
C     * PLOT Z(I,J).                                                    
      C=0.                                                              
      IF(IVERT.EQ.1) THEN                                               
         IF(ZMAX.GT.0.) C=FM/ZMAX                                       
      ELSEIF(IVERT.EQ.2) THEN                                           
         IF(ZMAX2.GT.0.) C=1.-HM*DLOG10(ZMAX2)                          
         GME=GM*EMAX                                                    
      ENDIF                                                             
      DO 20 J=1,NY,INCY                                                 
         E0=REAL(J-1)                                                   
         D0=A*E0                                                        
         DO 20 I=1,NX,INCX                                              
            D=D0+REAL(I-1)                                              
            E=E0                                                        
            IF(IVERT.EQ.1) THEN                                         
               tmpjw = DMAX1(0.D+0,C)                                   
               IF(Z(I,J).GT.0.) E=E+DMAX1(0.D+0,C*Z(I,J))               
            ELSEIF(IVERT.EQ.2) THEN                                     
               IF(Z(I,J).GT.0.) THEN                                    
                  E=E+DMAX1(0.D+0,GME*(C+HM*ALOG19(Z(I,J))))            
               ENDIF                                                    
            ENDIF                                                       
            CALL CONVRT(D ,ID ,0.D+0,DMAX,IXL,IXR)                      
            CALL CONVRT(E0,IE0,0.D+0,EMAX,IYB,IYT)                      
            CALL CONVRT(E ,IE ,0.D+0,EMAX,IYB,IYT)                      
            IF(IABS(IE-IE0).GT.1) THEN                                  
               CALL DRV(ID,IE,ID,IE0)                                   
            ELSE                                                        
               CALL DLCH(ID,-IE0,' ',46,2)                              
            ENDIF                                                       
   20 CONTINUE                                                          
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE P3PLOT(MX,MY,R,TH,NR,NTH,F,NDIM,THX,THY,TITLE,NTITLE)  
C                                                                       
C***********************************************************************
C     SUBROUTINE P3PLOT PRODUCES A THREE-DIMENSIONAL POLAR PLOT OF THE *
C FUNCTION F(R(I),TH(J)), I=1,..,NR, J=1,..,NTH.                       *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX/MY  - SEE LPLOT.                                                  *
C R      - 1D ARRAY OF RADIAL COORDINATES.                             *
C TH     - 1D ARRAY OF ANGULAR COORDINATES (IN RADIANS).               *
C NR     - NUMBER OF POINTS IN THE RADIAL DIRECTION.                   *
C NTH    - NUMBER OF POINTS IN THE ANGULAR DIRECTION.                  *
C F      - 2D ARRAY OF FUNCTION VALUES.                                *
C NDIM   - THE FIRST DIMENSION OF THE ARRAY F.  HENCE: NR <= NDIM.     *
C THX    - ANGLE (IN DEGREES!) AT WHICH THE X-AXIS IS TO BE DRAWN.     *
C THY    - ANGLE (IN DEGREES!) BETWEEN THE X- AND Y-AXIS.              *
C TITLE  - TITLE FOR THE GRAPH.                                        *
C NTITLE - NUMBER OF CHARACTERS IN TITLE.                              *
C                                                                      *
C     WRITTEN BY R.M. FRANK, 1975.                                     *
C     ADAPTED TO PPPLIB, JPG 24/04/86.                                 *
C     removed erroneous MOVABS commands, jpg 26/07/07.                 *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION R(*),TH(*),F(NDIM,*)                                    
      CHARACTER*(*) TITLE                                               
      DIMENSION JXRL(3),JYTB(6),X(2),Y(2)                               
      CHARACTER*3 LAB(2,2)                                              
C                                                                       
C     * FOR KR=1 (old):                                                 
C     DATA JXRL/900,400,400/,                                           
C    >     JYTB/645,285,285,165,165,165/                                
C     * FOR KR+9:                                                       
      DATA JXRL/8100,3600,3600/,                                        
     >     JYTB/5805,2565,2565,1485,1485,1485/                          
      DATA LAB/' 0 ',' 90','180','270'/                                 
C                                                                       
      PI=3.1415926535898                                                
      DGR=PI/180.                                                       
C                                                                       
C     * DETERMINE FRAME COORDINATES.                                    
      CALL MAXV(R,NR,1,RMAX,IRM)                                        
      CALL MAXAM(F,NDIM,NR,NTH,1,1,FMAX,IDUM,JDUM)                      
      SX=SIN(THX*DGR)                                                   
      CX=COS(THX*DGR)                                                   
      SXY=SIN((THY+THX)*DGR)                                            
      CXY=COS((THY+THX)*DGR)                                            
      XMX=RMAX*CX                                                       
      YMX=RMAX*SX                                                       
      DO 10 J=1,71                                                      
         THETA=J*5.*DGR                                                 
         Q=SIN(THETA)                                                   
         T=COS(THETA)                                                   
         XMX=DMAX1(XMX,RMAX*(T*CX+Q*CXY))                               
         YMX=DMAX1(YMX,RMAX*(T*SX+Q*SXY))                               
   10 CONTINUE                                                          
      XMX=XMX*1.125                                                     
      XMN=-XMX                                                          
      YMN=-YMX                                                          
      S=ABS((YMX-YMN)/(2.*FMAX))                                        
      DO 20 J=1,NTH                                                     
         Q=SIN(TH(J))*SXY+COS(TH(J))*SX                                 
         DO 20 I=1,NR                                                   
            YTEST=R(I)*Q+S*F(I,J)                                       
            YMX=DMAX1(YMX,YTEST)                                        
            YMN=DMIN1(YMN,YTEST)                                        
   20 CONTINUE                                                          
      YMX=YMX*1.125                                                     
      YMN=YMN*1.125                                                     
      IMX=MOD(IABS(MX),10)                                              
      IMY=MOD(IABS(MY),10)                                              
      IF((XMX-XMN)/(YMX-YMN).LT.REAL(JXRL(IMX))/JYTB(IMY)) THEN         
         MXX=20+IMX                                                     
         MYY=10+IMY                                                     
      ELSE                                                              
         MXX=10+IMX                                                     
         MYY=20+IMY                                                     
      ENDIF                                                             
      CALL NFRAME(MXX,MYY,5,XMN,XMX,YMN,YMX,TITLE,NTITLE,' ',1,' ',1)   
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A24/)') '%%%%Curves (from P3PLOT)'                   
C                                                                       
      XFAC=(IXR-IXL)/(XR-XL)                                            
      YFAC=(IYT-IYB)/(YT-YB)                                            
      IX0=IXL-INT(XL*XFAC)                                              
      IY0=IYB-INT(YB*YFAC)                                              
C                                                                       
C     * DRAW BOUNDARY CURVE.                                            
      IX1=IX0+INT(RMAX*CX*XFAC)                                         
      IY1=IY0+INT(RMAX*SX*YFAC)                                         
      L=0                                                               
      DO 30 J=1,72                                                      
         THETA=J*5.*DGR                                                 
         Q=SIN(THETA)                                                   
         T=COS(THETA)                                                   
         IX=IX0+INT(RMAX*(T*CX+Q*CXY)*XFAC)                             
         IY=IY0+INT(RMAX*(Q*SXY+T*SX)*YFAC)                             
         CALL DASH(IX1,IY1,IX,IY,10*KR,10*KR,L,LL)                      
         L=LL                                                           
         IX1=IX                                                         
         IY1=IY                                                         
   30 CONTINUE                                                          
C                                                                       
C     * DRAW AXES AND LABELS.                                           
      RLAB=1.+60.*XMX/((IXR-IXL)*RMAX)                                  
      DO 50 K=1,2                                                       
         DO 40 L=1,2                                                    
            THETA=(90.*(K-1)+180.*(L-1))*DGR                            
            Q=SIN(THETA)                                                
            T=COS(THETA)                                                
            X(L)=RMAX*(T*CX+Q*CXY)                                      
            Y(L)=RMAX*(Q*SXY+T*SX)                                      
   40    CONTINUE                                                       
         CALL DASH(IX0+INT(X(1)*XFAC),IY0+INT(Y(1)*YFAC),               
     A             IX0+INT(X(2)*XFAC),IY0+INT(Y(2)*YFAC),               
     B             10*KR,10*KR,0,IDUM)                                  
         DO 50 L=1,2                                                    
            IX=IX0+INT(X(L)*RLAB*XFAC)                                  
            IY=IY0+INT(Y(L)*RLAB*YFAC)                                  
            CALL DLCH(IX-12*KR,-IY,LAB(K,L),3,2)                        
   50 CONTINUE                                                          
C                                                                       
C     * DRAW BOUNDARY VERTICALS.                                        
      DO 60 J=1,NTH-1                                                   
         THETA=TH(J)                                                    
         Q=SIN(THETA)                                                   
         T=COS(THETA)                                                   
         IX =IX0+INT(RMAX*(T*CX+Q*CXY)*XFAC)                            
         IY1=IY0+INT(RMAX*(Q*SXY+T*SX)*YFAC)                            
         IY2=IY1+INT(S*F(IRM,J)*YFAC)                                   
         IF(IABS(IY2-IY1).GT.5) CALL DASH(IX,IY1,IX,IY2,                
     A                                    0*KR,5*KR,0*KR,IDUM)          
   60 CONTINUE                                                          
C                                                                       
C     * DRAW CENTER LINE.                                               
      CALL MINV(R,NR,1,RMIN,IR0)                                        
      IF(RMIN.EQ.0.)                                                    
     A   CALL DASH(IX0,IY0,IX0,IY0+INT(S*F(IR0,1)*YFAC),                
     B             10*KR,10*KR,0*KR,IDUM)                               
C                                                                       
C     * DRAW ANGULAR GRID LINES.                                        
      DO 70 I=1,NR                                                      
         RI=R(I)                                                        
         IX=IX0+INT(RI*CX*XFAC)                                         
         IY=IY0+INT((RI*SX+S*F(I,1))*YFAC)                              
         CALL MOVABS(IX,IY)                                             
         DO 70 J=2,NTH                                                  
            THETA=TH(J)                                                 
            Q=SIN(THETA)                                                
            T=COS(THETA)                                                
            IX=IX0+INT(RI*(T*CX+Q*CXY)*XFAC)                            
            IY=IY0+INT((RI*(Q*SXY+T*SX)+S*F(I,J))*YFAC)                 
C           * removed jpg 26/07/07                                      
C            CALL MOVABS(IX,IY)                                         
            CALL DRWABS(IX,IY)                                          
   70 CONTINUE                                                          
C                                                                       
C     * DRAW RADIAL GRID LINES.                                         
      DO 80 J=1,NTH-1                                                   
         THETA=TH(J)                                                    
         Q=SIN(THETA)                                                   
         T=COS(THETA)                                                   
         RI=R(1)                                                        
         IX=IX0+INT(RI*(T*CX+Q*CXY)*XFAC)                               
         IY=IY0+INT((RI*(Q*SXY+T*SX)+S*F(1,J))*YFAC)                    
         CALL MOVABS(IX,IY)                                             
            DO 80 I=2,NR                                                
            RI=R(I)                                                     
            IX=IX0+INT(RI*(T*CX+Q*CXY)*XFAC)                            
            IY=IY0+INT((RI*(Q*SXY+T*SX)+S*F(I,J))*YFAC)                 
C           * removed jpg 26/07/07                                      
C            CALL MOVABS(IX,IY)                                         
            CALL DRWABS(IX,IY)                                          
   80 CONTINUE                                                          
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE MAXV(A,N,INC,B,I)                                      
C                                                                       
C***********************************************************************
C     SUBROUTINE MAXV, AND ENTRIES MINV, MAXAV, MINAV DETERMINE THE    *
C MAXIMUM, MINIMUM, MAXIMUM ABSOLUTE, MINIMUM ABSOLUTE VALUES OF AN    *
C ARRAY OF REAL NUMBERS, RESPECTIVELY.  AS THE ARRAY IS SEARCHED, AN   *
C INDEX IS UPDATED EACH TIME A LARGER VALUE OF A (IN THE CASE OF MAXV) *
C IS ENCOUNTERED.  AFTER THE ARRAY IS SEARCHED, B IS SET TO THE VALUE  *
C OF A WITH THE CALCULATED INDEX.                                      *
C                                                                      *
C A   - ONE-DIMENSIONAL INPUT ARRAY OF REAL NUMBERS.                   *
C N   - NUMBER OF ELEMENTS IN THE ARRAY A.                             *
C INC - SPACING AT WHICH ELEMENTS ARE TO BE EXAMINED.                  *
C B   - MAXIMUM, MINIMUM, MAXIMUM ABSOLUTE OR MINIMUM ABSOLUTE VALUE   *
C       OF A RETURNED TO THE CALLER.                                   *
C I   - ELEMENT NUMBER OF MAXIMUM, MINIMUM, ETC. VALUE OF A (1<=I<=N). *
C                                                                      *
C     SEPARATED THE DIFFERENT ENTRIES, CHANGED THE MEANING OF N TO THE *
C     PRESENT ONE, JPG 9/1/86.                                         *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      DIMENSION A(*)                                                    
C                                                                       
      B=A(1)                                                            
      I=1                                                               
      DO 10 K=1,N,INC                                                   
         IF(A(K).GT.B) THEN                                             
            B=A(K)                                                      
            I=K                                                         
         ENDIF                                                          
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
      ENTRY MINV(A,N,INC,B,I)                                           
      B=A(1)                                                            
      I=1                                                               
      DO 20 K=1,N,INC                                                   
         IF(A(K).LT.B) THEN                                             
            B=A(K)                                                      
            I=K                                                         
         ENDIF                                                          
   20 CONTINUE                                                          
      RETURN                                                            
C                                                                       
      ENTRY MAXAV(A,N,INC,B,I)                                          
      B=ABS(A(1))                                                       
      I=1                                                               
      DO 30 K=1,N,INC                                                   
         S=ABS(A(K))                                                    
         IF(S.GT.B) THEN                                                
            B=S                                                         
            I=K                                                         
         ENDIF                                                          
   30 CONTINUE                                                          
      B=A(I)                                                            
      RETURN                                                            
C                                                                       
      ENTRY MINAV(A,N,INC,B,I)                                          
      B=ABS(A(1))                                                       
      I=1                                                               
      DO 40 K=1,N,INC                                                   
         S=ABS(A(K))                                                    
         IF(S.LT.B) THEN                                                
            B=S                                                         
            I=K                                                         
         ENDIF                                                          
   40 CONTINUE                                                          
      B=A(I)                                                            
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE MAXM(A,IA,M,N,INCK,INCL,B,I,J)                         
C                                                                       
C***********************************************************************
C     SUBROUTINE MAXM, AND ENTRIES MINM, MAXAM, MINAM DETERMINE THE    *
C MAXIMUM, MINIMUM, MAXIMUM ABSOLUTE, AND MINIMUM ABSOLUTE ELEMENT AND *
C THE INDICES OF THAT ELEMENT IN MATRIX A.                             *
C                                                                      *
C A    - TWO-DIMENSIONAL INPUT ARRAY.                                  *
C IA   - MAXIMUM LENGTH OF THE FIRST ARGUMENT OF A AS SPECIFIED IN THE *
C        DIMENSION STATEMENT, I.E. DIMENSION A(IA,JA).                 *
C M    - NUMBER OF COLUMNS (1ST ARGUMENT).                             *
C N    - NUMBER OF ROWS (2ND ARGUMENT).                                *
C INCK - SKIP PARAMETER FOR THE 1ST ARGUMENT.                          *
C INCL - SKIP PARAMETER FOR THE 2ND ARGUMENT.                          *
C B    - CONTAINS THE DESIRED ELEMENT.                                 *
C I    - FIRST INDEX TO THE RESULTANT ELEMENT.                         *
C J    - SECOND INDEX TO THE RESULTANT ELEMENT.                        *
C                                                                      *
C     SEPARATED THE DIFFERENT ENTRIES, ADDED ARGUMENTS INCK AND NCL,   *
C     JPG 9/1/86.                                                      *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      DIMENSION A(IA,*)                                                 
C                                                                       
      B=A(1,1)                                                          
      I=1                                                               
      J=1                                                               
      DO 10 K=1,M,INCK                                                  
         DO 10 L=1,N,INCL                                               
            IF(A(K,L).GT.B) THEN                                        
               B=A(K,L)                                                 
               I=K                                                      
               J=L                                                      
            ENDIF                                                       
   10 CONTINUE                                                          
      RETURN                                                            
C                                                                       
      ENTRY MINM(A,IA,M,N,INCK,INCL,B,I,J)                              
      B=A(1,1)                                                          
      I=1                                                               
      J=1                                                               
      DO 20 K=1,M,INCK                                                  
         DO 20 L=1,N,INCL                                               
            IF(A(K,L).LT.B) THEN                                        
               B=A(K,L)                                                 
               I=K                                                      
               J=L                                                      
            ENDIF                                                       
   20 CONTINUE                                                          
      RETURN                                                            
C                                                                       
      ENTRY MAXAM(A,IA,M,N,INCK,INCL,B,I,J)                             
      B=ABS(A(1,1))                                                     
      I=1                                                               
      J=1                                                               
      DO 30 K=1,M,INCK                                                  
         DO 30 L=1,N,INCL                                               
            S=ABS(A(K,L))                                               
            IF(S.GT.B) THEN                                             
               B=S                                                      
               I=K                                                      
               J=L                                                      
            ENDIF                                                       
   30 CONTINUE                                                          
      B=A(I,J)                                                          
      RETURN                                                            
C                                                                       
      ENTRY MINAM(A,IA,M,N,INCK,INCL,B,I,J)                             
      B=ABS(A(1,1))                                                     
      I=1                                                               
      J=1                                                               
      DO 40 K=1,M,INCK                                                  
         DO 40 L=1,N,INCL                                               
            S=ABS(A(K,L))                                               
            IF(S.LT.B) THEN                                             
               B=S                                                      
               I=K                                                      
               J=L                                                      
            ENDIF                                                       
   40 CONTINUE                                                          
      B=A(I,J)                                                          
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      FUNCTION ALOG19(ARG)                                              
C                                                                       
C***********************************************************************
C     SPECIAL ALOG10 TO PREVENT ERROR ON ZERO OR NEGATIVE ARGUMENT.    *
C     WRITTEN BY BOB MALONE 12/08/78.                                  *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      IF(ARG.LT.1.E-50) THEN                                            
         ALOG19=-50.                                                    
      ELSE                                                              
         ALOG19=DLOG10(ARG)                                             
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      BLOCK DATA LHEAD                                                  
C                                                                       
C***********************************************************************
C     PROPERLY INITIALIZING THE TOP AND BOTTOM LABELS FOR NFRAME.      *
C     WRITTEN BY HANS GOEDBLOED 2/8/91                                 *
C***********************************************************************
C                                                                       
      COMMON /LHEAD1/LABTOP,LABBOT,D,T                                  
      CHARACTER LABTOP*80,LABBOT*40,D*10,T*10                           
      COMMON /LHEAD2/NCT,NCB                                            
C                                                                       
      DATA LABTOP,LABBOT,D,T/' ',' ',' ',' '/                           
      DATA NCT,NCB/1,1/                                                 
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE LBLTOP(LABEL,NLABEL)                                   
C                                                                       
C***********************************************************************
C     SUBROUTINE LBLTOP ENABLES A USER TO SPECIFY AN 80-CHARACTER      *
C LABEL AT THE TOP OF A PAGE OF PLOTS.  ENTRY LBLBOT ENABLES A USER TO *
C SPECIFY A 40-CHARACTER LABEL AT THE BOTTOM OF A PLOTTING PAGE AND TO *
C WRITE DATE AND TIME IN THE LEFT CORNER OF THE PAGE.  THE LABELS ARE  *
C CENTERED WITH RESPECT TO THE WIDTH OF THE PAGE.  LBLTOP AND LBLBOT   *
C SHOULD BE CALLED BEFORE ANY OTHER PLOT CALLS FOR A PAGE.  ONCE A     *
C LABEL CALL IS GIVEN, IT REMAINS IN EFFECT FOR EACH SUCCEEDING PAGE   *
C UNTIL ANOTHER CALL WITH A DIFFERENT CHARACTER STRING IS GIVEN.       *
C                                                                      *
C    External LHEAD added by Sander Belien 15/12/1999.                 *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      COMMON /LHEAD1/LABTOP,LABBOT,D,T                                  
      CHARACTER LABTOP*80,LABBOT*40,D*10,T*10                           
      COMMON /LHEAD2/NCT,NCB                                            
      CHARACTER*(*) LABEL                                               
      EXTERNAL LHEAD                                                    
C                                                                       
      NCT=ISIGN(MIN(IABS(NLABEL),80),NLABEL)                            
      LABTOP=LABEL                                                      
      RETURN                                                            
C                                                                       
      ENTRY LBLBOT(LABEL,NLABEL)                                        
      NCB=ISIGN(MIN(IABS(NLABEL),40),NLABEL)                            
      LABBOT=LABEL                                                      
      CALL DATI(D,T)                                                    
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      BLOCK DATA POS                                                    
C                                                                       
C***********************************************************************
C     INITIALIZING PLOT POSITION VECTOR KP(M). THIS VECTOR IS UPDATED  *
C IN THE SUBROUTINES NFRAME AND WRTEXT. OCCUPIED POSITIONS RESULT IN   *
C FRAME ADVANCE.                                                       *
C                                                                      *
C     WRITTEN BY HANS GOEDBLOED 3/12/91.                               *
C     Added option M = 19 (MX=4,MY=1) for square frames, jpg 17/07/07. *
C***********************************************************************
C                                                                       
      COMMON /KPOS/KP(19)                                               
C                                                                       
C     * PLOT POSITIONS:                                                 
C M:       1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19      
C MX,MY:  11 12 13 14 15 16 21 22 23 24 25 26 31 32 33 34 35 36 41      
C                                                                       
      DATA (KP(M),M=1,19)                                               
     >   / 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 /    
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE NFRAME(MX,MY,IOP,XMIN,XMAX,YMIN,YMAX,                  
     A                  TITLE,NTITLE,XNAME,NXNAME,YNAME,NYNAME)         
C                                                                       
C***********************************************************************
C     NFRAME IS THE INTERFACE DRIVER FOR THE HIGH-LEVEL ROUTINES, SUCH *
C AS LPLOT, AND THE LOW-LEVEL ROUTINES, SUCH AS SBLIN, WHICH SCALES    *
C THE BOTTOM BOUNDARY OF THE PLOT LINEARLY.  NFRAME DEFINES THE GRAPH  *
C AREA AND THE SCALING ALONG X AND Y FROM THE MX AND MY VALUES PASSED  *
C TO IT.  IT HAS THE GRID, SPECIFIED IN THE IOP VALUE, DRAWN AND THE   *
C AXES SCALED ACCORDING TO THE MINIMUM AND MAXIMUM VALUES OF THE X AND *
C Y ARRAYS AND THE GIVEN IOP.  IT HANDLES PLACEMENT OF THE TITLES OF   *
C THE PLOT AND THE AXES.  IT ALSO PLACES THE TOP AND BOTTOM LABELS ON  *
C THE PAGE.  IT STORES THE SCALING INFORMATION IN COMMON BLOCK CJE07   *
C FOR FUTURE CALLS TO THE SAME (IMX,IMY) FRAME ON THE PAGE.  NFRAME    *
C AUTOMATICALLY ADVANCES A PAGE WITH THE FIRST PLOT THAT EXTENDS INTO  *
C THE UPPER LEFT-HAND CORNER.                                          *
C                                                                      *
C     ARGUMENTS:                                                       *
C                                                                      *
C MX     - DEFINES THE GRAPH AREA AND THE SCALING IN THE X-DIRECTION   *
C          ACCORDING TO THE FORMULA                                    *
C             IABS(MX) = IIX*1000 + IAX*100 + ISX*10 + IMX ,           *
C          WHERE IMX DETERMINES THE HORIZONTAL EXTENSION OF THE PLOT:  *
C             IMX = 1 - FULL PAGE                                      *
C                   2 - LEFT HALF OF THE PAGE                          *
C                   3 - RIGHT HALF OF THE PAGE                         *
C                   4 - full page of reduced size for square frames,   *
C          AND ISX DETERMINES THE SCALING ALONG THE X-AXIS:            *
C             ISX = 0 - AUTOMATIC SCALING WITH EXPANSION (DEFAULT)     *
C                   1 - EXACT SCALING (NO ROUNDING)                    *
C                   2 - EQUIDISTANT SCALING WITH THE X-SCALE ADAPTED   *
C                       TO THE LENGTHS ALONG Y (SEE NOTE IN NFRAME),   *
C          AND IAX PROVIDES AN ADDITIONAL OPTION:                      *
C             IAX = 0 - NO ACTION (DEFAULT)                            *
C                   1 - X=0 AXIS IS DRAWN  (IF IT LIES IN THE RANGE)   *
C                   2 - X=0 AXIS IS DASHED (IF IT LIES IN THE RANGE),  *
C          AND IIX OVERRULES THE DEFAULT NUMBER OF SCALE INTERVALS:    *
C             IIX = 0 - 4 INTERVALS FOR SCALES AND TICKMARKS (DEFAULT) *
C             IIX > 0 - IIX INTERVALS (NOT FOR AUTOMATIC SCALING).     *
C          MX < 0 : PLOTTING OF SCALES AND TICK MARKS SUPPRESSED.      *
C MY     - DEFINES THE GRAPH AREA AND THE SCALING IN THE Y-DIRECTION,  *
C          ANALOGOUS TO THE ABOVE EXPRESSIONS WITH X REPLACED BY Y,    *
C          WHERE IMY DETERMINES THE VERTICAL EXTENSION OF THE PLOT:    *
C             IMY = 1 - FULL PAGE                                      *
C                   2 - TOP HALF OF THE PAGE                           *
C                   3 - BOTTOM HALF OF THE PAGE                        *
C                   4 - TOP THIRD OF THE PAGE                          *
C                   5 - MIDDLE THIRD OF THE PAGE                       *
C                   6 - BOTTOM THIRD OF THE PAGE.                      *
C IOP    - EQUALS THE SCALING OPTION JOP OF SUBROUTINE LPLOT:          *
C             JOP = 1 - LINEAR X-AXIS, LINEAR Y-AXIS                   *
C                   2 - LINEAR X-AXIS, LOG Y-AXIS                      *
C                   3 - LOG X-AXIS, LINEAR Y-AXIS                      *
C                   4 - LOG X-AXIS, LOG Y-AXIS                         *
C                   5 - LINEAR X-AXIS, LINEAR Y-AXIS (BUT PLOTTING OF  *
C                       FRAME, SCALES, AND TICK MARKS SUPPRESSED).     *
C XMIN   - MINIMUM VALUE OF X.                                         *
C XMAX   - MAXIMUM VALUE OF X.                                         *
C YMIN   - MINIMUM VALUE OF Y.                                         *
C YMAX   - MAXIMUM VALUE OF Y.                                         *
C          THESE FOUR EXTREME VALUES ARE EITHER PRESCRIBED BY THE USER *
C          THROUGH A DIRECT CALL OF NFRAME (FOLLOWED BY CALLS TO LPLOT *
C          WITH NPTS < 0) OR DETERMINED AUTOMATICALLY BY LPLOT ITSELF. *
C TITLE  - TITLE FOR THE GRAPH.                                        *
C NTITLE - THE NUMBER OF CHARACTERS IN NTITLE.                         *
C XNAME  - LABEL FOR THE X-AXIS.                                       *
C NXNAME - NUMBER OF CHARACTERS IN XNAME.                              *
C YNAME  - LABEL FOR THE Y-AXIS.                                       *
C NYNAME - NUMBER OF CHARACTERS IN YNAME.                              *
C          THE ABOVE THREE CHARACTER STRINGS ARE AUTOMATICALLY TRUN-   *
C          CATED TO FIT ALONGSIDE THE CHOSEN FRAME.  THE FONT MAY BE   *
C          CHANGED ACCORDING TO THE RULES GIVEN IN DLCH.               *
C                                                                      *
C     NOTE:                                                            *
C THE SCALING ISX/Y=2 IS USED TO PRESERVE THE RELATIVE PROPORTIONS OF  *
C GEOMETRIC FIGURES.  E.G., A STANDING ELLIPSE X=COS(T), Y=1.5*SIN(T)  *
C IS PLOTTED ON THE LEFT HALF OF THE PAGE WITH THESE CALLS:            *
C     "CALL NFRAME(22,11,1,-1.,1.,-2.,2.,'ELLIPSE',7,'X',1,'Y',1)",    *
C     "CALL LPLOT(2,1,1,X,Y,-NPTS,1,' ',0,' ',0,' ',0)".               *
C SINCE THE RANGE OF X IS DETERMINED AUTOMATICALLY IN THIS CASE, THE   *
C PARAMETERS XMIN=-1.0 AND XMAX=1.0 ONLY FIX THE CENTRAL VALUE X=0.    *
C                                                                      *
C     OFRAME(MX,MY) IS AN ENTRY POINT INTO NFRAME; IT RESTORES THE     *
C PLOTTING COMMON CJE07 TO THE CONDITIONS OF THE PARTICULAR (IMX,IMY)  *
C PLOT DETERMINED BY THE LAST CALL TO NFRAME, TO PLOT A SECOND AND     *
C THIRD CURVE ON THE SAME PLOT.                                        *
C                                                                      *
C     SETADV(IA) IS ANOTHER ENTRY POINT INTO NFRAME; IT OVERRIDES THE  *
C AUTOMATIC ADVANCE AND PRINTING OF TOP AND BOTTOM LABELS (IN EFFECT   *
C FOR THE DEFAULT VALUE IA = 0).  IA = 1 / -1 : ADVANCE / NO ADVANCE,  *
C IRRESPECTIVE OF THE VALUES OF IMX AND IMY.                           *
C                                                                      *
C     WRITTEN BY CLAIR NIELSON.                                        *
C     MODIFIED BY DEBBY HYMAN 2/80 FOR SCALING AXES NICELY.            *
C     MODIFIED BY DICK HOGEWEIJ 21/06/84 FOR EQUIDISTANT SCALINGS.     *
C     MODIFIED BY HANS GOEDBLOED 14/11/85 FOR ADAPTATION TO NEW DLCH,  *
C     NEW MEANING OF ARGUMENTS MX,MY, IMPROVED EQUIDISTANT SCALING,    *
C     IMPROVED HANDLING OF THE LABELS.                                 *
C     NEW FRAME ADVANCE, ROUNDING OF LOG SCALES, JPG 4/11/91.          *
C                                                                      *
c     Increased plotting resolution with parameter KR (JPG 6/11/99).   *
c     External LHEAD, POS added by Sander Belien (15/12/99).           *
c     Extended with option for square frames, jpg 17/07/07.            *
c     Changed top/bottom labels for proportional fonts, jpg 4/09/07.   *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
c                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /KPOS/KP(19)                                               
      COMMON /LHEAD1/LABTOP,LABBOT,D,T                                  
      CHARACTER LABTOP*80,LABBOT*40,D*10,T*10                           
      COMMON /LHEAD2/NCT,NCB                                            
      CHARACTER*(*) TITLE,XNAME,YNAME                                   
      DIMENSION JXL(4),JXR(4),JYB(6),JYT(6),                            
     A          IXL(19),IXR(19),IYB(19),IYT(19),                        
     B          XL(19),XR(19),YB(19),YT(19),                            
     C          NPOS(19,19)                                             
      LOGICAL FLOGX,FLOGY                                               
      INTEGER ASW                                                       
      SAVE IXL,IXR,IYB,IYT,XL,XR,YB,YT,ASW,NPOS                         
      EXTERNAL LHEAD,POS                                                
C                                                                       
C     * FRAME COORDINATES.                                              
C     * FOR KR=1 (original ones):                                       
C      DATA JXL/ 90, 90,590/                                            
C      DATA JXR/990,490,990/                                            
C      DATA JYB/ 77,437, 77,557,317, 77/                                
C      DATA JYT/722,722,362,722,482,242/                                
C     * FOR KR=9:                                                       
      DATA JXL/ 810, 810,5310, 810/                                     
      DATA JXR/8910,4410,8910,6615/                                     
      DATA JYB/ 693,3933, 693,5013,2853, 693/                           
      DATA JYT/6498,6498,3258,6498,4338,2178/                           
      DATA ASW/0/                                                       
C                                                                       
C     * DECISION TABLE FOR FRAME ADVANCE.                               
C M:       1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16 17 18 19      
C MX,MY:  11 12 13 14 15 16 21 22 23 24 25 26 31 32 33 34 35 36 41      
C                                                                       
      DATA ((NPOS(N,M),N=1,19),M=1,19)                                  
     1   / 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,     
     2     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,     
     3     1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1,     
     4     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,     
     5     1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1,     
     6     1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1,     
     7     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,     
     8     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,     
     9     1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1,     
     *     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,     
     1     1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1,     
     2     1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1,     
     3     1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1,     
     4     1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1,     
     5     1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1,     
     6     1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1,     
     7     1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1,     
     8     1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1,     
     9     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 /    
C                                                                       
C     * INPUT PARAMETERS.                                               
      IMX=MOD(IABS(MX),10)                                              
      IMY=MOD(IABS(MY),10)                                              
      ISX=MOD(IABS(MX)/10,10)                                           
      ISY=MOD(IABS(MY)/10,10)                                           
      IAX=MOD(IABS(MX)/100,10)                                          
      IAY=MOD(IABS(MY)/100,10)                                          
      IIX=MOD(IABS(MX)/1000,10)                                         
      IIY=MOD(IABS(MY)/1000,10)                                         
      M=IMY+6*IMX-6                                                     
      IF(M.GT.19) STOP '*** NFRAME: IMX OR IMY TOO BIG ***'             
      JOP=MOD(IABS(IOP),10)                                             
      FLOGX=.FALSE.                                                     
      FLOGY=.FALSE.                                                     
      IF(JOP.EQ.3.OR.JOP.EQ.4) FLOGX=.TRUE.                             
      IF(JOP.EQ.2.OR.JOP.EQ.4) FLOGY=.TRUE.                             
C                                                                       
C     * ADVANCE A PAGE AND DRAW TOP AND BOTTOM LABELS.                  
      IADV=0                                                            
      DO 10 N=1,19                                                      
   10    IADV=IADV+KP(N)*NPOS(N,M)                                      
      IF((ASW.EQ.0.AND.IADV.NE.0).OR.(ASW.EQ.1)) THEN                   
         CALL ADV(1)                                                    
         DO 20 N=1,19                                                   
   20       KP(N)=0                                                     
         ICEN=(JXR(1)+JXL(1))/2                                         
         IF(M.EQ.19) ICEN=(JXR(4)+JXL(4))/2                             
c        * postscript comment                                           
         WRITE(IPS,'(/A14)') '%%%%Label top:' 
         CALL DLCH(ICEN,766*KR,LABTOP,NCT,-2)             
c        * postscript comment                                           
         WRITE(IPS,'(/A17)') '%%%%Label bottom:'                        
         CALL DLCH(ICEN,0*KR,LABBOT,NCB,-3)               
c        * postscript comment                                           
         WRITE(IPS,'(/A18)') '%%%%Date and time:'                       
         CALL DLCH(25*KR,17*KR,D,8,1)                                  
         CALL DLCH(25*KR,2*KR,T,8,1)                                    
      ENDIF                                                             
      IF(ASW.NE.0) ASW=0                                                
      KP(M)=1                                                           
C                                                                       
C     * COMPUTE FRAME COORDINATES.                                      
      IXL(M)=JXL(IMX)                                                   
      IXR(M)=JXR(IMX)                                                   
      IYB(M)=JYB(IMY)                                                   
      IYT(M)=JYT(IMY)                                                   
C     * B GODFREY'S IDEA TO FORCE NORMALIZATION:                        
      XLN=XMIN+0.0                                                      
      XRN=XMAX+0.0                                                      
      IF(XLN.EQ.XRN) THEN                                               
         XLN=(1.0-SIGN(0.5,XLN))*XLN-1.0E-6                             
         XRN=(1.0+SIGN(0.5,XRN))*XRN+1.0E-6                             
      ENDIF                                                             
      IF(FLOGX) THEN                                                    
         XLN=ALOG19(XLN)                                                
         XRN=ALOG19(XRN)                                                
C        * LIMIT DECADES PLOTTED TO MOST SIGNIFICANT, HEWETT 6/9/83     
         XLN=DMAX1(XLN,XRN-24.)                                         
      ENDIF                                                             
      YBN=YMIN+0.0                                                      
      YTN=YMAX+0.0                                                      
      IF(YBN.EQ.YTN) THEN                                               
         YBN=(1.0-SIGN(0.5,YBN))*YBN-1.0E-6                             
         YTN=(1.0+SIGN(0.5,YTN))*YTN+1.0E-6                             
      ENDIF                                                             
      IF(FLOGY) THEN                                                    
         YBN=ALOG19(YBN)                                                
         YTN=ALOG19(YTN)                                                
C        * LIMIT DECADES PLOTTED TO MOST SIGNIFICANT, HEWETT 6/9/83     
         YBN=DMAX1(YBN,YTN-24.)                                         
      ENDIF                                                             
      XL(M)=XLN                                                         
      XR(M)=XRN                                                         
      YB(M)=YBN                                                         
      YT(M)=YTN                                                         
C     * IF XMAX <= XMIN FOR A PARTICULAR FRAME,                         
C     * MAKE XMAX = XMIN + 1.0 AT LEAST.                                
      IF(XR(M).LE.XL(M)) XR(M)=XL(M)+DMAX1(1.D+0,XL(M))                 
      IF(YT(M).LE.YB(M)) YT(M)=YB(M)+DMAX1(1.D+0,YB(M))                 
C                                                                       
C     * NUMBER OF INTERVALS NX FOR EXACT AND AUTOMATIC SCALING.         
      NX=4                                                              
      IF(ISX.NE.0.AND.IIX.NE.0) NX=IIX                                  
C     * AUTOMATIC SCALING.                                              
      IF(ISX.EQ.0.AND.(.NOT.FLOGX)) THEN                                
         CALL ASCL(3,XL(M),XR(M),NX,IDUM,JDUM)                          
         IF(NX.GT.5) THEN                                               
            IDIFF=XR(M)-XL(M)                                           
            IF(MOD(IDIFF,5).EQ.0) NX=5                                  
            IF(MOD(IDIFF,4).EQ.0) NX=4                                  
            IF(MOD(IDIFF,3).EQ.0) NX=3                                  
         ENDIF                                                          
      ENDIF                                                             
C     * ROUNDING OF LOG SCALES.                                         
      IF(ISX.EQ.0.AND.(FLOGX)) THEN                                     
         XL(M)=DMIN1(AINT(XL(M)),SIGN(AINT(ABS(XL(M))+.999),XL(M)))     
         XR(M)=DMAX1(AINT(XR(M)),SIGN(AINT(ABS(XR(M))+.999),XR(M)))     
      ENDIF                                                             
C                                                                       
C     * NUMBER OF INTERVALS NY FOR EXACT AND AUTOMATIC SCALING.         
      NY=4                                                              
      IF(ISY.NE.0.AND.IIY.NE.0) NY=IIY                                  
C     * AUTOMATIC SCALING.                                              
      IF(ISY.EQ.0.AND.(.NOT.FLOGY)) THEN                                
         CALL ASCL(3,YB(M),YT(M),NY,IDUM,JDUM)                          
         IF(NY.GT.5) THEN                                               
            IDIFF=YT(M)-YB(M)                                           
            IF(MOD(IDIFF,5).EQ.0) NY=5                                  
            IF(MOD(IDIFF,4).EQ.0) NY=4                                  
            IF(MOD(IDIFF,3).EQ.0) NY=3                                  
         ENDIF                                                          
      ENDIF                                                             
C     * ROUNDING OF LOG SCALES.                                         
      IF(ISY.EQ.0.AND.(FLOGY)) THEN                                     
         YB(M)=DMIN1(AINT(YB(M)),SIGN(AINT(ABS(YB(M))+.999),YB(M)))     
         YT(M)=DMAX1(AINT(YT(M)),SIGN(AINT(ABS(YT(M))+.999),YT(M)))     
      ENDIF                                                             
C                                                                       
C     * INITIALIZE COORDINATES OF THE EXTREME TICK MARKS.               
      IXLX=IXL(M)                                                       
      IXRX=IXR(M)                                                       
      IYBX=IYB(M)                                                       
      IYTX=IYT(M)                                                       
      XLX=XL(M)                                                         
      XRX=XR(M)                                                         
      YBX=YB(M)                                                         
      YTX=YT(M)                                                         
C                                                                       
C     * EQUIDISTANT SCALING WITH X-SCALE ADAPTED; ADDED 210684 GMDH.    
      IF(ISX.EQ.2.AND.(.NOT.FLOGX)) THEN                                
         IF(ISY.EQ.2) STOP '*** NFRAME: ISX=ISY=2 FORBIDDEN ***'        
C        * CENTER X-INTERVAL WITH RESPECT TO PLOTTING AREA; JPG 25/11/85
         XMID=.5*(XL(M)+XR(M))                                          
         FAC=(YT(M)-YB(M))*(IXR(M)-IXL(M))/(IYT(M)-IYB(M))              
         XL(M)=XMID-.5*FAC                                              
         XR(M)=XMID+.5*FAC                                              
         IDIVY=(IYT(M)-IYB(M))/NY                                       
         DIVY=(YT(M)-YB(M))/NY                                          
         RMULT=(XL(M)-YB(M))/DIVY                                       
         MULT=RMULT                                                     
         IF(MULT.LT.RMULT) MULT=MULT+1                                  
         XLX=YB(M)+MULT*DIVY                                            
         IXLX=IXL(M)+(XLX-XL(M))*(IXR(M)-IXL(M))/(XR(M)-XL(M))          
         NX=0                                                           
         XRX=XLX                                                        
   30    IF((XRX+DIVY).LE.XR(M)) THEN                                   
            XRX=XRX+DIVY                                                
            NX=NX+1                                                     
            GOTO 30                                                     
         ENDIF                                                          
         IXRX=IXLX+IDIVY*NX                                             
      ENDIF                                                             
C                                                                       
C     * EQUIDISTANT SCALING WITH Y-SCALE ADAPTED; ADDED 210684 GMDH.    
      IF(ISY.EQ.2.AND.(.NOT.FLOGY)) THEN                                
C        * CENTER Y-INTERVAL WITH RESPECT TO PLOTTING AREA; JPG 25/11/85
         YMID=.5*(YB(M)+YT(M))                                          
         FAC=(XR(M)-XL(M))*(IYT(M)-IYB(M))/(IXR(M)-IXL(M))              
         YB(M)=YMID-.5*FAC                                              
         YT(M)=YMID+.5*FAC                                              
         IDIVX=(IXR(M)-IXL(M))/NX                                       
         DIVX=(XR(M)-XL(M))/NX                                          
         RMULT=(YB(M)-XL(M))/DIVX                                       
         MULT=RMULT                                                     
         IF(MULT.LT.RMULT) MULT=MULT+1                                  
         YBX=XL(M)+MULT*DIVX                                            
         IYBX=IYB(M)+(YBX-YB(M))*(IYT(M)-IYB(M))/(YT(M)-YB(M))          
         NY=0                                                           
         YTX=YBX                                                        
   40    IF((YTX+DIVX).LE.YT(M)) THEN                                   
            YTX=YTX+DIVX                                                
            NY=NY+1                                                     
            GOTO 40                                                     
         ENDIF                                                          
         IYTX=IYBX+IDIVX*NY                                             
      ENDIF                                                             
C                                                                       
C     * DEFINE THE GRAPH AREA AND EXTREME TICK MARKS.                   
      CALL DGA(IXL(M),IXR(M),IYB(M),IYT(M),XL(M),XR(M),YB(M),YT(M))     
      CALL DGAX(IXLX,IXRX,IYBX,IYTX,XLX,XRX,YBX,YTX)                    
C                                                                       
C     * SUPPRESS PLOTTING OF THE SCALES IF MX/Y < 0.                    
      IF(MX.LT.0) NX=0                                                  
      IF(MY.LT.0) NY=0                                                  
C                                                                       
C     * DRAW FRAME, TICK MARKS, AND SCALES (EXCEPT FOT JOP=5).          
c     * postscript comment                                              
      WRITE(IPS,'(/A33//A33)')                                          
     >          '%%%%New frame%%%%%%%%%%%%%%%%%%%%',                    
     >          '%%%%Frame, tickmarks, and scales:'                     
      IF(JOP.EQ.1) THEN                                                 
         CALL DLNLN(NX,NY,1,IAX,IAY)                                    
         CALL SBLIN(NX)                                                 
         CALL SLLIN(NY)                                                 
      ELSEIF(JOP.EQ.2) THEN                                             
         CALL DLNLG(NX,NY)                                              
         CALL SBLIN(NX)                                                 
         CALL SLLOG(NY)                                                 
      ELSEIF(JOP.EQ.3) THEN                                             
         CALL DLGLN(NX,NY)                                              
         CALL SBLOG(NX)                                                 
         CALL SLLIN(NY)                                                 
      ELSEIF(JOP.EQ.4) THEN                                             
         CALL DLGLG(NX,NY)                                              
         CALL SBLOG(NX)                                                 
         CALL SLLOG(NY)                                                 
      ELSEIF(JOP.EQ.5) THEN                                             
C        * DRAW X/Y=0 AXIS WHEN IAX/Y.NE.0.                             
         CALL DLNLN(0,0,0,IAX,IAY)                                      
      ENDIF                                                             
C                                                                       
C     * LABELS OF THE AXES AND TITLE.                                   
C     * MAXIMUM NUMBER OF CHARACTERS FITTING ALONG THE FRAME:           
      MCX=33                                                            
      IF(IMX.EQ.1) MCX=75                                               
      MCY=13                                                            
      IF(IMY.EQ.2.OR.IMY.EQ.3) MCY=23                                   
      IF(IMY.EQ.1) MCY=53                                               
C     * TRUNCATE IF THE STRING IS TOO LONG, WHILE ACCOUNTING FOR THE    
C     * DIFFERENT MEANING OF THE ARGUMENTS FOR SINGLE CHARACTER CODING: 
      NXNAM1=ISIGN(MIN(IABS(NXNAME),MCX-6),NXNAME)                      
      IXNAME=(IXL(M)+IXR(M))/2-6*IABS(NXNAM1)*KR                        
      IF((LEN(XNAME).EQ.1).AND.(NXNAME.NE.1)) THEN                      
         NXNAM1=NXNAME                                                  
         IXNAME=(IXL(M)+IXR(M))/2-6*KR                                  
      ENDIF                                                             
      NYNAM1=ISIGN(MIN(IABS(NYNAME),MCY),NYNAME)                        
      IYNAME=(IYB(M)+IYT(M))/2-6*IABS(NYNAM1)*KR                        
      IF((LEN(YNAME).EQ.1).AND.(NYNAME.NE.1)) THEN                      
         NYNAM1=NYNAME                                                  
         IYNAME=(IYB(M)+IYT(M))/2-6*KR                                  
      ENDIF                                                             
      NTITL1=ISIGN(MIN(IABS(NTITLE),MCX),NTITLE)                        
      ITITLE=(IXL(M)+IXR(M))/2-6*IABS(NTITL1)*KR                        
c     * postscript comment                                              
      WRITE(IPS,'(/A30)') '%%%%Labels title, x and y axis'              
      CALL DLCH(ITITLE,IYT(M)+8*KR,TITLE,NTITL1,2)                      
      CALL DLCH(IXNAME,IYB(M)-43*KR,XNAME,NXNAM1,2)                     
      CALL DLCV(IXL(M)-64*KR,IYNAME,YNAME,NYNAM1,2)                     
c     * postscript marker                                               
      WRITE(IPS,'(/,A33)') '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'          
      RETURN                                                            
C                                                                       
C     * ENTRY FOR RESTORING PLOTTING COMMON CJE07.                      
      ENTRY OFRAME(MX,MY)                                               
      IMX=MOD(IABS(MX),10)                                              
      IMY=MOD(IABS(MY),10)                                              
      M=IMY+6*IMX-6                                                     
      IF(M.GT.19) STOP '*** OFRAME: IMX OR IMY TOO BIG ***'             
      CALL DGA(IXL(M),IXR(M),IYB(M),IYT(M),XL(M),XR(M),YB(M),YT(M))     
      RETURN                                                            
C                                                                       
C     * ENTRY FOR MANUAL ADVANCE BEFORE NEXT PLOT.                      
      ENTRY SETADV(IA)                                                  
      ASW=IA                                                            
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE ASCL(M,ZMIN,ZMAX,MAJOR,MINOR,KF)                       
C                                                                       
C***********************************************************************
C     THIS ROUTINE PROVIDES THE AUTOMATIC SCALING OF THE GRAPH BOUN-   *
C DARIES TO ROUNDED DECIMAL NUMBERS AND COMPUTES THE ASSOCIATED PARAM- *
C ETERS FOR THE LINEAR GRID DRAWING SUBROUTINES.                       *
C                                                                      *
C M     - ON INPUT, MINIMUM NUMBER OF MAJOR INTERVALS (1 <= M <= 20).  *
C         IT IS SUGGESTED THAT M BE FAIRLY SMALL (E.G. 4 OR 5) IN      *
C         ORDER TO PREVENT THE NUMERICAL SCALE FROM RUNNING TOGETHER.  *
C         THIS DEPENDS ON HOW MUCH OF THE PLOTTING AREA IS TO BE USED  *
C         AND ON THE NUMBER OF CHARACTERS WHICH WILL BE NEEDED FOR     *
C         EACH SCALE NUMBER.                                           *
C ZMIN  - ON INPUT, THE VALUE OF THE SMALLER ENDPOINT.                 *
C         ON OUTPUT, THE VALUE OF THE NEW SMALLER ENDPOINT.            *
C ZMAX  - ON INPUT, THE VALUE OF THE LARGER ENDPOINT.                  *
C         ON OUTPUT, THE VALUE OF THE NEW LARGER ENDPOINT.             *
C MAJOR - ON OUTPUT, THE NUMBER OF MAJOR INTERVALS AT WHICH TO PLACE   *
C         TICK MARKS AND A NUMERIC SCALE.                              *
C MINOR - ON OUTPUT, THE NUMBER OF MINOR INTERVALS AT WHICH TO PLACE   *
C         TICK MARKS AND A NUMERIC SCALE.                              *
C KF    - ON OUTPUT, THE FORMAT CODE DESCRIBING THE NUMBER OF DIGITS   *
C         NECESSARY TO DISPLAY THE SCALE NUMBERS UNIQUELY.  KF IS AN   *
C         INTEGER (0 <= KF <= 6 OR 10 <= KF <= 16) SUCH THAT THE UNITS *
C         DIGIT SPECIFIES THE NUMBER OF DIGITS TO BE PRINTED TO THE    *
C         RIGHT OF THE DECIMAL POINT.  A TENS DIGIT OF ZERO INDICATES  *
C         FIXED POINT FORMAT (F FORMAT) AND A TENS DIGIT OF ONE INDI-  *
C         CATES FLOATING POINT FORMAT (E FORMAT).  THIS FORMAT CODE    *
C         WAS USED PREVIOUSLY FOR PLACING A NUMERIC SCALE ALONG  THE   *
C         GRAPH BOUNDARY USING THE SCALE BOUNDARY ROUTINES SBLIN AND   *
C         SLLIN.  THE PRESENT VERSIONS OF THE LATTER SUBROUTINES DO    *
C         NOT HAVE THIS INPUT ARGUMENT ANYMORE.                        *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      Z1=ZMIN                                                           
      Z2=ZMAX                                                           
      AM=M                                                              
C                                                                       
C     * ZMAX <= ZMIN, M <= 0, AND M > 20 ARE INVALID VALUES: RETURN.    
      IF((Z2.LE.Z1).OR.(M.LE.0.OR.M.GT.20)) THEN                        
         MAJOR=0                                                        
         MINOR=0                                                        
         KF=0                                                           
         RETURN                                                         
      ENDIF                                                             
C                                                                       
      IF(Z2.NE.0.AND.Z1.NE.0) THEN                                      
         ZBAR=Z2/Z1                                                     
         IF(ABS(ZBAR).GE.1000.) THEN                                    
            Z1=0.                                                       
         ELSEIF(ABS(ZBAR).LE..001) THEN                                 
            Z2=0.                                                       
         ELSEIF(ABS(ZBAR-1.).LE..000005*AM) THEN                        
            ZBAR=(Z2+Z1)/2.                                             
            Z=.0000026*AM*ABS(ZBAR)                                     
            Z2=ZBAR+Z                                                   
            Z1=ZBAR-Z                                                   
            GOTO 10                                                     
         ENDIF                                                          
      ENDIF                                                             
      IF(Z2-Z1.NE.AM) THEN                                              
         Z2=Z2-.000001*ABS(Z2)                                          
         Z1=Z1+.000001*ABS(Z1)                                          
      ENDIF                                                             
   10 P=(Z2-Z1)/AM                                                      
      IFLAG=0                                                           
      TENK=1.                                                           
      K=0                                                               
      IF(P.LT.1.) THEN                                                  
         IFLAG=1                                                        
         P=1./P                                                         
      ENDIF                                                             
   20 IF(P.GE.10000.) THEN                                              
         P=P/10000.                                                     
         TENK=TENK*10000.                                               
         K=K+4                                                          
         GOTO 20                                                        
      ENDIF                                                             
   30 IF(P.GE.10.) THEN                                                 
         P=P/10.                                                        
         TENK=TENK*10.                                                  
         K=K+1                                                          
         GOTO 30                                                        
      ENDIF                                                             
      IF(IFLAG.NE.0) THEN                                               
         P=10./P                                                        
         TENK=.1/TENK                                                   
         K=-K-1                                                         
      ENDIF                                                             
      IF(P.LT.2.) THEN                                                  
         P=1.                                                           
         NM=5                                                           
      ELSEIF(P.LT.5) THEN                                               
         P=2.                                                           
         NM=4                                                           
      ELSEIF(P.GE.5.) THEN                                              
         P=5.                                                           
         NM=5                                                           
      ENDIF                                                             
      DZ=P*TENK                                                         
      N1=Z1/DZ                                                          
      FN=N1                                                             
      Z=FN*DZ                                                           
      IF(Z.GT.Z1) THEN                                                  
         Z=Z-DZ                                                         
         N1=N1-1                                                        
      ENDIF                                                             
      Z1=Z                                                              
      N2=Z2/DZ                                                          
      FN=N2                                                             
      Z=FN*DZ                                                           
      IF(Z.LT.Z2) THEN                                                  
         N2=N2+1                                                        
         Z=Z+DZ                                                         
      ENDIF                                                             
      Z2=Z                                                              
      IF(K.LE.0.AND.K.GE.-5) THEN                                       
         K=-K                                                           
         GOTO 50                                                        
      ENDIF                                                             
      IF(ABS(Z2).LE.ABS(Z1)) THEN                                       
         Z=ABS(Z1)                                                      
      ELSE                                                              
         Z=ABS(Z2)                                                      
      ENDIF                                                             
      Z=Z/TENK                                                          
      J=0                                                               
   40 IF(Z.GE.10.) THEN                                                 
         Z=Z/10.                                                        
         J=J+1                                                          
         GOTO 40                                                        
      ENDIF                                                             
      IF(K.GE.0.AND.J+K.LE.5) THEN                                      
         K=0                                                            
      ELSE                                                              
         K=10+J                                                         
         IF(K.LT.11) K=11                                               
      ENDIF                                                             
C                                                                       
   50 ZMIN=Z1                                                           
      ZMAX=Z2                                                           
      MAJOR=N2-N1                                                       
      MINOR=NM*MAJOR                                                    
      KF=K                                                              
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DGA(IX1,IX2,IY1,IY2,X1,X2,Y1,Y2)                       
C                                                                       
C***********************************************************************
C     THIS ROUTINE DEFINES THE GRAPH AREA.  THE FIRST FOUR ARGUMENTS   *
C DEFINE THE FRAME COORDINATES FOR THE BOUNDARIES OF THE GRAPH AREA.   *
C THE NEXT FOUR ARGUMENTS ARE THE FLOATING-POINT VALUES ASSIGNED TO    *
C THE BOUNDARIES.  IF IXL > IXR, AND SIMILARLY IF IYB > IYT, THEY ARE  *
C REVERSED. BOUNDARY COORDINATES ARE TESTED FOR 0*KR < RANGE < 1023*KR;*
C IF THEY ARE OUT OF RANGE, THEIR VALUES ARE SET TO THE APPROPRIATE    *
C MINIMUM OR MAXIMUM VALUE.  THERE ARE NO RESTRICTIONS ON XL, XR, YB,  *
C OR YT OTHER THAN NORMAL MACHINE LIMITS.  THE VALUES ARE STORED IN    *
C COMMON BLOCK CJE07.                                                  *
C     ENTRY DGAX FILLS COMMON /CJE07X/ WITH THE FRAME COORDINATES AND  *
C FLOATING-POINT VALUES BELONGING TO THE MINIMUM/MAXIMUM LOCATIONS OF  *
C THE TICK MARKS.                                                      *
C                                                                      *
C     MODIFIED 210684 GMDH: ADDED COMMON /CJE07X/ AND ENTRY DGAX.      *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      COMMON /CJE07X/XLX,XRX,YBX,YTX,IXLX,IXRX,IYBX,IYTX                
C                                                                       
      IXL=MIN(MAX(0*KR,MIN(IX1,IX2)),1023*KR)                           
      IXR=MIN(MAX(0*KR,MAX(IX1,IX2)),1023*KR)                           
      IYB=MIN(MAX(0*KR,MIN(IY1,IY2)),1023*KR)                           
      IYT=MIN(MAX(0*KR,MAX(IY1,IY2)),1023*KR)                           
      XL=X1                                                             
      XR=X2                                                             
      YB=Y1                                                             
      YT=Y2                                                             
C                                                                       
C     * ENTRY FOR EQUIDISTANT SCALING.                                  
      ENTRY DGAX(IX1,IX2,IY1,IY2,X1,X2,Y1,Y2)                           
      IXLX=IX1                                                          
      IXRX=IX2                                                          
      IYBX=IY1                                                          
      IYTX=IY2                                                          
      XLX=X1                                                            
      XRX=X2                                                            
      YBX=Y1                                                            
      YTX=Y2                                                            
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE DLGLG(JX,JY)                                           
C                                                                       
C***********************************************************************
C     CALLING SEQUENCES: CALL DLNLN(NX,NY,IBOX,IAX,IAY)                *
C                        CALL DLNLG(NX,JY)                             *
C                        CALL DLGLN(JX,NY)                             *
C                        CALL DLGLG(JX,JY)                             *
C     THESE ARE THE CALLING SEQUENCES FOR DRAWING A FRAME WITH LINEAR- *
C LINEAR, LINEAR-LOG, LOG-LINEAR, AND LOG-LOG GRIDS, RESPECTIVELY.     *
C LINEAR-LOG MEANS THE GRID WILL BE DIVIDED LINEARLY IN THE X-DIREC-   *
C TION AND LOGARITHMICALLY IN THE Y-DIRECTION.  LOG-LINEAR MEANS THE   *
C REVERSE.  NX AND NY REFER TO THE NUMBER OF LINEAR INTERVALS IN THE   *
C X- AND Y-DIRECTIONS.                                                 *
C     THE NUMBER OF LOG CYCLES TO BE DRAWN IS DETERMINED BY THE        *
C FLOATING-POINT VALUES ASSIGNED TO THE APPROPRIATE GRAPH BOUNDARIES.  *
C THE VALUE ASSIGNED TO A SPECIFIC BOUNDARY IN THIS CASE IS THE POWER  *
C OF 10 ASSOCIATED WITH THAT BOUNDARY.  THE DIFFERENCE BETWEEN THE     *
C VALUES ASSIGNED TO THE BOUNDARIES IS THE NUMBER OF LOG CYCLES.  IF   *
C THE NUMBER OF CYCLES EXCEEDS 25, AN ERROR MESSAGE IS PRINTED, AND AN *
C EXIT IS PERFORMED WITHOUT DRAWING ANY CYCLES.  THE LINEAR GRID WILL  *
C BE COMPLETE THOUGH.                                                  *
C                                                                      *
C     MODIFIED JPG 13/11/85: ARGUMENTS JX,JY ADDED TO PERMIT SEPARATE  *
C     SUPPRESSION OF THE TICK MARKS FOR JX/Y=0.                        *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION IXY(4),XY(4)                                            
      EQUIVALENCE (IXY,IXL),(XY,XL)                                     
      DIMENSION ALG(8)                                                  
      CHARACTER*14 MESS1,MESS2(2)                                       
C                                                                       
      DATA (ALG(K),K=1,8) /.30102999566398,.47712125471966,             
     A     .60205999132796,.69897000433602,.77815125038364,             
     B     .84509804001426,.90308998699194,.95424250943933/             
      DATA MESS1/'DECADES EXCEED'/                                      
      DATA MESS2/'  25 NO OF X  ','  25 NO OF Y  '/                     
C                                                                       
C     * ORDER OF EXECUTION IS: FIRST VERTICAL AXIS (ITYPE=2),           
C     * THEN HORIZONTAL AXIS (ITYPE=1).                                 
      IEX=1                                                             
      ITYPE=2                                                           
      CALL BOX(IXL,IXR,IYB,IYT)                                         
C                                                                       
C     * SKIP PLOTTING OF THE VERTICAL SCALE IF JY=0.                    
   10 IF(IEX.EQ.1.AND.JY.EQ.0) GOTO 40                                  
      I1=2*ITYPE-1                                                      
      I2=2*ITYPE                                                        
      Z1=XY(I1)                                                         
      Z2=XY(I2)                                                         
      IF(Z1.EQ.Z2) Z2=Z2+.01                                            
      ZMIN=DMIN1(Z1,Z2)                                                 
      ZMAX=DMAX1(Z1,Z2)                                                 
      ZMIN=DMIN1(AINT(ZMIN),SIGN(AINT(ABS(ZMIN)+.999),ZMIN))            
      ZMAX=DMAX1(AINT(ZMAX),SIGN(AINT(ABS(ZMAX)+.999),ZMAX))            
      Z1=ZMIN                                                           
      Z2=ZMAX                                                           
      NZ=ABS(Z1-Z2)                                                     
      IF(NZ.GT.25) THEN                                                 
         CALL DLCH(500*KR,520*KR,MESS1,14,2)                            
         CALL DLCH(500*KR,500*KR,MESS2(ITYPE),14,2)                     
         RETURN                                                         
      ENDIF                                                             
      IF(NZ.EQ.0) THEN                                                  
         Z11=Z1+1.                                                      
         IF(Z2.LT.Z1) Z11=Z1-1.                                         
         NZ=1                                                           
         Z1=Z11                                                         
      ENDIF                                                             
      IF(XY(I2).GE.XY(I1)) THEN                                         
         IREV=1                                                         
         XY(I1)=Z1                                                      
         XY(I2)=Z2                                                      
      ELSE                                                              
         IREV=2                                                         
         XY(I1)=Z2                                                      
         XY(I2)=Z1                                                      
      ENDIF                                                             
      ISL=(IXY(I2)-IXY(I1))/NZ                                          
      IZC=IXY(I1)                                                       
      DO 30 I=1,NZ                                                      
         DO 20 K=1,8                                                    
            ICZ=IZC+(IREV-1+(3-IREV-IREV)*ALG(K))*ISL                   
            IF(ITYPE.EQ.1) THEN                                         
               CALL DRV(ICZ,IYT-15*KR,ICZ,IYT)                          
               CALL DRV(ICZ,IYB,ICZ,IYB+15)                             
            ELSE                                                        
               CALL DRV(IXL,ICZ,IXL+15,ICZ)                             
               CALL DRV(IXR-15*KR,ICZ,IXR,ICZ)                          
            ENDIF                                                       
   20    CONTINUE                                                       
         IZC=IXY(I1)+(I*(IXY(I2)-IXY(I1)))/NZ                           
         IF(ITYPE.EQ.1) THEN                                            
            CALL DRV(IZC,IYT,IZC,IYT-25*KR)                             
            CALL DRV(IZC,IYB+25*KR,IZC,IYB)                             
         ELSE                                                           
            CALL DRV(IXL,IZC,IXL+25*KR,IZC)                             
            CALL DRV(IXR-25*KR,IZC,IXR,IZC)                             
         ENDIF                                                          
   30 CONTINUE                                                          
      IF(IEX.EQ.2) RETURN                                               
      GOTO 40                                                           
C                                                                       
      ENTRY DLGLN(JX,NY)                                                
      CALL DLNLN(0,NY,1,0,0)                                            
   40 IF(JX.EQ.0) RETURN                                                
      IEX=2                                                             
      ITYPE=1                                                           
      GOTO 10                                                           
C                                                                       
      ENTRY DLNLG(NX,JY)                                                
      CALL DLNLN(NX,0,1,0,0)                                            
      IF(JY.EQ.0) RETURN                                                
      IEX=2                                                             
      ITYPE=2                                                           
      GOTO 10                                                           
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE DLNLN(NX,NY,IBOX,IAX,IAY)                              
C                                                                       
C***********************************************************************
C     THIS ROUTINE DRAWS A FRAME WITH A LINEAR-LINEAR GRID CONSISTING  *
C OF NX EQUALLY SPACED INTERVALS IN THE X-DIRECTION AND NY EQUALLY     *
C SPACED INTERVALS IN THE Y-DIRECTION (0 < NX/Y <= 10).  THE INTERVALS *
C ARE MARKED OFF BY TICKS ON THE BOUNDARIES.                           *
C                                                                      *
C     MODIFIED GMDH 21/06/84: NUMBER OF TICK MARKS INCREASED WITH 1 ON *
C     EACH SIDE OF THE RANGE; COMMON CJE07X ADDED.                     *
C     MODIFIED JPG 13/11/85: SUPPRESS TICK MARKS IF NX/Y=0; ADDED THE  *
C     ARGUMENTS IBOX,IAX,IAY TO SUPPRESS DRAWING OF THE BOX IF IBOX=0  *
C     AND TO DRAW THE X/Y=0 AXIS IF IAX/Y.NE.0.                        *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      COMMON /CJE07X/XLX,XRX,YBX,YTX,IXLX,IXRX,IYBX,IYTX                
C                                                                       
      IF(IBOX.NE.0) CALL BOX(IXL,IXR,IYB,IYT)                           
C                                                                       
      IF(IAX.NE.0.AND.(XL.LT.0..AND.XR.GT.0.)) THEN                     
C        * DRAW X=0 AXIS.                                               
         IX0=(IXL*XR-IXR*XL)/(XR-XL)                                    
         IF(IAX.EQ.1) CALL DRV(IX0,IYB,IX0,IYT)                         
         IF(IAX.EQ.2) CALL DASH(IX0,IYB,IX0,IYT,10*KR,10*KR,0*KR,IDUM)  
      ENDIF                                                             
      IF(NX.NE.0) THEN                                                  
         NXS=MIN(IABS(NX),128)                                          
         DX=REAL(IXRX-IXLX)/NXS                                         
         IIYB=IYB+20*KR                                                 
         IIYT=IYT-20*KR                                                 
         DO 10 I=0,NXS                                                  
            IXS=IXLX+I*DX                                               
            CALL DRV(IXS,IYB,IXS,IIYB)                                  
            CALL DRV(IXS,IYT,IXS,IIYT)                                  
   10    CONTINUE                                                       
      ENDIF                                                             
C                                                                       
      IF(IAY.NE.0.AND.(YB.LT.0..AND.YT.GT.0.)) THEN                     
C        * DRAW Y=0 AXIS.                                               
         IY0=(IYB*YT-IYT*YB)/(YT-YB)                                    
         IF(IAY.EQ.1) CALL DRV(IXL,IY0,IXR,IY0)                         
         IF(IAY.EQ.2) CALL DASH(IXL,IY0,IXR,IY0,10*KR,10*KR,0*KR,IDUM)  
      ENDIF                                                             
      IF(NY.NE.0) THEN                                                  
         NYS=MIN(IABS(NY),128)                                          
         DY=REAL(IYTX-IYBX)/NYS                                         
         IIXR=IXR-20*KR                                                 
         IIXL=IXL+20*KR                                                 
         DO 20 I=0,NYS                                                  
            IYS=IYBX+I*DY                                               
            CALL DRV(IXL,IYS,IIXL,IYS)                                  
            CALL DRV(IXR,IYS,IIXR,IYS)                                  
   20    CONTINUE                                                       
      ENDIF                                                             
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE SBLIN(NX)                                              
C                                                                       
C***********************************************************************
C     THIS ROUTINE PRINTS A LINEAR NUMERIC SCALE ON THE BOTTOM BOUN-   *
C DARY OF A FRAME WITH NX EQUALLY SPACED INTERVALS DRAWN BY DLNLN OR   *
C DLNLG.  THE NUMBERS ARE PRINTED IN F5.2 FORMAT WITH AN ADDITIONAL    *
C POWER OF 10 (IF NEEDED) PRINTED SEPATATELY.  THE DATA FOR THE SCALE  *
C ARE OBTAINED FROM XLX,XRX,YBX,YTX OF COMMON BLOCK CJE07X.            *
C                                                                      *
C     MODIFIED BY DEBBY HYMAN 4/7/80: SCALE FACTOR KS CORRECTED.       *
C     MODIFIED GMDH 21/06/84: ADDED COMMON /CJE07X/.                   *
C     MODIFIED JPG 13/11/85: RETURN ON NX=0.                           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      COMMON /CJE07X/XLX,XRX,YBX,YTX,IXLX,IXRX,IYBX,IYTX                
      CHARACTER*5 OUT                                                   
C                                                                       
      IF(NX.EQ.0) RETURN                                                
C                                                                       
C     * DETERMINE THE SCALE FACTOR KS OF 10.                            
      T=DMAX1(ABS(XLX),ABS(XRX))                                        
      IF(ABS(T).LE.1.E-15) T=1.E-15                                     
      X=ALOG19(T)                                                       
C     * FIX FOR -1.0E7 THAT RETURNS KS=6 INSTEAD OF KS=7:               
      KS=X+SIGN(0.001,X)                                                
C                                                                       
      FACT=10.**(-KS)                                                   
      XLL=XLX*FACT                                                      
      XRR=XRX*FACT                                                      
C                                                                       
C     * WRITE XLL ONTO THE BOUNDARY.                                    
      IYB1=IYB-22*KR                                                    
      WRITE(OUT,'(F5.2)') XLL                                           
      CALL DLCH(IXLX-21*KR,IYB1,OUT,5,2)                                
C                                                                       
C     * DETERMINE THE NUMBER OF INTERVALS TO SCALE (0 < NX <= 10).      
      NXA=MIN(10,IABS(NX))                                              
      DX=(XRR-XLL)/NXA                                                  
      DDX=REAL(IXRX-IXLX)/NXA                                           
C                                                                       
C     * WRITE THE SCALE ONTO THE BOUNDARY.                              
      DO 10 I=1,NXA                                                     
         IXC=IXLX+I*DDX-35*KR                                           
         XC=XLL+I*DX                                                    
         WRITE(OUT,'(F5.2)') XC                                         
         CALL DLCH(IXC,IYB1,OUT,5,2)                                    
   10 CONTINUE                                                          
C                                                                       
C     * WRITE THE SCALE FACTOR OF 10.                                   
      IF(KS.EQ.0) RETURN                                                
      IF(2.LE.KS.AND.KS.LE.9) J=1                                       
      IF((-9.LE.KS.AND.KS.LE.-1).OR.(KS.GT.9)) J=2                      
      IF(KS.LE.-10) J=3                                                 
      IXR1=IXR-36*KR                                                    
      IYB2=IYB-43*KR                                                    
      CALL DLCH(IXR1,IYB2+1*KR,'X',1,1)                                 
      CALL DLCH(IXR1,IYB2,' 10',3,2)                                    
      IF(KS.EQ.1) RETURN                                                
      WRITE(OUT,'(I3)') KS                                              
      CALL DLCH(IXR1+36*KR,IYB2+7*KR,OUT(4-J:3),J,1)                    
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE SLLIN(NY)                                              
C                                                                       
C***********************************************************************
C     THIS ROUTINE PRINTS A LINEAR NUMERIC SCALE ON THE LEFT BOUN-     *
C DARY OF A FRAME WITH NY EQUALLY SPACED INTERVALS DRAWN BY DLNLN OR   *
C DLGLN.  THE NUMBERS ARE PRINTED IN F5.2 FORMAT WITH AN ADDITIONAL    *
C POWER OF 10 (IF NEEDED) PRINTED SEPATATELY.  THE DATA FOR THE SCALE  *
C ARE OBTAINED FROM XLX,XRX,YBX,YTX OF COMMON BLOCK CJE07X.            *
C                                                                      *
C     MODIFIED BY DEBBY HYMAN 4/7/80: FIXED ALOG(X) BEING OFF FOR      *
C     SCALING IN SOME CASES.                                           *
C     MODIFIED GMDH 21/06/84: ADDED COMMON /CJE07X/.                   *
C     MODIFIED JPG 13/11/85: RETURN ON NY=0.                           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      COMMON /CJE07X/XLX,XRX,YBX,YTX,IXLX,IXRX,IYBX,IYTX                
      CHARACTER*5 OUT                                                   
C                                                                       
      IF(NY.EQ.0) RETURN                                                
C                                                                       
C     * DETERMINE THE SCALE FACTOR KS OF 10.                            
      T=DMAX1(ABS(YBX),ABS(YTX))                                        
      IF(ABS(T).LE.1.E-15) T=1.E-15                                     
      X=ALOG19(T)                                                       
C     * FIX FOR -1.0E7 THAT RETURNS KS=6 INSTEAD OF KS=7:               
      KS=X+SIGN(0.001,X)                                                
C                                                                       
      FACT=10.**(-KS)                                                   
      YTT=YTX*FACT                                                      
      YBB=YBX*FACT                                                      
C                                                                       
C     * WRITE YBB ONTO THE BOUNDARY.                                    
      IXL1=IXL-64*KR                                                    
      IF(IXL1.LT.15) IXL1=15*KR                                         
      WRITE(OUT,'(F5.2)') YBB                                           
      CALL DLCH(IXL1,IYBX-2*KR,OUT,5,2)                                 
C                                                                       
C     * DETERMINE THE NUMBER OF INTERVALS TO SCALE (0 < NY <= 10).      
      NYA=MIN(10,IABS(NY))                                              
      DY=(YTT-YBB)/NYA                                                  
      DDY=REAL(IYTX-IYBX)/NYA                                           
C                                                                       
C     * WRITE THE SCALE ONTO THE BOUNDARY.                              
      DO 10 I=1,NYA                                                     
         IYC=IYBX+I*DDY-6*KR                                            
         YC=YBB+I*DY                                                    
         WRITE(OUT,'(F5.2)') YC                                         
         CALL DLCH(IXL1,IYC,OUT,5,2)                                    
   10 CONTINUE                                                          
C                                                                       
C     * WRITE THE SCALE FACTOR OF 10.                                   
      IF(KS.EQ.0) RETURN                                                
      IF(2.LE.KS.AND.KS.LE.9) J=1                                       
      IF((-9.LE.KS.AND.KS.LE.-1).OR.(KS.GT.9)) J=2                      
      IF(KS.LE.-10) J=3                                                 
      IYT1=IYT+13*KR                                                    
      CALL DLCH(IXL1,IYT1+1*KR,'X',1,1)                                 
      CALL DLCH(IXL1,IYT1,' 10',3,2)                                    
      IF(KS.EQ.1) RETURN                                                
      WRITE(OUT,'(I3)') KS                                              
      CALL DLCH(IXL1+36*KR,IYT1+7*KR,OUT(4-J:3),J,1)                    
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE SBLOG(JX)                                              
C                                                                       
C***********************************************************************
C     THIS ROUTINE PRINTS A LOG NUMERIC SCALE ON THE BOTTOM BOUNDARY.  *
C THROUGH ENTRY SLLOG(JY) A LOG NUMERIC SCALE IS PRINTED ON THE LEFT   *
C BOUNDARY.                                                            *
C                                                                      *
C     MODIFIED JPG 13/11/85: RETURN UPON JX=0 AND JY=0.                *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      COMMON /CJE07/XL,XR,YB,YT,IXL,IXR,IYB,IYT                         
      DIMENSION IXY(4),XY(4)                                            
      EQUIVALENCE (IXY,IXL),(XY,XL)                                     
      CHARACTER*3 OUT                                                   
C                                                                       
      IF(JX.EQ.0) RETURN                                                
      IY=IYB                                                            
      IYDEL=-23*KR                                                      
      IYDL=8*KR                                                         
      IX=IXL                                                            
      IXDEL=-16*KR                                                      
      IXDL=23*KR                                                        
      I1=1                                                              
      I2=2                                                              
      GOTO 10                                                           
C                                                                       
C     * ENTRY FOR PLOTTING LOG NUMERIC SCALE ON THE LEFT BOUNDARY.      
      ENTRY SLLOG(JY)                                                   
      IF(JY.EQ.0) RETURN                                                
      IX=IXL                                                            
      IXDEL=-54*KR                                                      
      IXDL=24*KR                                                        
      IY=IYB                                                            
      IYDEL=-2*KR                                                       
      IYDL=8*KR                                                         
      I1=3                                                              
      I2=4                                                              
C                                                                       
   10 IXYV=XY(I1)                                                       
      NX=DMIN1(ABS(XY(I1)-XY(I2)),25.D+0)                               
      WRITE(OUT,'(I3)') IXYV                                            
      IXC=IX+IXDEL                                                      
      IYC=IY+IYDEL                                                      
      IXX=IXC+IXDL                                                      
      IYX=IYC+IYDL                                                      
      CALL DLCH(IXC,IYC,'10',2,2)                                       
      J=1                                                               
      IF(IXYV.LT.0) J=2                                                 
      IF(IXYV.LT.-9) J=3                                                
      CALL DLCH(IXX,IYX,OUT(4-J:3),J,1)                                 
      IF(NX.EQ.0) RETURN                                                
      IDXYV=ISIGN(1,INT(XY(I2)-XY(I1)))                                 
      DO 20 I=1,NX                                                      
         IXYV=IXYV+IDXYV                                                
         WRITE(OUT,'(I3)') IXYV                                         
         IF(I1.NE.1) THEN                                               
            IYC=IY+IYDEL+(I*(IXY(I2)-IXY(I1)))/NX                       
            IYX=IYC+IYDL                                                
         ELSE                                                           
            IXC=IX+IXDEL+(I*(IXY(I2)-IXY(I1)))/NX                       
            IXX=IXC+IXDL                                                
         ENDIF                                                          
         CALL DLCH(IXC,IYC,'10',2,2)                                    
         IF(IXYV.GE.-9) J=2                                             
         IF(IXYV.GE.0) J=1                                              
         CALL DLCH(IXX,IYX,OUT(4-J:3),J,1)                              
   20 CONTINUE                                                          
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE CONVRT(Z,IZ,Z1,Z2,IZ1,IZ2)                             
C                                                                       
C***********************************************************************
C     CONVRT CONVERTS THE REAL NUMBER Z TO AN SC-4020 COORDINATE BASED *
C ON Z1 AND Z2 AS THE REAL USER-SCALED VALUES ASSOCIATED WITH THE PLOT *
C AREA BOUNDARIES IZ1 AND IZ2, RESPECTIVELY.  THE RESULT IS STORED IN  *
C IZ.  THE CONVERSION IS PERFORMED BY THE FORMULA:                     *
C                                                                      *
C     IZ = IZ1 +((Z -Z1)/(Z2 -Z1))*(IZ2 -IZ1)                          *
C                                                                      *
C IZ IS TESTED TO ENSURE THAT IT LIES WITHIN THE BOUNDARIES SPECIFIED  *
C BY IZ1 AND IZ2.  IF IT LIES OUTSIDE THESE LIMITS, IT IS SET EQUAL TO *
C THE APPROPRIATE LIMIT.  IF Z2 EQUALS Z1 ON INPUT, THEN IZ IS SET TO  *
C MAX(IZ1,IZ2).                                                        *
C                                                                      *
C Z       - REAL USER COORDINATE.                                      *
C IZ      - CONVERTED SC-4020 COORDINATE IN THE RANGE IZ1 TO IZ2.      *
C Z1/Z2   - REAL USER VALUES CORRESPONDING TO IZ1/IZ2.                 *
C IZ1/IZ2 - SC-4020 COORDINATES BOUNDS OF THE PLOT AREA ALONG ONE AXIS *
C           (0 <= IZ1 <= IZ2 <= 1023*KR).                              * 
C                                                                      *
C EXAMPLE: "CALL CONVRT(1.,IX,0.,2.,100,900)".  UPON RETURN, IX=500.   *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      F=Z2-Z1                                                           
      IF(F.NE.0) F=(IZ2-IZ1)/F                                          
      IZ=MIN(MAX(MIN(IZ1,IZ2),IZ1+INT((Z-Z1)*F)),MAX(IZ1,IZ2))          
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE BOX(IX1,IX2,IY1,IY2)                                   
C                                                                       
C***********************************************************************
C     THIS ROUTINE DRAWS A BOX WITH VERTICAL SIDES AT IX1 AND IX2 AND  *
C HORIZONTAL SIDES AT IY1 AND IY2.                                     *
C                                                                      *
C     WRITTEN BY HANS GOEDBLOED 18/10/85, modified 30/07/07.           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      CALL DR4(IX1,IY1,IX1,IY2,IX2,IY2,IX2,IY1)                         
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DATI(D,T)                                              
C                                                                       
C***********************************************************************
C     THIS SUBROUTINE WRITES DATE AND TIME ONTO THE VARIABLES D AND T. *
C                                                                      *
C     WRITTEN BY HANS GOEDBLOED 3/12/85.                               *
C     CHANGED NAME OF THE SUBROUTINE, JPG 2/8/91.                      *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      CHARACTER*(*) D,T                                                 
      CHARACTER Z*5                                                     
      INTEGER DATE_TIME(8)                                              
      CHARACTER YEAR*4                                                  
C                                                                       
      CALL DATE_AND_TIME(D,T,Z,DATE_TIME)                               
      WRITE(YEAR,'(I4)') DATE_TIME(1)                                   
      WRITE(D,'(I2.2,"/",I2.2,"/",A2)') DATE_TIME(3),DATE_TIME(2),      
     &                                  YEAR(3:4)                       
      WRITE(T,'(I2.2,":",I2.2,":",I2.2)') DATE_TIME(5),DATE_TIME(6),    
     &                                    DATE_TIME(7)                  
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE LWCOL(LW,ICOL)                                         
C                                                                       
C***********************************************************************
C     THIS ROUTINE CHANGES THE LINEWIDTH LW AND THE COLOR ICOL OF THE  *
C LINES, DASHES, DOTS OR CHARACTERS OF A PLOT.                         *
C                                                                      *
C LW   - LINEWIDTH                                                     *
C           DEFAULT: 9                                                 *
C ICOL - PRECHOSEN RGB COLOR CODES:                                    *
C           ICOL = 0: BLACK                                            *
C           ICOL = 1: RED                                              *
C           ICOL = 2: GREEN                                            *
C           ICOL = 3: BLUE                                             *
C           ICOL = 4: ORANGE                                           *
C           ICOL = 5: BROWN                                            *
C           ICOL = 6: YELLOW                                           *
C           ICOL = 7: PURPLE                                           *
C           ICOL = 8: MAGENTA                                          *
C           ICOL = 9: CYAN                                             *
C                                                                      *
C More color codes to compute the real numbers r,b,g in the postscript *
C commands 'r g b setrgbcolor' below may be found on the website:      *
C http://www.pitt.edu/~nisg/cis/web/cgi/rgb.html                       *
C                                                                      *
C     Written by Hans Goedbloed 23/07/07.                              *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
                                                                        
c     * set setlinewidth if LW.ne.0                                     
      IF(LW.EQ.0) THEN                                                  
         WRITE(IPS,'(a8/)') 'st gsave'                                  
      ELSE                                                              
         WRITE(IPS,'(a8//i2,a13)') 'st gsave',LW,' setlinewidth'        
      ENDIF                                                             
C                                                                       
c     * set color                                                       
      IF(ICOL.EQ.0) WRITE(IPS,'(a35/)')                                 
     >              '0.00 0.00 0.00 setrgbcolor %black  '               
      IF(ICOL.EQ.1) WRITE(IPS,'(a35/)')                                 
     >              '1.00 0.00 0.00 setrgbcolor %red    '               
      IF(ICOL.EQ.2) WRITE(IPS,'(a35/)')                                 
     >              '0.00 0.90 0.10 setrgbcolor %green  '               
      IF(ICOL.EQ.3) WRITE(IPS,'(a35/)')                                 
     >              '0.00 0.00 1.00 setrgbcolor %blue   '               
      IF(ICOL.EQ.4) WRITE(IPS,'(a35/)')                                 
     >              '1.00 0.50 0.00 setrgbcolor %orange '               
      IF(ICOL.EQ.5) WRITE(IPS,'(a35/)')                                 
     >              '0.50 0.10 0.10 setrgbcolor %brown  '               
      IF(ICOL.EQ.6) WRITE(IPS,'(a35/)')                                 
     >              '0.90 0.90 0.00 setrgbcolor %yellow '               
      IF(ICOL.EQ.7) WRITE(IPS,'(a35/)')                                 
     >              '0.60 0.10 0.90 setrgbcolor %purple '               
      IF(ICOL.EQ.8) WRITE(IPS,'(a35/)')                                 
     >              '1.00 0.00 1.00 setrgbcolor %magenta'               
      IF(ICOL.EQ.9) WRITE(IPS,'(a35/)')                                 
     >              '0.00 0.50 0.50 setrgbcolor %cyan   '               
c                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE WRTEXT(IUNIT)                                          
C                                                                       
C***********************************************************************
C     THIS ROUTINE READS A LOCAL FILE, THAT IS OPENED IN THE CALLING   *
C PROGRAM WITH THE UNIT NUMBER "IUNIT", AND WRITES IT TO THE GRAPHICS  *
C FILE.  WRTEXT STARTS WRITING ON A NEW FRAME, UNLESS IUNIT < 0 WHEN   *
C WRITING STARTS AT THE CURRENT IY POSITION OF THE DRAWING BEAM.  IT   *
C AUTOMATICALLY ADVANCES A FRAME IF THE FILE NEEDS AN ADDITIONAL PAGE. *
C TYPICAL USE FOR WRTEXT IS TO WRITE THE CURRENT UPDATE MODIFICATIONS  *
C OF THE SOURCE OR THE NAMELIST INPUT ONTO THE GRAPHICS FILE.          *
C                                                                      *
C     WRITTEN BY DEBBY HYMAN, 8-79.                                    *
C     MODIFIED JPG 25/10/85: OPTION IUNIT < 0, IMPROVED LINE SPACING.  *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
      PARAMETER (KR = 9)                                                
C                                                                       
c     * filenumber postscript file                                      
      PARAMETER (IPS=51)                                                
C                                                                       
      PARAMETER (ISPACE=4*KR)                                           
      CHARACTER*80 LINE                                                 
C                                                                       
      COMMON /KPOS/KP(19)                                               
C                                                                       
      KP(1) = 1                                                         
C                                                                       
      MY = 17*KR+ISPACE                                                 
      IU = IABS(IUNIT)                                                  
      IF(IUNIT.LT.0) THEN                                               
         CALL SEELOC(IX,IY)                                             
         IY = IY-MY                                                     
      ELSE                                                              
         CALL ADV(1)                                                    
         IY = 780*KR-MY                                                 
      ENDIF                                                             
C                                                                       
c     * postscript comment                                              
      WRITE(IPS,'(/A22/)') '%%%%Text (from WRTEXT)'                     
C                                                                       
      REWIND IU                                                         
   10 READ(IU,'(A80)',END=40) LINE                                      
C                                                                       
      DO 20 L=80,1,-1                                                   
   20    IF(LINE(L:L).NE.' ') GOTO 30                                   
   30 CALL DLCH(20*KR,IY,LINE(1:L),L,2)                                 
      IY = IY-MY                                                        
C                                                                       
      IF(IY.LT.0) THEN                                                  
C        * RESET IY FOR ANOTHER PAGE OF TEXT.                           
         CALL ADV(1)                                                    
         IY = 780*KR-MY                                                 
      ENDIF                                                             
      GOTO 10                                                           
C                                                                       
   40 RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DLCH(IX,IY,STRING,NC,ISIZE)                            
C                                                                       
C***********************************************************************
C     THIS ROUTINE WILL PRINT ARBITRARILY LARGE CHARACTERS ON THE      *
C GRAPHICS FILE, EITHER HORIZONTALLY OR VERTICALLY (WITH ENTRY DLCV).  *
C HORIZONTAL PRINTING IS FROM LEFT TO RIGHT.  FOR VERTICAL PRINTING,   *
C CHARACTERS ARE ROTATED 90 DEGREES COUNTERCLOCKWISE AND PRINTED FROM  *
C BOTTOM TO TOP.                                                       *
C                                                                      *
C     THE NC CHARACTERS STORED IN STRING ARE WRITTEN WITH THE LOWER    *
C LEFT-HAND CORNER OF THE FIRST CHARACTER AT (IX,IY) FOR BOTH HORIZON- *
C TAL AND VERTICAL CHARACTERS.  CHARACTER AND LINE SPACING ARE AUTOMA- *
C TIC IN EITHER DIRECTION WITH CHARACTER SIZES GIVEN BY MX=ISIZE*6*KR, *
C MY=ISIZE*8*KR.  EACH LINE IS SPACED DOWN BY MY PLOTTING POSITIONS.   *
C ON SUBSEQUENT CALLS IF IX < 0, PRINTING WILL CONTINUE WHERE IT LEFT  *
C OFF ON THE PRECEDING PRINT. IF IY < 0, THE FIRST CHARACTER IN STRING *
C IS CENTERED AT IX,IY.                                                *
C                                                                      *
C     IF NC < 0, EACH OCCURRENCE OF THE CHARACTER '$' IN STRING CAUSES *
C THE FONT TO BE CHANGED FROM ASCII (NFONT=1, IC=32,126) TO SYMBOL     *
C (NFONT=2, IC=192,254) AND VICE VERSA, WHERE '$' IS NOT COUNTED IN NC.*
C IF STRING=' ' AND NC.NE.1, ONE SINGLE CHARACTER IS DRAWN REPRESENTED *
C BY THE INTEGER CODE IC=NC.                                           *
C                                                                      *
C     FOR EXAMPLE,                                                     *
C THE GREEK CHARACTER alpha WITH:                                      *
C     "CALL DLCH(IX,IY,'$a',-1,ISIZE)" OR "DLCH(IX,IY,' ',225,ISIZE)", *
C AND THE STRING "A single (alpha) is printed" WITH:                   *
C     "CALL DLCH(IX,IY,'A single $a$ is printed',-21,ISIZE)".          *
C                                                                      *
C     ISIZE IS THE CHARACTER SIZE DEFINED AS A MULTIPLICATIVE FACTOR.  *
C                                                                      *
C     THIS POST-SCRIPT VERSION EXPLOITS THE LASERWRITER FONT HELVETICA *
C (NFONT=1) AND AN ADAPTED VERSION OF THE SYMBOL FONT (NFONT=2).       *
C FOR ISIZE>0, THE CHARACTER SPACING HAS BEEN MODIFIED TO CONSTANT     *
C PITCH (TYPEWRITER STYLE).  FOR ISIZE < 0, THE ORIGINAL PROPORTIONAL  *
C FONTS ARE EXPLOITED.                                                 *
C                                                                      *
C     * Table ASCII characters:       Symbol font characters:          *
C                                                                      *
C     32.       64.  @    96.         192. le          224. bar        *
C     33.  !    65.  A    97.  a      193. approx      225. alpha      *
C     34.  "    66.  B    98.  b      194. ge          226. beta       *
C     35.  #    67.  C    99.  c      195. partial     227. chi        *
C     36.  $    68.  D   100.  d      196. Delta       228. delta      *
C     37.  %    69.  E   101.  e      197. equiv       229. epsilon    *
C     38.  &    70.  F   102.  f      198. Phi         230. phi        *
C     39.  '    71.  G   103.  g      199. Gamma       231. gamma      *
C     40.  (    72.  H   104.  h      200. diamond     232. eta        *
C     41.  )    73.  I   105.  i      201. int         233. iota       *
C     42.  *    74.  J   106.  j      202. vartheta    234. varphi     *
C     43.  +    75.  K   107.  k      203. fatdiamond  235. kappa      *
C     44.  ,    76.  L   108.  l      204. Lambda      236. lambda     *
C     45.  -    77.  M   109.  m      205. minus       237. mu         *
C     46.  .    78.  N   110.  n      206. nabla       238. nu         *
C     47.  /    79.  O   111.  o      207. dot         239. omicron    *
C     48.  0    80.  P   112.  p      208. Pi          240. pi         *
C     49.  1    81.  Q   113.  q      209. Theta       241. theta      *
C     50.  2    82.  R   114.  r      210. sqrt        242. rho        *
C     51.  3    83.  S   115.  s      211. Sigma       243. sigma      *
C     52.  4    84.  T   116.  t      212. perp        244. tau        *
C     53.  5    85.  U   117.  u      213. ne          245. upsilon    *
C     54.  6    86.  V   118.  v      214. pm          246. varpi      *
C     55.  7    87.  W   119.  w      215. Omega       247. omega      *
C     56.  8    88.  X   120.  x      216. Ksi         248. ksi        *
C     57.  9    89.  Y   121.  y      217. Psi         249. psi        *
C     58.  :    01.  Z   122.  z      218. inf         250. zeta       *
C     59.  ;    91.  [   123.  {      219. leftarrow   251. prime      *
C     60.  <    92.  \   124.  |      220. downarrow   252. degree     *
C     61.  =    93.  ]   125.  }      221. rightarrow  253. Re         *
C     62.  >    94.  ^   126.  ~      222. uparrow     254. Im         *
C     63.  ?    95.  _   127.         223. emdash      255.            *
C                                                                      *
C     Postscript version, adapted from original calcomp version, by    *
C     Guido Huysmans, Egbert Westerhof and Hans Goedbloed 11/11/91.    *
C     Added prime, degree, Re, Im for IC = 251-254 of character table; *
C     corrected entry DLCV, jpg 24/07/07.                              *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (KR = 9)                                                
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /ADVPAGE/ADVP                                              
      LOGICAL ADVP                                                      
C                                                                       
      CHARACTER*(*) STRING                                              
      CHARACTER CHR*1, STROUT*81, FORM*24                              
      CHARACTER*4 OCT, SYMB(192:254)                                    
      CHARACTER*1 BS1                                                   
      LOGICAL FVERT, FFONT, FSING, FCHANGE, FLINETL, FOCT               
C                                                                       
      SAVE NFONT, MAGN                                                  
C                                                                       
      DATA NFONT, MAGN / 0, 0/                                          
C                                                                       
C     * OCTAL VALUES FOR SYMBOL FONT CHARACTERS.                        
C                                                                       
      DATA (SYMB(IC),IC=192,223)                                        
C        IC = 192    193    194    195    196    197    198    199      
     >    / '\243','\273','\263','\266','\104','\272','\106','\107',    
C        IC = 200    201    202    203    204    205    206    207      
     >      '\340','\362','\112','\250','\114','\055','\321','\267',    
C        IC = 208    209    210    211    212    213    214    215      
     >      '\120','\121','\326','\123','\136','\271','\261','\127',    
C        IC = 216    217    218    219    220    221    222    223      
     >      '\130','\131','\245','\254','\257','\256','\255','\276' /   
C                                                                       
      DATA (SYMB(IC),IC=224,254)                                        
C        IC = 224    225    226    227    228    229    230    231      
     >    / '\140','\141','\142','\143','\144','\145','\146','\147',    
C        IC = 232    233    234    235    236    237    238    239      
     >      '\150','\151','\152','\153','\154','\155','\156','\157',    
C        IC = 240    241    242    243    244    245    246    247      
     >      '\160','\161','\162','\163','\164','\165','\166','\167',    
C        IC = 248    249    250    251    252    253    254             
     >      '\170','\171','\172','\242','\260','\302','\301' /          
C                                                                       
C     * NC=0 MAY BE USED TO SWITCH OFF PRINTING OF STRING.              
      IF(NC.EQ.0) RETURN                                                
C                                                                       
C     * CHECK FOR IX AND IY WITHIN THE RANGES 0-1023*KR AND 0-779*KR.   
      ISX = MIN(IABS(IX),1023*KR)                                       
      ISY = MIN(IABS(IY),779*KR)                                        
C     * IF IX<0, CONTINUE PRINTING AT PREVIOUS LOCATION.                
      IF(IX.LT.0) CALL SEELOC(ISX,ISY)                                  
C                                                                       
C     * FLAG FOR ROTATE (DRAW VERTICAL CHARACTERS).                     
      FVERT = .FALSE.                                                   
C                                                                       
   10 CONTINUE                                                          
C                                                                       
C     * BACKSLASH IS A ONE CHARACTER VARIABLE.                          
      BS1='\\'                                                          
C                                                                       
      FOCT = .FALSE.                                                    
      JSIZE = IABS(ISIZE)                                               
      IF(JSIZE.EQ.1) THEN                                               
         MX = 9*KR                                                      
         MY = 13*KR                                                     
      ELSE                                                              
         MX = JSIZE*6*KR                                                
         MY = JSIZE*8.5*KR                                              
      ENDIF                                                             
C                                                                       
      IF((MAGN.NE.MY).OR.(NFONT.NE.1).OR.(ADVP)) THEN                   
         MAGN = MY                                                      
         NFONT = 1                                                      
         WRITE(IPS,'(I4,A5)') MY,' scaH'                                
         ADVP = .FALSE.                                                 
      ENDIF                                                             
      FCHANGE = .FALSE.                                                 
      FFONT = .FALSE.                                                   
      IF(NC.LT.0) FFONT = .TRUE.                                        
C                                                                       
C     * FLAG FOR SINGLE CHARACTER.                                      
      FSING = .FALSE.                                                   
      IF((LEN(STRING).EQ.1).AND.(NC.NE.1)) THEN                         
         IC = NC                                                        
         IF(IC.LT.32.OR.(126.LT.IC.AND.IC.LT.192).OR.IC.GT.254) RETURN  
         FSING = .TRUE.                                                 
         NCHR = 1                                                       
      ELSE                                                              
C        * MAXIMUM FOR NC IS 80 CHARACTERS.                             
         NCHR = MIN(IABS(NC),80)                                        
      ENDIF                                                             
C                                                                       
C     * SAVE ISX AND ISY FOR LINE OVERFLOW.                             
      ISXOLD = ISX                                                      
      ISYOLD = ISY                                                      
      IF(.NOT.FVERT) WRITE(IPS,'(I4,1X,I4,A2)') ISX,ISY,' m'            
      IF(FVERT) WRITE(IPS,'(A6,I4,1X,I4,A21,I1,1X,I1,A2)')              
     >                'gsave ',ISY,ISX,' translate 90 rotate ',0,0,' m' 
C                                                                       
C     * DRAWING SINGLE CHARACTERS.                                      
C                                                                       
      IF(FSING) THEN                                                    
         IF(192.LE.IC.AND.IC.LE.254) THEN                               
            NFONT = 2                                                   
            WRITE(IPS,'(I4,A5)') MY,' scaS'                             
            FOCT = .FALSE.                                              
            IF(IC.LE.223.OR.IC.GT.250) THEN                             
               OCT = SYMB(IC)                                           
               FOCT = .TRUE.                                            
            ENDIF                                                       
         ENDIF                                                          
         IF(IC.EQ.46.AND.IY.LT.0) THEN                                  
C           * SIZE CORRECTION FOR SINGLE CENTERED DOT.                  
            WRITE(IPS,'(I4,A5)') MY+8*KR,' scaH'                        
            MAGN = MY+8*KR                                              
         ENDIF                                                          
         IF(IC.LE.126.OR.IC.GE.224) THEN                                
            IF(IC.GE.224) IC = IC-128                                   
            CHR = CHAR(IC)                                              
         ENDIF                                                          
         IF(IY.LT.0) THEN                                               
            IF(FOCT) THEN                                               
               WRITE(IPS,'(I4,1X,I7,A10)') ISX,ISY,' ('//OCT//') tc'    
            ELSEIF(CHR.EQ.'('.OR.CHR.EQ.')'.OR.CHR.EQ.BS1) THEN         
            WRITE(IPS,'(I4,1X,I4,A2,2A1,A4)')ISX,ISY,' (',BS1,CHR,') tc'
            ELSE                                                        
               WRITE(IPS,'(I4,1X,I4,A7)')  ISX,ISY,' ('//CHR//') tc'    
            ENDIF                                                       
         ELSE                                                           
            IF(FOCT) THEN                                               
               WRITE(IPS,'(I4,A10)') MX,' ('//OCT//') tw'               
            ELSEIF(CHR.EQ.'('.OR.CHR.EQ.')'.OR.CHR.EQ.BS1) THEN         
               WRITE(IPS,'(I4,A2,2A1,A4)')  MX,' (',BS1,CHR,') tw'      
            ELSE                                                        
               WRITE(IPS,'(I4,A7)')  MX,' ('//CHR//') tw'               
            ENDIF                                                       
         ENDIF                                                          
         FOCT = .FALSE.                                                 
         GOTO 50                                                        
      ENDIF                                                             
C                                                                       
C     * DRAWING STRING OF CHARACTERS.                                   
C                                                                       
      NUM = 0                                                           
      M = 1                                                             
      FLINETL = .FALSE.                                                 
C                                                                       
   20 CONTINUE                                                          
C                                                                       
         STROUT = 'X'                                                   
         ILEN = 0                                                       
         N = 0                                                          
C                                                                       
C        * PROCESSING PART OF STRING WITH THE SAME FONT.                
   30    CONTINUE                                                       
            IF(NUM.GE.NCHR) GOTO 40                                     
            IF(((ISX+(N+1)*MX.GE.1023*KR).AND.(.NOT.FVERT)).OR.         
     >         ((ISX+(N+1)*MX.GE. 779*KR).AND.(     FVERT))) THEN       
               IF(NUM.EQ.0) RETURN                                      
               FLINETL = .TRUE.                                         
               GOTO 40                                                  
            ENDIF                                                       
            IF(FFONT.AND.(STRING(M:M).EQ.'$')) THEN                     
               M = M+1                                                  
               FCHANGE = .TRUE.                                         
               GOTO 40                                                  
            ENDIF                                                       
            CHR = STRING(M:M)                                           
            IF(NFONT.EQ.2.AND.CHR.NE.' ') THEN                          
               IC = ICHAR(CHR)                                          
               IF(IC.LT.64) RETURN                                      
               FOCT = .FALSE.                                           
               IF(IC.LE.95.OR.IC.GT.122) THEN                           
                  OCT = SYMB(IC+128)                                    
                  FOCT = .TRUE.                                         
               ENDIF                                                    
            ENDIF                                                       
            IF(CHR.EQ.'('.OR.CHR.EQ.')'.OR.CHR.EQ.BS1) THEN             
C              * INTERCEPT SPECIAL POSTSCRIPT CHARACTERS.               
               STROUT = STROUT(1:ILEN+1)//BS1//CHR                      
               ILEN = ILEN+2                                            
            ELSEIF(FOCT) THEN                                           
C              * INTERCEPT SPECIAL SYMBOLS.                             
               STROUT = STROUT(1:ILEN+1)//OCT                           
               ILEN = ILEN+4                                            
               FOCT = .FALSE.                                           
            ELSE                                                        
               STROUT = STROUT(1:ILEN+1)//CHR                           
               ILEN = ILEN+1                                            
            ENDIF                                                       
            M = M+1                                                     
            NUM = NUM+1                                                 
            N = N+1                                                     
         GOTO 30                                                        
C                                                                       
C        * WRITING PART OF STRING WITH THE SAME FONT.                   
   40    IF(ILEN.NE.0) THEN                                             
            IF(ISIZE.GT.0) THEN                                         
               IF(ILEN.LE.70) THEN                                      
                  WRITE(FORM,'(A8,I3,A4)') '(I4,A2,A',ILEN,',A4)'       
                  WRITE(IPS,FORM) MX,' (',STROUT(2:ILEN+1),') tw'       
               ELSE                                                     
                  WRITE(IPS,'(I4,A2,A70,A4)')                           
     >                            MX,' (',STROUT(2:71),') tw'           
                  WRITE(FORM,'(A8,I3,A4)') '(I4,A2,A',ILEN-70,',A4)'    
                  WRITE(IPS,FORM) MX,' (',STROUT(72:ILEN+1),') tw'      
               ENDIF                                                    
            ELSE                                                        
               IF(ILEN.LE.70) THEN                                      
                  WRITE(FORM,'(A17,I3,A4)') 
     >                            '(I4,1X,I4,1X,A1,A',ILEN,',A5)'          
                  WRITE(IPS,FORM) ISX,ISY,'(',STROUT(2:ILEN+1),') tcs'
               ELSE                                                     
                  WRITE(IPS,'(A1,A70,A4)') '(',STROUT(2:71),') sh'      
                  WRITE(FORM,'(A5,I3,A4)') '(A1,A',ILEN-70,',A4)'       
                  WRITE(IPS,FORM) '(',STROUT(72:ILEN+1),') sh'          
               ENDIF                                                    
            ENDIF                                                       
         ENDIF                                                          
         ISX = ISX+ILEN*MX                                              
         IF(FLINETL) THEN                                               
            ISX = ISXOLD                                                
            IF(.NOT.FVERT) ISY = ISY-(MY+2*JSIZE)                       
            IF(FVERT)      ISY = ISY+(MY+2*JSIZE)                       
            IF(ISY.LT.0) RETURN                                         
            IF(.NOT.FVERT) WRITE(IPS,'(I4,1X,I4,A2)') ISX,ISY,' m'      
            IF(FVERT)      WRITE(IPS,'(I4,1X,I4,A2)') 0,ISYOLD-ISY,' m' 
            FLINETL = .FALSE.                                           
         ENDIF                                                          
         IF(FCHANGE) THEN                                               
            NFONT = -NFONT+3                                            
            IF(NFONT.EQ.1) WRITE(IPS,'(I4,A5)') MY,' scaH'              
            IF(NFONT.EQ.2) WRITE(IPS,'(I4,A5)') MY,' scaS'              
            FCHANGE = .FALSE.                                           
         ENDIF                                                          
C                                                                       
      IF(NUM.LT.NCHR) GOTO 20                                           
C                                                                       
C     * POST BEAM POSITION.                                             
   50 IF(.NOT.FVERT) CALL MOVABS(ISX,ISY)                               
      IF(FVERT) WRITE(IPS,'(A8)') 'grestore'                            
      IF(FVERT) CALL MOVABS(ISY,ISX)                                    
C                                                                       
      RETURN                                                            
C                                                                       
C     * ENTRY FOR DRAWING VERTICALLY.                                   
      ENTRY DLCV(IX,IY,STRING,NC,ISIZE)                                 
      IF(NC.EQ.0) RETURN                                                
      FVERT = .TRUE.                                                    
      ISX = MIN(IABS(IY),779*KR)                                        
      ISY = MIN(IABS(IX),1023*KR)                                       
      IF(IX.LT.0) CALL SEELOC(ISY,ISX)                                  
      GOTO 10                                                           
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE BEGPLT(NAME)                                           
C                                                                       
C***********************************************************************
C     BEGPLT INITIALIZES THE PLOTTING ROUTINES; IT MUST BE CALLED      *
C BEFORE ANY PLOTTING IS DONE.  THE PLOTTING FRAME COORDINATES ARE SET *
C TO 1024*KR BY 780*KR.                                                *
C                                                                      *
C     WRITTEN BY CLAIR NIELSON.                                        *
C     MODIFIED JPG 23/10/85: ELIMINATED PARAMETERS TITLE AND NTITLE.   *
C     Removed definition /pt with linewidth change to avoid conflict   *
C     with variable LW in LPLOT and DPLOT, jpg 18/07/07.               *
C     New definition /cp for closepath, jpg 30/07/07.                  *
C     Bounding boxes modified and put inside prolog,                   *
C     new definition /tcs for typing centered string, jpg 4/09/07 .    *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      CHARACTER*(*) NAME                                                
      COMMON /GRNR2/IGR                                                 
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      OPEN(IPS,FILE=NAME)                                               
c
      WRITE(IPS,'(A/A,A/11(A/))')                                      
     > '%!PS-Adobe-2.0',                                                
     > '%%Title: ',NAME, 
     > '%%For: PPPLIB',                                                 
     > '%%%%',                                                          
     > '%%%%Bounding box for landscape (bottom right):',         
     > '%%BoundingBox: 70 115 545 720 %%%%landscape',                 
     > '%%%%',                                                          
     > '%%%%Bounding box for portrait (bottom down)',  
     > '%%%%BoundingBox:  5 -5 610 470  %%%%portrait, normal mx=1,my=1',   
     > '%%%%BoundingBox:  5 -5 457 470  %%%%portrait, square mx=4,my=1',   
     > '%%%%',                                                          
     > '%%EndComments',
     > '%%EndProlog'                                                    
c
      WRITE(IPS,'(39(A/))')                                           
     > '%%Begin Setup',                                                  
     > '%%%%',                                                          
     > '%%%%Scale:',                                                          
     > '.066667 .066667 scale',                                                          
     > '%%%%',                                                          
     > '%%%%Translate and rotate:',                                                          
     > ' 8100 1620 translate %%%%landscape (comment out for portrait)',                                                          
     > '90 rotate            %%%%landscape (comment out for portrait)',                                                          
     > '%%%%',                                                          
     > '%%%%Linewidth of the plot:',                                    
     > '9 setlinewidth',                                                
     > '%%%%',                                                          
     > '%%%%',                                                          
     > '%%%%Definitions:',                                              
     > '/l {lineto} def /m {moveto} def',                               
     > '/rl {rlineto} def /rm {rmoveto} def',                           
     > '/cp {lineto closepath stroke} def',                             
     > '/sh {show} def /st {stroke} def',                               
     > '/scaH {/Helvetica findfont exch scalefont setfont} def',        
     > '/scaS {/Symbol findfont exch scalefont setfont} def',            
     > '/tw  % typewrite (str) with dx=skip.',                          
     > ' {/str exch def /skip exch def',                                
     > '  str {/charcode exch def /char ( ) dup 0 charcode put def',    
     > '   skip 2 div 0 rm gsave',                                      
     > '   char stringwidth pop 2 div neg 0 rm',                        
     > '   char show grestore skip 2 div 0 rm} forall} def',            
     > '/tc  % type centered character.',                               
     > ' {/ch exch def /y exch def /x exch def',                        
     > '  gsave newpath 0 0 m',                                         
     > '  ch true charpath flattenpath pathbbox',                       
     > '  /ury exch def /urx exch def /lly exch def /llx exch def',     
     > '  urx llx add 2 div /dx exch def',                              
     > '  ury lly add 2 div /dy exch def grestore',                     
     > '  x dx sub y dy sub m ch sh} def',                              
     > '/tcs  % type centered string',                               
     > ' {/str exch def /y exch def /x exch def',                        
     > '  /hw str stringwidth pop 2 div def',                        
     > '  x hw sub y m str sh} def',                              
     > '%%End Setup'                                                   
c
      WRITE(IPS,'(4(/A))')                                    
     > 'newpath',                                                       
     > '%%%%First page',                                                
     > '%%Page:  1',                                                   
     > '%%start plotting'                                               
C                                                                       
      IGR = 0                                                           
      IXSAV = 0                                                         
      IYSAV = 0                                                         
C                                                                       
      RETURN                                                            
      END                                                             
C                                                                       
      SUBROUTINE FINPLT                                                 
C                                                                       
C***********************************************************************
C     THIS ROUTINE IS CALLED AFTER ALL PLOTTING IN A CODE IS FINISHED. *
C IT CLOSES THE GRAPHICS FILE.                                         *
C***********************************************************************
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /GRNR2/IGR                                                 
C                                                                       
      WRITE(IPS,'(/A/A/A)')                                             
     > 'stroke showpage',                                               
     > '%%Trailer',                                                     
     > '%%EOF'                                                          
      CLOSE(IPS)                                                        
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE ADV(N)                                                 
C                                                                       
C***********************************************************************
C     THIS ROUTINE ADVANCES N PLOTTING PAGES (ONLY SENSIBLE FOR N=1).  *
C                                                                      *
C     Added page number, Sander Belien Sept'93.                        *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /GRNR2/IGR                                                 
      COMMON /ADVPAGE/ADVP                                              
      LOGICAL ADVP                                                      
C                                                                       
      DO 10 I=1,N                                                       
         IF(IGR.NE.0) WRITE(IPS,'(A30///A7,I3)')                      
     >    'stroke gsave showpage grestore',                             
     >    '%%Page:',IGR+N                                        
   10 CONTINUE                                                          
C                                                                       
      IGR = IGR+N                                                       
      ADVP= .TRUE.                                                      
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DRV(IX1,IY1,IX2,IY2)                                   
C                                                                       
C***********************************************************************
C     THIS ROUTINE DRAWS A LINE VECTOR FROM (IX1,IY1) TO (IX2,IY2).    *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      SAVE NUMLIN                                                       
      DATA NUMLIN / 0 /                                                 
C                                                                       
      NUMLIN = NUMLIN+1                                                 
      IF(NUMLIN.GE.50) THEN                                             
         WRITE(IPS,'(A2)') 'st'                                         
         NUMLIN = 0                                                     
      ENDIF                                                             
      WRITE(IPS,'(I4,1X,I4,A3,I4,1X,I4,A2)') IX1,IY1,' m ',IX2,IY2,' l' 
C                                                                       
      IXSAV = IX2                                                       
      IYSAV = IY2                                                       
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DRP(IX,IY)                                             
C                                                                       
C***********************************************************************
C     THIS ROUTINE DRAWS A POINT AT THE LOCATION (IX,IY).              *
C     Modified to yield small but visible square, jpg 30/07/07.        *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3)') 
     >      'st ',IX,IY,' m ',IX+1,IY,' l ',IX+1,IY+1,' l ',IX,IY+1,    
     >      ' cp'                                                       
      IXSAV = IX                                                        
      IYSAV = IY                                                        
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE MOVABS(IX,IY)                                          
C                                                                       
C***********************************************************************
C     THIS ROUTINE MOVES THE DRAWING BEAM TO THE LOCATION (IX,IY).     *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      SAVE NUMBIN                                                       
      DATA NUMBIN / 0 /                                                 
C                                                                       
      NUMBIN = NUMBIN+1                                                 
      IF(NUMBIN.GE.50) THEN                                             
         WRITE(IPS,'(A2)') 'st'                                         
         NUMBIN = 0                                                     
      ENDIF                                                             
      WRITE(IPS,'(I4,1X,I4,A2)') IX,IY,' m'                             
      IXSAV = IX                                                        
      IYSAV = IY                                                        
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DRWABS(IX,IY)                                          
C                                                                       
C***********************************************************************
C     THIS ROUTINE DRAWS A LINE VECTOR FROM THE CURRENT BEAM POSITION  *
C TO (IX,IY), WHICH BECOMES THE NEW BEAM POSITION.                     *
C     Modified drawing of single point as in DRP, jpg 30/07/07.        *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      IF(IX.EQ.IXSAV.AND.IY.EQ.IYSAV) THEN                              
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3)') 
     >      'st ',IX,IY,' m ',IX+1,IY,' l ',IX+1,IY+1,' l ',IX,IY+1,    
     >      ' cp'                                                       
      ELSE                                                              
         WRITE(IPS,'(I4,1X,I4,A2)') IX,IY,' l'                          
      ENDIF                                                             
      IXSAV = IX                                                        
      IYSAV = IY                                                        
C                                                                       
      RETURN                                                            
      END                                                               
C                                                                       
      SUBROUTINE DR3(IX1,IY1,IX2,IY2,IX3,IY3)                           
C                                                                       
C***********************************************************************
C     This routine draws an open (closed for entry DR3C) triangle.     *
C     Written, jpg 30/07/07.                                           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3)')             
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' cp'             
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      ENTRY DR3C(IX1,IY1,IX2,IY2,IX3,IY3)                               
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A10)')            
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' l fill st'      
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE DR4(IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4)                   
C                                                                       
C***********************************************************************
C     This routine draws an open (closed for entry DR4C) quadrangle.   *
C     Written, jpg 30/07/07.                                           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3)') 
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' l ',IX4,IY4,    
     >      ' cp'                                                       
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      ENTRY DR4C(IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4)                       
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A10)')
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' l ',IX4,IY4,    
     >      ' l fill st'                                                
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE DR5(IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,IX5,IY5)           
C                                                                       
C***********************************************************************
C     This routine draws an open (closed for entry DR4C) pentagon;     *
C changing order of arguments to 1,3,5,2,4 gives a five-pointed star.  *
C     Written, jpg 30/07/07.                                           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,      
     >            A3,I4,1X,I4,A3)')                                     
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' l ',IX4,IY4,    
     >      ' l ',IX5,IY5,' cp'                                         
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      ENTRY DR5C(IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,IX5,IY5)               
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,      
     >            A3,I4,1X,I4,A10)')                                    
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' l ',IX4,IY4,    
     >      ' l ',IX5,IY5,' l fill st'                                  
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE DR6(IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,IX5,IY5,IX6,IY6)   
C                                                                       
C***********************************************************************
C     This routine draws an open (closed for entry DR4C) hexagon.      *
C     Written, jpg 30/07/07.                                           *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      PARAMETER (IPS=51)                                                
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,      
     >            A3,I4,1X,I4,A3,I4,1X,I4,A3)')                         
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' l ',IX4,IY4,    
     >      ' l ',IX5,IY5,' l ',IX6,IY6,' cp'                           
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      ENTRY DR6C(IX1,IY1,IX2,IY2,IX3,IY3,IX4,IY4,IX5,IY5,IX6,IY6)       
      WRITE(IPS,'(A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,A3,I4,1X,I4,      
     >            A3,I4,1X,I4,A3,I4,1X,I4,A10)')                        
     >      'st ',IX1,IY1,' m ',IX2,IY2,' l ',IX3,IY3,' l ',IX4,IY4,    
     >      ' l ',IX5,IY5,' l ',IX6,IY6,' l fill st'                    
      IXSAV = IX1                                                       
      IYSAV = IY1                                                       
      RETURN                                                            
C                                                                       
      END                                                               
C                                                                       
      SUBROUTINE SEELOC(IX,IY)                                          
C                                                                       
C***********************************************************************
C     THIS ROUTINE LOOKS UP THE CURRENT POSITION OF THE DRAWING BEAM.  *
C COMMON /LIB8X/ ITSELF SHOULD NOT BE USED FOR THIS PURPOSE SINCE ITS  *
C CONTENTS SHOULD REMAIN SHARED AND AFFECTED ONLY BY THE LOWEST-LEVEL  *
C SYSTEM-DEPENDENT DRAWING ROUTINES.                                   *
C***********************************************************************
C                                                                       
      implicit double precision (a-h,o-z)                               
C                                                                       
      COMMON /LIB8X/IXSAV,IYSAV                                         
C                                                                       
      IX = IXSAV                                                        
      IY = IYSAV                                                        
C                                                                       
      RETURN                                                            
      END                                                               
